/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.IAreaOfEffectCloud;
import net.hydra.jojomod.access.IEnderMan;
import net.hydra.jojomod.access.ILevelAccess;
import net.hydra.jojomod.block.BloodBlock;
import net.hydra.jojomod.block.EnderBloodBlock;
import net.hydra.jojomod.block.GasolineBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.block.StandFireBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.FireProjectile;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.GasolineSplatterEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.StoredSoundInstance;
import net.hydra.jojomod.event.index.PlunderTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersSoftAndWet;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.MagmaBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Unique;

public class SoftAndWetPlunderBubbleEntity
extends SoftAndWetBubbleEntity {
    private static final EntityDataAccessor<Byte> PLUNDER_TYPE = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<BlockPos> BLOCK_POS = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private static final EntityDataAccessor<Boolean> FINISHED = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ENTITY_STOLEN = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> LIQUID_STOLEN = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SINGULAR = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    @Unique
    public List<StoredSoundInstance> bubbleSounds = new ArrayList<StoredSoundInstance>();
    public boolean stolenPhysicalLiquid = false;
    public boolean finishedUsingLiquid = false;
    public int airSupply = 0;
    Collection<MobEffectInstance> mobEffects;
    public int fireTicks;
    public boolean hasDitchedItem = false;
    public boolean isArrayAdded = false;
    protected static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(SoftAndWetPlunderBubbleEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);

    @Unique
    public void bubbleSoundsInit() {
        if (this.bubbleSounds == null) {
            this.bubbleSounds = new ArrayList<StoredSoundInstance>();
        }
    }

    @Override
    public boolean m_6087_() {
        if (this.isPopPlunderBubbble()) {
            return false;
        }
        if (this.getPlunderType() == PlunderTypes.POTION_EFFECTS.id && this.getActivated()) {
            return true;
        }
        return !this.m_9236_().m_5776_() || ClientUtil.getPlayer() == null || ClientUtil.getPlayer().m_19879_() != this.getUserID();
    }

    @Unique
    public void addPlunderBubbleSounds(StoredSoundInstance plunder) {
        this.bubbleSoundsInit();
        this.bubbleSounds.add(plunder);
    }

    @Unique
    public void addPlunderBubbleSounds(SoundEvent soundEvent, SoundSource soundSource, float pitch, float volum) {
        this.bubbleSoundsInit();
        this.bubbleSounds.add(new StoredSoundInstance(soundEvent, soundSource, pitch, volum));
    }

    public SoftAndWetPlunderBubbleEntity(LivingEntity $$1, Level $$2) {
        super(ModEntities.PLUNDER_BUBBLE, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public SoftAndWetPlunderBubbleEntity(EntityType<SoftAndWetPlunderBubbleEntity> softAndWetPlunderBubbleEntityEntityType, Level level) {
        super(ModEntities.PLUNDER_BUBBLE, level);
    }

    @Override
    protected void m_8060_(BlockHitResult $$0) {
        if (!(this.m_9236_().m_5776_() || this.getFinished() || this.getReturning())) {
            if (!(this.getPlunderType() != PlunderTypes.FRICTION.id && this.getPlunderType() != PlunderTypes.SOUND.id || this.getActivated())) {
                this.setBlockPos($$0.m_82425_().m_7494_());
                this.setBlockPos($$0.m_82425_());
                if ($$0.m_82434_() == Direction.DOWN) {
                    this.setFloatingUpsideDown();
                } else {
                    this.setFloating();
                }
            } else if (this.getPlunderType() == PlunderTypes.MOISTURE.id) {
                if (!this.getActivated()) {
                    if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof GasolineBlock) {
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_7731_($$0.m_82425_(), Blocks.f_50016_.m_49966_(), 11);
                            this.stolenPhysicalLiquid = true;
                        }
                        this.setLiquidStolen(1);
                        if ($$0.m_82434_() == Direction.DOWN) {
                            this.setFloatingUpsideDown();
                            this.stolenPhysicalLiquid = true;
                        } else {
                            this.setFloating();
                        }
                    } else if (this.m_9236_().m_8055_($$0.m_82425_().m_7494_()).m_60734_() instanceof GasolineBlock) {
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_7731_($$0.m_82425_().m_7494_(), Blocks.f_50016_.m_49966_(), 11);
                        }
                        this.setLiquidStolen(1);
                        this.setFloating();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof BloodBlock) {
                        boolean ender = this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof EnderBloodBlock;
                        boolean spider = this.m_9236_().m_8055_($$0.m_82425_()).m_60713_(ModBlocks.BLUE_BLOOD_SPLATTER);
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_7731_($$0.m_82425_(), Blocks.f_50016_.m_49966_(), 11);
                            this.stolenPhysicalLiquid = true;
                        }
                        if (ender) {
                            this.setLiquidStolen(6);
                        } else if (spider) {
                            this.setLiquidStolen(5);
                        } else {
                            this.setLiquidStolen(4);
                        }
                        if ($$0.m_82434_() == Direction.DOWN) {
                            this.setFloatingUpsideDown();
                            this.stolenPhysicalLiquid = true;
                        } else {
                            this.setFloating();
                        }
                    } else if (this.m_9236_().m_8055_($$0.m_82425_().m_7494_()).m_60734_() instanceof BloodBlock) {
                        boolean ender = this.m_9236_().m_8055_($$0.m_82425_().m_7494_()).m_60734_() instanceof EnderBloodBlock;
                        boolean spider = this.m_9236_().m_8055_($$0.m_82425_().m_7494_()).m_60713_(ModBlocks.BLUE_BLOOD_SPLATTER);
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_7731_($$0.m_82425_().m_7494_(), Blocks.f_50016_.m_49966_(), 11);
                        }
                        if (ender) {
                            this.setLiquidStolen(6);
                        } else if (spider) {
                            this.setLiquidStolen(5);
                        } else {
                            this.setLiquidStolen(4);
                        }
                        this.setFloating();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_()).m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)this.m_9236_().m_8055_($$0.m_82425_()).m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_46597_($$0.m_82425_(), (BlockState)this.m_9236_().m_8055_($$0.m_82425_()).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                            this.stolenPhysicalLiquid = true;
                        }
                        this.setLiquidStolen(2);
                        this.setFloating();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_().m_121945_($$0.m_82434_())).m_61138_((Property)BlockStateProperties.f_61362_) && ((Boolean)this.m_9236_().m_8055_($$0.m_82425_().m_121945_($$0.m_82434_())).m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_46597_($$0.m_82425_().m_121945_($$0.m_82434_()), (BlockState)this.m_9236_().m_8055_($$0.m_82425_().m_121945_($$0.m_82434_())).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false)));
                            this.stolenPhysicalLiquid = true;
                        }
                        this.setLiquidStolen(2);
                        this.setFloating();
                    } else {
                        super.m_8060_($$0);
                    }
                } else {
                    if (this.stolenPhysicalLiquid) {
                        if (this.getLiquidStolen() == 1) {
                            if (this.stolenPhysicalLiquid) {
                                BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                                Block bk = this.m_9236_().m_8055_(bpos).m_60734_();
                                if (bk instanceof FireBlock || bk instanceof StandFireBlock || bk instanceof CampfireBlock) {
                                    this.gasExplode();
                                    this.popBubble();
                                } else if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos)) {
                                    this.m_9236_().m_46597_(bpos, (BlockState)ModBlocks.GASOLINE_SPLATTER.m_49966_().m_61124_((Property)ModBlocks.GAS_CAN_LEVEL, (Comparable)Integer.valueOf(2)));
                                    this.finishedUsingLiquid = true;
                                } else {
                                    this.spawnGasSplatter();
                                    this.finishedUsingLiquid = true;
                                }
                            }
                        } else if (this.getLiquidStolen() == 2) {
                            BlockPos bpos1 = $$0.m_82425_();
                            if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && this.m_9236_().m_8055_(bpos1).m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)this.m_9236_().m_8055_(bpos1).m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                                this.m_9236_().m_46597_(bpos1, (BlockState)this.m_9236_().m_8055_(bpos1).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                                this.finishedUsingLiquid = true;
                            }
                            BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                            if (!this.finishedUsingLiquid && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && this.m_9236_().m_8055_(bpos).m_61138_((Property)BlockStateProperties.f_61362_) && !((Boolean)this.m_9236_().m_8055_(bpos).m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                                this.m_9236_().m_46597_(bpos, (BlockState)this.m_9236_().m_8055_(bpos).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true)));
                                this.finishedUsingLiquid = true;
                            }
                            if (!this.finishedUsingLiquid) {
                                if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos, true)) {
                                    this.m_9236_().m_46597_(bpos, Blocks.f_49990_.m_49966_());
                                } else {
                                    this.splashWater();
                                }
                                this.finishedUsingLiquid = true;
                            }
                        } else if (this.getLiquidStolen() == 3) {
                            BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                            if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos, true)) {
                                this.m_9236_().m_46597_(bpos, Blocks.f_49991_.m_49966_());
                            } else {
                                this.splashLava();
                            }
                            this.finishedUsingLiquid = true;
                        } else if (this.getLiquidStolen() == 4) {
                            BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                            if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos, true)) {
                                this.m_9236_().m_46597_(bpos, ModBlocks.BLOOD_SPLATTER.m_49966_());
                            } else {
                                this.splashLava();
                            }
                            this.finishedUsingLiquid = true;
                        } else if (this.getLiquidStolen() == 5) {
                            BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                            if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos, true)) {
                                this.m_9236_().m_46597_(bpos, ModBlocks.BLUE_BLOOD_SPLATTER.m_49966_());
                            } else {
                                this.splashLava();
                            }
                            this.finishedUsingLiquid = true;
                        } else if (this.getLiquidStolen() == 6) {
                            BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                            if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos, true)) {
                                this.m_9236_().m_46597_(bpos, ModBlocks.ENDER_BLOOD_SPLATTER.m_49966_());
                            } else {
                                this.splashLava();
                            }
                            this.finishedUsingLiquid = true;
                        }
                    }
                    super.m_8060_($$0);
                }
            } else if (this.getPlunderType() == PlunderTypes.OXYGEN.id) {
                if (this.getLaunched() && this.getActivated()) {
                    BlockPos bpos = $$0.m_82425_().m_121945_($$0.m_82434_());
                    BlockPos bpos2 = $$0.m_82425_();
                    if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof GasolineBlock) {
                        this.gasExplode();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof CampfireBlock && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && this.m_9236_().m_8055_($$0.m_82425_()).m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)this.m_9236_().m_8055_($$0.m_82425_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                        this.m_9236_().m_46597_(bpos2, (BlockState)this.m_9236_().m_8055_($$0.m_82425_()).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                    } else if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof CandleBlock && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && this.m_9236_().m_8055_($$0.m_82425_()).m_61138_((Property)BlockStateProperties.f_61443_) && !((Boolean)this.m_9236_().m_8055_($$0.m_82425_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                        this.m_9236_().m_46597_(bpos2, (BlockState)this.m_9236_().m_8055_($$0.m_82425_()).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                    } else if (MainUtil.tryPlaceBlock((Entity)this.standUser, bpos) && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser)) {
                        if (this.m_9236_().m_8055_(bpos.m_7495_()).m_60795_()) {
                            if ($$0.m_82434_().equals((Object)Direction.NORTH)) {
                                this.m_9236_().m_46597_(bpos, (BlockState)Blocks.f_50083_.m_49966_().m_61124_((Property)PipeBlock.f_55150_, (Comparable)Boolean.valueOf(true)));
                            } else if ($$0.m_82434_().equals((Object)Direction.SOUTH)) {
                                this.m_9236_().m_46597_(bpos, (BlockState)Blocks.f_50083_.m_49966_().m_61124_((Property)PipeBlock.f_55148_, (Comparable)Boolean.valueOf(true)));
                            } else if ($$0.m_82434_().equals((Object)Direction.EAST)) {
                                this.m_9236_().m_46597_(bpos, (BlockState)Blocks.f_50083_.m_49966_().m_61124_((Property)PipeBlock.f_55151_, (Comparable)Boolean.valueOf(true)));
                            } else if ($$0.m_82434_().equals((Object)Direction.WEST)) {
                                this.m_9236_().m_46597_(bpos, (BlockState)Blocks.f_50083_.m_49966_().m_61124_((Property)PipeBlock.f_55149_, (Comparable)Boolean.valueOf(true)));
                            } else {
                                this.m_9236_().m_46597_(bpos, Blocks.f_50083_.m_49966_());
                            }
                        } else {
                            this.m_9236_().m_46597_(bpos, Blocks.f_50083_.m_49966_());
                        }
                    }
                    super.m_8060_($$0);
                } else if (this.standUser != null) {
                    if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof MagmaBlock) {
                        this.airSupply = this.standUser.m_6062_();
                        this.startReturning();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof CampfireBlock && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && this.m_9236_().m_8055_($$0.m_82425_()).m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)this.m_9236_().m_8055_($$0.m_82425_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                        this.fireTicks = 100;
                        this.m_9236_().m_46597_($$0.m_82425_(), (BlockState)this.m_9236_().m_8055_($$0.m_82425_()).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                        this.setFloating();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_()).m_60734_() instanceof CandleBlock && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && this.m_9236_().m_8055_($$0.m_82425_()).m_61138_((Property)BlockStateProperties.f_61443_) && ((Boolean)this.m_9236_().m_8055_($$0.m_82425_()).m_61143_((Property)BlockStateProperties.f_61443_)).booleanValue()) {
                        this.fireTicks = 100;
                        this.m_9236_().m_46597_($$0.m_82425_(), (BlockState)this.m_9236_().m_8055_($$0.m_82425_()).m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(false)));
                        this.setFloating();
                    } else if (this.m_9236_().m_8055_($$0.m_82425_().m_121945_($$0.m_82434_())).m_60734_() instanceof BaseFireBlock && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser)) {
                        this.fireTicks = 100;
                        this.m_9236_().m_46597_($$0.m_82425_().m_7494_(), Blocks.f_50016_.m_49966_());
                        this.setFloating();
                    } else {
                        super.m_8060_($$0);
                    }
                } else {
                    super.m_8060_($$0);
                }
            } else {
                super.m_8060_($$0);
            }
        }
    }

    public void rangedSplash() {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.GASOLINE_SPLATTER.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 15, 0.4, 0.4, 0.25, 0.4);
            SoundEvent $$6 = SoundEvents.f_11917_;
            this.m_5496_($$6, 1.0f, 1.5f);
            List<Entity> entities = MainUtil.hitbox(MainUtil.genHitbox(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0, 2.0, 2.0));
            if (!entities.isEmpty()) {
                for (Entity value : entities) {
                    if (!(value instanceof LivingEntity)) continue;
                    ((StandUser)value).roundabout$setGasolineTime(((StandUser)value).roundabout$getMaxBucketGasolineTime());
                }
            }
        }
    }

    public void setFloating2() {
        if (this.getPlunderType() != PlunderTypes.SOUND.id) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.BUBBLE_PLUNDER_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
        }
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.PLUNDER, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 10, 0.2, 0.2, 0.2, 0.015);
        }
        this.setActivated(true);
        if (this.getPlunderType() == PlunderTypes.SIGHT.id) {
            Entity entity;
            if (this.getEntityStolen() > 0 && (entity = this.m_9236_().m_6815_(this.getEntityStolen())) instanceof Player) {
                Player PL = (Player)entity;
                this.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.sightStealingDurationOnPlayersInTicks;
            } else {
                this.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.sightStealingDurationOnMobsInTicks;
            }
            this.theatricPop();
        } else if (this.getPlunderType() == PlunderTypes.FRICTION.id) {
            this.lifeSpan = ClientNetworking.getAppropriateConfig().softAndWetSettings.frictionStealingDurationInTicks;
            this.theatricPop();
        }
    }

    public void setFloating() {
        this.setLaunched(false);
        this.setFloating2();
        this.m_20334_(0.0, 0.01, 0.0);
    }

    public void setFloatingUpsideDown() {
        this.setFloating2();
        this.m_20334_(0.0, -0.01, 0.0);
    }

    public void gasExplode() {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 40, 0.0, 0.2, 0.0, 0.2);
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), 1, 0.5, 0.5, 0.5, 0.2);
            MainUtil.gasExplode(null, (ServerLevel)this.m_9236_(), this.m_20097_(), 0, 2, 4, MainUtil.gasDamageMultiplier() * 16.0f);
        }
    }

    public void popSounds() {
        this.bubbleSoundsInit();
        ArrayList<StoredSoundInstance> bs = new ArrayList<StoredSoundInstance>(this.bubbleSounds){};
        if (bs != null && !bs.isEmpty()) {
            for (StoredSoundInstance value : bs) {
                if (this.m_9236_().m_5776_()) {
                    this.m_9236_().m_7785_((double)this.m_20183_().m_123341_(), (double)this.m_20183_().m_123342_(), (double)this.m_20183_().m_123343_(), value.soundEvent, value.soundSource, value.pitch, value.volume, false);
                    continue;
                }
                this.m_9236_().m_5594_(null, this.m_20183_(), value.soundEvent, value.soundSource, value.pitch, value.volume);
            }
            if (this.getPlunderType() == PlunderTypes.SOUND.id && this.getLaunched()) {
                this.m_9236_().m_214171_(GameEvent.f_157812_, this.m_20182_(), GameEvent.Context.m_223717_((Entity)this.getStandUser()));
            }
        }
    }

    public void theatricPop() {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.6, this.m_20189_(), 1, 0.0, 0.0, 0.0, 0.015);
        this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
    }

    @Override
    public void popBubble() {
        this.setFinished(true);
        if (!this.m_9236_().m_5776_()) {
            ServerLevel serverWorld = (ServerLevel)this.m_9236_();
            Vec3 userLocation = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, 100.0)) continue;
                S2CPacketUtil.sendGenericIntToClientPacket((Player)serverPlayerEntity, (byte)8, this.m_19879_());
            }
            if (!this.isPopPlunderBubbble()) {
                this.theatricPop();
                this.popSounds();
            }
            if (this.getPlunderType() == PlunderTypes.MOISTURE.id && !this.finishedUsingLiquid) {
                this.finishedUsingLiquid = true;
                if (this.stolenPhysicalLiquid && ClientNetworking.getAppropriateConfig().softAndWetSettings.moisturePoppingPlacesLiquidsInAir.booleanValue()) {
                    if (this.getLiquidStolen() == 1) {
                        this.spawnGasSplatter();
                    } else if (this.getLiquidStolen() == 2) {
                        if (MainUtil.tryPlaceBlock((Entity)this.standUser, this.m_20183_(), true)) {
                            this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_49990_.m_49966_());
                        } else {
                            this.splashWater();
                        }
                    } else if (this.getLiquidStolen() == 3) {
                        if (MainUtil.tryPlaceBlock((Entity)this.standUser, this.m_20183_(), true)) {
                            this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_49991_.m_49966_());
                        } else {
                            this.splashLava();
                        }
                    }
                } else if (this.getLiquidStolen() == 1) {
                    this.rangedSplash();
                } else if (this.getLiquidStolen() == 2) {
                    this.splashWater();
                } else if (this.getLiquidStolen() == 3) {
                    this.splashLava();
                }
            }
            this.m_146870_();
        }
    }

    public void splashWater() {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49990_.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 80, 1.0, 1.0, 1.0, 0.4);
            SoundEvent $$6 = SoundEvents.f_11917_;
            this.m_5496_($$6, 1.0f, 1.5f);
            List<Entity> entities = MainUtil.hitbox(MainUtil.genHitbox(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0, 4.0, 4.0));
            if (!entities.isEmpty()) {
                for (Entity value : entities) {
                    if (value instanceof LivingEntity && ((StandUser)value).roundabout$isOnStandFire()) {
                        ((StandUser)value).roundabout$setRemainingStandFireTicks(0);
                    }
                    if (!value.m_6060_()) continue;
                    value.m_20095_();
                }
            }
        }
    }

    public void splashLava() {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_49991_.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 80, 1.0, 1.0, 1.0, 0.4);
            SoundEvent $$6 = SoundEvents.f_11917_;
            this.m_5496_($$6, 1.0f, 1.5f);
            List<Entity> entities = MainUtil.hitbox(MainUtil.genHitbox(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 4.0, 4.0, 4.0));
            if (!entities.isEmpty()) {
                for (Entity value : entities) {
                    value.m_7311_(180 + value.m_20094_());
                }
            }
        }
    }

    public void spawnGasSplatter() {
        if (this.standUser != null) {
            GasolineSplatterEntity splat = new GasolineSplatterEntity(this.standUser, this.standUser.m_9236_());
            splat.m_20248_(this.m_20185_(), this.m_20186_(), this.m_20189_());
            this.standUser.m_9236_().m_7967_((Entity)splat);
        }
    }

    public void m_7380_(CompoundTag $$0) {
        CompoundTag compoundtag = new CompoundTag();
        $$0.m_128365_("roundabout.HeldItem", (Tag)this.getHeldItem().m_41739_(compoundtag));
        $$0.m_128379_("roundabout.ditchedItem", this.hasDitchedItem);
        $$0.m_128350_("roundabout.speed", this.getSped());
        $$0.m_128379_("roundabout.stolenLiquid", this.stolenPhysicalLiquid);
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        CompoundTag compoundtag = $$0.m_128469_("roundabout.HeldItem");
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
        this.hasDitchedItem = $$0.m_128471_("roundabout.ditchedItem");
        this.setSped($$0.m_128457_("roundabout.speed"));
        this.stolenPhysicalLiquid = $$0.m_128471_("roundabout.stolenPhysicalLiquid");
        this.setHeldItem(itemstack);
        super.m_7378_($$0);
    }

    public boolean isPopPlunderBubbble() {
        return (this.getPlunderType() == PlunderTypes.FRICTION.id || this.getPlunderType() == PlunderTypes.SIGHT.id) && this.getActivated();
    }

    public boolean isPopPotionBubbble() {
        return this.getPlunderType() == PlunderTypes.POTION_EFFECTS.id && this.getActivated();
    }

    public double m_6048_() {
        return -0.5;
    }

    public void addExp(int exp, Entity ent) {
        StandPowers standPowers;
        if (ent instanceof LivingEntity) {
            StandPowers standPowers2;
            LivingEntity LE = (LivingEntity)ent;
            if (this.standUser != null && (standPowers2 = ((StandUser)this.standUser).roundabout$getStandPowers()) instanceof PowersSoftAndWet) {
                PowersSoftAndWet PW = (PowersSoftAndWet)standPowers2;
                PW.addEXP(exp, LE);
            }
        } else if (this.standUser != null && (standPowers = ((StandUser)this.standUser).roundabout$getStandPowers()) instanceof PowersSoftAndWet) {
            PowersSoftAndWet PW = (PowersSoftAndWet)standPowers;
            PW.addEXP(exp);
        }
    }

    @Override
    protected void m_5790_(EntityHitResult $$0) {
        if (!this.m_9236_().m_5776_()) {
            Object object = $$0.m_82443_();
            if (object instanceof AbstractArrow) {
                AbstractArrow ac = (AbstractArrow)object;
                if (this.getPlunderType() == PlunderTypes.ITEM.id) {
                    this.setHeldItem(((IAbstractArrowAccess)ac).roundabout$GetPickupItem().m_278832_());
                    this.startReturning();
                    ac.m_146870_();
                    return;
                }
            }
            if ((object = $$0.m_82443_()) instanceof AreaEffectCloud) {
                ArrayList effects3;
                Potion potion;
                AreaEffectCloud ac = (AreaEffectCloud)object;
                ArrayList<MobEffectInstance> effects = new ArrayList<MobEffectInstance>(((IAreaOfEffectCloud)ac).roundabout$getEffects());
                if (!effects.isEmpty()) {
                    ArrayList<MobEffectInstance> effects2 = new ArrayList<MobEffectInstance>();
                    for (MobEffectInstance value : effects) {
                        if (MainUtil.isSpecialEffect(value) || value.m_267577_()) continue;
                        effects2.add(new MobEffectInstance(value));
                    }
                    if (!effects2.isEmpty()) {
                        this.mobEffects = effects2;
                        this.addExp(1, null);
                        this.setFloating();
                    }
                }
                if ((potion = ((IAreaOfEffectCloud)ac).roundabout$getPotions()) != null && !(effects3 = new ArrayList(potion.m_43488_())).isEmpty()) {
                    ArrayList<Object> effects4 = this.mobEffects != null && !this.mobEffects.isEmpty() ? new ArrayList<MobEffectInstance>(this.mobEffects) : new ArrayList();
                    for (MobEffectInstance value : effects3) {
                        if (MainUtil.isSpecialEffect(value) || value.m_267577_()) continue;
                        effects4.add(new MobEffectInstance(value));
                    }
                    if (!effects4.isEmpty()) {
                        this.mobEffects = effects4;
                        if (!this.getActivated()) {
                            this.setFloating();
                            this.addExp(1, null);
                        }
                    }
                }
                ac.m_146870_();
                return;
            }
            Entity ac = $$0.m_82443_();
            if (ac instanceof EnderMan) {
                EnderMan em = (EnderMan)ac;
                ((IEnderMan)em).roundabout$teleport();
                return;
            }
            if (!($$0.m_82443_() instanceof SoftAndWetBubbleEntity)) {
                if (!(this.getActivated() || this.getFinished() || MainUtil.isMobOrItsMounts($$0.m_82443_(), (Entity)this.getStandUser()) || this.getReturning())) {
                    if (this.getPlunderType() == PlunderTypes.SOUND.id) {
                        if (!((ILevelAccess)this.m_9236_()).roundabout$isSoundPlunderedEntity($$0.m_82443_())) {
                            this.setEntityStolen($$0.m_82443_().m_19879_());
                            this.addExp(1, $$0.m_82443_());
                            this.setFloating();
                        } else {
                            super.m_5790_($$0);
                        }
                    } else if (this.getPlunderType() == PlunderTypes.MOBS.id) {
                        ac = $$0.m_82443_();
                        if (ac instanceof LivingEntity && MainUtil.canBeScoopedUpInBubble(LE = (LivingEntity)ac)) {
                            this.setEntityStolen($$0.m_82443_().m_19879_());
                            $$0.m_82443_().m_20153_();
                            if ($$0.m_82443_().m_20202_() != null) {
                                $$0.m_82443_().m_20202_().m_20153_();
                            }
                            $$0.m_82443_().m_20329_((Entity)this);
                            if ($$0.m_82443_().m_20202_() != null && $$0.m_82443_().m_20202_().m_7306_((Entity)this)) {
                                this.setFloating();
                            } else {
                                super.m_5790_($$0);
                            }
                        } else {
                            super.m_5790_($$0);
                        }
                    } else if (this.getPlunderType() == PlunderTypes.FRICTION.id) {
                        ac = $$0.m_82443_();
                        if (ac instanceof LivingEntity && MainUtil.canHaveFrictionTaken(LE = (LivingEntity)ac)) {
                            if (!((ILevelAccess)this.m_9236_()).roundabout$isFrictionPlunderedEntity($$0.m_82443_())) {
                                this.setEntityStolen($$0.m_82443_().m_19879_());
                                this.addExp(1, $$0.m_82443_());
                                this.setFloating();
                            }
                        } else {
                            super.m_5790_($$0);
                        }
                    } else if (this.getPlunderType() == PlunderTypes.POTION_EFFECTS.id) {
                        ac = $$0.m_82443_();
                        if (ac instanceof LivingEntity && !(LE = (LivingEntity)ac).m_21220_().isEmpty()) {
                            effects = new ArrayList(LE.m_21220_());
                            if (!effects.isEmpty()) {
                                ArrayList<MobEffectInstance> effects2 = new ArrayList<MobEffectInstance>();
                                Iterator potion = effects.iterator();
                                while (potion.hasNext()) {
                                    MobEffectInstance value = (MobEffectInstance)potion.next();
                                    if (MainUtil.isSpecialEffect(value) || value.m_267577_()) continue;
                                    effects2.add(new MobEffectInstance(value));
                                    LE.m_21195_(value.m_19544_());
                                }
                                if (!effects2.isEmpty()) {
                                    this.mobEffects = effects2;
                                    this.addExp(1, $$0.m_82443_());
                                    this.setFloating();
                                } else {
                                    super.m_5790_($$0);
                                }
                            } else {
                                super.m_5790_($$0);
                            }
                        } else {
                            super.m_5790_($$0);
                        }
                    } else if (this.getPlunderType() == PlunderTypes.SIGHT.id) {
                        effects = $$0.m_82443_();
                        if (effects instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)effects)).roundabout$getEyeSightTaken() == null && MainUtil.canHaveSightTaken(LE)) {
                            this.setEntityStolen($$0.m_82443_().m_19879_());
                            this.addExp(1, $$0.m_82443_());
                            if (!this.m_9236_().m_5776_()) {
                                ((StandUser)LE).roundabout$deeplyRemoveAttackTarget();
                                ((StandUser)LE).roundabout$setEyeSightTaken(this);
                            }
                            this.setFloating();
                        } else {
                            super.m_5790_($$0);
                        }
                    } else if (this.getPlunderType() == PlunderTypes.OXYGEN.id) {
                        if (this.getLaunched() && this.getActivated()) {
                            $$0.m_82443_().m_7311_($$0.m_82443_().m_20094_() + this.fireTicks);
                            super.m_5790_($$0);
                        } else if ($$0.m_82443_().m_6060_()) {
                            this.fireTicks = $$0.m_82443_().m_20094_();
                            $$0.m_82443_().m_20095_();
                            this.setFloating();
                        } else {
                            effects = $$0.m_82443_();
                            if (effects instanceof LivingEntity && !(LE = (LivingEntity)effects).m_6040_()) {
                                int supply = $$0.m_82443_().m_20146_();
                                if (supply > 0) {
                                    this.airSupply = supply;
                                    $$0.m_82443_().m_20301_(0);
                                    this.startReturning();
                                }
                            } else {
                                super.m_5790_($$0);
                            }
                        }
                    } else {
                        super.m_5790_($$0);
                    }
                } else if (this.getActivated() && this.getLaunched() && !this.getFinished()) {
                    if (this.getPlunderType() == PlunderTypes.POTION_EFFECTS.id) {
                        Entity supply = $$0.m_82443_();
                        if (supply instanceof LivingEntity) {
                            LE = (LivingEntity)supply;
                            if (this.mobEffects != null && !this.mobEffects.isEmpty()) {
                                ArrayList<MobEffectInstance> mobEffects2 = new ArrayList<MobEffectInstance>(this.mobEffects);
                                for (MobEffectInstance value : mobEffects2) {
                                    LE.m_7292_(value);
                                }
                            }
                            super.m_5790_($$0);
                        }
                    } else if (this.getPlunderType() == PlunderTypes.OXYGEN.id && !MainUtil.isMobOrItsMounts($$0.m_82443_(), (Entity)this.getStandUser())) {
                        $$0.m_82443_().m_7311_($$0.m_82443_().m_20094_() + this.fireTicks);
                        super.m_5790_($$0);
                    } else if (this.getPlunderType() == PlunderTypes.MOISTURE.id && !MainUtil.isMobOrItsMounts($$0.m_82443_(), (Entity)this.getStandUser())) {
                        if (this.getLiquidStolen() == 1) {
                            this.splashGas($$0.m_82443_());
                            this.finishedUsingLiquid = true;
                        } else if (this.getLiquidStolen() == 6) {
                            Entity entity = $$0.m_82443_();
                            if (entity instanceof LivingEntity && !MainUtil.hasEnderBlood((Entity)(LE = (LivingEntity)entity))) {
                                MainUtil.randomChorusTeleport(LE);
                            }
                            this.finishedUsingLiquid = true;
                        }
                        super.m_5790_($$0);
                    }
                }
            }
        }
    }

    public void splashGas(Entity ent) {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.GASOLINE_SPLATTER.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 15, 0.4, 0.4, 0.25, 0.4);
        SoundEvent $$6 = SoundEvents.f_11917_;
        this.m_5496_($$6, 1.0f, 1.5f);
        if (ent instanceof LivingEntity) {
            ((StandUser)ent).roundabout$setGasolineTime(((StandUser)ent).roundabout$getMaxBucketGasolineTime());
        }
    }

    protected float m_6380_(Pose $$0, EntityDimensions $$1) {
        return $$1.f_20378_ * 0.1f;
    }

    public void addItemLight() {
        if (!this.hasDitchedItem) {
            LivingEntity livingEntity = this.standUser;
            if (livingEntity instanceof Player) {
                Player PE = (Player)livingEntity;
                if (this.canAddItem(this.getHeldItem(), PE.m_150109_()) && this.standUser.m_6084_()) {
                    PE.m_36356_(this.getHeldItem());
                } else {
                    $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
                    $$4.m_32010_(40);
                    $$4.m_32052_(this.standUser.m_20148_());
                    this.standUser.m_9236_().m_7967_((Entity)$$4);
                }
            } else {
                $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
                $$4.m_32010_(40);
                this.m_9236_().m_7967_((Entity)$$4);
            }
        }
    }

    public void forceDropItem() {
        if (!this.hasDitchedItem) {
            ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
            $$4.m_32010_(40);
            $$4.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)$$4);
            this.hasDitchedItem = true;
        }
    }

    public void addItemNotLight(Entity ent) {
        if (!this.hasDitchedItem) {
            if (ent instanceof Player) {
                Player PE = (Player)ent;
                if (this.canAddItem(this.getHeldItem(), PE.m_150109_()) && PE.m_6084_()) {
                    PE.m_36356_(this.getHeldItem());
                } else {
                    ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
                    $$4.m_32010_(40);
                    $$4.m_32052_(PE.m_20148_());
                    PE.m_9236_().m_7967_((Entity)$$4);
                }
            } else {
                ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.getHeldItem());
                $$4.m_32010_(40);
                this.m_9236_().m_7967_((Entity)$$4);
            }
        }
    }

    public boolean canAddItem(ItemStack itemStack, Inventory inventory) {
        boolean bl = false;
        for (ItemStack itemStack2 : inventory.f_35974_) {
            if (!itemStack2.m_41619_() && (!ItemStack.m_150942_((ItemStack)itemStack2, (ItemStack)itemStack) || itemStack2.m_41613_() >= itemStack2.m_41741_())) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public void returnToUser() {
        if (this.standUser != null) {
            this.m_20256_(this.m_20318_(1.0f).m_82546_(this.standUser.m_20182_()).m_82548_().m_82541_().m_82490_(0.4));
        }
    }

    public void startReturning() {
        if (this.getPlunderType() != PlunderTypes.SOUND.id) {
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.BUBBLE_PLUNDER_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
        }
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ModParticles.PLUNDER, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() * 0.5, this.m_20189_(), 10, 0.2, 0.2, 0.2, 0.015);
        }
        this.setReturning(true);
        this.returnToUser();
    }

    public LivingEntity getStandUser() {
        if (this.standUser != null) {
            return this.standUser;
        }
        if (this.standUserUUID != null && !this.m_9236_().m_5776_()) {
            Entity ett = ((ServerLevel)this.m_9236_()).m_8791_(this.standUserUUID);
            if (ett instanceof LivingEntity) {
                LivingEntity lett;
                this.standUser = lett = (LivingEntity)ett;
                this.setUserID(lett.m_19879_());
            }
        } else {
            Entity entity = this.m_9236_().m_6815_(this.getUserID());
            if (entity instanceof LivingEntity) {
                LivingEntity LE;
                this.standUser = LE = (LivingEntity)entity;
            }
        }
        return this.standUser;
    }

    public void popIfSuffocating() {
        if (!this.m_9236_().m_5776_() && this.getPlunderType() == PlunderTypes.MOBS.id && this.getActivated()) {
            Entity ent = this.m_9236_().m_6815_(this.getEntityStolen());
            if (ent != null) {
                SoftAndWetPlunderBubbleEntity sbe;
                Entity entity;
                if (ent.m_5830_() || !((entity = ent.m_20202_()) instanceof SoftAndWetPlunderBubbleEntity) || !(sbe = (SoftAndWetPlunderBubbleEntity)entity).m_7306_((Entity)this)) {
                    this.m_20153_();
                    this.popBubble();
                }
            } else {
                this.m_20153_();
                this.popBubble();
            }
        }
    }

    @Override
    public void m_8119_() {
        StandPowers standPowers;
        LivingEntity usr;
        if (!this.m_9236_().m_5776_()) {
            if (this.isPopPlunderBubbble()) {
                this.m_20256_(Vec3.f_82478_);
            }
            --this.lifeSpan;
            if (this.lifeSpan <= 0 || this.standUser == null || !(((StandUser)this.standUser).roundabout$getStandPowers() instanceof PowersSoftAndWet)) {
                this.popBubble();
                return;
            }
        }
        if ((usr = this.getStandUser()) != null && (standPowers = ((StandUser)usr).roundabout$getStandPowers()) instanceof PowersSoftAndWet) {
            PowersSoftAndWet PW = (PowersSoftAndWet)standPowers;
            if (PW.bubbleList != null && !PW.bubbleList.contains(this)) {
                PW.bubbleList.add(this);
            }
        } else if (!this.m_9236_().m_5776_()) {
            this.popBubble();
            return;
        }
        if (this.getActivated()) {
            if (!(!this.m_9236_().m_5776_() && this.isArrayAdded || this.getPlunderType() != PlunderTypes.FRICTION.id && this.getPlunderType() != PlunderTypes.SOUND.id)) {
                if (this.getEntityStolen() <= 0) {
                    ((ILevelAccess)this.m_9236_()).roundabout$addPlunderBubble(this);
                    this.isArrayAdded = true;
                } else {
                    ((ILevelAccess)this.m_9236_()).roundabout$addPlunderBubbleEntity(this);
                    this.isArrayAdded = true;
                }
            }
        } else if (this.getReturning()) {
            this.returnToUser();
        } else {
            Entity owner = this.m_19749_();
            if (this.getSingular()) {
                if (owner != null && !this.getActivated()) {
                    this.shootFromRotationDeltaAgnostic2(owner, owner.m_146909_(), owner.m_146908_(), 1.0f, this.getSped());
                }
            } else if (this.f_19797_ < 20 && !this.getLaunched()) {
                this.m_20256_(this.m_20184_().m_82490_(0.86));
            }
        }
        Vec3 currentPos = this.m_20182_();
        Vec3 nextPos = currentPos.m_82549_(this.m_20184_());
        AABB sweptBox = this.m_20191_().m_82369_(this.m_20184_()).m_82400_((double)(this.m_20205_() * 1.0f) + 0.1);
        EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)sweptBox, this::m_5603_);
        if (entityHitResult != null) {
            this.m_5790_(entityHitResult);
        }
        AABB box = this.m_20191_().m_82400_(0.2);
        for (Entity e : this.m_9236_().m_6249_((Entity)this, box, this::m_5603_)) {
            this.m_5790_(new EntityHitResult(e));
        }
        this.stealLiquidsAndFlames();
        if (this.getActivated() && !this.getReturning() && !this.getFinished() && !this.getLaunched()) {
            this.m_20334_(0.0, 0.01, 0.0);
        }
        AABB BB1 = this.m_20191_();
        this.popIfSuffocating();
        super.m_8119_();
        this.popIfSuffocating();
        if (!(this.getPlunderType() != PlunderTypes.ITEM.id || this.getReturning() || this.getFinished() || this.m_213877_())) {
            AABB BB2 = this.m_20191_();
            this.tryPhaseItemGrab(BB1, BB2);
        }
        this.stealLiquidsAndFlames();
        if (!this.getReturning() && !this.m_9236_().m_5776_() && this.getPlunderType() == PlunderTypes.OXYGEN.id && this.standUser != null && this.standUser.m_5842_() && this.m_9236_().m_8055_(this.m_20183_()).m_60795_()) {
            this.airSupply = this.standUser.m_6062_();
            this.startReturning();
        }
        if (this.getFinished()) {
            if (!this.m_9236_().m_5776_()) {
                this.m_146870_();
            }
        } else if (this.getReturning() && !this.m_9236_().m_5776_() && this.standUser != null && this.m_20270_((Entity)this.standUser) < 1.0f) {
            if (this.getPlunderType() == PlunderTypes.OXYGEN.id) {
                int maxSupply = this.standUser.m_6062_();
                int supply = this.standUser.m_20146_();
                if (supply < maxSupply) {
                    if ((supply += this.airSupply) > maxSupply) {
                        supply = maxSupply;
                    }
                    this.standUser.m_20301_(supply);
                    this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.AIR_BUBBLE_EVENT, SoundSource.PLAYERS, 2.0f, (float)(1.1 + Math.random() * 0.04));
                }
            }
            this.popBubble();
        }
    }

    protected boolean m_5603_(Entity $$0x) {
        if ($$0x instanceof AbstractArrow) {
            AbstractArrow aw = (AbstractArrow)$$0x;
            if (aw.f_36705_.equals((Object)AbstractArrow.Pickup.ALLOWED) && ((IAbstractArrowAccess)aw).roundabout$GetInGround() && this.getPlunderType() == PlunderTypes.ITEM.id) {
                return true;
            }
        }
        if ($$0x instanceof AreaEffectCloud && this.getPlunderType() == PlunderTypes.POTION_EFFECTS.id) {
            return true;
        }
        return super.m_5603_($$0x);
    }

    public boolean m_5825_() {
        return true;
    }

    public void tryPhaseItemGrab(AABB bb1, AABB bb2) {
        if (!this.m_9236_().f_46443_) {
            bb1 = bb1.m_82400_((double)1.6f);
            bb2 = bb2.m_82400_((double)1.6f);
            AABB $$2 = bb1.m_82367_(bb2);
            List $$3 = this.m_9236_().m_45933_((Entity)this, $$2);
            if (!$$3.isEmpty()) {
                for (int $$4 = 0; $$4 < $$3.size(); ++$$4) {
                    BlockItem BI;
                    ItemEntity IE;
                    Item item;
                    Entity $$5 = (Entity)$$3.get($$4);
                    if (!($$5 instanceof ItemEntity) || (item = (IE = (ItemEntity)$$5).m_32055_().m_41720_()) instanceof BlockItem && (BI = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock) continue;
                    this.setHeldItem(IE.m_32055_().m_255036_(1));
                    this.startReturning();
                    IE.m_32055_().m_41774_(1);
                    this.itemNearby(IE.m_19879_());
                    return;
                }
            }
        }
    }

    public void stealLiquidsAndFlames() {
        if (!this.m_9236_().m_5776_() && !this.m_213877_()) {
            if (this.getPlunderType() == PlunderTypes.MOISTURE.id) {
                BlockState bs = this.m_9236_().m_8055_(this.m_20183_());
                if (!this.getActivated()) {
                    if (bs.m_60713_(Blocks.f_49990_) && (Integer)bs.m_61143_((Property)BlockStateProperties.f_61422_) == 0) {
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_7731_(this.m_20183_(), Blocks.f_50016_.m_49966_(), 11);
                            this.stolenPhysicalLiquid = true;
                        }
                        this.setLiquidStolen(2);
                        this.setFloating();
                    } else if (bs.m_60713_(Blocks.f_49991_) && (Integer)bs.m_61143_((Property)BlockStateProperties.f_61422_) == 0) {
                        if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser) && ClientNetworking.getAppropriateConfig().softAndWetSettings.moistureWithStandGriefingTakesLiquidBlocks.booleanValue()) {
                            this.m_9236_().m_7731_(this.m_20183_(), Blocks.f_50016_.m_49966_(), 11);
                            this.stolenPhysicalLiquid = true;
                        }
                        this.setLiquidStolen(3);
                        this.setFloating();
                    }
                } else if (this.getLiquidStolen() == 1 && (bs.m_60734_() instanceof FireBlock || bs.m_60734_() instanceof StandFireBlock)) {
                    this.gasExplode();
                    this.popBubble();
                }
            } else if (this.getPlunderType() == PlunderTypes.OXYGEN.id) {
                BlockState bs = this.m_9236_().m_8055_(this.m_20183_());
                if (!this.getActivated() && bs.m_60734_() instanceof BaseFireBlock && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.standUser)) {
                    this.fireTicks = 100;
                    this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_50016_.m_49966_());
                    this.setFloating();
                }
            }
        }
    }

    @Override
    public boolean m_6469_(DamageSource $$0, float $$1) {
        block4: {
            block6: {
                Entity entity;
                block7: {
                    block8: {
                        block5: {
                            if (this.isPopPlunderBubbble()) {
                                return false;
                            }
                            if (this.m_9236_().m_5776_()) break block4;
                            if (this.getPlunderType() != PlunderTypes.ITEM.id) break block5;
                            this.addItemNotLight($$0.m_7639_());
                            this.hasDitchedItem = true;
                            break block6;
                        }
                        if (this.getPlunderType() != PlunderTypes.MOISTURE.id) break block7;
                        if (this.getLiquidStolen() != 1 || !this.stolenPhysicalLiquid || $$0.m_7640_() == null || $$0.m_7639_() == null) break block6;
                        if (!$$0.m_7640_().m_6060_() && !($$0.m_7640_() instanceof FireProjectile)) break block8;
                        this.gasExplode();
                        this.finishedUsingLiquid = true;
                        break block6;
                    }
                    ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, ModBlocks.GASOLINE_SPLATTER.m_49966_()), (double)this.m_20097_().m_123341_() + 0.5, (double)this.m_20097_().m_123342_() + 0.5, (double)this.m_20097_().m_123343_() + 0.5, 15, 0.4, 0.4, 0.25, 0.4);
                    SoundEvent $$6 = SoundEvents.f_11917_;
                    this.m_5496_($$6, 1.0f, 1.5f);
                    if (!($$0.m_7639_() instanceof LivingEntity) || !$$0.m_7640_().m_7306_($$0.m_7639_())) break block6;
                    ((StandUser)$$0.m_7639_()).roundabout$setGasolineTime(((StandUser)$$0.m_7639_()).roundabout$getMaxBucketGasolineTime());
                    break block6;
                }
                if (this.getPlunderType() == PlunderTypes.POTION_EFFECTS.id && (entity = $$0.m_7639_()) instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)entity;
                    if (this.mobEffects != null && !this.mobEffects.isEmpty()) {
                        ArrayList<MobEffectInstance> mobEffects2 = new ArrayList<MobEffectInstance>(this.mobEffects);
                        for (MobEffectInstance value : mobEffects2) {
                            LE.m_7292_(value);
                        }
                    }
                }
            }
            return super.m_6469_($$0, $$1);
        }
        return true;
    }

    public final ItemStack getHeldItem() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM);
    }

    public final void setHeldItem(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM, (Object)stack);
    }

    public final void itemNearby(int id) {
        if (!this.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.m_9236_();
            Vec3 userLocation = new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, 100.0)) continue;
                S2CPacketUtil.sendGenericIntToClientPacket((Player)serverPlayerEntity, (byte)4, id);
            }
        }
    }

    public int getPlunderType() {
        return ((Byte)this.m_20088_().m_135370_(PLUNDER_TYPE)).byteValue();
    }

    public void setPlunderType(byte bt) {
        this.m_20088_().m_135381_(PLUNDER_TYPE, (Object)bt);
    }

    public PlunderTypes getPlunderTypes(PlunderTypes bt) {
        return PlunderTypes.getPlunderTypeDromByte((Byte)this.m_20088_().m_135370_(PLUNDER_TYPE));
    }

    public void setPlunderType(PlunderTypes bt) {
        this.m_20088_().m_135381_(PLUNDER_TYPE, (Object)bt.id);
    }

    public BlockPos getBlockPos() {
        return (BlockPos)this.m_20088_().m_135370_(BLOCK_POS);
    }

    public void setBlockPos(BlockPos bpos) {
        this.m_20088_().m_135381_(BLOCK_POS, (Object)bpos);
    }

    public boolean getFinished() {
        return (Boolean)this.m_20088_().m_135370_(FINISHED);
    }

    public void setFinished(boolean activ) {
        this.m_20088_().m_135381_(FINISHED, (Object)activ);
    }

    public boolean getSingular() {
        return (Boolean)this.m_20088_().m_135370_(SINGULAR);
    }

    public void setSingular(boolean single) {
        this.m_20088_().m_135381_(SINGULAR, (Object)single);
    }

    public boolean getReturning() {
        return (Boolean)this.m_20088_().m_135370_(RETURNING);
    }

    public void setReturning(boolean single) {
        this.m_20088_().m_135381_(RETURNING, (Object)single);
    }

    public int getEntityStolen() {
        return (Integer)this.m_20088_().m_135370_(ENTITY_STOLEN);
    }

    public void setEntityStolen(int entid) {
        this.m_20088_().m_135381_(ENTITY_STOLEN, (Object)entid);
    }

    public int getLiquidStolen() {
        return (Integer)this.m_20088_().m_135370_(LIQUID_STOLEN);
    }

    public void setLiquidStolen(int entid) {
        this.m_20088_().m_135381_(LIQUID_STOLEN, (Object)entid);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        if (!this.f_19804_.m_285897_(PLUNDER_TYPE)) {
            this.f_19804_.m_135372_(PLUNDER_TYPE, (Object)0);
            this.f_19804_.m_135372_(BLOCK_POS, (Object)BlockPos.f_121853_);
            this.f_19804_.m_135372_(FINISHED, (Object)false);
            this.f_19804_.m_135372_(SINGULAR, (Object)false);
            this.f_19804_.m_135372_(RETURNING, (Object)false);
            this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
            this.f_19804_.m_135372_(ENTITY_STOLEN, (Object)-1);
            this.f_19804_.m_135372_(LIQUID_STOLEN, (Object)-1);
        }
    }

    public void m_142687_(Entity.RemovalReason $$0) {
        if (!this.getHeldItem().m_41619_() && !this.m_9236_().m_5776_()) {
            this.addItemLight();
        }
        super.m_142687_($$0);
    }
}

