/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import java.util.UUID;
import net.hydra.jojomod.access.NoVibrationEntity;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.Minecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public abstract class StandEntity
extends Mob
implements NoVibrationEntity {
    public final int MaxFade = 8;
    public float fadePercent = 0.0f;
    protected static final EntityDataAccessor<Integer> FADE_PERCENT = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> FADE_OUT = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> USER_ID = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> ANIMATION = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> IDLE_ANIMATION = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<ItemStack> HELD_ITEM = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Byte> SKIN = SynchedEntityData.m_135353_(StandEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public boolean canAcquireHeldItem = false;
    public float bodyRotationX = 0.0f;
    public float bodyRotationY = 0.0f;
    public float headRotationX = 0.0f;
    public float headRotationY = 0.0f;
    public float standRotationX = 0.0f;
    public float standRotationY = 0.0f;
    public float standRotationZ = 0.0f;
    private boolean isDisplay;
    @Nullable
    public LivingEntity User;
    public static final byte IDLE = 0;
    public static final byte FIRST_PUNCH = 1;
    public static final byte SECOND_PUNCH = 2;
    public static final byte THIRD_PUNCH = 3;
    public static final byte BLOCK = 10;
    public static final byte BARRAGE_CHARGE = 11;
    public static final byte BARRAGE = 12;
    public static final byte BARRAGE_FINISHER = 13;
    public static final byte HURT_BY_BARRAGE = 14;
    public static final byte BROKEN_GUARD = 15;
    public static final byte MINING_BARRAGE = 16;
    public static final byte LEAP = 17;
    public static final byte LEAP_END = 18;
    public static final byte TIME_STOP = 30;
    public static final byte TIME_STOP_RELEASE = 31;
    public static final byte BLOCK_GRAB = 32;
    public static final byte BLOCK_THROW = 33;
    public static final byte ITEM_GRAB = 34;
    public static final byte ITEM_THROW = 35;
    public static final byte BLOCK_RETRACT = 36;
    public static final byte ITEM_RETRACT = 37;
    public static final byte ENTITY_GRAB = 38;
    public static final byte KICK_BARRAGE_WINDUP = 42;
    public static final byte KICK_BARRAGE_END = 43;
    public static final byte IMPALE = 81;
    public static final byte KICK_BARRAGE = 80;
    public static final byte FINAL_ATTACK_WINDUP = 85;
    public static final byte FINAL_ATTACK = 86;
    public static final byte PHASE_GRAB = 87;
    public final AnimationState idleAnimationState = new AnimationState();
    public final AnimationState idleAnimationState2 = new AnimationState();
    public final AnimationState idleAnimationState3 = new AnimationState();
    public final AnimationState idleAnimationState4 = new AnimationState();
    public final AnimationState punchState1 = new AnimationState();
    public final AnimationState punchState2 = new AnimationState();
    public final AnimationState punchState3 = new AnimationState();
    public final AnimationState blockAnimationState = new AnimationState();
    public final AnimationState blockLoinAnimationState = new AnimationState();
    public final AnimationState barrageChargeAnimationState = new AnimationState();
    public final AnimationState barrageAnimationState = new AnimationState();
    public final AnimationState miningBarrageAnimationState = new AnimationState();
    public final AnimationState barrageEndAnimationState = new AnimationState();
    public final AnimationState barrageHurtAnimationState = new AnimationState();
    public final AnimationState brokenBlockAnimationState = new AnimationState();
    public final AnimationState standLeapAnimationState = new AnimationState();
    public final AnimationState standLeapEndAnimationState = new AnimationState();
    public final AnimationState armlessAnimation = new AnimationState();
    public final AnimationState armlessAnimationIdle = new AnimationState();
    public boolean forceVisible = false;
    public UUID validationUUID = null;
    public boolean forceDespawnSet = false;

    public boolean lockPos() {
        return true;
    }

    @Override
    public boolean getVibration() {
        return false;
    }

    public boolean m_5801_() {
        return false;
    }

    public void setUser(LivingEntity StandSet) {
        this.User = StandSet;
        int standSetId = -1;
        if (StandSet != null) {
            standSetId = StandSet.m_19879_();
        }
        this.f_19804_.m_135381_(USER_ID, (Object)standSetId);
        this.setFollowing(StandSet);
    }

    public void setFollowing(LivingEntity StandSet) {
    }

    public void setupAnimationStates() {
        if (this.getUser() != null) {
            byte idle = this.getIdleAnimation();
            byte animation = this.getAnimation();
            if (animation == 0 && idle == 1) {
                this.idleAnimationState2.m_216982_(this.f_19797_);
            } else {
                this.idleAnimationState2.m_216973_();
            }
            if (animation == 0 && idle == 0) {
                this.idleAnimationState.m_216982_(this.f_19797_);
            } else {
                this.idleAnimationState.m_216973_();
            }
            if (animation == 0 && idle == 2) {
                this.idleAnimationState3.m_216982_(this.f_19797_);
            } else {
                this.idleAnimationState3.m_216973_();
            }
            if (animation == 0 && idle == 3) {
                this.idleAnimationState4.m_216982_(this.f_19797_);
            } else {
                this.idleAnimationState4.m_216973_();
            }
            if (idle == 4) {
                if (animation == 0) {
                    this.armlessAnimationIdle.m_216982_(this.f_19797_);
                    this.armlessAnimation.m_216973_();
                } else {
                    this.armlessAnimation.m_216982_(this.f_19797_);
                    this.armlessAnimationIdle.m_216973_();
                }
            } else {
                this.armlessAnimationIdle.m_216973_();
                this.armlessAnimation.m_216973_();
            }
            if (animation == 1) {
                this.punchState1.m_216982_(this.f_19797_);
            } else {
                this.punchState1.m_216973_();
            }
            if (animation == 2) {
                this.punchState2.m_216982_(this.f_19797_);
            } else {
                this.punchState2.m_216973_();
            }
            if (animation == 3) {
                this.punchState3.m_216982_(this.f_19797_);
            } else {
                this.punchState3.m_216973_();
            }
            if (animation == 10) {
                this.blockAnimationState.m_216982_(this.f_19797_);
            } else {
                this.blockAnimationState.m_216973_();
            }
            if (animation == 11) {
                this.barrageChargeAnimationState.m_216982_(this.f_19797_);
            } else {
                this.barrageChargeAnimationState.m_216973_();
            }
            if (animation == 12) {
                this.barrageAnimationState.m_216982_(this.f_19797_);
            } else {
                this.barrageAnimationState.m_216973_();
            }
            if (animation == 13) {
                this.barrageEndAnimationState.m_216982_(this.f_19797_);
            } else {
                this.barrageEndAnimationState.m_216973_();
            }
            if (animation == 14) {
                this.barrageHurtAnimationState.m_216982_(this.f_19797_);
            } else {
                this.barrageHurtAnimationState.m_216973_();
            }
            if (animation == 15) {
                this.brokenBlockAnimationState.m_216982_(this.f_19797_);
            } else {
                this.brokenBlockAnimationState.m_216973_();
            }
            if (animation == 16) {
                this.miningBarrageAnimationState.m_216982_(this.f_19797_);
            } else {
                this.miningBarrageAnimationState.m_216973_();
            }
            if (animation == 17) {
                this.standLeapAnimationState.m_216982_(this.f_19797_);
            } else {
                this.standLeapAnimationState.m_216973_();
            }
            if (animation == 18) {
                this.standLeapEndAnimationState.m_216982_(this.f_19797_);
            } else {
                this.standLeapEndAnimationState.m_216973_();
            }
        }
    }

    public final void setAnimation(byte animation) {
        this.f_19804_.m_135381_(ANIMATION, (Object)animation);
    }

    public final void setIdleAnimation(byte animation) {
        this.f_19804_.m_135381_(IDLE_ANIMATION, (Object)animation);
    }

    public final void setSkin(byte skin) {
        this.f_19804_.m_135381_(SKIN, (Object)skin);
    }

    public boolean dismountOnHit() {
        return true;
    }

    public boolean canRestrainWhileMounted() {
        return true;
    }

    public final void setHeldItem(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM, (Object)stack);
    }

    public byte getMaxFade() {
        return 8;
    }

    public final void setFadeOut(Byte FadeOut) {
        this.f_19804_.m_135381_(FADE_OUT, (Object)FadeOut);
    }

    public int getFadeOut() {
        return ((Byte)this.f_19804_.m_135370_(FADE_OUT)).byteValue();
    }

    public final void setFadePercent(Integer FadeOut) {
        this.f_19804_.m_135381_(FADE_PERCENT, (Object)FadeOut);
    }

    public int getFadePercent() {
        return (Integer)this.f_19804_.m_135370_(FADE_PERCENT);
    }

    public boolean m_5825_() {
        return true;
    }

    public final byte getAnimation() {
        return (Byte)this.f_19804_.m_135370_(ANIMATION);
    }

    public final byte getIdleAnimation() {
        return (Byte)this.f_19804_.m_135370_(IDLE_ANIMATION);
    }

    public final ItemStack getHeldItem() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM);
    }

    public final byte getSkin() {
        return (Byte)this.f_19804_.m_135370_(SKIN);
    }

    public final boolean getNeedsUser() {
        return true;
    }

    public float getBodyRotationX() {
        return this.bodyRotationX;
    }

    public float getBodyRotationY() {
        return this.bodyRotationY;
    }

    public void setBodyRotationX(float bodRot) {
        this.bodyRotationX = bodRot;
    }

    public void setBodyRotationY(float bodRot) {
        this.bodyRotationY = bodRot;
    }

    public float getHeadRotationX() {
        return this.headRotationX;
    }

    public float getHeadRotationY() {
        return this.headRotationY;
    }

    public void setHeadRotationX(float bodRot) {
        this.headRotationX = bodRot;
    }

    public void setHeadRotationY(float bodRot) {
        this.headRotationY = bodRot;
    }

    public float getStandRotationX() {
        return this.standRotationX;
    }

    public float getStandRotationY() {
        return this.standRotationY;
    }

    public float getStandRotationZ() {
        return this.standRotationZ;
    }

    public void setStandRotationX(float bodRot) {
        this.standRotationX = bodRot;
    }

    public void setStandRotationY(float bodRot) {
        this.standRotationY = bodRot;
    }

    public void setStandRotationZ(float bodRot) {
        this.standRotationZ = bodRot;
    }

    public Vec3 getBonusOffset() {
        return Vec3.f_82478_;
    }

    public void playerSetProperties(Player PE) {
    }

    public boolean m_6069_() {
        if (this.getUser() != null) {
            return this.getUser().m_6069_();
        }
        return false;
    }

    public boolean m_20143_() {
        if (this.getUser() != null) {
            return this.getUser().m_20143_();
        }
        return false;
    }

    public boolean m_21255_() {
        if (this.getUser() != null) {
            return this.getUser().m_21255_();
        }
        return false;
    }

    public boolean getDisplay() {
        return this.isDisplay;
    }

    public void setDisplay(boolean display) {
        this.isDisplay = display;
    }

    public void incFadeOut(byte inc) {
        this.setFadeOut((byte)(this.getFadeOut() + inc));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(FADE_OUT, (Object)0);
        this.f_19804_.m_135372_(FADE_PERCENT, (Object)100);
        this.f_19804_.m_135372_(USER_ID, (Object)-1);
        this.f_19804_.m_135372_(ANIMATION, (Object)0);
        this.f_19804_.m_135372_(IDLE_ANIMATION, (Object)0);
        this.f_19804_.m_135372_(HELD_ITEM, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(SKIN, (Object)0);
    }

    protected StandEntity(EntityType<? extends Mob> entityType, Level world) {
        super(entityType, world);
    }

    public boolean m_6040_() {
        return true;
    }

    public boolean hasUser() {
        return this.getUser() != null;
    }

    public StandUser getUserData(LivingEntity User) {
        return (StandUser)User;
    }

    public void setMaster(LivingEntity Master) {
        this.setUser(Master);
    }

    public LivingEntity getUser() {
        if (this.m_9236_().f_46443_) {
            return (LivingEntity)this.m_9236_().m_6815_(((Integer)this.f_19804_.m_135370_(USER_ID)).intValue());
        }
        return this.User;
    }

    public void validateUUID() {
        LivingEntity livingEntity;
        if (!this.m_9236_().f_46443_ && this.getUser() != null && (livingEntity = this.getUser()) instanceof Player) {
            Player PE = (Player)livingEntity;
            if (this.validationUUID == null) {
                this.validationUUID = PE.m_20148_();
            } else {
                Player ZE = this.m_9236_().m_46003_(this.validationUUID);
                if (!(ZE == null || ZE.m_7306_((Entity)PE) && ZE.m_19879_() == PE.m_19879_())) {
                    this.m_146870_();
                }
            }
        }
    }

    public boolean startStandRiding(LivingEntity entity, boolean force) {
        ((StandUser)entity).roundabout$setStand(this);
        return true;
    }

    public boolean redirectKnockbackToUser() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.getUser() != null && MainUtil.isStandDamage(source)) {
            return this.getUser().m_6469_(source, amount);
        }
        return false;
    }

    public boolean m_20147_() {
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_7313_(Entity $$0) {
        return true;
    }

    public boolean m_6063_() {
        return false;
    }

    public boolean m_5829_() {
        return false;
    }

    public boolean m_7337_(Entity $$0) {
        return false;
    }

    public boolean m_271807_() {
        return false;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    public boolean hasNoPhysics() {
        return !this.isRemoteControlled();
    }

    public void m_7334_(Entity $$0) {
    }

    public void m_7324_(Entity $$0) {
    }

    public void m_8119_() {
        this.validateUUID();
        this.f_19794_ = this.hasNoPhysics();
        super.m_8119_();
        if (this.m_9236_().m_5776_()) {
            this.setupAnimationStates();
        }
        if ((this.m_6084_() && !this.f_20890_ || this.forceVisible) && !this.forceDespawnSet) {
            if (this.getNeedsUser() && !this.forceVisible) {
                LivingEntity userEntity = this.getUser();
                if (userEntity != null && !userEntity.m_213877_()) {
                    StandEntity thisStand;
                    StandUser user = this.getUserData(userEntity);
                    boolean userActive = user.roundabout$getActive();
                    if (this.isValid(userActive, (LivingEntity)(thisStand = user.roundabout$getStand()), userEntity)) {
                        if (this.getFadeOut() < 8 && !this.m_9236_().m_5776_()) {
                            this.incFadeOut((byte)1);
                        }
                        if (!this.m_9236_().m_5776_() && (((StandUser)this.getUser()).roundabout$getStandDisc().m_41619_() || ((StandUser)this.getUser()).roundabout$getStandDisc().m_150930_(ModItems.STAND_DISC))) {
                            this.m_146870_();
                            return;
                        }
                    } else {
                        this.handleTickDownIfDupe((LivingEntity)thisStand);
                    }
                } else {
                    this.TickDown();
                }
            } else if (!this.getNeedsUser()) {
                if (this.getFadeOut() < 8 && !this.m_9236_().m_5776_()) {
                    this.incFadeOut((byte)1);
                }
            } else {
                this.setFadeOut(this.getMaxFade());
            }
        } else {
            this.TickDown();
        }
        this.m_20242_(!this.standHasGravity());
    }

    public boolean standHasGravity() {
        return false;
    }

    public boolean validatePowers(LivingEntity user) {
        return ((StandUser)user).roundabout$getStandPowers() instanceof StandPowers;
    }

    public boolean needsActive() {
        return true;
    }

    public boolean isValid(boolean userActive, LivingEntity thisStand, LivingEntity userEntity) {
        return userEntity.m_6084_() && !userEntity.m_213877_() && (!this.needsActive() || userActive) && thisStand != null && thisStand.m_7306_((Entity)this);
    }

    public void handleTickDownIfDupe(LivingEntity thisStand) {
        StandEntity SE;
        if (thisStand != null && !thisStand.m_7306_((Entity)this) && thisStand instanceof StandEntity && (SE = (StandEntity)thisStand).getFadeOut() >= 1 && this.getFadeOut() > 1) {
            this.setFadeOut((byte)1);
            this.TickDown();
        }
        this.TickDown();
    }

    public void forceDespawn(boolean despawn) {
        this.forceDespawnSet = despawn;
    }

    public void TickDown() {
        int currFade = this.getFadeOut();
        if (!this.m_9236_().m_5776_() && currFade >= 0) {
            MainUtil.ejectInFront(this);
            this.incFadeOut((byte)-1);
            if (!this.getHeldItem().m_41619_() && this.canAcquireHeldItem) {
                double $$3 = this.m_20188_() - (double)0.3f;
                ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), $$3, this.m_20189_(), this.getHeldItem());
                $$4.m_32010_(40);
                $$4.m_32052_(this.m_20148_());
                this.m_9236_().m_7967_((Entity)$$4);
                this.setHeldItem(ItemStack.f_41583_);
            }
        }
        if (currFade < 0) {
            if (!this.m_20197_().isEmpty()) {
                this.m_20153_();
            }
            this.m_146870_();
        }
    }

    public boolean isASingularEntity() {
        return true;
    }

    @javax.annotation.Nullable
    public Entity m_5489_(ServerLevel $$0) {
        if (this.m_9236_() instanceof ServerLevel && !this.m_213877_() && !this.getHeldItem().m_41619_() && this.canAcquireHeldItem) {
            double $$3 = this.m_20188_() - (double)0.3f;
            ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), $$3, this.m_20189_(), this.getHeldItem().m_41777_());
            $$4.m_32010_(40);
            $$4.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)$$4);
            this.setHeldItem(ItemStack.f_41583_);
        }
        return super.m_5489_($$0);
    }

    public void m_142687_(Entity.RemovalReason $$0) {
        MainUtil.ejectInFront(this);
        if (!this.getHeldItem().m_41619_() && this.canAcquireHeldItem) {
            double $$3 = this.m_20188_() - (double)0.3f;
            ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), $$3, this.m_20189_(), this.getHeldItem().m_41777_());
            $$4.m_32010_(40);
            $$4.m_32052_(this.m_20148_());
            this.m_9236_().m_7967_((Entity)$$4);
            this.setHeldItem(ItemStack.f_41583_);
        }
        super.m_142687_($$0);
    }

    public boolean canBeHitByStands() {
        return true;
    }

    public boolean isRemoteControlled() {
        Player PE;
        StandUser user;
        StandPowers powers;
        LivingEntity ent = this.getUser();
        return ent != null && ent instanceof Player && (powers = (user = (StandUser)(PE = (Player)ent)).roundabout$getStandPowers()).isPiloting();
    }

    public boolean m_6785_(double $$0) {
        return false;
    }

    public boolean m_142535_(float $$0, float $$1, DamageSource $$2) {
        return false;
    }

    protected void m_21229_() {
    }

    protected void m_7840_(double $$0, boolean $$1, BlockState $$2, BlockPos $$3) {
    }

    public void m_7380_(CompoundTag $$0) {
        $$0.m_128379_("roundabout.AcquireHeldItem", this.canAcquireHeldItem);
        CompoundTag compoundtag = new CompoundTag();
        $$0.m_128365_("roundabout.HeldItem", (Tag)this.getHeldItem().m_41739_(compoundtag));
        super.m_7380_($$0);
    }

    public void m_7378_(CompoundTag $$0) {
        this.canAcquireHeldItem = $$0.m_128471_("roundabout.AcquireHeldItem");
        CompoundTag compoundtag = $$0.m_128469_("roundabout.HeldItem");
        ItemStack itemstack = ItemStack.m_41712_((CompoundTag)compoundtag);
        this.setHeldItem(itemstack);
        super.m_7378_($$0);
    }

    public boolean isTechnicallyInWall() {
        float $$0 = this.m_6972_((Pose)this.m_20089_()).f_20377_ * 0.8f;
        AABB $$1 = AABB.m_165882_((Vec3)this.m_146892_(), (double)$$0, (double)1.0E-6, (double)$$0);
        return BlockPos.m_121921_((AABB)$$1).anyMatch($$1x -> {
            BlockState $$2 = this.m_9236_().m_8055_($$1x);
            return !$$2.m_60795_() && $$2.m_60828_((BlockGetter)this.m_9236_(), $$1x) && Shapes.m_83157_((VoxelShape)$$2.m_60812_((BlockGetter)this.m_9236_(), $$1x).m_83216_((double)$$1x.m_123341_(), (double)$$1x.m_123342_(), (double)$$1x.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)$$1), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean isTechnicallyInImpassableWall() {
        float $$0 = this.m_6972_((Pose)this.m_20089_()).f_20377_ * 0.8f;
        AABB $$1 = AABB.m_165882_((Vec3)this.m_146892_(), (double)$$0, (double)1.0E-6, (double)$$0);
        return BlockPos.m_121921_((AABB)$$1).anyMatch($$1x -> {
            BlockState $$2 = this.m_9236_().m_8055_($$1x);
            return !$$2.m_60795_() && !($$2.m_60734_() instanceof IronBarsBlock) && !($$2.m_60734_() instanceof FenceBlock) && !($$2.m_60734_() instanceof FenceGateBlock) && !($$2.m_60734_() instanceof SlabBlock) && !($$2.m_60734_() instanceof AnvilBlock) && !($$2.m_60734_() instanceof BellBlock) && !($$2.m_60734_() instanceof RodBlock) && $$2.m_60828_((BlockGetter)this.m_9236_(), $$1x) && Shapes.m_83157_((VoxelShape)$$2.m_60812_((BlockGetter)this.m_9236_(), $$1x).m_83216_((double)$$1x.m_123341_(), (double)$$1x.m_123342_(), (double)$$1x.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)$$1), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public boolean forceVisualRotation() {
        return false;
    }

    public boolean ignoreTridentSpin() {
        return true;
    }

    public Vec3 FrontVectors(Entity standUser, double dr, float distance) {
        Vec3 vec3d = new Vec3(standUser.m_20185_(), standUser.m_20186_(), standUser.m_20189_());
        Vec3 vec3d2 = DamageHandler.getRotationVector(standUser.m_146909_(), (float)((double)standUser.m_146908_() + dr));
        return vec3d.m_82520_(vec3d2.f_82479_ * (double)distance, vec3d2.f_82480_ * (double)distance, vec3d2.f_82481_ * (double)distance);
    }

    public double getPunchYaw(double Yaw, double multi) {
        if (Yaw < 90.0) {
            return Yaw * multi;
        }
        if (Yaw <= 180.0) {
            return (180.0 - Yaw) * multi;
        }
        if (Yaw <= 270.0) {
            return -((Yaw - 180.0) * multi);
        }
        return -((360.0 - Yaw) * multi);
    }

    public static AttributeSupplier.Builder createStandAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, (double)0.2f).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0);
    }

    public boolean m_20329_(Entity $$0) {
        if (!($$0 instanceof Boat) && !($$0 instanceof Minecart)) {
            return this.m_7998_($$0, false);
        }
        return false;
    }

    public float getLookYaw(double maxDistance) {
        Vec3 pointVec = DamageHandler.getRayPoint(this.getUser(), maxDistance);
        if (pointVec != null) {
            double d = pointVec.f_82479_ - this.m_20185_();
            double e = pointVec.f_82480_ - this.m_20186_();
            double f = pointVec.f_82481_ - this.m_20189_();
            double g = Math.sqrt(d * d + f * f);
            return Mth.m_14177_((float)((float)(Mth.m_14136_((double)e, (double)g) * 57.2957763671875)));
        }
        return 0.0f;
    }
}

