/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.time_stop;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import net.hydra.jojomod.access.IBlockEntityAccess;
import net.hydra.jojomod.access.IProjectileAccess;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.entity.projectile.GoBeyondEntity;
import net.hydra.jojomod.entity.stand.FollowingStandEntity;
import net.hydra.jojomod.event.TimeStopInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.stand.powers.presets.TWAndSPSharedPowers;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Level.class})
public class TimeStopWorld
implements TimeStop {
    private ImmutableList<LivingEntity> roundabout$timeStoppingEntities = ImmutableList.of();
    private ImmutableList<TimeStopInstance> roundabout$timeStoppingEntitiesClient = ImmutableList.of();
    @Shadow
    @Final
    private ResourceKey<DimensionType> f_220349_;

    @Override
    public void addTimeStoppingEntity(LivingEntity $$0) {
        if (!((Level)this).f_46443_) {
            if (this.roundabout$timeStoppingEntities.isEmpty()) {
                this.roundabout$timeStoppingEntities = ImmutableList.of((Object)$$0);
            } else if (!this.roundabout$timeStoppingEntities.contains((Object)$$0)) {
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
                $$1.add($$0);
                this.roundabout$timeStoppingEntities = ImmutableList.copyOf((Collection)$$1);
            }
            this.streamTimeStopToClients();
        }
    }

    @Override
    public void addTimeStoppingEntityClient(int id, double x, double y, double z, double range, int duration, int maxDuration) {
        if (((Level)this).f_46443_) {
            if (this.roundabout$timeStoppingEntitiesClient.isEmpty()) {
                this.roundabout$timeStoppingEntitiesClient = ImmutableList.of((Object)new TimeStopInstance(id, x, y, z, range, duration, maxDuration));
            } else {
                ArrayList $$0 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
                for (int i = $$0.size() - 1; i >= 0; --i) {
                    if (((TimeStopInstance)$$0.get((int)i)).id != id) continue;
                    $$1.remove($$0.get(i));
                }
                $$1.add(new TimeStopInstance(id, x, y, z, range, duration, maxDuration));
                this.roundabout$timeStoppingEntitiesClient = ImmutableList.copyOf((Collection)$$1);
            }
        }
    }

    @Override
    public void removeTimeStoppingEntity(LivingEntity $$0) {
        if (!((Level)this).f_46443_ && !this.roundabout$timeStoppingEntities.isEmpty()) {
            ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
            for (int i = this.roundabout$timeStoppingEntities.size() - 1; i >= 0; --i) {
                if (((LivingEntity)this.roundabout$timeStoppingEntities.get(i)).m_19879_() != $$0.m_19879_()) continue;
                this.streamTimeStopRemovalToClients((LivingEntity)this.roundabout$timeStoppingEntities.get(i));
                $$1.remove(i);
            }
            this.roundabout$timeStoppingEntities = ImmutableList.copyOf((Collection)$$1);
        }
    }

    @Override
    public void removeTimeStoppingEntityClient(int id) {
        if (((Level)this).f_46443_ && !this.roundabout$timeStoppingEntitiesClient.isEmpty()) {
            ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
            for (int i = this.roundabout$timeStoppingEntitiesClient.size() - 1; i >= 0; --i) {
                if (((TimeStopInstance)this.roundabout$timeStoppingEntitiesClient.get((int)i)).id != id) continue;
                $$1.remove(i);
            }
            this.roundabout$timeStoppingEntitiesClient = ImmutableList.copyOf((Collection)$$1);
        }
    }

    @Override
    public void streamTimeStopToClients() {
        if (!((Level)this).f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this;
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                if (this.roundabout$timeStoppingEntities.isEmpty()) continue;
                ServerPlayer serverPlayer = (ServerPlayer)serverWorld.m_6907_().get(j);
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    Entity TSI = (Entity)$$1.get(i);
                    if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2(TSI.m_20185_(), TSI.m_20189_(), serverPlayer.m_20185_(), serverPlayer.m_20189_()) < (double)Math.max(250, ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite))) continue;
                    S2CPacketUtil.addTSEntity((Player)serverPlayer, TSI.m_19879_(), TSI.m_20185_(), TSI.m_20186_(), TSI.m_20189_(), ((StandUser)TSI).roundabout$getStandPowers().getTimestopRange(), ((StandUser)TSI).roundabout$getStandPowers().getChargedTSTicks(), ((StandUser)TSI).roundabout$getStandPowers().getMaxChargeTSTime());
                }
            }
        }
    }

    @Override
    public void streamTimeStopRemovalToClients(LivingEntity removedStoppingEntity) {
        if (!((Level)this).f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this;
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                if (this.roundabout$timeStoppingEntities.isEmpty()) continue;
                ServerPlayer serverPlayer = (ServerPlayer)serverWorld.m_6907_().get(j);
                S2CPacketUtil.removeTSEntity((Player)serverPlayer, removedStoppingEntity.m_19879_());
            }
        }
    }

    @Override
    public void processTSPacket(int timeStoppingEntity, double x, double y, double z, double range, int duration, int maxDuration) {
        if (((Level)this).f_46443_) {
            this.addTimeStoppingEntityClient(timeStoppingEntity, x, y, z, range, duration, maxDuration);
        }
    }

    @Override
    public void processTSRemovePacket(int timeStoppingEntity) {
        if (((Level)this).f_46443_) {
            this.removeTimeStoppingEntityClient(timeStoppingEntity);
        }
    }

    @Override
    public void processTSBlockEntityPacket(BlockEntity blockEntity) {
        if (((Level)this).f_46443_) {
            ((IBlockEntityAccess)blockEntity).roundabout$setRoundaboutTimeInteracted(true);
        }
    }

    @Override
    public void tickTimeStoppingEntity() {
        if (!((Level)this).f_46443_) {
            this.streamTimeStopToClients();
        }
    }

    @Override
    public void tickAllTimeStops() {
        if (!this.roundabout$timeStoppingEntities.isEmpty()) {
            ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
            for (int i = $$1.size() - 1; i >= 0; --i) {
                if (((LivingEntity)$$1.get(i)).m_213877_() || !((LivingEntity)$$1.get(i)).m_6084_() || ((LivingEntity)$$1.get(i)).m_9236_().m_220362_() != this.f_220349_) {
                    StandPowers standPowers;
                    if (((LivingEntity)$$1.get(i)).m_9236_().m_220362_() != this.f_220349_ && (standPowers = ((StandUser)$$1.get(i)).roundabout$getStandPowers()) instanceof TWAndSPSharedPowers) {
                        TWAndSPSharedPowers TP = (TWAndSPSharedPowers)standPowers;
                        TP.resumeTime((Level)this);
                        continue;
                    }
                    this.removeTimeStoppingEntity((LivingEntity)$$1.get(i));
                    continue;
                }
                if (((Level)this).f_46443_) continue;
                ((StandUser)$$1.get(i)).roundabout$getStandPowers().timeTickStopPower();
            }
        }
    }

    @Override
    public ImmutableList<LivingEntity> getTimeStoppingEntities() {
        if (!((Level)this).f_46443_) {
            return this.roundabout$timeStoppingEntities;
        }
        ArrayList $$0 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
        ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
        for (int i = $$1.size() - 1; i >= 0; --i) {
            Entity ent = ((Level)this).m_6815_(((TimeStopInstance)$$1.get((int)i)).id);
            if (!(ent instanceof LivingEntity)) continue;
            $$0.add((LivingEntity)ent);
        }
        return ImmutableList.copyOf((Collection)$$0);
    }

    @Override
    public boolean inTimeStopRange(Vec3i pos) {
        block4: {
            block3: {
                if (((Level)this).f_46443_) break block3;
                if (this.roundabout$timeStoppingEntities.isEmpty()) break block4;
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    LivingEntity it = (LivingEntity)$$1.get(i);
                    if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2((double)pos.m_123341_(), (double)pos.m_123343_(), it.m_20185_(), it.m_20189_()) <= (double)((StandUser)it).roundabout$getStandPowers().getTimestopRange())) continue;
                    return true;
                }
                break block4;
            }
            if (!this.roundabout$timeStoppingEntitiesClient.isEmpty()) {
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    TimeStopInstance it = (TimeStopInstance)$$1.get(i);
                    if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2((double)pos.m_123341_(), (double)pos.m_123343_(), it.x, it.z) <= it.range)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean inTimeStopRange(Entity entity) {
        return this.inTimeStopRange(new Vec3i((int)entity.m_20185_(), (int)entity.m_20186_(), (int)entity.m_20189_()));
    }

    @Override
    public TimeStopInstance getTimeStopperInstanceClient(Vec3 pos) {
        if (!this.roundabout$timeStoppingEntitiesClient.isEmpty()) {
            ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
            for (int i = $$1.size() - 1; i >= 0; --i) {
                TimeStopInstance it = (TimeStopInstance)$$1.get(i);
                if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2(pos.m_7096_(), pos.m_7094_(), it.x, it.z) <= it.range)) continue;
                return it;
            }
        }
        return null;
    }

    @Override
    public LivingEntity inTimeStopRangeEntity(Vec3i pos) {
        block4: {
            block3: {
                if (((Level)this).f_46443_) break block3;
                if (this.roundabout$timeStoppingEntities.isEmpty()) break block4;
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    LivingEntity it = (LivingEntity)$$1.get(i);
                    if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2((double)pos.m_123341_(), (double)pos.m_123343_(), it.m_20185_(), it.m_20189_()) <= (double)((StandUser)it).roundabout$getStandPowers().getTimestopRange())) continue;
                    return it;
                }
                break block4;
            }
            if (!this.roundabout$timeStoppingEntitiesClient.isEmpty()) {
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    Entity it2;
                    TimeStopInstance it = (TimeStopInstance)$$1.get(i);
                    if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2((double)pos.m_123341_(), (double)pos.m_123343_(), it.x, it.z) <= it.range) || !((it2 = ((Level)this).m_6815_(it.id)) instanceof LivingEntity)) continue;
                    return (LivingEntity)it2;
                }
            }
        }
        return null;
    }

    @Override
    public LivingEntity inTimeStopRangeEntity(Entity entity) {
        return this.inTimeStopRangeEntity(new Vec3i((int)entity.m_20185_(), (int)entity.m_20186_(), (int)entity.m_20189_()));
    }

    @Override
    public boolean CanTimeStopEntity(Entity entity) {
        if (entity instanceof Player && ((Player)entity).m_7500_() || entity.m_5833_()) {
            return false;
        }
        if (entity instanceof Warden && ClientNetworking.getAppropriateConfig().timeStopSettings.wardenMovesInStoppedTime.booleanValue()) {
            return false;
        }
        if (entity instanceof GoBeyondEntity) {
            return false;
        }
        if (!(entity instanceof LivingEntity) && entity.m_146895_() != null && entity.m_146895_() instanceof LivingEntity && this.isTimeStoppingEntity((LivingEntity)entity.m_146895_())) {
            return false;
        }
        if (entity instanceof FollowingStandEntity) {
            FollowingStandEntity FE = (FollowingStandEntity)entity;
            LivingEntity Following = FE.getFollowing();
            return Following != null && this.CanTimeStopEntity((Entity)Following);
        }
        if (entity instanceof Projectile) {
            if (((IProjectileAccess)entity).roundabout$getRoundaboutIsTimeStopCreated()) {
                return false;
            }
            return this.inTimeStopRange(entity);
        }
        if (entity instanceof LivingEntity) {
            if (this.isTimeStoppingEntity((LivingEntity)entity)) {
                return false;
            }
            return this.inTimeStopRange(entity);
        }
        return this.inTimeStopRange(entity);
    }

    @Override
    public boolean isTimeStoppingEntity(LivingEntity entity) {
        block4: {
            block3: {
                if (((Level)this).f_46443_) break block3;
                if (this.roundabout$timeStoppingEntities.isEmpty()) break block4;
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    if (((LivingEntity)$$1.get(i)).m_19879_() != entity.m_19879_()) continue;
                    return true;
                }
                break block4;
            }
            if (!this.roundabout$timeStoppingEntitiesClient.isEmpty()) {
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntitiesClient);
                for (int i = $$1.size() - 1; i >= 0; --i) {
                    if (((TimeStopInstance)$$1.get((int)i)).id != entity.m_19879_()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void streamTileEntityTSToCLient(BlockPos blockPos) {
        if (!((Level)this).f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this;
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                if (this.roundabout$timeStoppingEntities.isEmpty()) continue;
                ServerPlayer serverPlayer = (ServerPlayer)serverWorld.m_6907_().get(j);
                ArrayList $$1 = Lists.newArrayList(this.roundabout$timeStoppingEntities);
                if (ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite != -1 && !(MainUtil.cheapDistanceTo2((double)blockPos.m_123341_(), (double)blockPos.m_123343_(), serverPlayer.m_20185_(), serverPlayer.m_20189_()) < (double)Math.max(250, ClientNetworking.getAppropriateConfig().timeStopSettings.blockRangeNegativeOneIsInfinite))) continue;
                S2CPacketUtil.resumeTileEntityTSPacket((Player)serverPlayer, new Vec3i(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_()));
            }
        }
    }

    @Inject(method={"shouldTickBlocksAt(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$TickBlocksAt(BlockPos $$0, CallbackInfoReturnable<Boolean> ci) {
        if (this.inTimeStopRange((Vec3i)$$0) && !((Level)this).m_8055_($$0).m_60713_(Blocks.f_50110_)) {
            BlockEntity blk = ((Level)this).m_7702_($$0);
            if (blk != null && ((IBlockEntityAccess)blk).roundabout$getRoundaboutTimeInteracted()) {
                return;
            }
            ci.setReturnValue((Object)false);
        }
    }
}

