/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util;

import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.util.gravity.QuaternionUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.Validate;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RotationAnimation {
    private boolean inAnimation = false;
    private Quaternionf startGravityRotation;
    private Quaternionf endGravityRotation;
    private Vec3 relativeRotationCenter = Vec3.f_82478_;
    private Entity ent;
    private long startTimeMs;
    private long endTimeMs;

    public void startRotationAnimation(Direction newGravity, Direction prevGravity, long durationTimeMs, Entity entity, long timeMs, boolean rotateView, Vec3 relativeRotationCenter) {
        if (durationTimeMs == 0L) {
            this.inAnimation = false;
            return;
        }
        Validate.notNull((Object)entity);
        this.ent = entity;
        Vec3 newLookingDirection = this.getNewLookingDirection(newGravity, prevGravity, entity, rotateView);
        Quaternionf oldViewRotation = QuaternionUtil.getViewRotation(entity.m_146909_(), entity.m_146908_());
        this.update(timeMs);
        Quaternionf currentAnimatedGravityRotation = this.getCurrentGravityRotation(prevGravity, timeMs);
        Quaternionf currentAnimatedCameraRotation = new Quaternionf().set((Quaternionfc)oldViewRotation).mul((Quaternionfc)currentAnimatedGravityRotation);
        Quaternionf newEndGravityRotation = RotationUtil.getWorldRotationQuaternion(newGravity);
        Vec2 newYawAndPitch = RotationUtil.vecToRot(RotationUtil.vecWorldToPlayer(newLookingDirection, newGravity));
        float newPitch = newYawAndPitch.f_82471_;
        float newYaw = newYawAndPitch.f_82470_;
        float deltaYaw = newYaw - entity.m_146908_();
        float deltaPitch = newPitch - entity.m_146909_();
        entity.m_146922_(entity.m_146908_() + deltaYaw);
        entity.m_146926_(entity.m_146909_() + deltaPitch);
        entity.f_19859_ += deltaYaw;
        entity.f_19860_ += deltaPitch;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20883_ += deltaYaw;
            livingEntity.f_20884_ += deltaYaw;
            livingEntity.f_20885_ += deltaYaw;
            livingEntity.f_20886_ += deltaYaw;
        }
        Quaternionf newViewRotation = QuaternionUtil.getViewRotation(entity.m_146909_(), entity.m_146908_());
        Quaternionf animationStartGravityRotation = new Quaternionf().set((Quaternionfc)newViewRotation).conjugate().mul((Quaternionfc)currentAnimatedCameraRotation);
        this.relativeRotationCenter = relativeRotationCenter;
        this.inAnimation = true;
        this.startGravityRotation = animationStartGravityRotation;
        this.endGravityRotation = newEndGravityRotation;
        this.startTimeMs = timeMs;
        this.endTimeMs = timeMs + durationTimeMs;
    }

    private Vec3 getNewLookingDirection(Direction newGravity, Direction prevGravity, Entity player, boolean rotateView) {
        Vec3 oldLookingDirection = RotationUtil.vecPlayerToWorld(RotationUtil.rotToVec(player.m_146908_(), player.m_146909_()), prevGravity);
        if (!rotateView) {
            return oldLookingDirection;
        }
        if (newGravity == prevGravity.m_122424_()) {
            return oldLookingDirection.m_82490_(-1.0);
        }
        Quaternionf deltaRotation = QuaternionUtil.getRotationBetween(Vec3.m_82528_((Vec3i)prevGravity.m_122436_()), Vec3.m_82528_((Vec3i)newGravity.m_122436_()));
        Vector3f lookingDirection = new Vector3f((float)oldLookingDirection.f_82479_, (float)oldLookingDirection.f_82480_, (float)oldLookingDirection.f_82481_);
        lookingDirection.rotate((Quaternionfc)deltaRotation);
        Vec3 newLookingDirection = new Vec3(lookingDirection);
        return newLookingDirection;
    }

    public Quaternionf getCurrentGravityRotation(Direction currentGravity, long timeMs) {
        if (ClientUtil.checkIfGamePaused() && this.ent != null) {
            timeMs = this.ent.m_9236_().m_46467_() * 50L;
        }
        this.update(timeMs);
        if (!this.inAnimation) {
            return RotationUtil.getWorldRotationQuaternion(currentGravity);
        }
        double delta = (double)(timeMs - this.startTimeMs) / (double)(this.endTimeMs - this.startTimeMs);
        return RotationUtil.interpolate(this.startGravityRotation, this.endGravityRotation, RotationAnimation.mapProgress((float)delta));
    }

    public void update(long timeMs) {
        if (timeMs > this.endTimeMs) {
            this.inAnimation = false;
        }
    }

    public Vec3 getEyeOffset(Quaternionf gravityRot, Vec3 localEyeOffset, Direction newGravity) {
        Quaternionf gravityRotForEntity = new Quaternionf((Quaternionfc)gravityRot).conjugate();
        if (!this.inAnimation || this.relativeRotationCenter.equals((Object)Vec3.f_82478_)) {
            return QuaternionUtil.rotate(localEyeOffset, gravityRotForEntity);
        }
        Vec3 rotationCenterOffset = RotationUtil.vecPlayerToWorld(this.relativeRotationCenter, newGravity);
        Vec3 eyeOffsetFromRotationCenter = localEyeOffset.m_82546_(this.relativeRotationCenter);
        Vec3 rotatedEyeOffsetFromRotationCenter = QuaternionUtil.rotate(eyeOffsetFromRotationCenter, gravityRotForEntity);
        return rotationCenterOffset.m_82549_(rotatedEyeOffsetFromRotationCenter);
    }

    private static float mapProgress(float delta) {
        return Mth.m_14036_((float)(delta * delta * (3.0f - 2.0f * delta)), (float)0.0f, (float)1.0f);
    }

    public boolean isInAnimation() {
        return this.inAnimation;
    }
}

