/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.visages;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.entity.visages.JojoNPCItemInHandLayer;
import net.hydra.jojomod.entity.visages.PlayerLikeArrowLayer;
import net.hydra.jojomod.entity.visages.PlayerLikeBeeStingLayer;
import net.hydra.jojomod.entity.visages.PlayerLikeModel;
import net.hydra.jojomod.entity.visages.PlayerLikeParrotOnShoulderLayer;
import net.hydra.jojomod.entity.visages.PlayerLikeSpinAttackLayer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;

public class PlayerLikeRenderer<T extends JojoNPC>
extends MobRenderer<T, PlayerLikeModel<T>> {
    public PlayerLikeRenderer(EntityRendererProvider.Context context, PlayerLikeModel<T> entityModel, float f) {
        super(context, entityModel, f);
        this.m_115326_((RenderLayer)new JojoNPCItemInHandLayer(this, context.m_234598_()));
        this.m_115326_(new PlayerLikeArrowLayer(context, this));
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.m_174027_(), context.m_234598_()));
        this.m_115326_((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.m_174027_()));
        this.m_115326_(new PlayerLikeParrotOnShoulderLayer(this, context.m_174027_()));
        this.m_115326_(new PlayerLikeSpinAttackLayer(this, context.m_174027_()));
        this.m_115326_(new PlayerLikeBeeStingLayer(this));
    }

    public ResourceLocation getTextureLocation(JojoNPC entity) {
        return null;
    }

    public void render(T mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        this.setModelProperties(mobEntity);
        super.m_7392_(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
    }

    public final int getTrueLight(Entity entity, float tickDelta) {
        BlockPos blockPos = BlockPos.m_274446_((Position)entity.m_7371_(tickDelta));
        return LightTexture.m_109885_((int)this.getTrueBlockLight(entity, blockPos), (int)this.getTrueSkyLight(entity, blockPos));
    }

    protected int getTrueSkyLight(Entity entity, BlockPos pos) {
        return entity.m_9236_().m_45517_(LightLayer.SKY, pos);
    }

    protected int getTrueBlockLight(Entity entity, BlockPos pos) {
        if (entity.m_6060_()) {
            return 15;
        }
        return entity.m_9236_().m_45517_(LightLayer.BLOCK, pos);
    }

    private void setModelProperties(T $$0) {
        PlayerLikeModel $$1 = (PlayerLikeModel)this.m_7200_();
        if ($$0.m_5833_()) {
            $$1.setAllVisible(false);
            $$1.head.f_104207_ = true;
            $$1.hat.f_104207_ = true;
            $$1.cloak.f_104207_ = false;
        } else {
            $$1.setAllVisible(true);
            $$1.hat.f_104207_ = true;
            $$1.jacket.f_104207_ = true;
            $$1.leftPants.f_104207_ = true;
            $$1.rightPants.f_104207_ = true;
            $$1.leftSleeve.f_104207_ = true;
            $$1.rightSleeve.f_104207_ = true;
            $$1.cloak.f_104207_ = false;
            $$1.crouching = $$0.m_6047_();
            Object ent = $$0;
            if (((JojoNPC)((Object)$$0)).host != null) {
                ent = ((JojoNPC)((Object)$$0)).host;
            }
            HumanoidModel.ArmPose $$2 = PlayerLikeRenderer.getArmPose(ent, InteractionHand.MAIN_HAND);
            HumanoidModel.ArmPose $$3 = PlayerLikeRenderer.getArmPose(ent, InteractionHand.OFF_HAND);
            if ($$2.m_102897_()) {
                HumanoidModel.ArmPose armPose = $$3 = ent.m_21206_().m_41619_() ? HumanoidModel.ArmPose.EMPTY : HumanoidModel.ArmPose.ITEM;
            }
            if (ent.m_5737_() == HumanoidArm.RIGHT) {
                $$1.rightArmPose = $$2;
                $$1.leftArmPose = $$3;
            } else {
                $$1.rightArmPose = $$3;
                $$1.leftArmPose = $$2;
            }
        }
    }

    public Vec3 getRenderOffset(T $$0, float $$1) {
        return $$0.m_6047_() ? new Vec3(0.0, -0.125, 0.0) : super.m_7860_($$0, $$1);
    }

    private static HumanoidModel.ArmPose getArmPose(LivingEntity $$0, InteractionHand $$1) {
        ItemStack $$2 = $$0.m_21120_($$1);
        if ($$2.m_41619_()) {
            return HumanoidModel.ArmPose.EMPTY;
        }
        if ($$0.m_7655_() == $$1 && $$0.m_21212_() > 0) {
            UseAnim $$3 = $$2.m_41780_();
            if ($$3 == UseAnim.BLOCK) {
                return HumanoidModel.ArmPose.BLOCK;
            }
            if ($$3 == UseAnim.BOW) {
                return HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
            if ($$3 == UseAnim.SPEAR) {
                return HumanoidModel.ArmPose.THROW_SPEAR;
            }
            if ($$3 == UseAnim.CROSSBOW && $$1 == $$0.m_7655_()) {
                return HumanoidModel.ArmPose.CROSSBOW_CHARGE;
            }
            if ($$3 == UseAnim.SPYGLASS) {
                return HumanoidModel.ArmPose.SPYGLASS;
            }
            if ($$3 == UseAnim.TOOT_HORN) {
                return HumanoidModel.ArmPose.TOOT_HORN;
            }
            if ($$3 == UseAnim.BRUSH) {
                return HumanoidModel.ArmPose.BRUSH;
            }
        } else if (!$$0.f_20911_ && $$2.m_150930_(Items.f_42717_) && CrossbowItem.m_40932_((ItemStack)$$2)) {
            return HumanoidModel.ArmPose.CROSSBOW_HOLD;
        }
        return HumanoidModel.ArmPose.ITEM;
    }

    protected void setupRotations(T $$0, PoseStack $$1, float $$2, float $$3, float $$4) {
        int dodgeTime;
        float $$5 = $$0.m_20998_($$4);
        if ($$0.m_21255_()) {
            super.m_7523_($$0, $$1, $$2, $$3, $$4);
            float $$6 = (float)$$0.m_21256_() + $$4;
            float $$7 = Mth.m_14036_((float)($$6 * $$6 / 100.0f), (float)0.0f, (float)1.0f);
            if (!$$0.m_21209_()) {
                $$1.m_252781_(Axis.f_252529_.m_252977_($$7 * (-90.0f - $$0.m_146909_())));
            }
            Vec3 $$8 = $$0.m_20252_($$4);
            Vec3 $$9 = ((JojoNPC)((Object)$$0)).getDeltaMovementLerped($$4);
            double $$10 = $$9.m_165925_();
            double $$11 = $$8.m_165925_();
            if ($$10 > 0.0 && $$11 > 0.0) {
                double $$12 = ($$9.f_82479_ * $$8.f_82479_ + $$9.f_82481_ * $$8.f_82481_) / Math.sqrt($$10 * $$11);
                double $$13 = $$9.f_82479_ * $$8.f_82481_ - $$9.f_82481_ * $$8.f_82479_;
                $$1.m_252781_(Axis.f_252436_.m_252961_((float)(Math.signum($$13) * Math.acos($$12))));
            }
        } else if ($$5 > 0.0f) {
            super.m_7523_($$0, $$1, $$2, $$3, $$4);
            float $$14 = $$0.m_20069_() ? -90.0f - $$0.m_146909_() : -90.0f;
            float $$15 = Mth.m_14179_((float)$$5, (float)0.0f, (float)$$14);
            $$1.m_252781_(Axis.f_252529_.m_252977_($$15));
            if ($$0.m_6067_()) {
                $$1.m_252880_(0.0f, -1.0f, 0.3f);
            }
        } else {
            super.m_7523_($$0, $$1, $$2, $$3, $$4);
        }
        byte playerP = ((JojoNPC)((Object)$$0)).roundabout$GetPos();
        if ((playerP == 2 || playerP == 3) && (dodgeTime = ((JojoNPC)((Object)$$0)).roundabout$getDodgeTime()) > -1) {
            float FL = dodgeTime > 5 ? (11.0f - ((float)dodgeTime + 1.0f + $$4 - 1.0f)) / 20.0f * 1.6f : ((float)dodgeTime + 1.0f + $$4 - 1.0f) / 20.0f * 1.6f;
            if ((FL = Mth.m_14116_((float)FL)) > 1.0f) {
                FL = 1.0f;
            }
            if (playerP == 2) {
                FL *= -1.0f;
            }
            $$1.m_252781_(Axis.f_252529_.m_252977_(FL * 45.0f));
        }
    }
}

