/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.networking.s2c;

import java.util.function.Supplier;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import org.joml.Vector3f;

public class ForgeBlipPacket {
    private final byte activePower;
    private final int data;
    private final Vector3f vec;

    public ForgeBlipPacket(byte activePowers, int data, Vector3f vec) {
        this.activePower = activePowers;
        this.data = data;
        this.vec = vec;
    }

    public ForgeBlipPacket(FriendlyByteBuf buf) {
        this.activePower = buf.readByte();
        this.data = buf.readInt();
        this.vec = buf.m_269394_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeByte((int)this.activePower);
        buf.writeInt(this.data);
        buf.m_269582_(this.vec);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> ClientUtil.handleBlipPacketS2C(this.data, this.activePower, this.vec));
        return true;
    }
}

