/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.stand.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import net.hydra.jojomod.client.models.stand.StandModel;
import net.hydra.jojomod.client.models.stand.renderers.StandRenderer;
import net.hydra.jojomod.entity.stand.DarkMirageEntity;
import net.hydra.jojomod.entity.stand.JusticeEntity;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;

public class JusticeBaseRenderer
extends StandRenderer<JusticeEntity> {
    private static final ResourceLocation PART_3_SKIN = new ResourceLocation("roundabout", "textures/stand/justice/anime.png");
    private static final ResourceLocation PART_3_MANGA_SKIN = new ResourceLocation("roundabout", "textures/stand/justice/manga.png");
    private static final ResourceLocation OVA_SKIN = new ResourceLocation("roundabout", "textures/stand/justice/ova.png");
    private static final ResourceLocation BOGGED_SKIN = new ResourceLocation("roundabout", "textures/stand/justice/bogged.png");
    private static final ResourceLocation SKELETON = new ResourceLocation("roundabout", "textures/stand/justice/skeleton.png");
    private static final ResourceLocation STRAY = new ResourceLocation("roundabout", "textures/stand/justice/stray.png");
    private static final ResourceLocation WITHER = new ResourceLocation("roundabout", "textures/stand/justice/wither.png");
    private static final ResourceLocation TAROT = new ResourceLocation("roundabout", "textures/stand/justice/tarot.png");
    private static final ResourceLocation FLAMED = new ResourceLocation("roundabout", "textures/stand/justice/flamed.png");
    private static final ResourceLocation TWILIGHT = new ResourceLocation("roundabout", "textures/stand/justice/twilight.png");
    private static final ResourceLocation PIRATE = new ResourceLocation("roundabout", "textures/stand/justice/pirate.png");
    private static final ResourceLocation BLUE_FLAME = new ResourceLocation("roundabout", "textures/stand/justice/flamed_blue.png");
    private static final ResourceLocation DARK_MIRAGE = new ResourceLocation("roundabout", "textures/stand/justice/dark_mirage.png");
    private static final ResourceLocation JOJONIUM = new ResourceLocation("roundabout", "textures/stand/justice/jojonium.png");
    private static final ResourceLocation PUMPKIN = new ResourceLocation("roundabout", "textures/stand/justice/pumpkin.png");
    private static final ResourceLocation JACK = new ResourceLocation("roundabout", "textures/stand/justice/jack.png");

    public JusticeBaseRenderer(EntityRendererProvider.Context context, StandModel<JusticeEntity> entityModel, float f) {
        super(context, entityModel, f);
    }

    public void renderRightHand(PoseStack $$0, MultiBufferSource $$1, int $$2, JusticeEntity $$3) {
        this.renderHand($$0, $$1, $$2, $$3, ((StandModel)this.f_115290_).rightHand);
    }

    public void renderLeftHand(PoseStack $$0, MultiBufferSource $$1, int $$2, JusticeEntity $$3) {
        this.renderHand($$0, $$1, $$2, $$3, ((StandModel)this.f_115290_).leftHand);
    }

    private void renderHand(PoseStack $$0, MultiBufferSource $$1, int $$2, JusticeEntity $$3, ModelPart $$4) {
        StandModel $$6 = (StandModel)this.m_7200_();
        $$6.f_102608_ = 0.0f;
        $$6.setupAnim($$3, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
        $$4.f_104203_ = 0.0f;
        $$4.m_104301_($$0, $$1.m_6299_(RenderType.m_110446_((ResourceLocation)this.getTextureLocation($$3))), $$2, OverlayTexture.f_118083_);
    }

    @Override
    public ResourceLocation getTextureLocation(JusticeEntity entity) {
        byte BT = entity.getSkin();
        if (BT == 1) {
            return PART_3_SKIN;
        }
        if (BT == 2) {
            return PART_3_MANGA_SKIN;
        }
        if (BT == 4) {
            return OVA_SKIN;
        }
        if (BT == 5) {
            return BOGGED_SKIN;
        }
        if (BT == 3) {
            return SKELETON;
        }
        if (BT == 6) {
            return STRAY;
        }
        if (BT == 7) {
            return FLAMED;
        }
        if (BT == 9) {
            return WITHER;
        }
        if (BT == 8) {
            return TAROT;
        }
        if (BT == 10) {
            return TWILIGHT;
        }
        if (BT == 11) {
            return PIRATE;
        }
        if (BT == 12) {
            return BLUE_FLAME;
        }
        if (BT == 13) {
            return DARK_MIRAGE;
        }
        if (BT == 14) {
            return JOJONIUM;
        }
        if (BT == 15) {
            return PUMPKIN;
        }
        if (BT == 16) {
            return JACK;
        }
        return PART_3_SKIN;
    }

    @Override
    public void render(JusticeEntity mobEntity, float f, float g, PoseStack matrixStack, MultiBufferSource vertexConsumerProvider, int i) {
        StandUser standUser;
        StandPowers powers;
        float factor = 0.5f + mobEntity.getSizePercent() / 2.0f;
        if (mobEntity.getSkin() == 13) {
            matrixStack.m_85841_(0.87f * factor, 0.87f * factor, 0.87f * factor);
        } else {
            matrixStack.m_85841_(2.0f * factor, 2.0f * factor, 2.0f * factor);
        }
        float percentage = (float)mobEntity.getJusticeSize() / 100.0f;
        matrixStack.m_85841_(percentage, percentage, percentage);
        LocalPlayer pl = Minecraft.m_91087_().f_91074_;
        LivingEntity user = mobEntity.getUser();
        if (user != null && (powers = (standUser = (StandUser)mobEntity.getUser()).roundabout$getStandPowers()).isPiloting()) {
            boolean fp;
            boolean renderHand = ConfigManager.getClientConfig().renderJusticeHandsWhilePiloting;
            if (powers.getPilotingStand() != null && powers.getPilotingStand().m_7306_((Entity)mobEntity) && (fp = Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) && !mobEntity.getDisplay() && pl != null && user.m_7306_((Entity)pl)) {
                ((StandModel)this.f_115290_).getHead().f_104207_ = false;
                if (mobEntity instanceof DarkMirageEntity) {
                    ((StandModel)this.f_115290_).m_142109_().f_104207_ = false;
                } else if (!renderHand) {
                    ((StandModel)this.f_115290_).leftHand.f_104207_ = false;
                    ((StandModel)this.f_115290_).rightHand.f_104207_ = false;
                }
            }
        }
        super.render(mobEntity, f, g, matrixStack, vertexConsumerProvider, i);
        ((StandModel)this.f_115290_).getHead().f_104207_ = true;
        if (mobEntity instanceof DarkMirageEntity) {
            ((StandModel)this.f_115290_).m_142109_().f_104207_ = true;
        } else {
            ((StandModel)this.f_115290_).leftHand.f_104207_ = true;
            ((StandModel)this.f_115290_).rightHand.f_104207_ = true;
        }
    }

    @Override
    @Nullable
    protected RenderType getRenderType(JusticeEntity entity, boolean showBody, boolean translucent, boolean showOutline) {
        return super.getRenderType(entity, showBody, true, showOutline);
    }
}

