/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.util.RotationAnimation;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={GameRenderer.class})
public abstract class GravityGameRendererMixin {
    @Shadow
    @Final
    private Camera f_109054_;

    @Inject(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="HEAD")})
    private void roundabout$inject_renderWorldHEAD(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci) {
        IGravityEntity igav;
        if (ClientUtil.getPlayer() != null && (igav = (IGravityEntity)ClientUtil.getPlayer()).roundabout$canChangeGravity()) {
            igav.roundabout$updateGravityStatus();
            igav.roundabout$applyGravityChange();
        }
    }

    @Inject(method={"renderLevel(FJLcom/mojang/blaze3d/vertex/PoseStack;)V"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;mulPose(Lorg/joml/Quaternionf;)V", ordinal=3, shift=At.Shift.AFTER)})
    private void roundabout$inject_renderWorld(float tickDelta, long limitTime, PoseStack matrix, CallbackInfo ci) {
        if (!Objects.equals(ModPacketHandler.PLATFORM_ACCESS.getPlatformName(), "Forge") && this.f_109054_.m_90592_() != null) {
            Entity focusedEntity = this.f_109054_.m_90592_();
            Direction gravityDirection = GravityAPI.getGravityDirection(focusedEntity);
            RotationAnimation animation = GravityAPI.getRotationAnimation(focusedEntity);
            if (animation == null) {
                return;
            }
            long timeMs = focusedEntity.m_9236_().m_46467_() * 50L + (long)(tickDelta * 50.0f);
            Quaternionf currentGravityRotation = animation.getCurrentGravityRotation(gravityDirection, timeMs);
            if (animation.isInAnimation()) {
                Minecraft.m_91087_().f_91060_.m_109826_();
            }
            matrix.m_252781_(currentGravityRotation);
        }
    }
}

