/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.networking.packet.impl;

import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.zetalasis.networking.packet.api.IClientNetworking;
import net.zetalasis.networking.packet.api.args.c2s.AbstractBaseC2SPacket;
import net.zetalasis.networking.packet.api.args.s2c.AbstractBaseS2CPacket;
import net.zetalasis.networking.packet.impl.packet.MessageC2S;
import net.zetalasis.networking.packet.impl.packet.MessageS2C;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class ModNetworking {
    private static final HashMap<Class<?>, Function<FriendlyByteBuf, Object>> DECODERS = new HashMap();
    public static final Map<Class<?>, BiConsumer<FriendlyByteBuf, Object>> ENCODERS = new HashMap();
    private static final HashMap<ResourceLocation, AbstractBaseC2SPacket> registrarC2S = new HashMap();
    private static final HashMap<ResourceLocation, AbstractBaseS2CPacket> registrarS2C = new HashMap();

    public static void bootstrap() {
        ModNetworking.register(new MessageC2S());
        ModNetworking.register(new MessageS2C());
    }

    @Nullable
    public static Connection getC2SConnection() {
        return ClientUtil.getC2SConnection();
    }

    private static ResourceLocation buildFromClassName(Class<?> c) {
        return Roundabout.location(c.getSimpleName().toLowerCase());
    }

    public static <T extends AbstractBaseC2SPacket> void register(T packet) {
        if (registrarC2S.containsValue(packet)) {
            Roundabout.LOGGER.warn("Duplicate caught while registering C2S packet \"{}\"", (Object)ModNetworking.buildFromClassName(packet.getClass()));
            return;
        }
        registrarC2S.put(ModNetworking.buildFromClassName(packet.getClass()), packet);
    }

    public static <T extends AbstractBaseS2CPacket> void register(T packet) {
        if (registrarS2C.containsValue(packet)) {
            Roundabout.LOGGER.warn("Duplicate caught while registering S2C packet \"{}\"", (Object)ModNetworking.buildFromClassName(packet.getClass()));
            return;
        }
        registrarS2C.put(ModNetworking.buildFromClassName(packet.getClass()), packet);
    }

    public static <T extends AbstractBaseC2SPacket> void send(T packetType, Object ... args) {
        Connection con = ModNetworking.getC2SConnection();
        if (con == null) {
            return;
        }
        con.m_129512_((Packet)new ServerboundCustomPayloadPacket(ModNetworking.buildFromClassName(packetType.getClass()), ModNetworking.createBufferFromVArgs(args)));
    }

    public static <T extends AbstractBaseS2CPacket> void send(T packetType, ServerPlayer recipient, Object ... args) {
        Connection con = ((IClientNetworking)recipient.f_8906_).roundabout$getServer();
        if (con == null) {
            return;
        }
        con.m_129512_((Packet)new ClientboundCustomPayloadPacket(ModNetworking.buildFromClassName(packetType.getClass()), ModNetworking.createBufferFromVArgs(args)));
    }

    public static void encodeValue(FriendlyByteBuf buf, Object value) {
        BiConsumer<FriendlyByteBuf, Object> encoder = ENCODERS.get(value.getClass());
        if (encoder == null) {
            throw new IllegalArgumentException("No encoder for type: " + value.getClass().getName());
        }
        encoder.accept(buf, value);
    }

    public static Object decodeValue(FriendlyByteBuf buf, Class<?> type) {
        Function<FriendlyByteBuf, Object> decoder = DECODERS.get(type);
        if (decoder == null) {
            throw new IllegalArgumentException("No decoder for type: " + type.getName());
        }
        return decoder.apply(buf);
    }

    private static String generateSignature(Object ... args) {
        if (args.length == 0) {
            return "void";
        }
        StringBuilder sig = new StringBuilder();
        for (Object arg : args) {
            Class<?> c = arg.getClass();
            sig.append(c.getName()).append(";");
        }
        return sig.toString();
    }

    private static FriendlyByteBuf createBufferFromVArgs(Object ... args) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.m_130070_(ModNetworking.generateSignature(args));
        for (Object arg : args) {
            ModNetworking.encodeValue(buf, arg);
        }
        return buf;
    }

    public static Object[] decodeBufferToVArgs(FriendlyByteBuf buf) {
        String[] sigClasses;
        String sig = buf.m_130277_();
        if (sig.equals("void")) {
            return new Object[0];
        }
        ArrayList<Object> result = new ArrayList<Object>();
        for (String className : sigClasses = sig.split(";")) {
            if (className.isEmpty()) continue;
            try {
                Class<?> clazz = Class.forName(className);
                result.add(ModNetworking.decodeValue(buf, clazz));
            }
            catch (Exception e) {
                throw new RuntimeException("Failed decoding FriendlyByteBuf to VArgs:\n" + className + " was not found.\n[" + sig + "]");
            }
        }
        if (buf.readableBytes() > 0) {
            throw new RuntimeException("Warning: extra unread bytes in buffer! Signature: " + sig);
        }
        return result.toArray();
    }

    @Nullable
    public static AbstractBaseC2SPacket getC2S(ResourceLocation location) {
        return registrarC2S.get(location);
    }

    @Nullable
    public static AbstractBaseS2CPacket getS2C(ResourceLocation location) {
        return registrarS2C.get(location);
    }

    static {
        DECODERS.put(Integer.class, FriendlyByteBuf::readInt);
        DECODERS.put(Long.class, FriendlyByteBuf::readLong);
        DECODERS.put(Float.class, FriendlyByteBuf::readFloat);
        DECODERS.put(Double.class, FriendlyByteBuf::readDouble);
        DECODERS.put(Boolean.class, FriendlyByteBuf::readBoolean);
        DECODERS.put(Byte.class, FriendlyByteBuf::readByte);
        DECODERS.put(Short.class, FriendlyByteBuf::readShort);
        DECODERS.put(String.class, FriendlyByteBuf::m_130277_);
        DECODERS.put(UUID.class, FriendlyByteBuf::m_130259_);
        DECODERS.put(ResourceLocation.class, FriendlyByteBuf::m_130281_);
        DECODERS.put(BlockPos.MutableBlockPos.class, FriendlyByteBuf::m_130135_);
        DECODERS.put(BlockPos.class, FriendlyByteBuf::m_130135_);
        DECODERS.put(Vector3f.class, FriendlyByteBuf::m_269394_);
        DECODERS.put(ItemStack.class, FriendlyByteBuf::m_130267_);
        DECODERS.put(BlockHitResult.class, FriendlyByteBuf::m_130283_);
        DECODERS.put(CompoundTag.class, FriendlyByteBuf::m_130260_);
        ENCODERS.put(Integer.class, (buf, o) -> buf.writeInt(((Integer)o).intValue()));
        ENCODERS.put(Integer.TYPE, (buf, o) -> buf.writeInt(((Integer)o).intValue()));
        ENCODERS.put(Long.class, (buf, o) -> buf.writeLong(((Long)o).longValue()));
        ENCODERS.put(Long.TYPE, (buf, o) -> buf.writeLong(((Long)o).longValue()));
        ENCODERS.put(Float.class, (buf, o) -> buf.writeFloat(((Float)o).floatValue()));
        ENCODERS.put(Float.TYPE, (buf, o) -> buf.writeFloat(((Float)o).floatValue()));
        ENCODERS.put(Double.class, (buf, o) -> buf.writeDouble(((Double)o).doubleValue()));
        ENCODERS.put(Double.TYPE, (buf, o) -> buf.writeDouble(((Double)o).doubleValue()));
        ENCODERS.put(Boolean.class, (buf, o) -> buf.writeBoolean(((Boolean)o).booleanValue()));
        ENCODERS.put(Boolean.TYPE, (buf, o) -> buf.writeBoolean(((Boolean)o).booleanValue()));
        ENCODERS.put(Byte.class, (buf, o) -> buf.writeByte((int)((Byte)o).byteValue()));
        ENCODERS.put(Byte.TYPE, (buf, o) -> buf.writeByte((int)((Byte)o).byteValue()));
        ENCODERS.put(Short.class, (buf, o) -> buf.writeShort((int)((Short)o).shortValue()));
        ENCODERS.put(Short.TYPE, (buf, o) -> buf.writeShort((int)((Short)o).shortValue()));
        ENCODERS.put(Character.class, (buf, o) -> buf.writeChar((int)((Character)o).charValue()));
        ENCODERS.put(Character.TYPE, (buf, o) -> buf.writeChar((int)((Character)o).charValue()));
        ENCODERS.put(String.class, (buf, o) -> buf.m_130070_((String)o));
        ENCODERS.put(UUID.class, (buf, o) -> buf.m_130077_((UUID)o));
        ENCODERS.put(ResourceLocation.class, (buf, o) -> buf.m_130085_((ResourceLocation)o));
        ENCODERS.put(BlockPos.MutableBlockPos.class, (buf, o) -> buf.m_130064_((BlockPos)o));
        ENCODERS.put(BlockPos.class, (buf, o) -> buf.m_130064_((BlockPos)o));
        ENCODERS.put(ItemStack.class, (buf, o) -> buf.m_130055_((ItemStack)o));
        ENCODERS.put(Vector3f.class, (buf, o) -> buf.m_269582_((Vector3f)o));
        ENCODERS.put(BlockHitResult.class, (buf, o) -> buf.m_130062_((BlockHitResult)o));
        ENCODERS.put(CompoundTag.class, (buf, o) -> buf.m_130079_((CompoundTag)o));
    }
}

