/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IFatePlayer;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.projectile.RoadRollerEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.TimeStopInstance;
import net.hydra.jojomod.event.index.FateTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.stand.powers.PowersSoftAndWet;
import net.hydra.jojomod.stand.powers.PowersWalkingHeart;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class StandHudRender {
    private static final int guiSize = 174;
    private static float presentX = 0.0f;
    private static final ResourceLocation GUI_ICONS_LOCATION = new ResourceLocation("textures/gui/icons.png");

    public static boolean configIsLoaded() {
        return ConfigManager.getClientConfig() != null;
    }

    public static void renderStandHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        if (!StandHudRender.configIsLoaded()) {
            return;
        }
        if (ConfigManager.getClientConfig() == null || ConfigManager.getClientConfig().dynamicSettings == null) {
            return;
        }
        if (playerEntity != null) {
            boolean renderIcons;
            RenderSystem.enableBlend();
            int x = 0;
            int y = 0;
            int width = scaledWidth;
            int height = scaledHeight;
            int textureWidth = 174;
            int textureHeight = 30;
            int iconHeight = 18;
            int iconWidth = 18;
            x = (int)(-194.0f + presentX);
            y = ConfigManager.getClientConfig().abilityIconHudY;
            Minecraft mc = Minecraft.m_91087_();
            float tickDelta = mc.m_91297_();
            boolean standOn = ((StandUser)playerEntity).roundabout$getActive();
            boolean bl = renderIcons = !(!standOn && FateTypes.isHuman((LivingEntity)playerEntity) || ConfigManager.getClientConfig().dynamicSettings.hideGUI != false || ConfigManager.getClientConfig().enablePickyIconRendering != false && !((StandUser)playerEntity).roundabout$getStandPowers().hasCooldowns());
            if (renderIcons || (double)presentX > 0.1) {
                if (!renderIcons) {
                    presentX = ConfigManager.getClientConfig().abilityIconHudIsAnimated.booleanValue() ? Math.max(StandHudRender.controlledLerp(tickDelta, presentX, 0.0f, 0.5f), 0.0f) : 0.0f;
                } else if (ConfigManager.getClientConfig().abilityIconHudIsAnimated.booleanValue()) {
                    if (presentX < (float)ConfigManager.getClientConfig().abilityIconHudX.intValue()) {
                        presentX += 1.0f;
                        presentX = Math.min(StandHudRender.controlledLerp(tickDelta, presentX, ConfigManager.getClientConfig().abilityIconHudX.intValue(), 0.5f), (float)ConfigManager.getClientConfig().abilityIconHudX.intValue());
                    }
                } else {
                    presentX = ConfigManager.getClientConfig().abilityIconHudX.intValue();
                }
                context.m_280246_(1.0f, 1.0f, 1.0f, 0.9f);
                if (standOn) {
                    ((StandUser)playerEntity).roundabout$getStandPowers().renderIcons(context, x, y);
                } else {
                    ((IFatePlayer)playerEntity).rdbt$getFatePowers().renderIcons(context, x, y);
                }
                context.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            }
        }
    }

    public static Component fixKey(Component textIn) {
        String X = textIn.getString();
        if (X.length() > 1) {
            String[] split = X.split("\\s");
            if (split.length > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[1].charAt(0)));
            }
            if (split[0].length() > 1) {
                return Component.m_130674_((String)("" + split[0].charAt(0) + split[0].charAt(1)));
            }
            return Component.m_130674_((String)("" + split[0].charAt(0)));
        }
        return textIn;
    }

    public static float controlledLerp(float delta, float start, float end, float multiplier) {
        return start + delta * (end - start) * multiplier;
    }

    public static void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        if (playerEntity != null) {
            ((StandUser)playerEntity).roundabout$getStandPowers().renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
            ((IFatePlayer)playerEntity).rdbt$getFatePowers().renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
        }
    }

    public static void renderRoadRollerHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, RoadRollerEntity RRE) {
        ResourceLocation itemID = BuiltInRegistries.f_257033_.m_7981_((Object)RRE.getConcreteColour().m_41720_());
        if (itemID == null) {
            return;
        }
        String fixedString = itemID.m_135815_().replace("_powder", "");
        ResourceLocation blockID = new ResourceLocation(itemID.m_135827_(), fixedString);
        Block actualConcrete = BuiltInRegistries.f_256975_.m_6612_(blockID).orElse(Blocks.f_50505_);
        int l = scaledHeight - 32 + 3;
        int k = (int)(182.0f - 0.2275f * (float)RRE.getPavingTimer());
        int vOffset = actualConcrete.equals(Blocks.f_50505_) ? 45 : (actualConcrete.equals(Blocks.f_50501_) ? 65 : (actualConcrete.equals(Blocks.f_50502_) ? 50 : (actualConcrete.equals(Blocks.f_50500_) ? 70 : (actualConcrete.equals(Blocks.f_50496_) ? 20 : (actualConcrete.equals(Blocks.f_50499_) ? 15 : (actualConcrete.equals(Blocks.f_50544_) ? 25 : (actualConcrete.equals(Blocks.f_50494_) ? 5 : (actualConcrete.equals(Blocks.f_50504_) ? 10 : (actualConcrete.equals(Blocks.f_50497_) ? 40 : (actualConcrete.equals(Blocks.f_50545_) ? 75 : (actualConcrete.equals(Blocks.f_50498_) ? 35 : (actualConcrete.equals(Blocks.f_50503_) ? 60 : (actualConcrete.equals(Blocks.f_50495_) ? 0 : (actualConcrete.equals(Blocks.f_50542_) ? 30 : (actualConcrete.equals(Blocks.f_50543_) ? 55 : 0)))))))))))))));
        context.m_280218_(StandIcons.VEHICLE_ICONS, x, l, 0, 0, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.VEHICLE_ICONS, x, l, 0, vOffset + 5, k, 5);
        }
        int iconU = 193;
        int iconV = 40;
        int iconW = 9;
        int iconH = 9;
        int iconX = scaledWidth / 2 - 5;
        int iconY = scaledHeight - 31 - 10;
        context.m_280218_(StandIcons.VEHICLE_ICONS, iconX, iconY, iconU, iconV, iconW, iconH);
        int overlayU = 193;
        int overlayV = 141;
        if (actualConcrete.equals(Blocks.f_50505_)) {
            overlayV = 140;
        } else if (actualConcrete.equals(Blocks.f_50501_)) {
            overlayV = 60;
            overlayU = 209;
        } else if (actualConcrete.equals(Blocks.f_50502_)) {
            overlayV = 150;
        } else if (actualConcrete.equals(Blocks.f_50500_)) {
            overlayV = 70;
            overlayU = 209;
        } else if (actualConcrete.equals(Blocks.f_50496_)) {
            overlayV = 90;
        } else if (actualConcrete.equals(Blocks.f_50499_)) {
            overlayV = 80;
        } else if (actualConcrete.equals(Blocks.f_50544_)) {
            overlayV = 100;
        } else if (actualConcrete.equals(Blocks.f_50494_)) {
            overlayV = 60;
        } else if (actualConcrete.equals(Blocks.f_50504_)) {
            overlayV = 70;
        } else if (actualConcrete.equals(Blocks.f_50497_)) {
            overlayV = 130;
        } else if (actualConcrete.equals(Blocks.f_50545_)) {
            overlayV = 80;
            overlayU = 209;
        } else if (actualConcrete.equals(Blocks.f_50498_)) {
            overlayV = 120;
        } else if (actualConcrete.equals(Blocks.f_50503_)) {
            overlayV = 50;
            overlayU = 209;
        } else if (actualConcrete.equals(Blocks.f_50495_)) {
            overlayV = 50;
        } else if (actualConcrete.equals(Blocks.f_50542_)) {
            overlayV = 110;
        } else if (actualConcrete.equals(Blocks.f_50543_)) {
            overlayV = 160;
        } else {
            overlayV = 141;
            overlayU = 193;
        }
        context.m_280218_(StandIcons.VEHICLE_ICONS, iconX, iconY, overlayU, overlayV, iconW, iconH);
    }

    public static void renderRoadRollerPickupHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, RoadRollerEntity RRE) {
        int l = scaledHeight - 32 + 3;
        int k = (int)(1.82f * (float)RRE.getPickupTimer());
        context.m_280218_(StandIcons.VEHICLE_ICONS, x, l, 0, 90, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.VEHICLE_ICONS, x, l, 0, 85, k, 5);
        }
        int iconU = 183;
        int iconV = 0;
        int iconW = 9;
        int iconH = 9;
        int iconX = scaledWidth / 2 - 5;
        int iconY = scaledHeight - 31 - 10;
        context.m_280218_(StandIcons.VEHICLE_ICONS, iconX, iconY, iconU, iconV, iconW, iconH);
    }

    private static int getFinalATimeInt(StandUser standUser) {
        int barrageWindup = standUser.roundabout$getStandPowers().getBarrageWindup();
        int barrageLength = standUser.roundabout$getStandPowers().getBarrageLength();
        float attackTimeDuring = standUser.roundabout$getAttackTimeDuring();
        int finalATimeInt = attackTimeDuring <= (float)barrageWindup ? Math.round(attackTimeDuring / (float)barrageWindup * 15.0f) : 15 - Math.round((attackTimeDuring - (float)barrageWindup) / (float)barrageLength * 15.0f);
        return finalATimeInt;
    }

    public static void renderGrabbedHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int k = (int)Math.floor(6.0666666f * (float)standUser.roundabout$getRestrainedTicks());
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 70, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 75, k, 5);
        }
        int u = 183;
        k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 50, 9, 9);
    }

    public static void renderSealedDiscHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int k = (int)Math.floor(182.0 / (double)standUser.roundabout$getMaxSealedTicks() * (double)(standUser.roundabout$getMaxSealedTicks() - standUser.roundabout$getSealedTicks()));
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 90, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 95, k, 5);
        }
        int u = 183;
        k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 60, 9, 9);
    }

    public static void renderWalkingHeartHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int x) {
        StandUser standUser = (StandUser)playerEntity;
        StandPowers standPowers = standUser.roundabout$getStandPowers();
        if (standPowers instanceof PowersWalkingHeart) {
            PowersWalkingHeart PW = (PowersWalkingHeart)standPowers;
            int l = scaledHeight - 32 + 3;
            int st = PW.getMaxShootTicks();
            int sc = PW.getShootTicks();
            sc = Mth.m_14045_((int)sc, (int)0, (int)st);
            int blt2 = 182 - (int)Math.floor(182.0 / (double)st * (double)sc);
            int bleh = 10;
            if (!PW.inCombatMode()) {
                bleh += 10;
            }
            context.m_280218_(StandIcons.JOJO_ICONS_2, x, l, 0, bleh, 182, 5);
            if (blt2 > 0) {
                context.m_280218_(StandIcons.JOJO_ICONS_2, x, l, 0, bleh += 5, blt2, 5);
            }
            int u = 183;
            int k = scaledWidth / 2 - 5;
            l = scaledHeight - 31 - 5;
            if (PW.canShootSpikes(PW.getUseTicks())) {
                context.m_280218_(StandIcons.JOJO_ICONS_2, k, l, u, 0, 9, 9);
            } else {
                context.m_280218_(StandIcons.JOJO_ICONS_2, k, l, u, 10, 9, 9);
            }
        }
    }

    public static void renderInvisibilityHUD(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int x) {
        int gb = ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstDuration;
        int gc = ((IEntityAndData)playerEntity).roundabout$getTrueInvisibility();
        gc = Mth.m_14045_((int)gc, (int)0, (int)gb);
        int gc2 = Mth.m_14143_((float)(((float)gc + 19.0f) / 20.0f));
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int blt = (int)Math.floor(182.0 / (double)gb * (double)gc);
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 0, 182, 5);
        if (blt > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS_2, x, l, 0, 5, blt, 5);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        int y = 10398321;
        Font renderer = minecraft.f_91062_;
        String $$6 = "" + gc2;
        int $$7 = (scaledWidth - renderer.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(renderer, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8, y, false);
    }

    public static void renderShootModeSoftAndWet(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int x, PowersSoftAndWet PW) {
        int gb = PW.getMaxGoBeyondChargeTicks();
        int gc = PW.getGoBeyondCharge();
        gc = Mth.m_14045_((int)gc, (int)0, (int)gb);
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        if (PW.getInExplosiveSpinMode()) {
            int blt = (int)Math.floor(182.0 / (double)gb * (double)gc);
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 151, 182, 5);
            if (blt > 0) {
                context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 156, blt, 5);
            }
        } else {
            int st = PW.getMaxShootTicks();
            int sc = PW.getShootTicks();
            sc = Mth.m_14045_((int)sc, (int)0, (int)st);
            int blt = (int)Math.floor(182.0 / (double)gb * (double)gc);
            int blt2 = (int)Math.floor(182.0 / (double)st * (double)sc);
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 141, 182, 2);
            context.m_280218_(StandIcons.JOJO_ICONS, x, l + 2, 0, 143, 182, 3);
            if (blt > 0) {
                context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 146, blt, 2);
            }
            if (blt2 > 0) {
                context.m_280218_(StandIcons.JOJO_ICONS, x, l + 2, 0, 148, blt2, 3);
            }
        }
        int u = 183;
        int k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        if (PW.getInExplosiveSpinMode()) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 80, 9, 9);
        } else if (PW.canShootExplosive(PW.getUseTicks())) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 70, 9, 9);
        } else {
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 90, 9, 9);
        }
    }

    public static void renderShootModeLightSoftAndWet(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int x, PowersSoftAndWet PW) {
        int u = 183;
        int k = scaledWidth / 2 - 5;
        int l = scaledHeight - 31 - 5;
        if (PW.getInExplosiveSpinMode()) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 80, 9, 9);
        } else if (PW.canShootExplosive(PW.getUseTicks())) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 70, 9, 9);
        } else {
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, 90, 9, 9);
        }
    }

    public static void renderExpHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, boolean removeNum) {
        StandUser standUser = (StandUser)playerEntity;
        byte level = ((IPlayerEntity)playerEntity).roundabout$getStandLevel();
        int exp = ((IPlayerEntity)playerEntity).roundabout$getStandExp();
        int maxXP = standUser.roundabout$getStandPowers().getExpForLevelUp(level);
        if (level == standUser.roundabout$getStandPowers().getMaxLevel() || !standUser.roundabout$getStandDisc().m_41619_() && standUser.roundabout$getStandDisc().m_41720_() instanceof MaxStandDiscItem) {
            exp = maxXP;
        }
        int blt = (int)Math.floor(182.0 / (double)maxXP * (double)exp);
        int l = scaledHeight - 32 + 3;
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 100, 182, 5);
        if (blt > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 105, blt, 5);
        }
        if (!removeNum) {
            int y = 6141337;
            Font renderer = client.f_91062_;
            String $$6 = "" + level;
            int $$7 = (scaledWidth - renderer.m_92895_($$6)) / 2;
            int $$8 = scaledHeight - 31 - 4;
            context.m_280056_(renderer, $$6, $$7 + 1, $$8, 0, false);
            context.m_280056_(renderer, $$6, $$7 - 1, $$8, 0, false);
            context.m_280056_(renderer, $$6, $$7, $$8 + 1, 0, false);
            context.m_280056_(renderer, $$6, $$7, $$8 - 1, 0, false);
            context.m_280056_(renderer, $$6, $$7, $$8, y, false);
        }
    }

    public static void renderExperienceBar(Minecraft client, int scaledWidth, int scaledHeight, GuiGraphics $$0) {
        int $$2 = client.f_91074_.m_36323_();
        if ($$2 > 0) {
            int $$3 = 182;
            int $$4 = (int)(client.f_91074_.f_36080_ * 183.0f);
            int $$5 = scaledHeight - 32 + 3;
            int $$7 = scaledWidth / 2 - 91;
            $$0.m_280218_(GUI_ICONS_LOCATION, $$7, $$5, 0, 64, 182, 5);
            if ($$4 > 0) {
                $$0.m_280218_(GUI_ICONS_LOCATION, $$7, $$5, 0, 69, $$4, 5);
            }
        }
    }

    public static void renderNumberHUD(GuiGraphics context, Minecraft client, int scaledWidth, int scaledHeight, int x, double value, double max, ResourceLocation file, int bx, int by, int color) {
        int blt = (int)Math.floor(182.0 / max * value);
        int l = scaledHeight - 32 + 3;
        context.m_280218_(file, x, l, bx, by, 182, 5);
        if (blt > 0) {
            context.m_280218_(file, x, l, bx, by + 5, blt, 5);
        }
        int u = 183;
        int k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        int y = color;
        Font renderer = client.f_91062_;
        String $$6 = "" + (int)value;
        int $$7 = (scaledWidth - renderer.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(renderer, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8, y, false);
    }

    public static void renderDistanceHUDJustice(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, StandEntity stand) {
        StandUser standUser = (StandUser)playerEntity;
        StandPowers powers = standUser.roundabout$getStandPowers();
        int mode = powers.getPilotMode();
        int maxDistance = powers.getMaxPilotRange();
        int distance = 1;
        if (mode == 1) {
            distance = (int)stand.m_20182_().m_82554_(playerEntity.m_20182_());
        } else if (mode == 2) {
            distance = (int)MainUtil.cheapDistanceTo2(stand.m_20185_(), stand.m_20189_(), playerEntity.m_20185_(), playerEntity.m_20189_());
        }
        int blt = (int)Math.floor(182.0 / (double)maxDistance * (double)distance);
        int l = scaledHeight - 32 + 3;
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 131, 182, 5);
        if (blt > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, 136, blt, 5);
        }
        int u = 183;
        int k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        int y = 16173823;
        Font renderer = client.f_91062_;
        String $$6 = "" + distance;
        int $$7 = (scaledWidth - renderer.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(renderer, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(renderer, $$6, $$7, $$8, y, false);
    }

    public static void renderGuardHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha) {
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        int v = standUser.roundabout$getGuardBroken() || !standUser.roundabout$shieldNotDisabled() ? 10 : 0;
        int k = (int)Math.floor(182.0f / standUser.roundabout$getMaxGuardPoints() * standUser.roundabout$getGuardPoints());
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v + 5, k, 5);
        }
        int u = 183;
        k = scaledWidth / 2 - 5;
        l = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, k, l, u, v, 9, 9);
    }

    public static void renderTSHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, boolean isTSEntity, Font font) {
        int y;
        int z;
        int k;
        int v;
        int l = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        if (isTSEntity || standUser.roundabout$getStandPowers().getIsTsCharging()) {
            v = 50;
            k = (int)Math.floor(182.0 / ((double)standUser.roundabout$getStandPowers().getMaxChargeTSTime() / 20.0) * ((double)standUser.roundabout$getStandPowers().getChargedTSTicks() / 20.0));
            z = (int)Math.min(Math.floor(((double)standUser.roundabout$getStandPowers().getChargedTSTicks() + 19.0) / 20.0), (double)standUser.roundabout$getStandPowers().getMaxChargeTSTime() / 20.0);
            y = 7654088;
        } else {
            v = 60;
            y = 7836819;
            TimeStopInstance tsi = ((TimeStop)playerEntity.m_9236_()).getTimeStopperInstanceClient(playerEntity.m_20182_());
            if (tsi != null) {
                k = (int)Math.floor(182.0 / ((double)tsi.maxDuration / 20.0) * ((double)tsi.duration / 20.0));
                z = (int)Math.min(Math.floor(((double)tsi.duration + 19.0) / 20.0), (double)tsi.maxDuration / 20.0);
            } else {
                k = 0;
                z = 0;
            }
        }
        context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v, 182, 5);
        if (k > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, l, 0, v + 5, k, 5);
        }
        String $$6 = "" + z;
        int $$7 = (scaledWidth - font.m_92895_($$6)) / 2;
        int $$8 = scaledHeight - 31 - 4;
        context.m_280056_(font, $$6, $$7 + 1, $$8, 0, false);
        context.m_280056_(font, $$6, $$7 - 1, $$8, 0, false);
        context.m_280056_(font, $$6, $$7, $$8 + 1, 0, false);
        context.m_280056_(font, $$6, $$7, $$8 - 1, 0, false);
        context.m_280056_(font, $$6, $$7, $$8, y, false);
    }

    public static void renderClashHud(GuiGraphics context, Minecraft client, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int x, float flashAlpha, float otherFlashAlpha, float c) {
        int d = (int)(c * 183.0f);
        int e = scaledHeight - 32 + 3;
        StandUser standUser = (StandUser)playerEntity;
        context.m_280218_(StandIcons.JOJO_ICONS, x, e, 0, 20, 182, 5);
        if (d > 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, x, e, 0, 25, d, 5);
        }
        int f = scaledWidth / 2 - 5;
        int g = scaledHeight - 31 - 5;
        context.m_280218_(StandIcons.JOJO_ICONS, f, g, 183, 20, 9, 9);
        LivingEntity clashOp = ((StandUser)client.f_91074_).roundabout$getStandPowers().getClashOp();
        if (clashOp != null) {
            int i = context.m_280182_();
            int j = 12;
            int k = i / 2 - 91;
            int l = j;
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, 0, 40, 182, 5);
            float q = ((StandUser)client.f_91074_).roundabout$getStandPowers().getClashOpProgress();
            int r = (int)(q * 183.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, l, 0, 45, r, 5);
            Component text = clashOp.m_7755_();
            int m = client.f_91062_.m_92852_((FormattedText)text);
            int n = i / 2 - m / 2;
            int o = l - 9;
            context.m_280430_(client.f_91062_, text, n, o, 0xFFFFFF);
            context.m_280218_(StandIcons.JOJO_ICONS, f, l + 5, 183, 20, 9, 9);
        }
    }
}

