/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.datagen;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.util.Map;
import net.hydra.jojomod.DataGenerators;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.datagen.GennedBlockModel;
import net.hydra.jojomod.datagen.GennedBlockState;
import net.hydra.jojomod.datagen.GennedItemModel;
import net.hydra.jojomod.registry.ForgeBlocks;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.zetalasis.hjson.JsonObject;
import net.zetalasis.hjson.JsonValue;
import net.zetalasis.hjson.Stringify;

public class RoundaboutBlockModelProvider
extends BlockStateProvider {
    public RoundaboutBlockModelProvider(PackOutput packOutput, String modId, ExistingFileHelper existingFileHelper) {
        super(packOutput, modId, existingFileHelper);
    }

    protected void registerStatesAndModels() {
        String OGPath;
        ResourceLocation i;
        Block b;
        for (Map.Entry<ResourceLocation, Block> me : ForgeBlocks.fogBlocks.entrySet()) {
            b = me.getValue();
            i = me.getKey();
            Roundabout.LOGGER.info(me.getKey().toString());
            OGPath = i.m_135815_().replace("fog_", "").replace("_coating", "");
            Roundabout.LOGGER.info("Generating blockstate for " + i.m_135815_());
            com.google.gson.JsonObject main = new com.google.gson.JsonObject();
            com.google.gson.JsonObject variants = new com.google.gson.JsonObject();
            com.google.gson.JsonObject falseVariant = new com.google.gson.JsonObject();
            falseVariant.addProperty("model", "roundabout:block/fog_block_invisible");
            InputStreamReader assetResource = DataGenerators.getJsonResourceStream("blockstates/" + i.m_135815_().replace("fog_", "")).get();
            variants.add("in_fog=false", (JsonElement)falseVariant);
            try {
                JsonObject OGVariants = JsonValue.readJSON(assetResource).asObject().get("variants").asObject();
                for (JsonObject.Member member : OGVariants) {
                    if (member.getName().isEmpty()) {
                        variants.add("in_fog=true", JsonParser.parseString((String)member.getValue().toString(Stringify.PLAIN)));
                        continue;
                    }
                    variants.add("in_fog=true," + member.getName(), JsonParser.parseString((String)member.getValue().toString(Stringify.PLAIN)));
                }
                main.add("variants", (JsonElement)variants);
                this.registeredBlocks.put(b, new GennedBlockState(main));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Roundabout.LOGGER.info("Generating item model for " + i.m_135815_());
            main = new com.google.gson.JsonObject();
            Roundabout.LOGGER.info("blockstates/" + i.m_135815_().replace("fog_", ""));
            main.addProperty("parent", DataGenerators.getModelFromBStateStream(DataGenerators.getJsonResourceStream("blockstates/" + i.m_135815_().replace("fog_", "")).get()).get());
            this.itemModels().generatedModels.put(i, new GennedItemModel(new ResourceLocation("roundabout", "item/" + i.m_135815_()), this.itemModels().existingFileHelper, main));
        }
        for (Map.Entry<ResourceLocation, Block> me : ForgeBlocks.fogCoatingBlocks.entrySet()) {
            b = me.getValue();
            i = me.getKey();
            Roundabout.LOGGER.info(me.getKey().toString());
            OGPath = i.m_135815_().replace("fog_", "").replace("_coating", "");
            InputStreamReader assetResource = DataGenerators.getJsonResourceStream("blockstates/" + i.m_135815_().replace("fog_", "").replace("_coating", "")).get();
            String blockTex = DataGenerators.getTexturefromModelName(DataGenerators.getModelFromBStateStream(assetResource).get()).get();
            Roundabout.LOGGER.info("Generating model for " + i.m_135815_());
            com.google.gson.JsonObject main = new com.google.gson.JsonObject();
            com.google.gson.JsonObject textures = new com.google.gson.JsonObject();
            main.addProperty("parent", "roundabout:block/fog_coating_source");
            if (!blockTex.isEmpty()) {
                textures.addProperty("texture", blockTex);
                main.add("textures", (JsonElement)textures);
            } else {
                Roundabout.LOGGER.info("Couldn't find texture for " + OGPath + ". Guessing texture name");
                textures.addProperty("texture", "minecraft:block/" + OGPath);
                main.add("textures", (JsonElement)textures);
            }
            this.models().generatedModels.put(i, new GennedBlockModel(new ResourceLocation("roundabout", "block/" + i.m_135815_()), this.models().existingFileHelper, main));
            Roundabout.LOGGER.info("Generating blockstate for " + i.m_135815_());
            String name = i.m_135815_();
            this.registeredBlocks.put(b, new GennedBlockState(JsonParser.parseString((String)String.format("{\n  \"variants\": {\n    \"in_fog=true,facing=east\": {\n      \"model\": \"roundabout:block/%s\",\n      \"x\": 270,\n      \"y\": 270\n    },\n    \"in_fog=true,facing=north\": {\n      \"model\": \"roundabout:block/%s\",\n      \"x\": 270,\n      \"y\": 180\n    },\n    \"in_fog=true,facing=south\": {\n      \"model\": \"roundabout:block/%s\",\n      \"x\": 270\n    },\n    \"in_fog=true,facing=west\": {\n      \"model\": \"roundabout:block/%s\",\n      \"x\": 270,\n      \"y\": 90\n    },\n    \"in_fog=true,facing=up\": {\n      \"model\": \"roundabout:block/%s\"\n    },\n    \"in_fog=true,facing=down\": {\n      \"model\": \"roundabout:block/%s\",\n      \"x\": 180\n    },\n    \"in_fog=false\": {\n      \"model\": \"roundabout:block/fog_block_invisible\"\n    }\n  }\n}\n\n", name, name, name, name, name, name)).getAsJsonObject()));
            Roundabout.LOGGER.info("Generating item model for " + i.m_135815_());
            this.itemModels().generatedModels.put(i, new GennedItemModel(new ResourceLocation("roundabout", "item/" + i.m_135815_()), this.itemModels().existingFileHelper, JsonParser.parseString((String)("{\n\t\"parent\": \"roundabout:item/fog_coating\",\n\t\"textures\": {\n  \"layer0\": \"" + blockTex + "\"\t}\n}\n")).getAsJsonObject()));
        }
    }
}

