/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.client.shader;

import java.io.IOException;
import java.util.HashMap;
import net.hydra.jojomod.Roundabout;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.zetalasis.client.shader.IPostChainAccessor;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class RPostShaderRegistry {
    public static Matrix4f InverseProjectionMatrix = new Matrix4f();
    private static HashMap<String, IPostChainAccessor> shaders = new HashMap();
    public static IPostChainAccessor D4C_DIMENSION_TRANSITION = null;
    public static IPostChainAccessor D4C_ALT_DIMENSION = null;
    public static IPostChainAccessor DESATURATE = null;
    public static IPostChainAccessor DECONVERGE = null;
    public static IPostChainAccessor PHOSPHOR = null;

    public static void bootstrap() {
        Roundabout.LOGGER.info("Registering post effects");
        D4C_DIMENSION_TRANSITION = RPostShaderRegistry.register("d4cdimtransition");
        D4C_ALT_DIMENSION = RPostShaderRegistry.register("d4caltdim");
        DESATURATE = RPostShaderRegistry.register("desaturate");
        DECONVERGE = RPostShaderRegistry.register("deconverge");
        PHOSPHOR = RPostShaderRegistry.register("phosphor");
    }

    @Nullable
    public static IPostChainAccessor register(String name) {
        try {
            Minecraft client = Minecraft.m_91087_();
            TextureManager tm = client.m_91097_();
            ResourceManager rm = client.m_91098_();
            IPostChainAccessor shader = IPostChainAccessor.getInstance(new PostChain(tm, rm, client.m_91385_(), new ResourceLocation("shaders/post/" + name + ".json")));
            shaders.put(name, shader);
            Roundabout.LOGGER.info("Registered post shader \"{}\" successfully", (Object)name);
            return shader;
        }
        catch (IOException e) {
            Roundabout.LOGGER.warn("Failed to register shader \"{}\"!\n\"{}\"", (Object)name, (Object)e.toString());
            return null;
        }
    }

    @Nullable
    public static IPostChainAccessor getByName(String name) {
        return shaders.get(name);
    }
}

