/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import net.hydra.jojomod.entity.stand.StandAnimations;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5597;
import net.minecraft.class_630;

public class StandModel<T extends StandEntity>
extends class_5597<T> {
    private float alpha;
    class_630 stand;
    class_630 head;
    class_630 body;
    public class_630 leftHand;
    public class_630 rightHand;
    private final float maxRotX = 0.25f;
    private final float minRotX = 0.04f;
    private float swimRotCorrect = 0.0f;

    public void setHeadRotations(float pitch, float yaw) {
        this.head.field_3654 = pitch;
        this.head.field_3675 = yaw;
    }

    public void setBodyRotations(float pitch, float yaw) {
        this.body.field_3654 = pitch;
        this.body.field_3675 = yaw;
    }

    public void setStandRotations(float pitch, float yaw, float z) {
        this.stand.field_3654 = pitch;
        this.stand.field_3675 = yaw;
        this.stand.field_3674 = z;
    }

    protected class_630 getArm(class_1306 p_102852_) {
        return p_102852_ == class_1306.field_6182 ? this.rightHand : this.leftHand;
    }

    public void translateToHand(class_1306 p_103778_, class_4587 p_103779_, float zshift, float yshift, float xshift) {
        float f = p_103778_ == class_1306.field_6183 ? xshift : -xshift;
        class_630 modelpart = this.getArm(p_103778_);
        modelpart.field_3657 += f;
        modelpart.field_3656 -= yshift;
        modelpart.field_3655 += zshift;
        modelpart.method_22703(p_103779_);
        modelpart.field_3657 -= f;
        modelpart.field_3656 += yshift;
        modelpart.field_3655 -= zshift;
    }

    public class_630 method_32008() {
        return this.stand;
    }

    public void defaultAnimations(T entity, float animationProgress, float windupLength) {
        this.method_43782(((StandEntity)((Object)entity)).idleAnimationState, StandAnimations.STAND_IDLE_FLOAT, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).idleAnimationState2, StandAnimations.IDLE_2, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).idleAnimationState3, StandAnimations.FLOATY_IDLE, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).idleAnimationState4, StandAnimations.STAR_PLATINUM_IDLE, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).punchState1, StandAnimations.COMBO1, animationProgress, 1.4f);
        this.method_43782(((StandEntity)((Object)entity)).punchState2, StandAnimations.COMBO2, animationProgress, 1.16666f);
        this.method_43782(((StandEntity)((Object)entity)).punchState3, StandAnimations.COMBO3, animationProgress, 1.16666f);
        this.method_43782(((StandEntity)((Object)entity)).blockAnimationState, StandAnimations.BLOCK, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).barrageChargeAnimationState, StandAnimations.BARRAGECHARGE, animationProgress, windupLength);
        this.method_43782(((StandEntity)((Object)entity)).barrageAnimationState, StandAnimations.BARRAGE, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).miningBarrageAnimationState, StandAnimations.MINING_BARRAGE, animationProgress, 1.65f);
        this.method_43782(((StandEntity)((Object)entity)).barrageEndAnimationState, StandAnimations.COMBO3, animationProgress, 2.2f);
        this.method_43782(((StandEntity)((Object)entity)).barrageHurtAnimationState, StandAnimations.BARRAGEDAMAGE, animationProgress, 2.5f);
        this.method_43782(((StandEntity)((Object)entity)).brokenBlockAnimationState, StandAnimations.BLOCKBREAK, animationProgress, 1.8f);
        this.method_43782(((StandEntity)((Object)entity)).standLeapAnimationState, StandAnimations.STAND_LEAP, animationProgress, 1.0f);
        this.method_43782(((StandEntity)((Object)entity)).standLeapEndAnimationState, StandAnimations.STAND_LEAP_END, animationProgress, 3.0f);
    }

    public void defaultModifiers(T entity) {
        class_310 mc = class_310.method_1551();
        if (((StandEntity)((Object)entity)).getUser() != null) {
            class_1309 User = ((StandEntity)((Object)entity)).getUser();
            if (!mc.method_1493() && !((TimeStop)entity.method_37908()).CanTimeStopEntity((class_1297)User)) {
                float tickDelta = mc.method_1534();
                this.rotateStand(entity, this.method_32008(), tickDelta);
                if (this.method_32008().method_41919("stand2")) {
                    if (this.method_32008().method_32086("stand2").method_41919("head")) {
                        if (User != null && User.method_6109()) {
                            class_630 mp = this.method_32008().method_32086("stand2").method_32086("head");
                            mp.field_37938 *= 1.5f;
                            mp.field_37939 *= 1.5f;
                            mp.field_37940 *= 1.5f;
                        }
                        this.rotateHead(entity, this.method_32008().method_32086("stand2").method_32086("head"), tickDelta);
                    }
                    if (this.method_32008().method_32086("stand2").method_41919("body")) {
                        this.rotateBody(entity, this.method_32008().method_32086("stand2").method_32086("body"), tickDelta);
                    }
                }
            } else {
                float rotX = ((StandEntity)((Object)entity)).getStandRotationX();
                float rotY = ((StandEntity)((Object)entity)).getStandRotationY();
                float rotZ = ((StandEntity)((Object)entity)).getStandRotationZ();
                this.setStandRotations(rotX, rotY, rotZ);
                if (this.method_32008().method_41919("stand2")) {
                    if (this.method_32008().method_32086("stand2").method_41919("head")) {
                        rotX = ((StandEntity)((Object)entity)).getHeadRotationX();
                        rotY = ((StandEntity)((Object)entity)).getHeadRotationY();
                        this.setHeadRotations(rotX, rotY);
                    }
                    if (this.method_32008().method_32086("stand2").method_41919("body")) {
                        rotX = ((StandEntity)((Object)entity)).getBodyRotationX();
                        rotY = ((StandEntity)((Object)entity)).getBodyRotationY();
                        this.setBodyRotations(rotX, rotY);
                    }
                }
            }
        }
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.method_32008().method_32088().forEach(class_630::method_41923);
    }

    public void method_2828(class_4587 matrices, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.stand.method_22699(matrices, vertexConsumer, light, overlay, red, green, blue, this.alpha);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void rotateHead(T mobEntity, class_630 head, float tickDelta) {
        if (((StandEntity)((Object)mobEntity)).getDisplay()) {
            this.setHeadRotations(0.0f, 0.0f);
            return;
        }
        byte animationNumber = ((StandEntity)((Object)mobEntity)).getOffsetType();
        byte animationStyle = OffsetIndex.OffsetStyle(animationNumber);
        float rotX = ((StandEntity)((Object)mobEntity)).getHeadRotationX();
        float rotY = ((StandEntity)((Object)mobEntity)).getHeadRotationY();
        if (animationStyle == 0) {
            if ((((StandEntity)((Object)mobEntity)).method_5681() || ((StandEntity)((Object)mobEntity)).method_20448() || ((StandEntity)((Object)mobEntity)).method_6128()) && animationNumber != 7) {
                if (this.swimRotCorrect > -45.0f) {
                    this.swimRotCorrect -= 2.0f;
                    this.swimRotCorrect = Math.min(this.swimRotCorrect, -45.0f);
                }
            } else if (this.swimRotCorrect < 0.0f) {
                this.swimRotCorrect += 2.0f;
                this.swimRotCorrect = Math.max(this.swimRotCorrect, 0.0f);
            }
            float tickDelta2 = Math.min(tickDelta, 2.0f);
            rotX = (((StandEntity)((Object)mobEntity)).getUser().method_5695(tickDelta2) % 360.0f - this.swimRotCorrect) * ((float)Math.PI / 180);
            rotY = 0.0f;
        } else if (animationStyle == 1) {
            rotX = 0.0f;
            rotY = 0.0f;
        } else if (animationStyle == 2) {
            rotX = 0.0f;
            rotY = 0.0f;
        }
        ((StandEntity)((Object)mobEntity)).setHeadRotationX(rotX);
        ((StandEntity)((Object)mobEntity)).setHeadRotationY(rotY);
        this.setHeadRotations(rotX, rotY);
    }

    public void rotateStand(T mobEntity, class_630 stand, float tickDelta) {
        if (((StandEntity)((Object)mobEntity)).getDisplay()) {
            this.setStandRotations(0.0f, 0.0f, 0.0f);
            return;
        }
        byte animationNumber = ((StandEntity)((Object)mobEntity)).getOffsetType();
        byte animationStyle = OffsetIndex.OffsetStyle(animationNumber);
        float rotX = ((StandEntity)((Object)mobEntity)).getStandRotationX();
        float rotY = ((StandEntity)((Object)mobEntity)).getStandRotationY();
        float rotZ = ((StandEntity)((Object)mobEntity)).getStandRotationZ();
        float cRX = 0.0f;
        float cRY = 0.0f;
        float cRZ = 0.0f;
        if (animationNumber == 0) {
            cRY = ((StandEntity)((Object)mobEntity)).getIdleRotation() * ((float)Math.PI / 180);
        }
        if (animationStyle == 1) {
            cRX = ((StandEntity)((Object)mobEntity)).getUser().method_5695(tickDelta) % 360.0f * ((float)Math.PI / 180);
            if (animationNumber == 6) {
                cRX = 1.5707964f;
                cRZ = (float)Math.PI;
            }
        } else if (animationStyle == 2 || animationNumber == 8) {
            cRX = mobEntity.method_5695(tickDelta) % 360.0f * ((float)Math.PI / 180);
        }
        rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, cRX, 0.8f);
        rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, cRY, 0.8f);
        rotZ = MainUtil.controlledLerpRadianDegrees(tickDelta, rotZ, cRZ, 0.8f);
        ((StandEntity)((Object)mobEntity)).setStandRotationX(rotX);
        ((StandEntity)((Object)mobEntity)).setStandRotationY(rotY);
        ((StandEntity)((Object)mobEntity)).setStandRotationZ(rotZ);
        this.setStandRotations(rotX, rotY, rotZ);
    }

    public void rotateBody(T mobEntity, class_630 body, float tickDelta) {
        if (((StandEntity)((Object)mobEntity)).getDisplay()) {
            this.setBodyRotations(0.0f, 0.0f);
            return;
        }
        byte animationNumber = ((StandEntity)((Object)mobEntity)).getOffsetType();
        byte animationStyle = OffsetIndex.OffsetStyle(animationNumber);
        float rotX = ((StandEntity)((Object)mobEntity)).getBodyRotationX();
        float rotY = ((StandEntity)((Object)mobEntity)).getBodyRotationY();
        if (animationStyle == 0) {
            float cRot = 0.25f;
            if ((((StandEntity)((Object)mobEntity)).method_5681() || ((StandEntity)((Object)mobEntity)).method_6128()) && animationNumber != 7) {
                cRot = (((StandEntity)((Object)mobEntity)).getUser().method_5695(tickDelta) % 360.0f + 90.0f) * ((float)Math.PI / 180);
            } else if (((StandEntity)((Object)mobEntity)).method_20448() && animationNumber != 7) {
                cRot = 1.5707964f;
            } else {
                byte moveForward = ((StandEntity)((Object)mobEntity)).getMoveForward();
                if (animationNumber == 7) {
                    moveForward = 0;
                }
                cRot = moveForward < 0 ? (cRot *= (float)(-moveForward)) : (moveForward > 0 ? (cRot *= (float)(-moveForward)) : 0.0f);
                cRot *= -0.6f;
            }
            rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, cRot, 0.15f);
            rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, 0.0f, 0.8f);
        } else if (animationStyle == 1) {
            float xRot = 0.0f;
            float yRot = 0.0f;
            rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, xRot, 0.8f);
            rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, yRot, 0.8f);
        } else if (animationStyle == 2) {
            rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, 0.0f, 0.8f);
            rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, 0.0f, 0.8f);
        }
        ((StandEntity)((Object)mobEntity)).setBodyRotationX(rotX);
        ((StandEntity)((Object)mobEntity)).setBodyRotationY(rotY);
        this.setBodyRotations(rotX, rotY);
    }
}

