/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util;

import net.hydra.jojomod.util.annotation.BooleanOption;
import net.hydra.jojomod.util.annotation.FloatOption;
import net.hydra.jojomod.util.annotation.Groups;
import net.hydra.jojomod.util.annotation.IntOption;
import net.hydra.jojomod.util.annotation.NestedOption;

@Groups(value={"toggles", "vanilla", "added_vanilla", "modded"})
public class ClientConfig {
    private static ClientConfig LOCAL_INSTANCE = new ClientConfig();
    @BooleanOption(group="inherit", value=true)
    public Boolean onlyStandUsersCanSeeStands;
    @BooleanOption(group="inherit", value=false)
    public Boolean onlyStandUsersCanSeeVanillaGhostMobs;
    @BooleanOption(group="inherit", value=true)
    public Boolean renderJusticeHandsWhilePiloting;
    @BooleanOption(group="inherit", value=true)
    public Boolean renderArmorOnFogClones;
    @BooleanOption(group="inherit", value=false)
    public Boolean renderGasSplatterOverlay;
    @BooleanOption(group="inherit", value=true)
    public Boolean showCreativeTextOnWorthinessArrow;
    @BooleanOption(group="inherit", value=true)
    public Boolean pressingAbilityKeysSummonsStands;
    @BooleanOption(group="inherit", value=true)
    public Boolean disableObviousExperimentalWarning;
    @IntOption(group="inherit", value=190)
    public Integer justiceFogBrightness;
    @BooleanOption(group="inherit", value=true)
    public Boolean magiciansRedTexturesMakeItEmmissive;
    @BooleanOption(group="inherit", value=false)
    public Boolean magiciansRedLashesMakeItEmmissive;
    @BooleanOption(group="inherit", value=true)
    public Boolean magiciansRedRenderOnFireInFirstPerson;
    @NestedOption(group="modded")
    public ParticleSettings particleSettings;
    @NestedOption(group="modded")
    public OpacitySettings opacitySettings;
    @NestedOption(group="modded")
    public TimeStopSettings timeStopSettings;

    private ClientConfig() {
    }

    public static ClientConfig getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    static void updateLocal(ClientConfig config) {
        LOCAL_INSTANCE = config;
    }

    public static class TimeStopSettings {
        @BooleanOption(group="inherit", value=false)
        public Boolean timeStopFreezesScreen;
        @BooleanOption(group="inherit", value=true)
        public Boolean simpleTimeStopShader;
    }

    public static class OpacitySettings {
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityOfStand;
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityWhileAttacking;
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityOfOthers;
    }

    public static class ParticleSettings {
        @BooleanOption(group="inherit", value=true)
        public Boolean renderJusticeParticlesInFirstPerson;
        @BooleanOption(group="inherit", value=false)
        public Boolean renderJusticeParticlesWhilePilotingInFirstPerson;
        @IntOption(group="inherit", value=5, min=0, max=72000)
        public Integer justiceFogParticlesPerTick;
        @IntOption(group="inherit", value=3, min=0, max=72000)
        public Integer justiceSkinFlameParticlesPerTick;
        @IntOption(group="inherit", value=3, min=0, max=72000)
        public Integer cfhTicksPerFlameParticle;
        @IntOption(group="inherit", value=1, min=0, max=72000)
        public Integer bodyBagHoldingParticlesPerFiveTicks;
        @FloatOption(group="inherit", value=0.01f, min=0.0f, max=1.0f)
        public Float magiciansRedFirestormEmbersRate;
    }
}

