/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.objects.Object2DoubleMap;
import java.util.List;
import net.hydra.jojomod.access.IClientEntity;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.entity.projectile.CinderellaVisageDisplayEntity;
import net.hydra.jojomod.entity.projectile.CrossfireHurricaneEntity;
import net.hydra.jojomod.entity.stand.FollowingStandEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersWalkingHeart;
import net.hydra.jojomod.util.GEntityTags;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.RotationAnimation;
import net.hydra.jojomod.util.RotationParameters;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1511;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_1297.class}, priority=100)
public abstract class GravityEntityMixin
implements IGravityEntity {
    @Shadow
    public boolean field_34927;
    @Shadow
    public boolean field_5992;
    @Shadow
    public boolean field_5976;
    @Shadow
    public boolean field_36331;
    @Shadow
    public float field_5994;
    @Shadow
    public float field_6039;
    @Shadow
    public float field_5973;
    @Shadow
    public double field_5989;
    @Shadow
    public double field_5971;
    @Shadow
    public double field_6038;
    @Shadow
    public int field_6012;
    @Unique
    private static final class_2940<class_2350> ROUNDABOUT$GRAVITY_DIRECTION = class_2945.method_12791(class_1297.class, (class_2941)class_2943.field_13321);
    @Unique
    private static boolean rdbdt$taggedForFlip;
    @Unique
    private boolean roundabout$initialized = false;
    @Unique
    private class_2350 roundabout$prevGravityDirection = class_2350.field_11033;
    @Unique
    private double roundabout$prevGravityStrength = 1.0;
    @Unique
    class_2350 roundabout$baseGravityDirection = class_2350.field_11033;
    @Unique
    private static double roundabout$baseGravityStrength;
    @Nullable
    RotationParameters roundabout$currentRotationParameters = RotationParameters.getDefault();
    @Unique
    private double roundabout$currGravityStrength = 1.0;
    @Unique
    private double roundabout$currentEffectPriority = Double.MIN_VALUE;
    @Unique
    private long roundabout$lastUpdateTickCount = 0L;
    public int rdbt$noSuffocateTicks = 0;
    @Shadow
    private class_243 field_22467;
    @Shadow
    private class_4048 field_18065;
    @Shadow
    private float field_18066;
    @Shadow
    public double field_6014;
    @Shadow
    public double field_6036;
    @Shadow
    public double field_5969;
    @Shadow
    public class_1937 field_6002;
    @Shadow
    public boolean field_5960;
    @Shadow
    @Final
    protected class_5819 field_5974;
    @Shadow
    public float field_6017;
    @Shadow
    @Final
    protected class_2945 field_6011;
    @Shadow
    private boolean field_5952;
    @Shadow
    private float field_6013;
    @Shadow
    protected Object2DoubleMap<class_6862<class_3611>> field_5964;

    @Shadow
    @Deprecated
    public abstract class_2338 method_43260();

    @Shadow
    protected abstract boolean method_39759(class_243 var1);

    @Shadow
    public abstract class_243 method_5663();

    @Shadow
    public abstract float method_17681();

    @Shadow
    public abstract class_243 method_30950(float var1);

    @Shadow
    public abstract class_241 method_5802();

    @Shadow
    @Nullable
    public abstract class_1309 method_5642();

    @Shadow
    public abstract boolean method_5787();

    @Shadow
    public abstract double method_5621();

    @Shadow
    public abstract boolean method_5626(class_1297 var1);

    @Shadow
    public abstract boolean method_24828();

    @Shadow
    protected abstract boolean method_51702(class_2680 var1);

    @Shadow
    public abstract class_2338 method_23312();

    @Shadow
    protected abstract class_243 method_17835(class_243 var1);

    @Shadow
    public abstract void method_33574(class_243 var1);

    @Shadow
    protected abstract class_238 method_33332();

    @Shadow
    public abstract void method_5857(class_238 var1);

    @Shadow
    @Nullable
    public abstract class_1297 method_5854();

    @Override
    @Unique
    public class_2350 roundabout$getGravityDirection() {
        if (this.field_6011.method_51696(ROUNDABOUT$GRAVITY_DIRECTION)) {
            return (class_2350)this.method_5841().method_12789(ROUNDABOUT$GRAVITY_DIRECTION);
        }
        return class_2350.field_11033;
    }

    @Override
    @Unique
    public void roundabout$setBaseGravityDirection(class_2350 gravityDirection) {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        if (this.roundabout$baseGravityDirection != gravityDirection) {
            this.roundabout$baseGravityDirection = gravityDirection;
            this.roundabout$updateGravityStatus();
        }
    }

    @Override
    @Unique
    public int roundabout$getSuffocationTicks() {
        return this.rdbt$noSuffocateTicks;
    }

    @Override
    @Unique
    public void roundabout$setGravityDirection(class_2350 direction) {
        if (this.field_6011.method_51696(ROUNDABOUT$GRAVITY_DIRECTION)) {
            this.method_5841().method_12778(ROUNDABOUT$GRAVITY_DIRECTION, (Object)direction);
        }
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V"}, at={@At(value="TAIL")})
    public void roundabout$init(class_1299 $$0, class_1937 $$1, CallbackInfo ci) {
        if (!((class_1297)this).method_5841().method_51696(ROUNDABOUT$GRAVITY_DIRECTION)) {
            ((class_1297)this).method_5841().method_12784(ROUNDABOUT$GRAVITY_DIRECTION, (Object)class_2350.field_11033);
        }
    }

    @Override
    @Unique
    public void rdbdt$setTaggedForFlip(boolean flip) {
        rdbdt$taggedForFlip = flip;
    }

    @Override
    @Unique
    public double roundabout$getGravityStrength() {
        return this.roundabout$currGravityStrength;
    }

    @Override
    @Unique
    public void roundabout$setGravityStrength(double str) {
        this.roundabout$currGravityStrength = str;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void roundabout$tickGrav(CallbackInfo ci) {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        this.roundabout$updateGravityStatus();
        this.roundabout$applyGravityChange();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void roundabout$tickGravTail(CallbackInfo ci) {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        this.roundabout$updateGravityStatus();
        this.roundabout$applyGravityChange();
        if (this.rdbt$noSuffocateTicks > 0) {
            --this.rdbt$noSuffocateTicks;
        }
    }

    @Override
    @Unique
    public void roundabout$applyGravityChange() {
        if (!this.roundabout$canChangeGravity()) {
            return;
        }
        if (this.roundabout$currentRotationParameters == null) {
            this.roundabout$currentRotationParameters = RotationParameters.getDefault();
        }
        if (this.roundabout$prevGravityDirection != this.roundabout$getGravityDirection()) {
            this.roundabout$applyGravityDirectionChange(this.roundabout$prevGravityDirection, this.roundabout$getGravityDirection(), this.roundabout$currentRotationParameters, false);
            this.roundabout$prevGravityDirection = this.roundabout$getGravityDirection();
        }
        if (Math.abs(this.roundabout$currGravityStrength - this.roundabout$prevGravityStrength) > 1.0E-4) {
            this.roundabout$prevGravityStrength = this.roundabout$currGravityStrength;
        }
    }

    @Override
    @Unique
    public boolean roundabout$canChangeGravity() {
        return GEntityTags.canChangeGravity((class_1297)this);
    }

    @Unique
    public void roundabout$applyGravityDirectionChange(class_2350 oldGravity, class_2350 newGravity, RotationParameters rotationParameters, boolean isInitialization) {
        this.method_5857(this.method_33332());
        if (isInitialization) {
            return;
        }
        this.field_6017 = 0.0f;
        long timeMs = this.method_37908().method_8510() * 50L;
        class_243 relativeRotationCenter = GravityEntityMixin.roundabout$getLocalRotationCenter((class_1297)this, oldGravity, newGravity, rotationParameters);
        class_243 oldPos = this.method_19538();
        class_243 oldLastTickPos = new class_243(this.field_6038, this.field_5971, this.field_5989);
        class_243 rotationCenter = oldPos.method_1019(RotationUtil.vecPlayerToWorld(relativeRotationCenter, oldGravity));
        class_243 newPos = rotationCenter.method_1020(RotationUtil.vecPlayerToWorld(relativeRotationCenter, newGravity));
        class_243 posTranslation = newPos.method_1020(oldPos);
        class_243 newLastTickPos = oldLastTickPos.method_1019(posTranslation);
        this.method_33574(newPos);
        this.field_6014 = newLastTickPos.field_1352;
        this.field_6036 = newLastTickPos.field_1351;
        this.field_5969 = newLastTickPos.field_1350;
        this.field_6038 = newLastTickPos.field_1352;
        this.field_5971 = newLastTickPos.field_1351;
        this.field_5989 = newLastTickPos.field_1350;
        this.roundabout$adjustEntityPosition(oldGravity, newGravity, this.method_5829());
        if (this.method_37908().method_8608()) {
            RotationAnimation ani = ((IClientEntity)((Object)this)).roundabout$getGravityAnimation();
            Validate.notNull((Object)ani, (String)"gravity animation is null", (Object[])new Object[0]);
            int rotationTimeMS = rotationParameters.rotationTimeMS();
            ani.startRotationAnimation(newGravity, oldGravity, rotationTimeMS, (class_1297)this, timeMs, rotationParameters.rotateView(), relativeRotationCenter);
        }
        class_243 revGrav = new class_243(0.0, 0.002, 0.0);
        class_243 revGrav2 = new class_243(0.0, 0.002, 0.0);
        revGrav = RotationUtil.vecPlayerToWorld(revGrav, oldGravity);
        revGrav2 = RotationUtil.vecPlayerToWorld(revGrav2, oldGravity);
        this.method_18799(this.method_18798().method_1031(revGrav.field_1352, revGrav.field_1351, revGrav.field_1350));
        class_243 realWorldVelocity = GravityEntityMixin.roundabout$getRealWorldVelocity((class_1297)this, oldGravity);
        this.method_18799(new class_243(0.0, 0.0, 0.0));
        this.rdbt$noSuffocateTicks = 20;
        class_243 yes = this.method_30950(1.0f).method_1019(revGrav2);
        class_2338 bpos = new class_2338((int)yes.field_1352, (int)yes.field_1351, (int)yes.field_1350);
        if (!this.field_6002.method_8320(bpos).method_51367()) {
            this.method_33574(yes);
        }
    }

    @Unique
    private void roundabout$adjustEntityPosition(class_2350 oldGravity, class_2350 newGravity, class_238 entityBoundingBox) {
        class_1297 ent = (class_1297)this;
        if (ent instanceof class_1295 || ent instanceof class_1665 || ent instanceof class_1511) {
            return;
        }
        class_2350 movingDirection = oldGravity.method_10153();
        Iterable collisions = ent.method_37908().method_8600(ent, entityBoundingBox.method_1014(-0.01));
        class_238 totalCollisionBox = null;
        for (class_265 collision : collisions) {
            if (collision.method_1110()) continue;
            class_238 boundingBox = collision.method_1107();
            if (totalCollisionBox == null) {
                totalCollisionBox = boundingBox;
                continue;
            }
            totalCollisionBox = totalCollisionBox.method_991(boundingBox);
        }
        if (totalCollisionBox != null) {
            class_243 positionAdjustmentOffset = GravityEntityMixin.roundabout$getPositionAdjustmentOffset(entityBoundingBox, totalCollisionBox, movingDirection);
            ent.method_33574(ent.method_19538().method_1019(positionAdjustmentOffset));
        }
    }

    @Unique
    private static class_243 roundabout$getPositionAdjustmentOffset(class_238 entityBoundingBox, class_238 nearbyCollisionUnion, class_2350 movingDirection) {
        class_2350.class_2351 axis = movingDirection.method_10166();
        double offset = 0.0;
        if (movingDirection.method_10171() == class_2350.class_2352.field_11056) {
            double pushed;
            double pushing = nearbyCollisionUnion.method_990(axis);
            if (pushing > (pushed = entityBoundingBox.method_1001(axis))) {
                offset = pushing - pushed;
            }
        } else {
            double pushed;
            double pushing = nearbyCollisionUnion.method_1001(axis);
            if (pushing < (pushed = entityBoundingBox.method_990(axis))) {
                offset = pushed - pushing;
            }
        }
        return new class_243(movingDirection.method_23955()).method_1021(offset);
    }

    @Unique
    @NotNull
    private static class_243 roundabout$getLocalRotationCenter(class_1297 entity, class_2350 oldGravity, class_2350 newGravity, RotationParameters rotationParameters) {
        if (entity instanceof class_1511) {
            return new class_243(0.0, -0.5, 0.0);
        }
        class_4048 dimensions = entity.method_18377(entity.method_18376());
        if (newGravity.method_10153() == oldGravity) {
            return new class_243(0.0, (double)(dimensions.field_18068 / 2.0f), 0.0);
        }
        return class_243.field_1353;
    }

    @Unique
    private static class_243 roundabout$getRealWorldVelocity(class_1297 entity, class_2350 prevGravityDirection) {
        if (entity.method_5787()) {
            return new class_243(entity.method_23317() - entity.field_6014, entity.method_23318() - entity.field_6036, entity.method_23321() - entity.field_5969);
        }
        return RotationUtil.vecPlayerToWorld(entity.method_18798(), prevGravityDirection);
    }

    @Unique
    public class_1297 rdbt$this() {
        return (class_1297)this;
    }

    @Override
    @Unique
    public void roundabout$updateGravityStatus() {
        class_2350 oldGravityDirection = this.roundabout$getGravityDirection();
        double oldGravityStrength = this.roundabout$currGravityStrength;
        class_1297 vehicle = this.method_5854();
        if (vehicle != null) {
            this.roundabout$setGravityDirection(GravityAPI.getGravityDirection(vehicle));
            this.roundabout$currGravityStrength = GravityAPI.getGravityStrength(vehicle);
        } else {
            FollowingStandEntity SE;
            class_1297 class_12972 = this.rdbt$this();
            if (class_12972 instanceof FollowingStandEntity && (SE = (FollowingStandEntity)class_12972).getFollowing() != null) {
                this.roundabout$setGravityDirection(GravityAPI.getGravityDirection((class_1297)SE.getFollowing()));
                this.roundabout$currGravityStrength = GravityAPI.getGravityStrength((class_1297)SE.getFollowing());
            } else {
                CinderellaVisageDisplayEntity CD;
                class_12972 = this.rdbt$this();
                if (class_12972 instanceof CinderellaVisageDisplayEntity && (CD = (CinderellaVisageDisplayEntity)class_12972).getStandUser() != null) {
                    this.roundabout$setGravityDirection(GravityAPI.getGravityDirection((class_1297)CD.getStandUser()));
                    this.roundabout$currGravityStrength = GravityAPI.getGravityStrength((class_1297)CD.getStandUser());
                } else {
                    CrossfireHurricaneEntity CD2;
                    class_12972 = this.rdbt$this();
                    if (class_12972 instanceof CrossfireHurricaneEntity && (CD2 = (CrossfireHurricaneEntity)class_12972).getUser() != null && CD2.getCrossNumber() != 7) {
                        this.roundabout$setGravityDirection(GravityAPI.getGravityDirection((class_1297)CD2.getUser()));
                        this.roundabout$currGravityStrength = GravityAPI.getGravityStrength((class_1297)CD2.getUser());
                    } else {
                        class_1309 LE;
                        class_12972 = this.rdbt$this();
                        if (class_12972 instanceof class_1309 && (LE = (class_1309)class_12972).method_6113()) {
                            this.roundabout$setGravityDirection(class_2350.field_11033);
                        } else {
                            if (!this.field_6002.method_8608()) {
                                PowersWalkingHeart PW;
                                class_1309 LE2;
                                class_2350 dr = class_2350.field_11033;
                                Object object = this.rdbt$this();
                                if (object instanceof class_1309 && (object = ((StandUser)(LE2 = (class_1309)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)object).hasExtendedHeelsForWalking()) {
                                    dr = PW.getHeelDirection();
                                } else {
                                    class_1293 mi;
                                    class_1309 LE3;
                                    object = this.rdbt$this();
                                    if (object instanceof class_1309 && (LE3 = (class_1309)object).method_6059(ModEffects.GRAVITY_FLIP) && (mi = LE3.method_6112(ModEffects.GRAVITY_FLIP)) != null) {
                                        if (mi.method_5578() == 0) {
                                            dr = class_2350.field_11043;
                                        }
                                        if (mi.method_5578() == 1) {
                                            dr = class_2350.field_11035;
                                        }
                                        if (mi.method_5578() == 2) {
                                            dr = class_2350.field_11034;
                                        }
                                        if (mi.method_5578() == 3) {
                                            dr = class_2350.field_11039;
                                        }
                                        if (mi.method_5578() == 4) {
                                            dr = class_2350.field_11036;
                                        }
                                    }
                                }
                                this.roundabout$setGravityDirection(dr);
                            }
                            if (this.roundabout$isReadyToResetGravity()) {
                                this.roundabout$setGravityDirection(this.roundabout$baseGravityDirection);
                                this.roundabout$currGravityStrength = roundabout$baseGravityStrength;
                                if (this.roundabout$currentEffectPriority == Double.MIN_VALUE) {
                                    this.roundabout$currentRotationParameters = RotationParameters.getDefault();
                                }
                            }
                            this.roundabout$lastUpdateTickCount = this.field_6012;
                        }
                    }
                }
            }
        }
    }

    @Unique
    public boolean roundabout$isReadyToResetGravity() {
        return false;
    }

    @Inject(method={"makeBoundingBox()Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_calculateBoundingBox(CallbackInfoReturnable<class_238> cir) {
        class_1297 entity = (class_1297)this;
        if (entity instanceof class_1676) {
            return;
        }
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_238 box = ((class_238)cir.getReturnValue()).method_997(this.field_22467.method_22882());
        if (gravityDirection.method_10171() == class_2350.class_2352.field_11056) {
            box = box.method_989(0.0, -1.0E-6, 0.0);
        }
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection).method_997(this.field_22467));
    }

    @Inject(method={"calculateViewVector(FF)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_getRotationVector(CallbackInfoReturnable<class_243> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld((class_243)cir.getReturnValue(), gravityDirection));
    }

    @Inject(method={"getBlockPosBelowThatAffectsMyMovement()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getVelocityAffectingPos(CallbackInfoReturnable<class_2338> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        cir.setReturnValue((Object)class_2338.method_49638((class_2374)this.field_22467.method_1019(class_243.method_24954((class_2382)gravityDirection.method_10163()).method_1021(0.5000001))));
    }

    @Inject(method={"getEyePosition()Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getEyePos(CallbackInfoReturnable<class_243> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(0.0, (double)this.field_18066, 0.0, gravityDirection).method_1019(this.field_22467));
    }

    @Inject(method={"getEyePosition(F)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getCameraPosVec(float tickDelta, CallbackInfoReturnable<class_243> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 vec3d = RotationUtil.vecPlayerToWorld(0.0, (double)this.field_18066, 0.0, gravityDirection);
        double d = class_3532.method_16436((double)tickDelta, (double)this.field_6014, (double)this.method_23317()) + vec3d.field_1352;
        double e = class_3532.method_16436((double)tickDelta, (double)this.field_6036, (double)this.method_23318()) + vec3d.field_1351;
        double f = class_3532.method_16436((double)tickDelta, (double)this.field_5969, (double)this.method_23321()) + vec3d.field_1350;
        cir.setReturnValue((Object)new class_243(d, e, f));
    }

    @Inject(method={"getLightLevelDependentMagicValue()F"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getBrightnessAtFEyes(CallbackInfoReturnable<Float> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        cir.setReturnValue((Object)Float.valueOf(this.field_6002.method_33598(this.method_31477(), this.method_31479()) ? this.field_6002.method_22349(class_2338.method_49638((class_2374)this.method_33571())) : 0.0f));
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private class_243 modify_move_Vec3d_0_0(class_243 vec3d) {
        class_1657 PE;
        class_1297 class_12972;
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (rdbdt$taggedForFlip) {
            rdbdt$taggedForFlip = false;
            vec3d = RotationUtil.vecWorldToPlayer(vec3d, gravityDirection).method_1031(0.0, -0.012, 0.0);
        } else if (gravityDirection != class_2350.field_11033 && (class_12972 = this.rdbt$this()) instanceof class_1657 && !(PE = (class_1657)class_12972).method_6128() && !PE.method_31549().field_7479 && !PE.method_7325()) {
            vec3d = vec3d.method_1031(0.0, -0.012, 0.0);
        }
        if (gravityDirection == class_2350.field_11033) {
            return vec3d;
        }
        return RotationUtil.vecPlayerToWorld(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=0), ordinal=0, argsOnly=true)
    private class_243 modify_move_Vec3d_0_1(class_243 vec3d) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;pop()V", ordinal=0), ordinal=1)
    private class_243 modify_move_Vec3d_1(class_243 vec3d) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return vec3d;
        }
        return RotationUtil.vecWorldToPlayer(vec3d, gravityDirection);
    }

    @ModifyVariable(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at=@At(value="STORE"), ordinal=1, argsOnly=false)
    private class_2338 rdbt$move(class_2338 bpos) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return bpos;
        }
        return this.method_43260();
    }

    @Inject(method={"move(Lnet/minecraft/world/entity/MoverType;Lnet/minecraft/world/phys/Vec3;)V"}, at={@At(value="INVOKE", target="Ljava/lang/Math;sqrt(D)D", ordinal=0, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void rdbt$stepsProperly(class_1313 $$0, class_243 $$1, CallbackInfo ci, class_243 $$2, double $$3, boolean $$5, boolean $$6, class_2338 $$7, class_2680 $$8, class_2248 $$10, class_1297.class_5799 $$11, double $$12, double $$13, double $$14, class_2338 $$15, class_2680 $$16) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 collide = $$2;
        class_243 collide2 = $$2;
        class_2338 bpos = this.method_23312();
        class_2680 bstate = this.method_37908().method_8320(bpos);
        double leng = 0.0;
        leng = Math.sqrt(collide.field_1352 * collide.field_1352 + collide.field_1350 * collide.field_1350);
        this.field_5973 = this.field_6039 + (float)leng * 0.6f;
        this.field_5994 -= (float)Math.sqrt($$12 * $$12 + $$13 * $$13 + $$14 * $$14) * 0.6f;
        boolean $$17 = this.method_51702(bstate);
        if (!$$17) {
            if (gravityDirection == class_2350.field_11043 || gravityDirection == class_2350.field_11035) {
                collide2 = new class_243(collide.field_1352, collide.field_1351, 0.0);
            }
            if (gravityDirection == class_2350.field_11034 || gravityDirection == class_2350.field_11039) {
                collide2 = new class_243(0.0, collide.field_1351, collide.field_1350);
            }
        }
        this.field_5994 += (float)Math.sqrt(collide2.field_1352 * collide2.field_1352 + collide2.field_1351 * collide2.field_1351 + collide2.field_1350 * collide2.field_1350) * 0.6f;
    }

    @Inject(method={"saveWithoutId(Lnet/minecraft/nbt/CompoundTag;)Lnet/minecraft/nbt/CompoundTag;"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void roundabout$addAdditionalSaveData(class_2487 $$0, CallbackInfoReturnable<class_2487> cir) {
        class_2487 compoundtag = $$0.method_10562("roundabout");
        compoundtag.method_10567("GravityDirection", MainUtil.getByteFromDirection(this.roundabout$getGravityDirection()));
    }

    @Inject(method={"load(Lnet/minecraft/nbt/CompoundTag;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)})
    public void roundabout$readAdditionalSaveData(class_2487 $$0, CallbackInfo ci) {
        class_1309 LE;
        Object object;
        class_2350 gd = MainUtil.getDirectionFromByte($$0.method_10562("roundabout").method_10571("GravityDirection"));
        this.roundabout$setGravityDirection(gd);
        if (gd != class_2350.field_11033 && (object = this.rdbt$this()) instanceof class_1309 && (object = ((StandUser)(LE = (class_1309)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart) {
            PowersWalkingHeart PW = (PowersWalkingHeart)object;
            PW.setHeelDirection(gd);
            PW.toggleSpikes(true);
        }
    }

    @Inject(method={"positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$positionRider(class_1297 $$0, class_1297.class_4738 $$1, CallbackInfo ci) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        ci.cancel();
        if (this.method_5626($$0)) {
            double $$2 = this.method_5621() + $$0.method_5678();
            class_243 transform = RotationUtil.vecPlayerToWorld(0.0, $$2, 0.0, gravityDirection);
            $$1.accept($$0, this.method_23317() + transform.field_1352, this.method_23318() + transform.field_1351, this.method_23321() + transform.field_1350);
        }
    }

    @Inject(method={"getOnPosLegacy()Lnet/minecraft/core/BlockPos;"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_getLandingPos(CallbackInfoReturnable<class_2338> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_2338 blockPos = class_2338.method_49638((class_2374)RotationUtil.vecPlayerToWorld(0.0, (double)-0.2f, 0.0, gravityDirection).method_1019(this.field_22467));
        cir.setReturnValue((Object)blockPos);
    }

    @Inject(method={"collide"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$collide(class_243 $$0, CallbackInfoReturnable<class_243> cir) {
        boolean $$7;
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_238 $$1 = this.method_5829();
        $$0 = RotationUtil.vecWorldToPlayer($$0, gravityDirection);
        List $$2 = this.method_37908().method_20743(this.rdbt$this(), $$1.method_18804($$0));
        class_243 $$3 = $$0.method_1027() == 0.0 ? $$0 : GravityEntityMixin.method_20736(this.rdbt$this(), $$0, $$1, this.method_37908(), $$2);
        boolean $$4 = $$0.field_1352 != $$3.field_1352;
        boolean $$5 = $$0.field_1351 != $$3.field_1351;
        boolean $$6 = $$0.field_1350 != $$3.field_1350;
        boolean bl = $$7 = this.method_24828() || $$5 && $$0.field_1351 < 0.0;
        if (this.method_49476() > 0.0f && $$7 && ($$4 || $$6)) {
            class_243 rotate2;
            class_243 $$8 = GravityEntityMixin.method_20736(this.rdbt$this(), new class_243($$0.field_1352, (double)this.method_49476(), $$0.field_1350), $$1, this.method_37908(), $$2);
            class_243 rotate = new class_243($$0.field_1352, 0.0, $$0.field_1350);
            rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((class_1297)this));
            class_243 $$9 = GravityEntityMixin.method_20736(this.rdbt$this(), new class_243(0.0, (double)this.method_49476(), 0.0), $$1.method_1012(rotate.field_1352, rotate.field_1351, rotate.field_1350), this.method_37908(), $$2);
            if ($$9.field_1351 < (double)this.method_49476()) {
                rotate2 = $$9;
                rotate2 = RotationUtil.vecPlayerToWorld(rotate2, GravityAPI.getGravityDirection((class_1297)this));
                class_243 $$10 = GravityEntityMixin.method_20736(this.rdbt$this(), new class_243($$0.field_1352, 0.0, $$0.field_1350), $$1.method_997(rotate2), this.method_37908(), $$2).method_1019($$9);
                if ($$10.method_37268() > $$8.method_37268()) {
                    $$8 = $$10;
                }
            }
            if ($$8.method_37268() > $$3.method_37268()) {
                rotate2 = $$8;
                rotate2 = RotationUtil.vecPlayerToWorld(rotate2, GravityAPI.getGravityDirection((class_1297)this));
                class_243 retrn = $$8.method_1019(GravityEntityMixin.method_20736(this.rdbt$this(), new class_243(0.0, -$$8.field_1351 + $$0.field_1351, 0.0), $$1.method_997(rotate2), this.method_37908(), $$2));
                cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(retrn, gravityDirection));
                return;
            }
        }
        class_243 retrn = $$3;
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(retrn, gravityDirection));
    }

    @Inject(method={"collideBoundingBox(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/AABB;Lnet/minecraft/world/level/Level;Ljava/util/List;)Lnet/minecraft/world/phys/Vec3;"}, at={@At(value="HEAD")}, cancellable=true)
    private static void roundabout$collideBoundingBox(@Nullable class_1297 entity, class_243 movement, class_238 entityBoundingBox, class_1937 $$3, List<class_265> collisions, CallbackInfoReturnable<class_243> cir) {
        boolean $$7;
        if (entity == null) {
            return;
        }
        class_2350 gravityDirection = GravityAPI.getGravityDirection(entity);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        movement = RotationUtil.vecPlayerToWorld(movement, gravityDirection);
        ImmutableList.Builder $$5 = ImmutableList.builderWithExpectedSize((int)(collisions.size() + 1));
        if (!collisions.isEmpty()) {
            $$5.addAll(collisions);
        }
        class_2784 $$6 = $$3.method_8621();
        boolean bl = $$7 = entity != null && $$6.method_39459(entity, entityBoundingBox.method_18804(movement));
        if ($$7) {
            $$5.add((Object)$$6.method_17903());
        }
        $$5.addAll($$3.method_20812(entity, entityBoundingBox.method_18804(movement)));
        cir.setReturnValue((Object)RotationUtil.vecWorldToPlayer(GravityEntityMixin.rdbt$collideWithShapesGrav(movement, entityBoundingBox, (List<class_265>)$$5.build(), entity), gravityDirection));
    }

    @Unique
    private static class_243 rdbt$collideWithShapesGrav(class_243 movement, class_238 entityBoundingBox, List<class_265> collisions, class_1297 entity) {
        boolean isZLargerThanX;
        class_2350 gravityDirection;
        if (entity == null || (gravityDirection = GravityAPI.getGravityDirection(entity)) == class_2350.field_11033) {
            return GravityEntityMixin.method_20737(movement, entityBoundingBox, collisions);
        }
        class_243 playerMovement = RotationUtil.vecWorldToPlayer(movement, gravityDirection);
        double playerMovementX = playerMovement.field_1352;
        double playerMovementY = playerMovement.field_1351;
        double playerMovementZ = playerMovement.field_1350;
        class_2350 directionX = RotationUtil.dirPlayerToWorld(class_2350.field_11034, gravityDirection);
        class_2350 directionY = RotationUtil.dirPlayerToWorld(class_2350.field_11036, gravityDirection);
        class_2350 directionZ = RotationUtil.dirPlayerToWorld(class_2350.field_11035, gravityDirection);
        if (playerMovementY != 0.0 && (playerMovementY = class_259.method_1085((class_2350.class_2351)directionY.method_10166(), (class_238)entityBoundingBox, collisions, (double)(playerMovementY * (double)directionY.method_10171().method_10181())) * (double)directionY.method_10171().method_10181()) != 0.0) {
            entityBoundingBox = entityBoundingBox.method_997(RotationUtil.vecPlayerToWorld(0.0, playerMovementY, 0.0, gravityDirection));
        }
        boolean bl = isZLargerThanX = Math.abs(playerMovementX) < Math.abs(playerMovementZ);
        if (isZLargerThanX && playerMovementZ != 0.0 && (playerMovementZ = class_259.method_1085((class_2350.class_2351)directionZ.method_10166(), (class_238)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.method_10171().method_10181())) * (double)directionZ.method_10171().method_10181()) != 0.0) {
            entityBoundingBox = entityBoundingBox.method_997(RotationUtil.vecPlayerToWorld(0.0, 0.0, playerMovementZ, gravityDirection));
        }
        if (playerMovementX != 0.0) {
            playerMovementX = class_259.method_1085((class_2350.class_2351)directionX.method_10166(), (class_238)entityBoundingBox, collisions, (double)(playerMovementX * (double)directionX.method_10171().method_10181())) * (double)directionX.method_10171().method_10181();
            if (!isZLargerThanX && playerMovementX != 0.0) {
                entityBoundingBox = entityBoundingBox.method_997(RotationUtil.vecPlayerToWorld(playerMovementX, 0.0, 0.0, gravityDirection));
            }
        }
        if (!isZLargerThanX && playerMovementZ != 0.0) {
            playerMovementZ = class_259.method_1085((class_2350.class_2351)directionZ.method_10166(), (class_238)entityBoundingBox, collisions, (double)(playerMovementZ * (double)directionZ.method_10171().method_10181())) * (double)directionZ.method_10171().method_10181();
        }
        return RotationUtil.vecPlayerToWorld(playerMovementX, playerMovementY, playerMovementZ, gravityDirection);
    }

    @Inject(method={"isInWall"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isInWall(CallbackInfoReturnable<Boolean> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        if (this.field_5960) {
            cir.setReturnValue((Object)false);
        } else {
            float $$0 = this.field_18065.field_18067 * 0.8f;
            class_243 rotate = new class_243((double)$$0, 1.0E-6, (double)$$0);
            rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((class_1297)this));
            class_238 $$1 = class_238.method_30048((class_243)this.method_33571(), (double)rotate.field_1352, (double)rotate.field_1351, (double)rotate.field_1350);
            cir.setReturnValue((Object)class_2338.method_29715((class_238)$$1).anyMatch($$1x -> {
                class_2680 $$2 = this.method_37908().method_8320($$1x);
                return !$$2.method_26215() && $$2.method_26228((class_1922)this.method_37908(), $$1x) && class_259.method_1074((class_265)$$2.method_26220((class_1922)this.method_37908(), $$1x).method_1096((double)$$1x.method_10263(), (double)$$1x.method_10264(), (double)$$1x.method_10260()), (class_265)class_259.method_1078((class_238)$$1), (class_247)class_247.field_16896);
            }));
        }
    }

    @Inject(method={"getForward"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$getForward(CallbackInfoReturnable<class_243> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        cir.setReturnValue((Object)RotationUtil.vecPlayerToWorld(class_243.method_1034((class_241)this.method_5802()), gravityDirection));
    }

    @Inject(method={"getDirection"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$getDirection(CallbackInfoReturnable<class_2350> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        cir.setReturnValue((Object)class_2350.method_10150((double)RotationUtil.rotPlayerToWorld((float)this.method_36454(), (float)this.method_36455(), (class_2350)gravityDirection).field_1343));
    }

    @Inject(method={"getBoundingBoxForPose(Lnet/minecraft/world/entity/Pose;)Lnet/minecraft/world/phys/AABB;"}, at={@At(value="RETURN")}, cancellable=true)
    private void inject_calculateBoundsForPose(class_4050 pos, CallbackInfoReturnable<class_238> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_238 box = ((class_238)cir.getReturnValue()).method_997(this.field_22467.method_22882());
        box = box.method_1014(-0.01);
        cir.setReturnValue((Object)RotationUtil.boxPlayerToWorld(box, gravityDirection).method_997(this.field_22467));
    }

    @Inject(method={"spawnSprintParticle()V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_spawnSprintingParticles(CallbackInfo ci) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        ci.cancel();
        class_243 floorPos = this.method_19538().method_1020(RotationUtil.vecPlayerToWorld(0.0, (double)0.2f, 0.0, gravityDirection));
        class_2338 blockPos = class_2338.method_49638((class_2374)floorPos);
        class_2680 blockState = this.field_6002.method_8320(blockPos);
        if (blockState.method_26217() != class_2464.field_11455) {
            class_243 particlePos = this.method_19538().method_1019(RotationUtil.vecPlayerToWorld((this.field_5974.method_43058() - 0.5) * (double)this.field_18065.field_18067, 0.1, (this.field_5974.method_43058() - 0.5) * (double)this.field_18065.field_18067, gravityDirection));
            class_243 playerVelocity = this.method_18798();
            class_243 particleVelocity = RotationUtil.vecPlayerToWorld(playerVelocity.field_1352 * -4.0, 1.5, playerVelocity.field_1350 * -4.0, gravityDirection);
            this.field_6002.method_8406((class_2394)new class_2388(class_2398.field_11217, blockState), particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, particleVelocity.field_1352, particleVelocity.field_1351, particleVelocity.field_1350);
        }
    }

    @Inject(method={"updateFluidHeightAndDoFluidPushing"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$updateFluidHeightAndDoFluidPushing(class_6862<class_3611> $$0, double $$1, CallbackInfoReturnable<Boolean> cir) {
        class_2350 gravityDirection;
        PowersWalkingHeart PW;
        class_1309 LE;
        boolean counterPushing = false;
        Object object = this.rdbt$this();
        if (object instanceof class_1309 && (object = ((StandUser)(LE = (class_1309)object)).roundabout$getStandPowers()) instanceof PowersWalkingHeart && (PW = (PowersWalkingHeart)object).hasExtendedHeelsForWalking()) {
            counterPushing = true;
        }
        if ((gravityDirection = GravityAPI.getGravityDirection((class_1297)this)) == class_2350.field_11033 && !counterPushing) {
            return;
        }
        if (this.method_33724()) {
            cir.setReturnValue((Object)false);
        } else {
            class_238 $$2 = this.method_5829().method_1011(0.001);
            int $$3 = class_3532.method_15357((double)$$2.field_1323);
            int $$4 = class_3532.method_15384((double)$$2.field_1320);
            int $$5 = class_3532.method_15357((double)$$2.field_1322);
            int $$6 = class_3532.method_15384((double)$$2.field_1325);
            int $$7 = class_3532.method_15357((double)$$2.field_1321);
            int $$8 = class_3532.method_15384((double)$$2.field_1324);
            double $$9 = 0.0;
            boolean $$10 = this.method_5675();
            if (counterPushing) {
                $$10 = false;
            }
            boolean $$11 = false;
            class_243 $$12 = class_243.field_1353;
            int $$13 = 0;
            class_2338.class_2339 $$14 = new class_2338.class_2339();
            for (int $$15 = $$3; $$15 < $$4; ++$$15) {
                for (int $$16 = $$5; $$16 < $$6; ++$$16) {
                    for (int $$17 = $$7; $$17 < $$8; ++$$17) {
                        double $$19;
                        $$14.method_10103($$15, $$16, $$17);
                        class_3610 $$18 = this.method_37908().method_8316((class_2338)$$14);
                        if (!$$18.method_15767($$0) || !(($$19 = (double)((float)$$16 + $$18.method_15763((class_1922)this.method_37908(), (class_2338)$$14))) >= $$2.field_1322)) continue;
                        $$11 = true;
                        $$9 = Math.max($$19 - $$2.field_1322, $$9);
                        if (!$$10) continue;
                        class_243 $$20 = $$18.method_15758((class_1922)this.method_37908(), (class_2338)$$14);
                        if ($$9 < 0.4) {
                            $$20 = $$20.method_1021($$9);
                        }
                        $$12 = $$12.method_1019($$20);
                        ++$$13;
                    }
                }
            }
            if ($$12.method_1033() > 0.0) {
                if ($$13 > 0) {
                    $$12 = $$12.method_1021(1.0 / (double)$$13);
                }
                if (!((class_1297)this instanceof class_1657)) {
                    $$12 = $$12.method_1029();
                }
                class_243 $$21 = this.method_18798();
                $$12 = $$12.method_1021($$1 * 1.0);
                double $$22 = 0.003;
                if (Math.abs($$21.field_1352) < 0.003 && Math.abs($$21.field_1350) < 0.003 && $$12.method_1033() < 0.0045000000000000005) {
                    $$12 = $$12.method_1029().method_1021(0.0045000000000000005);
                }
                this.method_18799(this.method_18798().method_1019(RotationUtil.vecWorldToPlayer($$12, gravityDirection)));
            }
            this.field_5964.put($$0, $$9);
            cir.setReturnValue((Object)$$11);
        }
    }

    @Inject(method={"push(Lnet/minecraft/world/entity/Entity;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void inject_pushAwayFrom(class_1297 entity, CallbackInfo ci) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        class_2350 otherGravityDirection = GravityAPI.getGravityDirection(entity);
        if (gravityDirection == class_2350.field_11033 && otherGravityDirection == class_2350.field_11033) {
            return;
        }
        ci.cancel();
        if (!(this.method_5794(entity) || entity.field_5960 || this.field_5960)) {
            double g;
            class_243 entityOffset = entity.method_5829().method_1005().method_1020(this.method_5829().method_1005());
            class_243 playerEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, gravityDirection);
            double dx = playerEntityOffset.field_1352;
            double dz = playerEntityOffset.field_1350;
            double f = class_3532.method_15391((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!this.method_5782()) {
                    this.method_5762(-dx, 0.0, -dz);
                }
            }
            class_243 entityEntityOffset = RotationUtil.vecWorldToPlayer(entityOffset, otherGravityDirection);
            dx = entityEntityOffset.field_1352;
            dz = entityEntityOffset.field_1350;
            f = class_3532.method_15391((double)dx, (double)dz);
            if (f >= (double)0.01f) {
                f = Math.sqrt(f);
                dx /= f;
                dz /= f;
                g = 1.0 / f;
                if (g > 1.0) {
                    g = 1.0;
                }
                dx *= g;
                dz *= g;
                dx *= (double)0.05f;
                dz *= (double)0.05f;
                if (!entity.method_5782()) {
                    entity.method_5762(dx, 0.0, dz);
                }
            }
        }
    }

    @Inject(method={"isFree(DDD)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isFree(double $$0, double $$1, double $$2, CallbackInfoReturnable<Boolean> cir) {
        class_2350 gravityDirection = GravityAPI.getGravityDirection((class_1297)this);
        if (gravityDirection == class_2350.field_11033) {
            return;
        }
        class_243 rotate = new class_243($$0, $$1, $$2);
        rotate = RotationUtil.vecPlayerToWorld(rotate, GravityAPI.getGravityDirection((class_1297)this));
        cir.setReturnValue((Object)this.method_5629(this.method_5829().method_989(rotate.field_1352, rotate.field_1351, rotate.field_1350)));
    }

    @ModifyVariable(method={"updateFluidOnEyes()V"}, at=@At(value="STORE"), ordinal=0)
    private double submergedInWaterEyeFix(double d) {
        d = this.method_33571().method_10214();
        return d;
    }

    @ModifyVariable(method={"updateFluidOnEyes()V"}, at=@At(value="STORE"), ordinal=0)
    private class_2338 submergedInWaterPosFix(class_2338 blockpos) {
        blockpos = class_2338.method_49638((class_2374)this.method_33571());
        return blockpos;
    }

    @Shadow
    public abstract double method_23317();

    @Shadow
    public abstract class_243 method_33571();

    @Shadow
    public abstract double method_23318();

    @Shadow
    public abstract double method_23321();

    @Shadow
    public abstract int method_31477();

    @Shadow
    public abstract int method_31479();

    @Shadow
    public abstract class_243 method_18798();

    @Shadow
    public abstract boolean method_5782();

    @Shadow
    public abstract class_238 method_5829();

    @Shadow
    public static class_243 method_20737(class_243 movement, class_238 entityBoundingBox, List<class_265> collisions) {
        return null;
    }

    @Shadow
    public abstract class_243 method_19538();

    @Shadow
    public abstract boolean method_5794(class_1297 var1);

    @Shadow
    public abstract void method_5762(double var1, double var3, double var5);

    @Shadow
    protected abstract void method_5825();

    @Shadow
    public abstract double method_23320();

    @Shadow
    public abstract float method_5705(float var1);

    @Shadow
    public abstract float method_36454();

    @Shadow
    public abstract float method_36455();

    @Shadow
    public abstract class_2945 method_5841();

    @Shadow
    public abstract float method_49476();

    @Shadow
    public static class_243 method_20736(@Nullable class_1297 entity, class_243 vec3, class_238 aABB, class_1937 level, List<class_265> list) {
        return null;
    }

    @Shadow
    public abstract class_1937 method_37908();

    @Shadow
    public abstract boolean method_33724();

    @Shadow
    public abstract boolean method_5675();

    @Shadow
    public abstract void method_18799(class_243 var1);

    @Shadow
    protected abstract boolean method_5629(class_238 var1);

    static {
        roundabout$baseGravityStrength = 1.0;
    }
}

