/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.RattDartEntity;
import net.hydra.jojomod.entity.stand.RattEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2874;
import net.minecraft.class_2960;
import net.minecraft.class_315;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import org.joml.Vector3f;

public class PowersRatt
extends NewDashPreset {
    public static final int MinThreshold = 30;
    public static final int MaxThreshold = 90;
    public static final int BaseShootCooldown = 10;
    public static final int PlaceDelay = 10;
    public static final int PlaceShootCooldown = 55;
    public static final int MaxShootCooldown = 20;
    public static final int[] ShotThresholds = new int[]{30, 50, 90};
    public static final float[] ShotPowerFloats = new float[]{3.55f, 3.5f, 4.0f};
    public static final int[] ShotSuperthrowTicks = new int[]{4, 10, 15};
    public static final float DespawnRange = 35.0f;
    public static final byte UPDATE_POSITION = 52;
    public static final byte AUTO = 54;
    public static final byte FIRE_DART = 57;
    public static final byte TOGGLE_BURSTING = 58;
    public static final byte START_PLAYER_BURST = 59;
    public static final byte PLAYER_BURST = 60;
    public static final byte START_PLACE_BURST = 61;
    public static final byte NET_PLACE = 63;
    public static final byte NET_RECALL = 64;
    public static final byte NET_SCOPE = 65;
    public static final byte UPDATE_CHARGE = 66;
    public static final byte START_CHARGE = 67;
    public static final byte CHECK_AUTO = 68;
    public static final byte PLACE_BURST = 69;
    public static final byte CHANGE_MODE = 7;
    public static final byte SETPLACE = 8;
    public static final byte SCOPE = 9;
    public static final byte RATT_LEAP = 5;
    int shotcooldown = 0;
    int maxshotcooldown = 0;
    public boolean active = false;
    public boolean immuneWhileReturning = false;
    int chargeTime = 0;
    class_243 Placement = null;

    public PowersRatt(class_1309 self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersRatt(entity);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.RATT.method_5883(this.getSelf().method_37908());
    }

    public void setShotCooldown(int i) {
        this.shotcooldown = i;
        this.maxshotcooldown = i;
    }

    public class_1309 getShootTarget() {
        StandEntity standEntity = this.getStandEntity(this.getSelf());
        if (standEntity instanceof RattEntity) {
            RattEntity RE = (RattEntity)standEntity;
            return RE.method_5968();
        }
        return null;
    }

    public void setShootTarget(class_1309 l) {
        StandEntity standEntity = this.getStandEntity(this.getSelf());
        if (standEntity instanceof RattEntity) {
            RattEntity RE = (RattEntity)standEntity;
            RE.method_5980(l);
        }
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public void updateChargeTime(int i) {
        this.tryIntPower(66, true, i);
        this.tryIntPowerPacket((byte)66, i);
    }

    public boolean isPlaced() {
        return this.getStandEntity(this.getSelf()) != null;
    }

    public boolean isAuto() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    public class_3965 getTargetPos() {
        class_243 vec3d = this.getSelf().method_5836(0.0f);
        class_243 vec3d2 = this.getSelf().method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * 60.0, vec3d2.field_1351 * 60.0, vec3d2.field_1350 * 60.0);
        return this.getSelf().method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.getSelf()));
    }

    public class_1297 CoolerrayCastEntity(class_1937 world, class_1309 ratt, double maxDistance) {
        class_243 vars = this.getRotations((class_1297)this.getShootTarget());
        class_243 eyePos = ratt.method_5836(1.0f);
        class_243 lookVec = new class_243(Math.cos(vars.field_1351 + 1.5707963267948966), Math.sin(vars.field_1352), Math.sin(vars.field_1351 + 1.5707963267948966));
        class_243 reachVec = eyePos.method_1019(lookVec.method_1021(maxDistance));
        class_3959 blockContext = new class_3959(eyePos, reachVec, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)ratt);
        class_3965 blockHit = world.method_17742(blockContext);
        double blockHitDistance = blockHit.method_17784().method_1022(eyePos);
        class_238 box = ratt.method_5829().method_18804(lookVec.method_1021(maxDistance)).method_1014(1.0);
        List candidates = world.method_8333((class_1297)ratt, box, e -> e instanceof class_1297 && e.method_5863() && e.method_5805());
        class_1297 closest = null;
        double closestDistance = blockHitDistance;
        for (class_1297 entity : candidates) {
            double hitDistance;
            class_238 aabb = entity.method_5829().method_1014(0.3);
            Optional hitOptional = aabb.method_992(eyePos, reachVec);
            if (!hitOptional.isPresent() || !((hitDistance = eyePos.method_1022((class_243)hitOptional.get())) < closestDistance) || entity.method_7325() || !MainUtil.isStandPickable(entity) || entity.method_5655() || entity.method_5626((class_1297)ratt)) continue;
            closestDistance = hitDistance;
            closest = entity;
        }
        return closest;
    }

    private class_243 getValidPlacement() {
        class_243 vec3d = this.getSelf().method_5836(0.0f);
        class_243 vec3d2 = this.getSelf().method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * 8.0, vec3d2.field_1351 * 8.0, vec3d2.field_1350 * 8.0);
        class_3965 blockHit = this.getSelf().method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.getSelf()));
        class_243 location = blockHit.method_17784();
        if (blockHit.method_17777() instanceof class_2338.class_2339) {
            if (blockHit.method_17780() == class_2350.field_11036) {
                return blockHit.method_17784();
            }
            if (blockHit.method_17780() == class_2350.field_11033) {
                if (this.getSelf().method_37908().method_8320(blockHit.method_17777().method_10086(1)).method_26215()) {
                    return new class_243(location.method_10216(), (double)((int)location.method_10214() + 1), location.method_10215());
                }
            } else {
                for (int oy = 0; oy < 3; ++oy) {
                    if (!this.getSelf().method_37908().method_8320(blockHit.method_17777().method_10086(oy)).method_26215()) continue;
                    return new class_243(location.method_10216(), (double)((int)location.method_10214() + oy), location.method_10215());
                }
            }
        }
        return null;
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        ClientUtil.fx.roundabout$onGUI(context);
        if (this.isPlaced()) {
            if (!this.isHoldingSneak()) {
                this.setSkillIcon(context, x, y, 1, this.LockedOrNot(StandIcons.RATT_BURST, 0), (byte)69);
            } else if (this.isAuto()) {
                this.setSkillIcon(context, x, y, 1, this.LockedOrNot(StandIcons.RATT_AUTO, 3), (byte)7);
            } else {
                this.setSkillIcon(context, x, y, 1, this.LockedOrNot(StandIcons.RATT_UNAUTO, 3), (byte)7);
            }
            if (this.scopeLevel == 0) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_RECALL, (byte)8);
            }
        } else {
            class_2960 ScopeIcon = StandIcons.RATT_SCOPE_IN;
            if (this.scopeLevel == 1) {
                ScopeIcon = StandIcons.RATT_SCOPE_OUT;
            }
            this.setSkillIcon(context, x, y, 1, this.LockedOrNot(ScopeIcon, 2), (byte)9);
            if (this.scopeLevel == 0) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_PLACE, (byte)8);
            } else if (this.isAuto()) {
                this.setSkillIcon(context, x, y, 2, this.LockedOrNot(StandIcons.RATT_BURST, 3), (byte)7);
            } else {
                this.setSkillIcon(context, x, y, 2, this.LockedOrNot(StandIcons.RATT_SINGLE, 3), (byte)7);
            }
        }
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        this.setSkillIcon(context, x, y, 4, this.LockedOrNot(StandIcons.RATT_LEAP, 4), (byte)5);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, class_243 pos) {
        StandEntity SE = this.getStandEntity(this.getSelf());
        switch (move) {
            case 52: {
                if (SE == null) break;
                SE.method_33574(pos);
                break;
            }
            case 63: {
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                this.active = true;
                this.immuneWhileReturning = false;
                this.Placement = pos;
                this.setCooldown((byte)8, 80);
            }
        }
        return true;
    }

    public void placeRatt(class_243 pos) {
        int cooldown = 60;
        this.setCooldown((byte)8, cooldown);
        if (!this.isClient()) {
            this.blipStand(pos);
        }
    }

    public void blipStand(class_243 pos) {
        StandEntity stand = this.getNewStandEntity();
        if (stand instanceof RattEntity) {
            StandUser user = this.getStandUserSelf();
            stand.setSkin(user.roundabout$getStandSkin());
            stand.setMaster(this.self);
            stand.method_30634(pos.method_10216(), pos.method_10214(), pos.method_10215());
            this.getStandUserSelf().roundabout$standMount(stand);
            this.self.method_37908().method_8649((class_1297)stand);
        }
    }

    public class_243 getRotations(class_1297 target) {
        RattEntity RE = (RattEntity)this.getStandEntity(this.getSelf());
        if (RE != null) {
            class_243 targetPos = this.getTargetPos().method_17784();
            if (target != null) {
                targetPos = target.method_5836(1.0f);
                if (this.isAuto()) {
                    double dist = targetPos.method_1022(RE.method_30950(1.0f));
                    double time = dist / (double)ShotPowerFloats[1];
                    class_243 vec = target.method_18798();
                    targetPos = targetPos.method_1019(vec.method_18805(time *= 1.4, time, time));
                }
            }
            double x = targetPos.method_10216() - RE.method_30950(0.0f).method_10216();
            double z = targetPos.method_10215() - RE.method_30950(0.0f).method_10215();
            float rot = (float)(Math.atan2(z, x) - 1.5707963267948966);
            double hy = targetPos.method_10214() - RE.getEyeP(0.0f).method_10214();
            double hd = Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
            float hrot = (float)(Math.atan2(hd, hy) + 1.5707963267948966);
            double percent = (double)RE.getFadeOut() / (double)RE.getMaxFade();
            if (percent != 1.0) {
                hrot = (float)class_3532.method_16436((double)percent, (double)0.0, (double)hrot);
            }
            return new class_243((double)hrot, (double)rot, 0.0);
        }
        return new class_243(0.0, 0.0, 0.0);
    }

    @Override
    public void tickPower() {
        super.tickPower();
        if (this.isPlaced()) {
            class_2874 T;
            class_2874 t = this.getStandEntity(this.getSelf()).method_37908().method_8597();
            if (t != (T = this.getSelf().method_37908().method_8597())) {
                this.RecallClient(true);
            }
            if (this.getSelf().method_5739((class_1297)this.getStandEntity(this.getSelf())) > 35.0f) {
                this.RecallClient(true);
            }
        }
        if (this.getActivePower() == 67) {
            this.updateChargeTime(class_3532.method_15340((int)(this.getChargeTime() + 4), (int)0, (int)100));
            if (this.getChargeTime() == 100 || this.scopeLevel == 0) {
                this.setPowerNone();
            }
        }
        if (this.getStandEntity(this.getSelf()) != null && this.getStandEntity((class_1309)this.getSelf()).forceDespawnSet) {
            this.setPowerNone();
        }
        if (this.shotcooldown != 0) {
            --this.shotcooldown;
        }
        if (this.shotcooldown == 0) {
            this.maxshotcooldown = 0;
        }
        StandEntity SE = this.getStandEntity(this.getSelf());
        if (this.isPlaced() && !(this.getSelf() instanceof class_1308)) {
            if (!this.isClient()) {
                class_1297 e;
                if (!SE.method_24828()) {
                    ((class_3218)this.getSelf().method_37908()).method_14199((class_2394)new class_2390(new Vector3f(0.86f, 0.28f, 0.48f), 1.0f), SE.method_23317(), ((RattEntity)SE).getEyeP(0.0f).method_10214(), SE.method_23321(), 0, 0.0, 0.0, 0.0, 0.0);
                }
                if ((e = MainUtil.getTargetEntity(this.getSelf(), 40.0f)) instanceof class_1309) {
                    class_1309 L = (class_1309)e;
                    if (!(this.isAuto() || L.equals((Object)this.getSelf()) || L.equals((Object)SE) || MainUtil.getEntityIsTrulyInvisible(e) || L.method_6112(class_1294.field_5905) != null || L instanceof StandEntity)) {
                        this.setShootTarget(L);
                    }
                    if (e.method_5739((class_1297)this.getStandEntity(this.getSelf())) >= 40.0f) {
                        this.setShootTarget(null);
                    }
                    if (this.getShootTarget() != null && (MainUtil.getEntityIsTrulyInvisible((class_1297)this.getShootTarget()) || this.getShootTarget().method_6112(class_1294.field_5905) != null)) {
                        this.setShootTarget(null);
                    }
                } else if (e == null && !this.isAuto()) {
                    this.setShootTarget(null);
                }
            }
            if (this.isAuto()) {
                if (this.isClient()) {
                    this.BurstFire();
                }
                if (this.getShootTarget() != null) {
                    if (this.getShootTarget().method_6032() == 0.0f) {
                        this.setShootTarget(null);
                    }
                } else if (this.isAuto()) {
                    this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                }
            }
        } else if (this.active && this.getStandUserSelf().roundabout$getActive() && !this.isClient() && this.Placement != null) {
            this.placeRatt(this.Placement);
        }
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 60) {
            if (this.isClient()) {
                if (this.attackTimeDuring % 2 == 1) {
                    this.tryPower(60, true);
                    this.tryPowerPacket((byte)60);
                }
                if (this.getChargeTime() < 30) {
                    this.updateChargeTime(0);
                    this.setShotCooldown(20);
                    this.tryPowerPacket((byte)0);
                    this.setPowerNone();
                }
            }
        } else if (this.getActivePower() == 69) {
            this.setShotCooldown(55);
            if (this.getAttackTimeDuring() == 10) {
                this.setAttackTimeDuring(15);
                this.setPowerNone();
                if (!this.isClient()) {
                    this.placeBurst();
                }
            }
        }
        super.updateUniqueMoves();
    }

    public void placeBurst() {
        this.animateStand((byte)81);
        this.setPowerNone();
        this.getSelf().method_37908().method_8396(null, this.getSelf().method_24515(), ModSounds.RATT_FIRING_EVENT, class_3419.field_15248, 1.7f, 0.9f + (float)Math.random() * 0.2f);
        for (int i = 0; i < 3; ++i) {
            StandEntity standEntity = this.getStandEntity(this.getSelf());
            if (!(standEntity instanceof RattEntity)) continue;
            RattEntity RE = (RattEntity)standEntity;
            RattDartEntity e = new RattDartEntity(RE.method_37908(), this.getSelf(), 1, 0.1f);
            class_243 v = this.getRotations((class_1297)this.getShootTarget());
            e.method_24919((class_1297)RE, (float)v.field_1352 * 180.0f / (float)Math.PI + 180.0f, (float)v.field_1351 * 180.0f / (float)Math.PI, -0.5f, ShotPowerFloats[1], 0.84f);
            e.EnableSuperThrow();
            RE.method_37908().method_8649((class_1297)e);
        }
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                if (!this.isPlaced()) {
                    if (!this.canExecuteMoveWithLevel(2)) break;
                    this.RattScope();
                    break;
                }
                this.BurstFire();
                break;
            }
            case SKILL_1_CROUCH: {
                if (this.isPlaced()) {
                    if (this.isAttackIneptVisually((byte)54, 1) || !this.canExecuteMoveWithLevel(3)) break;
                    this.ToggleAuto();
                    break;
                }
                if (!this.canExecuteMoveWithLevel(2)) break;
                this.RattScope();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                if (this.scopeLevel != 0) {
                    if (!this.canExecuteMoveWithLevel(3)) break;
                    this.ToggleBursting();
                    break;
                }
                if (!this.isPlaced()) {
                    if (this.getValidPlacement() == null) break;
                    this.DeployClient();
                    break;
                }
                this.RecallClient(false);
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.RattLeap();
            }
        }
    }

    public void RattLeap() {
        if (!this.onCooldown((byte)5)) {
            this.tryPower(5);
            this.tryPowerPacket((byte)5);
        }
    }

    public void RattScope() {
        if (!this.onCooldown((byte)9)) {
            int nl = this.scopeLevel + 1;
            this.tryIntPower(65, true, nl == 2 ? 0 : nl);
            this.tryIntPowerPacket((byte)65, nl == 2 ? 0 : nl);
            this.getSelf().method_5783(nl != 2 ? ModSounds.RATT_SCOPE_EVENT : ModSounds.RATT_DESCOPE_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        switch (move) {
            case 65: {
                this.setCooldown((byte)9, 10);
                this.setAttackTime(-1);
                this.setScopeLevel(chargeTime);
                this.getStandUserSelf().roundabout$setCombatMode(this.scopeLevel != 0);
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(true);
                break;
            }
            case 66: {
                this.chargeTime = chargeTime;
                break;
            }
            case 57: {
                this.setShotCooldown(chargeTime >= 90 ? 20 : 10);
                this.setCooldown((byte)8, 30);
                if (!this.isClient()) {
                    this.FireDart(chargeTime, 0.2f);
                    break;
                }
                this.updateChargeTime(0);
            }
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public void ToggleBursting() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.isAuto());
        this.tryPower(58, true);
        this.tryPowerPacket((byte)58);
    }

    public void PlayerFire() {
        int i = this.getChargeTime();
        this.tryIntPower(57, true, i);
        this.tryIntPowerPacket((byte)57, i);
    }

    public void BurstFire() {
        if (!this.isAttackIneptVisually((byte)69, 2)) {
            this.tryPower(61, true);
            this.tryPowerPacket((byte)61);
        }
    }

    public void FireDart(int i, float acuracy) {
        float power = 0.0f;
        for (int b = ShotThresholds.length - 1; b >= 0; --b) {
            if ((i == -1 ? 51 : i) < ShotThresholds[b]) continue;
            power = ShotPowerFloats[b];
            break;
        }
        RattDartEntity e = new RattDartEntity(this.getSelf().method_37908(), this.getSelf(), i);
        e.method_24919((class_1297)this.getSelf(), this.getSelf().method_36455(), this.getSelf().method_36454(), -0.5f, power, acuracy);
        e.EnableSuperThrow();
        this.getSelf().method_37908().method_8649((class_1297)e);
    }

    public void ToggleAuto() {
        this.tryPower(58, true);
        this.tryPowerPacket((byte)58);
    }

    public void DeployClient() {
        if (!this.onCooldown((byte)8)) {
            this.updateChargeTime(0);
            this.getSelf().method_5783(ModSounds.RATT_PLACE_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
            class_243 blockHitResult = this.getValidPlacement();
            if (blockHitResult != null) {
                this.tryPosPower(63, true, blockHitResult);
                this.tryPosPowerPacket((byte)63, blockHitResult);
            }
        }
    }

    public void RecallClient(boolean forced) {
        if (!this.onCooldown((byte)8) || forced) {
            this.tryPower(64, true);
            this.tryPowerPacket((byte)64);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        switch (move) {
            case 68: {
                this.setShootTarget(null);
                break;
            }
            case 64: {
                this.active = false;
                this.immuneWhileReturning = true;
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                if (this.getStandEntity(this.getSelf()) != null) {
                    this.getStandEntity((class_1309)this.getSelf()).forceDespawnSet = true;
                }
                this.setCooldown((byte)8, 40);
                break;
            }
            case 57: {
                this.setCooldown((byte)7, 15);
                break;
            }
            case 59: {
                this.setAttackTimeDuring(0);
                this.setActivePower((byte)60);
                break;
            }
            case 60: {
                this.setCooldown((byte)8, 10);
                this.setActivePower((byte)60);
                this.chargeTime -= 30;
                if (this.isClient()) break;
                if (30 <= this.chargeTime && this.chargeTime <= 40) {
                    this.FireDart(51, 0.4f);
                    break;
                }
                this.FireDart(51, 0.4f);
                break;
            }
            case 58: {
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.isAuto());
                this.setCooldown((byte)7, 10);
                break;
            }
            case 61: {
                this.setShotCooldown(55);
                this.setAttackTimeDuring(0);
                this.setAttackTime(-1);
                if (this.getActivePower() != 69) {
                    this.getSelf().method_37908().method_45447(null, this.getSelf().method_24515(), ModSounds.RATT_LOADING_EVENT, class_3419.field_15248);
                }
                this.setActivePower((byte)69);
                if (this.getSelf() instanceof class_1657) {
                    S2CPacketUtil.sendActivePowerPacket((class_1657)this.getSelf(), this.getActivePower());
                }
                if (this.isClient()) break;
                this.animateStand((byte)82);
                break;
            }
            case 5: {
                this.setCooldown((byte)5, 120);
                class_243 dir = this.getSelf().method_5828(1.0f);
                if (this.getStandEntity(this.getSelf()) == null) break;
                dir = dir.method_1021(1.1);
                class_243 vec3 = new class_243(dir.field_1352, dir.field_1351 + (double)0.1f, dir.field_1350);
                this.getStandEntity(this.getSelf()).method_18799(vec3);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.scopeLevel != 0) {
            basis *= 0.7f;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        switch (activeP) {
            case 54: {
                return this.getShootTarget() == null && this.isHoldingSneak() && !this.isAuto() && this.isPlaced();
            }
            case 8: {
                if (this.isPlaced()) {
                    return false;
                }
                if (this.scopeLevel != 0) break;
                return this.getValidPlacement() == null && !this.isPlaced();
            }
            case 69: {
                return this.shotcooldown != 0;
            }
            case 7: {
                if (!this.canExecuteMoveWithLevel(3)) {
                    return false;
                }
                if (this.scopeLevel != 0) {
                    return this.getChargeTime() <= 30 || this.shotcooldown != 0;
                }
                if (!this.isPlaced()) break;
                return !this.isAuto() && this.getShootTarget() == null;
            }
            case 5: {
                return !this.isPlaced() || !this.getStandEntity(this.getSelf()).method_24828();
            }
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public boolean interceptAttack() {
        return this.scopeLevel != 0;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, class_315 options) {
        if (keyIsDown && this.scopeLevel != 0 && this.chargeTime >= 30 && this.getActivePower() == 0 && !this.isAttackIneptVisually((byte)7, 2)) {
            this.getSelf().method_5783(ModSounds.RATT_FIRING_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
            if (this.isAuto()) {
                this.tryPower(59, true);
                this.tryPowerPacket((byte)59);
            } else {
                this.PlayerFire();
            }
        }
    }

    @Override
    public boolean interceptGuard() {
        return this.scopeLevel != 0;
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, class_315 options) {
        if (this.getActivePower() == 0 && this.getChargeTime() != 100 && this.shotcooldown == 0) {
            this.tryPower(3, true);
            this.tryPowerPacket((byte)3);
        }
        return true;
    }

    @Override
    public boolean clickRelease() {
        if (this.scopeLevel != 0 && this.getActivePower() == 67) {
            this.setPowerNone();
        }
        return false;
    }

    @Override
    public boolean setPowerGuard() {
        this.setActivePower((byte)67);
        return true;
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.isClient() && effect.method_5584() % 15 == 0) {
            class_1293 effec = this.getSelf().method_6112(ModEffects.MELTING);
            int stack = effec != null ? effec.method_5578() : 0;
            this.getSelf().method_6092(new class_1293(ModEffects.MELTING, 600, stack + 2));
            float degrees = (float)Math.random() * 360.0f;
            MainUtil.takeUnresistableKnockbackWithY((class_1297)this.getSelf(), 0.27f, class_3532.method_15374((float)(degrees * ((float)Math.PI / 180))), class_3532.method_15374((float)-0.34906584f), -class_3532.method_15362((float)(degrees * ((float)Math.PI / 180))));
        }
    }

    @Override
    public boolean shouldReset(byte activeP) {
        if (activeP == 69 && this.getSelf().method_6115()) {
            return false;
        }
        return super.shouldReset(activeP);
    }

    @Override
    public boolean setPowerNone() {
        if (this.getActivePower() == 69) {
            this.setShotCooldown(20);
        }
        return super.setPowerNone();
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        if (attackTarget != null) {
            this.setShootTarget(attackTarget);
            if (this.isPlaced()) {
                if (this.shotcooldown == 0) {
                    this.shotcooldown = 55;
                    ((StandUser)this.getSelf()).roundabout$tryPower(61, true);
                }
            } else if (!this.onCooldown((byte)8)) {
                class_243 vec3 = this.getSelf().method_30950(0.0f);
                this.blipStand(new class_243(vec3.field_1352, Math.floor(vec3.field_1351), vec3.field_1350));
            }
        }
    }

    @Override
    public void renderAttackHud(class_332 context, class_1657 playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.getValidPlacement() != null && !this.isPlaced()) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
        }
        if (this.shotcooldown != 0) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            float ratio = (float)this.shotcooldown / (float)this.maxshotcooldown;
            int fifteen = 15 - Math.round(ratio * 15.0f);
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 12, fifteen, 6);
        } else if (this.getChargeTime() >= 10 || this.scopeLevel != 0) {
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            float amount = (float)this.getChargeTime() / 100.0f;
            int finalAmount = Math.round(amount * 15.0f);
            int bartexture = 30;
            if (this.getChargeTime() >= 90) {
                bartexture -= 6;
            }
            context.method_25302(StandIcons.JOJO_ICONS, k, j, 193, bartexture, finalAmount, 6);
        }
        super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
    }

    @Override
    public boolean canScope() {
        return this.getStandUserSelf().roundabout$getActive() && !this.isPlaced();
    }

    @Override
    public boolean rendersPlayer() {
        return !this.isPlaced();
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList list = Lists.newArrayList();
        list.add((byte)1);
        list.add((byte)2);
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657) {
            boolean bypass;
            class_1657 PE = (class_1657)class_13092;
            byte Level = ((IPlayerEntity)PE).roundabout$getStandLevel();
            class_1799 goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.method_7337() || !goldDisc.method_7960() && goldDisc.method_7909() instanceof MaxStandDiscItem;
            if (Level >= 2 || bypass) {
                list.add((byte)3);
                list.add((byte)5);
            }
            if (Level >= 3 || bypass) {
                list.add((byte)6);
            }
            if (Level >= 3 || bypass) {
                list.add((byte)4);
                list.add((byte)7);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                list.add((byte)8);
                list.add((byte)9);
            }
        }
        return list;
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return PowersRatt.getSkinNameT(skinId);
    }

    public static class_2561 getSkinNameT(byte skinId) {
        switch (skinId) {
            case 2: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.manga");
            }
            case 3: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.melon");
            }
            case 4: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.sand");
            }
            case 5: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.aztec");
            }
            case 6: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.tower");
            }
            case 7: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.snowy");
            }
            case 8: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.guardian");
            }
            case 9: {
                return class_2561.method_43471((String)"skins.roundabout.ratt.elder_guardian");
            }
        }
        return class_2561.method_43471((String)"skins.roundabout.ratt.anime");
    }

    public void unlockSkin() {
        IPlayerEntity ipe;
        class_1657 PE;
        StandUser user;
        class_1799 stack;
        class_1937 lv = this.getSelf().method_37908();
        class_1309 class_13092 = this.getSelf();
        if (class_13092 instanceof class_1657 && !(stack = (user = (StandUser)(PE = (class_1657)class_13092)).roundabout$getStandDisc()).method_7960() && stack.method_31574(ModItems.STAND_DISC_RATT) && !(ipe = (IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !lv.method_8608()) {
            ipe.roundabout$setUnlockedBonusSkin(true);
            lv.method_43128(null, PE.method_23317(), PE.method_23318(), PE.method_23321(), ModSounds.UNLOCK_SKIN_EVENT, PE.method_5634(), 2.0f, 1.0f);
            ((class_3218)lv).method_14199((class_2394)ModParticles.HEART_ATTACK_MINI, PE.method_23317(), PE.method_23318() + (double)PE.method_5751(), PE.method_23321(), 10, 0.5, 0.5, 0.5, 0.2);
            user.roundabout$setStandSkin((byte)8);
            user.roundabout$summonStand(this.getSelf().method_37908(), true, false);
            ((class_3222)ipe).method_7353((class_2561)class_2561.method_43471((String)"unlock_skin.roundabout.ratt.guardians"), true);
        }
    }

    @Override
    public class_2561 getPosName(byte posID) {
        if (posID == 1) {
            return class_2561.method_43471((String)"idle.roundabout.ratt_1");
        }
        return class_2561.method_43471((String)"idle.roundabout.ratt_2");
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        if (soundChoice == 18) {
            return ModSounds.RATT_SUMMON_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte getMaxLevel() {
        return 4;
    }

    public class_2960 LockedOrNot(class_2960 img, int level) {
        return this.canExecuteMoveWithLevel(level) ? img : StandIcons.LOCKED;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 2, "ability.roundabout.ratt_scope", "instruction.roundabout.press_skill", StandIcons.RATT_SCOPE_IN, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 2, "ability.roundabout.ratt_single", "instruction.roundabout.hold_block", StandIcons.RATT_SINGLE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 3, "ability.roundabout.ratt_burst", "instruction.roundabout.press_skill", StandIcons.RATT_BURST, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.ratt_place", "instruction.roundabout.press_skill", StandIcons.RATT_PLACE, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.ratt_place_burst", "instruction.roundabout.press_skill", StandIcons.RATT_BURST, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 3, "ability.roundabout.ratt_auto", "instruction.roundabout.press_skill_crouch", StandIcons.RATT_AUTO, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, 4, "ability.roundabout.ratt_leap", "instruction.roundabout.press_skill", StandIcons.RATT_LEAP, 4, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, 0, "ability.roundabout.ratt_flesh", "instruction.roundabout.passive", StandIcons.RATT_BLOB, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        return $$1;
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public class_2561 ifWipListDevStatus() {
        return class_2561.method_43471((String)"roundabout.dev_status.active").method_27692(class_124.field_1075);
    }

    @Override
    public class_2561 ifWipListDev() {
        return class_2561.method_43470((String)"Prisma").method_27692(class_124.field_1054);
    }
}

