/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.IEnderMan;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.ModItems;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1560;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3966;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5275;
import net.minecraft.class_5819;
import net.minecraft.class_6026;
import net.minecraft.class_7094;
import net.minecraft.class_7923;
import net.minecraft.class_8111;

public class RoadRollerEntity
extends class_1309
implements class_6026 {
    private class_1799 roadRollerItem = new class_1799((class_1935)ModItems.ROAD_ROLLER);
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputDown;
    private float outOfControlTicks;
    private static final class_1856 CONCRETE;
    private int explosionParticleDelay = 0;
    private byte lastCrackiness = 0;
    private double roadRollerSped = 0.0;
    private int groundedTicks = 0;
    private boolean grounded = false;
    @Nullable
    private class_1657 pickupPlayer;
    public static final byte WHEELS = 1;
    public static final byte EXPLOSION = 2;
    public final class_7094 wheels = new class_7094();
    public final class_7094 explode = new class_7094();
    public class_1309 thrower = null;
    private boolean wasOnGround = true;
    private boolean groundState = false;
    private double highestY = Double.NEGATIVE_INFINITY;
    public boolean isThrown;
    private float lastYaw = 0.0f;
    private class_1297 previousVehicle = null;
    public boolean hasBeenBaraged = false;
    public boolean mixingSoundStarted = false;
    public boolean explosionSoundStarted = false;
    private boolean scrapParticlesSpawned = false;
    private boolean crackinessParticlesSpawned = false;
    private boolean smokeParticlesSpawned = false;
    private boolean explosionParticlesSpawned = false;
    private boolean hitGroundBeforeExploding = false;
    private boolean explosionDamageDone = false;
    public float pickupPlayerHealth;
    int rideLengthTicks = 0;
    protected static final class_2940<Integer> PAVING_TIMER;
    protected static final class_2940<Boolean> PAVING_BOOLEAN;
    protected static final class_2940<class_1799> CONCRETE_COLOUR;
    protected static final class_2940<Boolean> INPUT_UP;
    protected static final class_2940<Boolean> EXPLODED;
    protected static final class_2940<Byte> CRACKINESS;
    protected static final class_2940<Integer> PICKUP_TIMER;
    protected static final class_2940<Integer> PICKUP_BOOLEAN_INT;
    protected static final class_2940<Integer> EXPLOSION_TICKS;

    public byte getAnimation() {
        if (this.getInputUp()) {
            return 1;
        }
        if (this.getExploded() && this.method_37908().field_9236) {
            return 2;
        }
        return 0;
    }

    public void setupAnimationStates() {
        if (!this.method_37908().field_9236) {
            return;
        }
        byte animation = this.getAnimation();
        if (animation == 1) {
            this.wheels.method_41324(this.field_6012);
        } else {
            this.wheels.method_41325();
        }
        if (animation == 2) {
            this.explode.method_41324(this.field_6012);
        } else {
            this.explode.method_41325();
        }
    }

    public RoadRollerEntity(class_1299<? extends class_1309> type, class_1937 level) {
        super(type, level);
    }

    public RoadRollerEntity(class_1937 level, class_1309 owner, class_1799 stack, double x, double y, double z) {
        super(ModEntities.ROAD_ROLLER_ENTITY, level);
        this.roadRollerItem = stack.method_7972();
        this.method_5814(x, y, z);
    }

    public Iterable<class_1799> method_5661() {
        return Collections.emptyList();
    }

    public class_1799 method_6118(class_1304 slot) {
        return class_1799.field_8037;
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
    }

    public static class_5132.class_5133 createAttributes() {
        return RoadRollerEntity.method_26827().method_26868(class_5134.field_23716, 40.0).method_26868(class_5134.field_23719, 0.01).method_26868(class_5134.field_23717, 0.0);
    }

    public class_1306 method_6068() {
        return class_1306.field_6183;
    }

    public boolean method_30949(class_1297 other) {
        class_1309 le;
        block6: {
            block5: {
                block4: {
                    class_1297 class_12972 = this.method_5854();
                    if (!(class_12972 instanceof StandEntity)) break block4;
                    StandEntity stand = (StandEntity)class_12972;
                    break block5;
                }
                if (!this.getExploded()) break block6;
            }
            return false;
        }
        if (other instanceof class_1309 && ((StandUser)(le = (class_1309)other)).roundabout$getStandPowers().cancelCollision((class_1297)this)) {
            return false;
        }
        return super.method_30949(other);
    }

    public boolean method_30948() {
        block4: {
            block3: {
                block2: {
                    class_1297 vehicle = this.method_5854();
                    if (!(vehicle instanceof StandEntity)) break block2;
                    StandEntity stand = (StandEntity)vehicle;
                    break block3;
                }
                if (!this.getExploded()) break block4;
            }
            return false;
        }
        return super.method_30948();
    }

    public boolean method_5810() {
        if (this.getExploded()) {
            return false;
        }
        return !(this.method_5854() instanceof StandEntity) && super.method_5810();
    }

    protected void method_5623(double p_20990_, boolean p_20991_, class_2680 p_20992_, class_2338 p_20993_) {
    }

    protected float method_18394(class_4050 $$0, class_4048 $$1) {
        return 0.65f;
    }

    public void setLastYaw(float yaw) {
        this.lastYaw = yaw;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (this.method_5679(source)) {
            return false;
        }
        this.method_5785();
        return super.method_5643(source, amount);
    }

    public boolean method_5753() {
        return true;
    }

    public void method_5639(int seconds) {
    }

    public void method_6078(class_1282 $$0) {
        if (this.hasBeenBaraged && this.isThrown && this.thrower != null) {
            this.setExploded(true);
            this.field_6213 = 0;
        }
        super.method_6078($$0);
    }

    protected void method_6108() {
        if (!this.getExploded()) {
            this.explosionParticleDelay = 0;
        }
        if (!this.method_37908().field_9236 && this.getExploded()) {
            this.setExplosionTicks(this.getExplosionTicks() + 1);
        }
        if (this.getExploded()) {
            if (this.field_6213 == 0) {
                this.explode.method_41324(this.field_6012);
            }
            if (this.getExploded() && this.hitGroundBeforeExploding && !this.method_37908().field_9236) {
                ++this.explosionParticleDelay;
                if (this.explosionParticleDelay == 10) {
                    class_2338 center = this.method_24515();
                    class_5819 random = this.method_37908().method_8409();
                    int radius = 8;
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            double distSq = x * x + z * z;
                            if (!(distSq <= (double)(radius * radius)) || !(random.method_43057() < 0.5f)) continue;
                            class_2338 firePos = center.method_10069(x, 0, z);
                            class_2680 below = this.method_37908().method_8320(firePos.method_10074());
                            if (!below.method_51367() || !this.method_37908().method_22347(firePos)) continue;
                            this.method_37908().method_8652(firePos, class_2246.field_10036.method_9564(), 11);
                        }
                    }
                }
            }
            if (this.field_6213 < 300) {
                ++this.field_6213;
                return;
            }
            super.method_6078(this.method_48923().method_48830());
            this.method_5650(class_1297.class_5529.field_26998);
        } else {
            super.method_6108();
        }
    }

    protected void onHitEntity(class_3966 hitResult) {
        if (!this.method_37908().method_8608()) {
            class_1297 class_12972 = hitResult.method_17782();
            if (class_12972 instanceof class_1560) {
                class_1560 em = (class_1560)class_12972;
                ((IEnderMan)em).roundabout$teleport();
                return;
            }
            if (this.field_5960) {
                return;
            }
            double roadRollerSped = this.method_18798().method_1033();
            if (roadRollerSped < 1.0) {
                return;
            }
            float damage = 5.0f;
            float aboveDamage = 14.0f;
            double fallDistance = this.highestY - this.method_23318();
            if (fallDistance > 2.0 && this.method_18798().field_1351 < -1.0) {
                damage = aboveDamage;
            }
            if (this.thrower != null) {
                class_1282 src = ModDamageTypes.of(this.method_37908(), ModDamageTypes.ROAD_ROLLER, (class_1297)this, (class_1297)this.thrower);
                hitResult.method_17782().method_5643(src, damage);
            }
        }
    }

    public boolean method_5679(class_1282 source) {
        if (source.method_49708(class_8111.field_42340) || source.method_49708(class_8111.field_42342) || source.method_49708(class_8111.field_42354) || source.method_49708(class_8111.field_42339) || source.method_49708(class_8111.field_42353) || source.method_49708(class_8111.field_42350) || source.method_49708(class_8111.field_42344) || source.method_49708(class_8111.field_42335) || source.method_49708(class_8111.field_42337)) {
            return true;
        }
        return super.method_5679(source);
    }

    public boolean method_6094() {
        return true;
    }

    public void radialExplosion(@Nullable class_1309 mainTarget) {
        if (this.explosionParticleDelay == 10 && !this.method_37908().method_8608() && !this.explosionDamageDone) {
            this.explosionDamageDone = true;
            List<class_1297> entityList = DamageHandler.genHitbox(mainTarget, this.method_23317(), this.method_23318(), this.method_23321(), 12.0, 12.0, 12.0);
            if (!entityList.isEmpty()) {
                for (class_1297 value : entityList) {
                    if (!value.method_5863() || !value.method_5805()) continue;
                    class_1282 src = ModDamageTypes.of(this.method_37908(), ModDamageTypes.ROAD_ROLLER, (class_1297)this, (class_1297)this.thrower);
                    value.method_5643(src, 20.0f);
                }
            }
        }
    }

    public void pickUpRoadRoller(class_1657 player, class_1799 itemStack) {
        class_1799 copy;
        if (!this.method_37908().field_9236 && player.method_7270(copy = new class_1799((class_1935)ModItems.ROAD_ROLLER))) {
            this.setPickupBoolean(0);
            this.setPickupTimer(0);
            ClientUtil.setRoadRollerPickingEntity(null);
            this.method_31472();
        }
    }

    public void method_5773() {
        int x;
        byte previous;
        byte current;
        super.method_5773();
        if (this.method_5642() == null) {
            this.method_36456(this.field_5982);
            this.field_6283 = this.field_5982;
            this.field_6241 = this.field_5982;
        }
        if (!this.method_37908().method_8608()) {
            this.sendOutMessage();
        }
        if (!this.method_37908().field_9236 && this.getPavingBoolean()) {
            if (this.getPavingTimer() == 800) {
                this.setPavingTimer(0);
                this.setPavingBoolean(false);
            } else if (this.getPavingTimer() > -1) {
                this.setPavingTimer(this.getPavingTimer() + 1);
            }
        }
        if (this.method_37908().field_9236 && this.field_6012 % 60 == 1 && !((TimeStop)this.method_37908()).inTimeStopRange((class_1297)this)) {
            ClientUtil.handleRoadRollerAmbientSound((class_1297)this);
        }
        if (!this.method_37908().field_9236 && this.isThrown && this.field_6012 % 180 == 0) {
            this.thrower = null;
        }
        if (!this.method_37908().field_9236 && this.method_24828()) {
            this.hitGroundBeforeExploding = true;
        }
        if (this.getPickupBoolean() > 0) {
            if (this.getPickupTimer() < 100) {
                this.setPickupTimer(this.getPickupTimer() + 1);
            } else if (this.getPickupTimer() == 100) {
                if (!this.method_37908().field_9236 && this.pickupPlayer != null) {
                    this.pickUpRoadRoller(this.pickupPlayer, this.roadRollerItem);
                }
                if (this.pickupPlayer != null) {
                    this.setPickupBoolean(this.pickupPlayer.method_5628());
                } else {
                    this.setPickupBoolean(0);
                }
                this.setPickupTimer(0);
                this.pickupPlayer = null;
            }
        }
        if (!this.method_37908().field_9236 && this.pickupPlayer != null) {
            if (this.method_5739((class_1297)this.pickupPlayer) > 3.0f || ((TimeStop)this.method_37908()).inTimeStopRange((class_1297)this) || this.pickupPlayer.method_6032() < this.pickupPlayerHealth) {
                this.pickupPlayerHealth = this.pickupPlayer.method_6032();
                this.pickupPlayer = null;
                this.setPickupBoolean(0);
                this.setPickupTimer(0);
            } else {
                this.pickupPlayerHealth = this.pickupPlayer.method_6032();
            }
        }
        if (!this.method_37908().field_9236) {
            if (this.method_24828()) {
                ++this.groundedTicks;
                if (this.groundedTicks >= 20) {
                    this.grounded = true;
                }
            } else {
                this.groundedTicks = 0;
                this.grounded = false;
            }
        }
        if (!this.method_37908().field_9236 && this.getExploded() && this.explosionParticleDelay >= 10 && !((TimeStop)this.method_37908()).inTimeStopRange((class_1297)this) && !this.explosionSoundStarted) {
            this.explosionSoundStarted = true;
            ClientUtil.handleRoadRollerExplosionSound((class_1297)this);
        }
        if (this.method_37908().field_9236 && this.getPickupBoolean() > 0) {
            ClientUtil.setRoadRollerPickingEntity(this);
        }
        if (!this.method_37908().field_9236 && this.getExploded()) {
            this.radialExplosion(this);
        }
        if (this.method_37908().field_9236 && this.getExploded()) {
            int ticks = this.getExplosionTicks();
            ++this.explosionParticleDelay;
            if (ticks == 10) {
                double vz;
                double vy;
                double vx;
                int i;
                if (!this.scrapParticlesSpawned) {
                    this.scrapParticlesSpawned = true;
                    for (i = 0; i < 15; ++i) {
                        vx = (this.field_5974.method_43058() - 0.5) * 1.2;
                        vy = this.field_5974.method_43058() * 0.6;
                        vz = (this.field_5974.method_43058() - 0.5) * 1.2;
                        this.method_37908().method_8406((class_2394)ModParticles.ROAD_ROLLER_SCRAP, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), vx, vy, vz);
                    }
                }
                if (!this.smokeParticlesSpawned) {
                    this.smokeParticlesSpawned = true;
                    for (i = 0; i < 40; ++i) {
                        vx = (this.field_5974.method_43058() - 0.5) * 1.2;
                        vy = this.field_5974.method_43058() * 0.6;
                        vz = (this.field_5974.method_43058() - 0.5) * 1.2;
                        this.method_37908().method_8406((class_2394)ModParticles.ROAD_ROLLER_SMOKE, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), vx, vy, vz);
                    }
                }
                if (!this.explosionParticlesSpawned) {
                    this.explosionParticlesSpawned = true;
                    for (i = 0; i < 40; ++i) {
                        vx = (this.field_5974.method_43058() - 0.5) * 1.2;
                        vy = this.field_5974.method_43058() * 0.6;
                        vz = (this.field_5974.method_43058() - 0.5) * 1.2;
                        this.method_37908().method_8406((class_2394)ModParticles.ROAD_ROLLER_EXPLOSION, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), vx, vy, vz);
                    }
                }
            }
        }
        if (this.method_37908().field_9236) {
            this.setupAnimationStates();
        }
        if (!this.method_37908().field_9236) {
            float fraction = this.method_6032() / this.method_6063();
            this.setCrackiness(Crackiness.byHealthFraction(fraction));
        }
        if (this.method_37908().field_9236 && (current = this.getCrackiness()) != (previous = this.lastCrackiness)) {
            this.lastCrackiness = current;
            if (!this.crackinessParticlesSpawned) {
                this.crackinessParticlesSpawned = true;
                for (int i = 0; i < 5; ++i) {
                    double vx = (this.field_5974.method_43058() - 0.5) * 1.2;
                    double vy = this.field_5974.method_43058() * 0.6;
                    double vz = (this.field_5974.method_43058() - 0.5) * 1.2;
                    this.method_37908().method_8406((class_2394)ModParticles.ROAD_ROLLER_SCRAP, this.method_23317(), this.method_23318() + 1.0, this.method_23321(), vx, vy, vz);
                }
            }
        }
        if (!this.method_37908().field_9236) {
            class_265 shape;
            class_238 box = this.method_5829();
            boolean bottomInsideBlock = false;
            double cx = box.method_1005().field_1352;
            double cz = box.method_1005().field_1350;
            int y = class_3532.method_15357((double)(box.field_1322 - 0.05));
            class_2338 bp = new class_2338(class_3532.method_15357((double)cx), y, class_3532.method_15357((double)cz));
            class_2680 state = this.method_37908().method_8320(bp);
            if (!state.method_26215() && !(shape = state.method_26220((class_1922)this.method_37908(), bp)).method_1110() && shape.method_1105(class_2350.class_2351.field_11052) > box.field_1322 - (double)y) {
                bottomInsideBlock = true;
            }
            if (bottomInsideBlock) {
                for (int tries = 0; bottomInsideBlock && tries < 5; ++tries) {
                    this.method_5859(this.method_23317(), this.method_23318() + 0.05, this.method_23321());
                    this.method_18382();
                    bottomInsideBlock = !this.method_37908().method_17892((class_1297)this);
                }
                if (bottomInsideBlock) {
                    this.method_5859(this.method_23317(), this.method_23318() + 0.1, this.method_23321());
                    this.method_18382();
                }
            }
        }
        if (this.method_37908().field_9236 && this.getPavingBoolean()) {
            class_5819 random = this.method_37908().method_8409();
            float yaw = this.method_5705(1.0f);
            if (yaw == 0.0f && this.lastYaw != 0.0f) {
                yaw = this.lastYaw;
            } else {
                this.lastYaw = yaw;
            }
            float yawRad = (float)Math.toRadians(yaw);
            float cos = class_3532.method_15362((float)yawRad);
            float sin = class_3532.method_15374((float)yawRad);
            double rightX = cos;
            double rightZ = sin;
            double fwdX = -sin;
            double fwdZ = cos;
            double forwardOffset = 0.12;
            for (int i = 0; i < 4; ++i) {
                double localX = (random.method_43058() - 0.5) * 1.8;
                double localZ = (random.method_43058() - 1.75) * 1.8;
                localX = -localX;
                double offsetX = localX * rightX + localZ * fwdX;
                double offsetZ = localX * rightZ + localZ * fwdZ;
                double x2 = this.method_23317() + (offsetX += fwdX * forwardOffset);
                double y = this.method_23318() + 2.4 + random.method_43058() * 0.3;
                double z = this.method_23321() + (offsetZ += fwdZ * forwardOffset);
                double vy = 0.05 + random.method_43058() * 0.02;
                this.method_37908().method_8406((class_2394)class_2398.field_11251, x2, y, z, 0.0, vy, 0.0);
            }
        }
        class_1297 currentVehicle = this.method_5854();
        if (!(this.previousVehicle instanceof StandEntity) && currentVehicle instanceof StandEntity) {
            this.setLastYaw(this.method_36454());
        }
        this.previousVehicle = currentVehicle;
        class_243 currentPos = this.method_19538();
        class_243 nextPos = currentPos.method_1019(this.method_18798());
        class_238 sweptBox = this.method_5829().method_18804(this.method_18798()).method_1014((double)(this.method_17681() * 1.0f) + 0.1);
        class_3966 entityHitResult = class_1675.method_18077((class_1937)this.method_37908(), (class_1297)this, (class_243)currentPos, (class_243)nextPos, (class_238)sweptBox, this::canHitEntity);
        if (entityHitResult != null) {
            this.onHitEntity(entityHitResult);
        }
        class_238 box = this.method_5829().method_1014(1.0);
        for (class_1297 e : this.method_37908().method_8333((class_1297)this, box, this::canHitEntity)) {
            this.onHitEntity(new class_3966(e));
        }
        boolean onGroundNow = this.method_24828();
        double highestYValue = this.method_23318();
        if (this.wasOnGround && !onGroundNow) {
            this.isThrown = true;
            this.highestY = highestYValue;
        }
        if (this.isThrown && highestYValue > this.highestY) {
            this.highestY = highestYValue;
        }
        this.wasOnGround = onGroundNow;
        if (this.method_5642() == null) {
            this.setInputUp(false);
            this.inputDown = false;
            this.inputLeft = false;
            this.inputRight = false;
        }
        if (!this.method_37908().field_9236) {
            if (!this.method_37908().method_8450().method_8355(ModGamerules.ROUNDABOUT_ROAD_ROLLER_BREAK_ICE)) {
                return;
            }
            if (this.method_5854() instanceof StandEntity) {
                return;
            }
            class_2338 basePos = class_2338.method_49638((class_2374)this.method_19538().method_1031(0.0, -0.5, 0.0));
            for (x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    class_2338 blockPos = basePos.method_10069(x, 0, z);
                    class_2680 state = this.method_37908().method_8320(blockPos);
                    if (!state.method_27852(class_2246.field_10295) && !state.method_27852(class_2246.field_10225) && !state.method_27852(class_2246.field_10384) && !state.method_27852(class_2246.field_10110)) continue;
                    this.method_37908().method_22352(blockPos, false);
                }
            }
        }
        if (!this.getInputUp()) {
            return;
        }
        if (!this.method_37908().field_9236) {
            class_2338 sigmaPos;
            boolean willRaise = this.getPavingBoolean();
            if (willRaise) {
                block9: for (x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        sigmaPos = class_2338.method_49638((class_2374)this.method_19538().method_1031(0.0, -0.5, 0.0));
                        class_2338 bp = sigmaPos.method_10069(x, 0, z);
                        class_2680 s = this.method_37908().method_8320(bp);
                        if (!s.method_27852(class_2246.field_10194)) continue;
                        willRaise = true;
                        break block9;
                    }
                }
            }
            if (willRaise) {
                double dy = 0.0626;
                this.method_5859(this.method_23317(), this.method_23318() + dy, this.method_23321());
            }
            for (int x3 = -1; x3 <= 1; ++x3) {
                for (int z = -1; z <= 1; ++z) {
                    sigmaPos = class_2338.method_49638((class_2374)this.method_19538().method_1031(0.0, -0.5, 0.0));
                    class_2338 blockPos = sigmaPos.method_10069(x3, 0, z);
                    class_2680 state = this.method_37908().method_8320(blockPos);
                    if (!state.method_27852(class_2246.field_10219) && !state.method_27852(class_2246.field_10566) && !state.method_27852(class_2246.field_10194)) continue;
                    if (!this.getPavingBoolean()) {
                        this.method_37908().method_8652(blockPos, class_2246.field_10194.method_9564(), 3);
                        continue;
                    }
                    class_2960 itemID = class_7923.field_41178.method_10221((Object)this.getConcreteColour().method_7909());
                    if (itemID == null) continue;
                    String fixedString = itemID.method_12832().replace("_powder", "");
                    class_2960 blockID = new class_2960(itemID.method_12836(), fixedString);
                    class_2248 actualConcrete = class_7923.field_41175.method_17966(blockID).orElse(class_2246.field_10458);
                    this.method_37908().method_8652(blockPos, actualConcrete.method_9564(), 3);
                }
            }
        }
    }

    protected boolean canHitEntity(class_1297 $$0x) {
        if ($$0x == this.thrower) {
            return false;
        }
        return $$0x != this;
    }

    public float getLastYaw() {
        return this.lastYaw;
    }

    public void method_6087(class_1297 $$0) {
        block4: {
            block3: {
                block2: {
                    class_1297 class_12972 = this.method_5854();
                    if (!(class_12972 instanceof StandEntity)) break block2;
                    StandEntity stand = (StandEntity)class_12972;
                    break block3;
                }
                if (!this.getExploded()) break block4;
            }
            return;
        }
        super.method_6087($$0);
    }

    public void sendOutMessage() {
        class_1309 cpas = this.method_5642();
        if (cpas instanceof class_3222) {
            class_3222 SP = (class_3222)cpas;
            ++this.rideLengthTicks;
            if (this.rideLengthTicks == 40) {
                SP.method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.riding_road_roller").method_27692(class_124.field_1076), true);
            }
        } else {
            this.rideLengthTicks = 0;
        }
    }

    public void method_5697(class_1297 $$0) {
        class_1297 class_12972 = this.method_5854();
        if (class_12972 instanceof StandEntity) {
            StandEntity stand = (StandEntity)class_12972;
            return;
        }
        super.method_5697($$0);
        if (this.method_37908().field_9236) {
            return;
        }
        if (!this.isThrown) {
            return;
        }
        if ($$0 == this.method_5642()) {
            return;
        }
        if ($$0 == this.method_5854() || this.method_5794($$0)) {
            return;
        }
        if (this.field_5960 || $$0.field_5960) {
            return;
        }
        class_243 dir = this.method_18798();
        if (dir.method_1027() > 1.0E-4) {
            class_243 n = dir.method_1029();
            $$0.method_5762(n.field_1352 * 0.1, 0.2, n.field_1350 * 0.1);
        }
    }

    protected float method_49485(class_1657 $$0) {
        return (float)(this.method_26825(class_5134.field_23719) * 0.0);
    }

    protected void method_49481(class_1657 $$0, class_243 $$1) {
        super.method_49481($$0, $$1);
        class_241 $$2 = this.getRiddenRotation((class_1309)$$0);
        this.method_5710($$2.field_1342, $$2.field_1343);
        this.field_6283 = this.field_6241 = this.method_36454();
        this.field_5982 = this.field_6241;
        class_243 $$4 = this.method_18798();
        if (!this.getInputUp()) {
            this.method_18799($$4.method_18805(0.85, 1.0, 0.85));
            return;
        }
        if (this.method_24828()) {
            float sin = class_3532.method_15374((float)(this.method_36454() * ((float)Math.PI / 180)));
            float cos = class_3532.method_15362((float)(this.method_36454() * ((float)Math.PI / 180)));
            this.method_18799($$4.method_1031((double)(-0.06f * sin), 0.0, (double)(0.06f * cos)));
        } else {
            this.method_18799($$4.method_18805(0.98, 1.0, 0.98));
        }
    }

    public double method_5621() {
        return this.method_17682() * 0.7f;
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 move) {
        double backOffset = 0.7;
        float yawRad = (float)Math.toRadians(this.method_36454());
        double x = this.method_23317() + (double)class_3532.method_15374((float)yawRad) * backOffset;
        double y = this.method_23318() + 0.95;
        double z = this.method_23321() - (double)class_3532.method_15362((float)yawRad) * backOffset;
        passenger.method_5814(x, y, z);
    }

    public boolean method_5747(float $$0, float $$1, class_1282 $$2) {
        int $$3;
        if ($$0 > 1.0f) {
            // empty if block
        }
        if (($$3 = this.method_23329($$0, $$1)) <= 0) {
            return false;
        }
        this.method_5643($$2, $$3);
        this.method_23328();
        return true;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 entity;
        if (!this.method_5685().isEmpty() && (entity = (class_1297)this.method_5685().get(0)) instanceof class_1309) {
            return (class_1309)entity;
        }
        return null;
    }

    public float method_49476() {
        float f = super.method_49476();
        return this.method_5642() instanceof class_1657 ? Math.max(f, 1.5f) : f;
    }

    public void method_5844(class_2680 $$0, class_243 $$1) {
        if (!$$0.method_27852(class_2246.field_10343)) {
            super.method_5844($$0, $$1);
        }
    }

    protected class_241 getRiddenRotation(class_1309 $$0) {
        return new class_241($$0.method_36455() * 0.5f, $$0.method_36454());
    }

    protected class_243 method_49482(class_1657 $$0, class_243 $$1) {
        boolean pressed;
        float forward = $$0.field_6250;
        boolean bl = pressed = forward > 0.0f;
        if (!this.method_37908().field_9236) {
            this.setInputUp(pressed);
        }
        boolean bl2 = this.inputDown = forward < 0.0f;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        return class_243.field_1353;
    }

    protected void doPlayerRide(class_1657 $$0) {
        if (!this.method_37908().field_9236) {
            $$0.method_36456(this.method_36454());
            $$0.method_36457(this.method_36455());
            $$0.method_5804((class_1297)this);
        }
    }

    @Nullable
    private class_243 getDismountLocationInDirection(class_243 $$0, class_1309 $$1) {
        double $$2 = this.method_23317() + $$0.field_1352;
        double $$3 = this.method_5829().field_1322;
        double $$4 = this.method_23321() + $$0.field_1350;
        class_2338.class_2339 $$5 = new class_2338.class_2339();
        block0: for (class_4050 $$6 : $$1.method_24831()) {
            $$5.method_10102($$2, $$3, $$4);
            double $$7 = this.method_5829().field_1325 + 0.75;
            do {
                double $$8 = this.method_37908().method_30347((class_2338)$$5);
                if ((double)$$5.method_10264() + $$8 > $$7) continue block0;
                if (class_5275.method_27932((double)$$8)) {
                    class_238 $$9 = $$1.method_24833($$6);
                    class_243 $$10 = new class_243($$2, (double)$$5.method_10264() + $$8, $$4);
                    if (class_5275.method_27933((class_1941)this.method_37908(), (class_1309)$$1, (class_238)$$9.method_997($$10))) {
                        $$1.method_18380($$6);
                        return $$10;
                    }
                }
                $$5.method_10098(class_2350.field_11036);
            } while (!((double)$$5.method_10264() < $$7));
        }
        return null;
    }

    public class_243 method_24829(class_1309 $$0) {
        class_243 $$1 = RoadRollerEntity.method_24826((double)this.method_17681(), (double)$$0.method_17681(), (float)(this.method_36454() + ($$0.method_6068() == class_1306.field_6183 ? 90.0f : -90.0f)));
        class_243 $$2 = this.getDismountLocationInDirection($$1, $$0);
        if ($$2 != null) {
            return $$2;
        }
        class_243 $$3 = RoadRollerEntity.method_24826((double)this.method_17681(), (double)$$0.method_17681(), (float)(this.method_36454() + ($$0.method_6068() == class_1306.field_6182 ? 90.0f : -90.0f)));
        class_243 $$4 = this.getDismountLocationInDirection($$3, $$0);
        return $$4 != null ? $$4 : this.method_19538();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(PAVING_TIMER, (Object)0);
        this.field_6011.method_12784(PAVING_BOOLEAN, (Object)false);
        this.field_6011.method_12784(CONCRETE_COLOUR, (Object)class_1799.field_8037);
        this.field_6011.method_12784(INPUT_UP, (Object)false);
        this.field_6011.method_12784(EXPLODED, (Object)false);
        this.field_6011.method_12784(CRACKINESS, (Object)0);
        this.field_6011.method_12784(PICKUP_TIMER, (Object)0);
        this.field_6011.method_12784(PICKUP_BOOLEAN_INT, (Object)-1);
        this.field_6011.method_12784(EXPLOSION_TICKS, (Object)0);
    }

    public final void setPavingTimer(int PavingTimer) {
        this.field_6011.method_12778(PAVING_TIMER, (Object)PavingTimer);
    }

    public int getPavingTimer() {
        return (Integer)this.field_6011.method_12789(PAVING_TIMER);
    }

    public void setPavingBoolean(boolean value) {
        this.field_6011.method_12778(PAVING_BOOLEAN, (Object)value);
    }

    public boolean getPavingBoolean() {
        return (Boolean)this.field_6011.method_12789(PAVING_BOOLEAN);
    }

    public class_1799 getConcreteColour() {
        return (class_1799)this.field_6011.method_12789(CONCRETE_COLOUR);
    }

    public void setConcreteColour(class_1799 stack) {
        this.field_6011.method_12778(CONCRETE_COLOUR, (Object)stack.method_7972());
    }

    public void setInputUp(boolean value) {
        this.field_6011.method_12778(INPUT_UP, (Object)value);
    }

    public boolean getInputUp() {
        return (Boolean)this.field_6011.method_12789(INPUT_UP);
    }

    public void setExploded(boolean value) {
        this.field_6011.method_12778(EXPLODED, (Object)value);
    }

    public boolean getExploded() {
        return (Boolean)this.field_6011.method_12789(EXPLODED);
    }

    public byte getCrackiness() {
        return (Byte)this.field_6011.method_12789(CRACKINESS);
    }

    public void setCrackiness(byte level) {
        this.field_6011.method_12778(CRACKINESS, (Object)level);
    }

    public final void setPickupTimer(int PickupTimer) {
        this.field_6011.method_12778(PICKUP_TIMER, (Object)PickupTimer);
    }

    public int getPickupTimer() {
        return (Integer)this.field_6011.method_12789(PICKUP_TIMER);
    }

    public void setPickupBoolean(int value) {
        this.field_6011.method_12778(PICKUP_BOOLEAN_INT, (Object)value);
    }

    public int getPickupBoolean() {
        return (Integer)this.field_6011.method_12789(PICKUP_BOOLEAN_INT);
    }

    public void setExplosionTicks(int ticks) {
        this.field_6011.method_12778(EXPLOSION_TICKS, (Object)ticks);
    }

    public int getExplosionTicks() {
        return (Integer)this.field_6011.method_12789(EXPLOSION_TICKS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_5688(class_1657 $$0, class_1268 $$1) {
        boolean wasPaving = this.getPavingBoolean();
        if (this.getExploded()) {
            return class_1269.field_5814;
        }
        if (((TimeStop)this.method_37908()).inTimeStopRange((class_1297)this)) {
            return class_1269.field_5814;
        }
        if (this.method_5854() instanceof StandEntity) {
            return class_1269.field_5814;
        }
        boolean concreteEnabled = false;
        boolean pickupEnabled = false;
        class_1799 item = $$0.method_5998($$1);
        if ($$0.method_18276() && !this.isConcrete(item)) {
            if (this.pickupPlayer != null) {
                return class_1269.field_5814;
            }
            if (this.getCrackiness() != 0) {
                return class_1269.field_5814;
            }
            pickupEnabled = true;
            this.setPickupTimer(0);
            this.pickupPlayer = $$0;
            this.setPickupBoolean(this.pickupPlayer != null ? this.pickupPlayer.method_5628() : 0);
        }
        if (this.pickupPlayer != null) {
            return class_1269.field_5814;
        }
        if (this.isConcrete(item)) {
            concreteEnabled = true;
            if (this.getPavingBoolean()) {
                class_1799 current = this.getConcreteColour();
                if (!class_1799.method_31577((class_1799)current, (class_1799)item)) {
                    this.setConcreteColour(item);
                }
                if (this.method_37908().field_9236) {
                    if (this.getPavingBoolean() && !((TimeStop)this.method_37908()).inTimeStopRange((class_1297)this)) {
                        this.mixingSoundStarted = true;
                        ClientUtil.stopRoadRollerMixingSound((class_1297)this);
                        ClientUtil.handleRoadRollerMixingSound((class_1297)this);
                    } else if (!this.getPavingBoolean()) {
                        this.mixingSoundStarted = false;
                        ClientUtil.stopRoadRollerMixingSound((class_1297)this);
                    }
                }
                this.setPavingTimer(0);
            } else {
                this.setConcreteColour(item);
                this.setPavingBoolean(true);
                if (this.method_37908().field_9236) {
                    if (this.getPavingBoolean() && !((TimeStop)this.method_37908()).inTimeStopRange((class_1297)this)) {
                        this.mixingSoundStarted = true;
                        ClientUtil.stopRoadRollerMixingSound((class_1297)this);
                        ClientUtil.handleRoadRollerMixingSound((class_1297)this);
                    } else if (!this.getPavingBoolean()) {
                        this.mixingSoundStarted = false;
                        ClientUtil.stopRoadRollerMixingSound((class_1297)this);
                    }
                }
                this.setPavingTimer(0);
            }
            if ($$0.method_31549().field_7477 || this.method_37908().field_9236) return class_1269.method_29236((boolean)this.method_37908().field_9236);
            item.method_7934(1);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if ($$0.method_5794((class_1297)this)) {
            return class_1269.field_5811;
        }
        if ($$0.method_21823()) {
            return class_1269.field_5811;
        }
        if (!(this.outOfControlTicks < 60.0f)) return class_1269.field_5811;
        if (this.method_37908().field_9236) return class_1269.field_5812;
        if (!concreteEnabled) {
            return $$0.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        if (!concreteEnabled) return class_1269.field_5811;
        this.setPavingBoolean(true);
        return class_1269.field_5811;
    }

    public boolean isConcrete(class_1799 itemStack) {
        return CONCRETE.method_8093(itemStack);
    }

    static {
        PAVING_TIMER = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13327);
        PAVING_BOOLEAN = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13323);
        CONCRETE_COLOUR = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13322);
        INPUT_UP = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13323);
        EXPLODED = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13323);
        CRACKINESS = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13319);
        PICKUP_TIMER = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13327);
        PICKUP_BOOLEAN_INT = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13327);
        EXPLOSION_TICKS = class_2945.method_12791(RoadRollerEntity.class, (class_2941)class_2943.field_13327);
        CONCRETE = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8516, class_1802.field_8757, class_1802.field_8164, class_1802.field_8205, class_1802.field_8690, class_1802.field_8336, class_1802.field_8487, class_1802.field_8764, class_1802.field_8818, class_1802.field_8558, class_1802.field_8418, class_1802.field_8437, class_1802.field_8593, class_1802.field_8198, class_1802.field_8222, class_1802.field_8582});
    }

    public static class Crackiness {
        public static final byte NONE = 0;
        public static final byte MEDIUM = 1;
        public static final byte HIGH = 2;

        public static byte byHealthFraction(float fraction) {
            if (fraction < 0.25f) {
                return 2;
            }
            if (fraction < 0.5f) {
                return 1;
            }
            return 0;
        }
    }
}

