/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.hydra.jojomod.access.IShaderGameRenderer;
import net.hydra.jojomod.block.D4CLightBlock;
import net.hydra.jojomod.block.D4CLightBlockEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.zetalasis.client.shader.RCoreShader;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class D4CLightBlockEntityRenderer
implements BlockEntityRenderer<D4CLightBlockEntity> {
    public D4CLightBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(D4CLightBlockEntity blockEntity, float v, PoseStack matrices, MultiBufferSource bufferSource, int light, int overlay) {
        Minecraft client = Minecraft.m_91087_();
        if (client.f_91074_ == null) {
            return;
        }
        if (!ClientUtil.canSeeStands((Player)client.f_91074_)) {
            return;
        }
        ClientUtil.pushPoseAndCooperate(matrices, 2);
        matrices.m_85837_(0.5, 0.5, 0.5);
        Matrix4f poseMatrix = matrices.m_85850_().m_252922_();
        Matrix3f normalMatrix = matrices.m_85850_().m_252943_();
        Tesselator tesselator = Tesselator.m_85913_();
        BufferBuilder buffer = tesselator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(() -> RCoreShader.roundabout$loveTrainProgram);
        RenderSystem.setShaderTexture((int)0, (int)0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RCoreShader.roundabout$loveTrainProgram.m_173348_("FrameCount").m_5985_(((IShaderGameRenderer)Minecraft.m_91087_().f_91063_).roundabout$getFrameCount());
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        this.drawCoreCube(buffer, poseMatrix, normalMatrix, blockEntity);
        tesselator.m_85914_();
        ClientUtil.popPoseAndCooperate(matrices, 2);
    }

    private void drawCoreCube(BufferBuilder buffer, Matrix4f pose, Matrix3f normal, D4CLightBlockEntity blockEntity) {
        BlockPos origin = blockEntity.m_58899_();
        Level level = blockEntity.m_58904_();
        if (level == null) {
            return;
        }
        Direction[] directions = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST, Direction.DOWN, Direction.UP};
        Vector3f[] normals = new Vector3f[]{new Vector3f(0.0f, 0.0f, -1.0f), new Vector3f(0.0f, 0.0f, 1.0f), new Vector3f(-1.0f, 0.0f, 0.0f), new Vector3f(1.0f, 0.0f, 0.0f), new Vector3f(0.0f, -1.0f, 0.0f), new Vector3f(0.0f, 1.0f, 0.0f)};
        float[][] vertices = new float[][]{{-0.5f, -0.5f, -0.5f}, {0.5f, -0.5f, -0.5f}, {0.5f, 0.5f, -0.5f}, {-0.5f, 0.5f, -0.5f}, {-0.5f, -0.5f, 0.5f}, {0.5f, -0.5f, 0.5f}, {0.5f, 0.5f, 0.5f}, {-0.5f, 0.5f, 0.5f}};
        int[][] faces = new int[][]{{3, 2, 1, 0}, {6, 7, 4, 5}, {7, 3, 0, 4}, {2, 6, 5, 1}, {0, 1, 5, 4}, {7, 6, 2, 3}};
        float[][] uvs = new float[][]{{0.0f, 0.0f}, {1.0f, 0.0f}, {1.0f, 1.0f}, {0.0f, 1.0f}};
        for (int i = 0; i < faces.length; ++i) {
            Direction dir = directions[i];
            BlockState neighborState = level.m_8055_(origin.m_121945_(dir));
            if (neighborState.m_60734_().m_49966_().m_280296_() || neighborState.m_60734_() instanceof D4CLightBlock) continue;
            Vector3f normalVec = normals[i];
            for (int j = 0; j < 4; ++j) {
                int idx = faces[i][j];
                float[] v = vertices[idx];
                float[] uv = uvs[j];
                buffer.m_252986_(pose, v[0], v[1], v[2]).m_6122_(255, 255, 255, 255).m_7421_(uv[0], uv[1]).m_252939_(normal, normalVec.x(), normalVec.y(), normalVec.z()).m_5752_();
            }
        }
    }
}

