/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.IEnderMan;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.ModItems;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PlayerRideable;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RoadRollerEntity
extends LivingEntity
implements PlayerRideable {
    private ItemStack roadRollerItem = new ItemStack((ItemLike)ModItems.ROAD_ROLLER);
    private boolean inputLeft;
    private boolean inputRight;
    private boolean inputDown;
    private float outOfControlTicks;
    private static final Ingredient CONCRETE;
    private int explosionParticleDelay = 0;
    private byte lastCrackiness = 0;
    private double roadRollerSped = 0.0;
    private int groundedTicks = 0;
    private boolean grounded = false;
    @Nullable
    private Player pickupPlayer;
    public static final byte WHEELS = 1;
    public static final byte EXPLOSION = 2;
    public final AnimationState wheels = new AnimationState();
    public final AnimationState explode = new AnimationState();
    public LivingEntity thrower = null;
    private boolean wasOnGround = true;
    private boolean groundState = false;
    private double highestY = Double.NEGATIVE_INFINITY;
    public boolean isThrown;
    private float lastYaw = 0.0f;
    private Entity previousVehicle = null;
    public boolean hasBeenBaraged = false;
    public boolean mixingSoundStarted = false;
    public boolean explosionSoundStarted = false;
    private boolean scrapParticlesSpawned = false;
    private boolean crackinessParticlesSpawned = false;
    private boolean smokeParticlesSpawned = false;
    private boolean explosionParticlesSpawned = false;
    private boolean hitGroundBeforeExploding = false;
    private boolean explosionDamageDone = false;
    public float pickupPlayerHealth;
    int rideLengthTicks = 0;
    protected static final EntityDataAccessor<Integer> PAVING_TIMER;
    protected static final EntityDataAccessor<Boolean> PAVING_BOOLEAN;
    protected static final EntityDataAccessor<ItemStack> CONCRETE_COLOUR;
    protected static final EntityDataAccessor<Boolean> INPUT_UP;
    protected static final EntityDataAccessor<Boolean> EXPLODED;
    protected static final EntityDataAccessor<Byte> CRACKINESS;
    protected static final EntityDataAccessor<Integer> PICKUP_TIMER;
    protected static final EntityDataAccessor<Integer> PICKUP_BOOLEAN_INT;
    protected static final EntityDataAccessor<Integer> EXPLOSION_TICKS;

    public byte getAnimation() {
        if (this.getInputUp()) {
            return 1;
        }
        if (this.getExploded() && this.m_9236_().f_46443_) {
            return 2;
        }
        return 0;
    }

    public void setupAnimationStates() {
        if (!this.m_9236_().f_46443_) {
            return;
        }
        byte animation = this.getAnimation();
        if (animation == 1) {
            this.wheels.m_216982_(this.f_19797_);
        } else {
            this.wheels.m_216973_();
        }
        if (animation == 2) {
            this.explode.m_216982_(this.f_19797_);
        } else {
            this.explode.m_216973_();
        }
    }

    public RoadRollerEntity(EntityType<? extends LivingEntity> type, Level level) {
        super(type, level);
    }

    public RoadRollerEntity(Level level, LivingEntity owner, ItemStack stack, double x, double y, double z) {
        super(ModEntities.ROAD_ROLLER_ENTITY, level);
        this.roadRollerItem = stack.m_41777_();
        this.m_6034_(x, y, z);
    }

    public Iterable<ItemStack> m_6168_() {
        return Collections.emptyList();
    }

    public ItemStack m_6844_(EquipmentSlot slot) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot slot, ItemStack stack) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        return RoadRollerEntity.m_21183_().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, 0.01).m_22268_(Attributes.f_22277_, 0.0);
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public boolean m_7337_(Entity other) {
        LivingEntity le;
        block6: {
            block5: {
                block4: {
                    Entity entity = this.m_20202_();
                    if (!(entity instanceof StandEntity)) break block4;
                    StandEntity stand = (StandEntity)entity;
                    break block5;
                }
                if (!this.getExploded()) break block6;
            }
            return false;
        }
        if (other instanceof LivingEntity && ((StandUser)(le = (LivingEntity)other)).roundabout$getStandPowers().cancelCollision((Entity)this)) {
            return false;
        }
        return super.m_7337_(other);
    }

    public boolean m_5829_() {
        block4: {
            block3: {
                block2: {
                    Entity vehicle = this.m_20202_();
                    if (!(vehicle instanceof StandEntity)) break block2;
                    StandEntity stand = (StandEntity)vehicle;
                    break block3;
                }
                if (!this.getExploded()) break block4;
            }
            return false;
        }
        return super.m_5829_();
    }

    public boolean m_6094_() {
        if (this.getExploded()) {
            return false;
        }
        return !(this.m_20202_() instanceof StandEntity) && super.m_6094_();
    }

    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
    }

    protected float m_6431_(Pose $$0, EntityDimensions $$1) {
        return 0.65f;
    }

    public void setLastYaw(float yaw) {
        this.lastYaw = yaw;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        this.m_5834_();
        return super.m_6469_(source, amount);
    }

    public boolean m_5825_() {
        return true;
    }

    public void m_20254_(int seconds) {
    }

    public void m_6667_(DamageSource $$0) {
        if (this.hasBeenBaraged && this.isThrown && this.thrower != null) {
            this.setExploded(true);
            this.f_20919_ = 0;
        }
        super.m_6667_($$0);
    }

    protected void m_6153_() {
        if (!this.getExploded()) {
            this.explosionParticleDelay = 0;
        }
        if (!this.m_9236_().f_46443_ && this.getExploded()) {
            this.setExplosionTicks(this.getExplosionTicks() + 1);
        }
        if (this.getExploded()) {
            if (this.f_20919_ == 0) {
                this.explode.m_216982_(this.f_19797_);
            }
            if (this.getExploded() && this.hitGroundBeforeExploding && !this.m_9236_().f_46443_) {
                ++this.explosionParticleDelay;
                if (this.explosionParticleDelay == 10) {
                    BlockPos center = this.m_20183_();
                    RandomSource random = this.m_9236_().m_213780_();
                    int radius = 8;
                    for (int x = -radius; x <= radius; ++x) {
                        for (int z = -radius; z <= radius; ++z) {
                            double distSq = x * x + z * z;
                            if (!(distSq <= (double)(radius * radius)) || !(random.m_188501_() < 0.5f)) continue;
                            BlockPos firePos = center.m_7918_(x, 0, z);
                            BlockState below = this.m_9236_().m_8055_(firePos.m_7495_());
                            if (!below.m_280296_() || !this.m_9236_().m_46859_(firePos)) continue;
                            this.m_9236_().m_7731_(firePos, Blocks.f_50083_.m_49966_(), 11);
                        }
                    }
                }
            }
            if (this.f_20919_ < 300) {
                ++this.f_20919_;
                return;
            }
            super.m_6667_(this.m_269291_().m_269264_());
            this.m_142687_(Entity.RemovalReason.KILLED);
        } else {
            super.m_6153_();
        }
    }

    protected void onHitEntity(EntityHitResult hitResult) {
        if (!this.m_9236_().m_5776_()) {
            Entity entity = hitResult.m_82443_();
            if (entity instanceof EnderMan) {
                EnderMan em = (EnderMan)entity;
                ((IEnderMan)em).roundabout$teleport();
                return;
            }
            if (this.f_19794_) {
                return;
            }
            double roadRollerSped = this.m_20184_().m_82553_();
            if (roadRollerSped < 1.0) {
                return;
            }
            float damage = 5.0f;
            float aboveDamage = 14.0f;
            double fallDistance = this.highestY - this.m_20186_();
            if (fallDistance > 2.0 && this.m_20184_().f_82480_ < -1.0) {
                damage = aboveDamage;
            }
            if (this.thrower != null) {
                DamageSource src = ModDamageTypes.of(this.m_9236_(), ModDamageTypes.ROAD_ROLLER, (Entity)this, (Entity)this.thrower);
                hitResult.m_82443_().m_6469_(src, damage);
            }
        }
    }

    public boolean m_6673_(DamageSource source) {
        if (source.m_276093_(DamageTypes.f_268612_) || source.m_276093_(DamageTypes.f_268722_) || source.m_276093_(DamageTypes.f_268444_) || source.m_276093_(DamageTypes.f_268434_) || source.m_276093_(DamageTypes.f_268469_) || source.m_276093_(DamageTypes.f_268493_) || source.m_276093_(DamageTypes.f_268585_) || source.m_276093_(DamageTypes.f_268631_) || source.m_276093_(DamageTypes.f_268468_)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public boolean m_6040_() {
        return true;
    }

    public void radialExplosion(@Nullable LivingEntity mainTarget) {
        if (this.explosionParticleDelay == 10 && !this.m_9236_().m_5776_() && !this.explosionDamageDone) {
            this.explosionDamageDone = true;
            List<Entity> entityList = DamageHandler.genHitbox(mainTarget, this.m_20185_(), this.m_20186_(), this.m_20189_(), 12.0, 12.0, 12.0);
            if (!entityList.isEmpty()) {
                for (Entity value : entityList) {
                    if (!value.m_6087_() || !value.m_6084_()) continue;
                    DamageSource src = ModDamageTypes.of(this.m_9236_(), ModDamageTypes.ROAD_ROLLER, (Entity)this, (Entity)this.thrower);
                    value.m_6469_(src, 20.0f);
                }
            }
        }
    }

    public void pickUpRoadRoller(Player player, ItemStack itemStack) {
        if (!this.m_9236_().f_46443_) {
            ItemStack copy = new ItemStack((ItemLike)ModItems.ROAD_ROLLER);
            if (player.m_36356_(copy)) {
                this.setPickupBoolean(0);
                this.setPickupTimer(0);
                this.m_146870_();
            }
        } else {
            ClientUtil.setRoadRollerPickingEntity(null);
        }
    }

    public void m_8119_() {
        int x;
        byte previous;
        byte current;
        super.m_8119_();
        if (this.m_6688_() == null) {
            this.m_146922_(this.f_19859_);
            this.f_20883_ = this.f_19859_;
            this.f_20885_ = this.f_19859_;
        }
        if (!this.m_9236_().m_5776_()) {
            this.sendOutMessage();
        }
        if (!this.m_9236_().f_46443_ && this.getPavingBoolean()) {
            if (this.getPavingTimer() == 800) {
                this.setPavingTimer(0);
                this.setPavingBoolean(false);
            } else if (this.getPavingTimer() > -1) {
                this.setPavingTimer(this.getPavingTimer() + 1);
            }
        }
        if (this.m_9236_().m_5776_() && this.f_19797_ % 60 == 1 && !((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this)) {
            ClientUtil.handleRoadRollerAmbientSound((Entity)this);
        }
        if (!this.m_9236_().f_46443_ && this.isThrown && this.f_19797_ % 180 == 0) {
            this.thrower = null;
        }
        if (!this.m_9236_().f_46443_ && this.m_20096_()) {
            this.hitGroundBeforeExploding = true;
        }
        if (this.getPickupBoolean() > 0) {
            if (this.getPickupTimer() < 100) {
                this.setPickupTimer(this.getPickupTimer() + 1);
            } else if (this.getPickupTimer() == 100) {
                if (!this.m_9236_().f_46443_ && this.pickupPlayer != null) {
                    this.pickUpRoadRoller(this.pickupPlayer, this.roadRollerItem);
                }
                if (this.pickupPlayer != null) {
                    this.setPickupBoolean(this.pickupPlayer.m_19879_());
                } else {
                    this.setPickupBoolean(0);
                }
                this.setPickupTimer(0);
                this.pickupPlayer = null;
            }
        }
        if (!this.m_9236_().f_46443_ && this.pickupPlayer != null) {
            if (this.m_20270_((Entity)this.pickupPlayer) > 3.0f || ((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this) || this.pickupPlayer.m_21223_() < this.pickupPlayerHealth) {
                this.pickupPlayerHealth = this.pickupPlayer.m_21223_();
                this.pickupPlayer = null;
                this.setPickupBoolean(0);
                this.setPickupTimer(0);
            } else {
                this.pickupPlayerHealth = this.pickupPlayer.m_21223_();
            }
        }
        if (!this.m_9236_().f_46443_) {
            if (this.m_20096_()) {
                ++this.groundedTicks;
                if (this.groundedTicks >= 20) {
                    this.grounded = true;
                }
            } else {
                this.groundedTicks = 0;
                this.grounded = false;
            }
        }
        if (this.m_9236_().m_5776_() && this.getExploded() && this.explosionParticleDelay >= 10 && !((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this) && !this.explosionSoundStarted) {
            this.explosionSoundStarted = true;
            ClientUtil.handleRoadRollerExplosionSound((Entity)this);
        }
        if (this.m_9236_().f_46443_ && this.getPickupBoolean() > 0) {
            ClientUtil.setRoadRollerPickingEntity(this);
        }
        if (!this.m_9236_().f_46443_ && this.getExploded()) {
            this.radialExplosion(this);
        }
        if (this.m_9236_().f_46443_ && this.getExploded()) {
            int ticks = this.getExplosionTicks();
            ++this.explosionParticleDelay;
            if (ticks == 10) {
                double vz;
                double vy;
                double vx;
                int i;
                if (!this.scrapParticlesSpawned) {
                    this.scrapParticlesSpawned = true;
                    for (i = 0; i < 15; ++i) {
                        vx = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                        vy = this.f_19796_.m_188500_() * 0.6;
                        vz = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                        this.m_9236_().m_7106_((ParticleOptions)ModParticles.ROAD_ROLLER_SCRAP, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), vx, vy, vz);
                    }
                }
                if (!this.smokeParticlesSpawned) {
                    this.smokeParticlesSpawned = true;
                    for (i = 0; i < 40; ++i) {
                        vx = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                        vy = this.f_19796_.m_188500_() * 0.6;
                        vz = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                        this.m_9236_().m_7106_((ParticleOptions)ModParticles.ROAD_ROLLER_SMOKE, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), vx, vy, vz);
                    }
                }
                if (!this.explosionParticlesSpawned) {
                    this.explosionParticlesSpawned = true;
                    for (i = 0; i < 40; ++i) {
                        vx = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                        vy = this.f_19796_.m_188500_() * 0.6;
                        vz = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                        this.m_9236_().m_7106_((ParticleOptions)ModParticles.ROAD_ROLLER_EXPLOSION, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), vx, vy, vz);
                    }
                }
            }
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        }
        if (!this.m_9236_().f_46443_) {
            float fraction = this.m_21223_() / this.m_21233_();
            this.setCrackiness(Crackiness.byHealthFraction(fraction));
        }
        if (this.m_9236_().f_46443_ && (current = this.getCrackiness()) != (previous = this.lastCrackiness)) {
            this.lastCrackiness = current;
            if (!this.crackinessParticlesSpawned) {
                this.crackinessParticlesSpawned = true;
                for (int i = 0; i < 5; ++i) {
                    double vx = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                    double vy = this.f_19796_.m_188500_() * 0.6;
                    double vz = (this.f_19796_.m_188500_() - 0.5) * 1.2;
                    this.m_9236_().m_7106_((ParticleOptions)ModParticles.ROAD_ROLLER_SCRAP, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), vx, vy, vz);
                }
            }
        }
        if (!this.m_9236_().f_46443_) {
            VoxelShape shape;
            AABB box = this.m_20191_();
            boolean bottomInsideBlock = false;
            double cx = box.m_82399_().f_82479_;
            double cz = box.m_82399_().f_82481_;
            int y = Mth.m_14107_((double)(box.f_82289_ - 0.05));
            BlockPos bp = new BlockPos(Mth.m_14107_((double)cx), y, Mth.m_14107_((double)cz));
            BlockState state = this.m_9236_().m_8055_(bp);
            if (!state.m_60795_() && !(shape = state.m_60812_((BlockGetter)this.m_9236_(), bp)).m_83281_() && shape.m_83297_(Direction.Axis.Y) > box.f_82289_ - (double)y) {
                bottomInsideBlock = true;
            }
            if (bottomInsideBlock) {
                for (int tries = 0; bottomInsideBlock && tries < 5; ++tries) {
                    this.m_6021_(this.m_20185_(), this.m_20186_() + 0.05, this.m_20189_());
                    this.m_6210_();
                    bottomInsideBlock = !this.m_9236_().m_45786_((Entity)this);
                }
                if (bottomInsideBlock) {
                    this.m_6021_(this.m_20185_(), this.m_20186_() + 0.1, this.m_20189_());
                    this.m_6210_();
                }
            }
        }
        if (this.m_9236_().f_46443_ && this.getPavingBoolean()) {
            RandomSource random = this.m_9236_().m_213780_();
            float yaw = this.m_5675_(1.0f);
            if (yaw == 0.0f && this.lastYaw != 0.0f) {
                yaw = this.lastYaw;
            } else {
                this.lastYaw = yaw;
            }
            float yawRad = (float)Math.toRadians(yaw);
            float cos = Mth.m_14089_((float)yawRad);
            float sin = Mth.m_14031_((float)yawRad);
            double rightX = cos;
            double rightZ = sin;
            double fwdX = -sin;
            double fwdZ = cos;
            double forwardOffset = 0.12;
            for (int i = 0; i < 4; ++i) {
                double localX = (random.m_188500_() - 0.5) * 1.8;
                double localZ = (random.m_188500_() - 1.75) * 1.8;
                localX = -localX;
                double offsetX = localX * rightX + localZ * fwdX;
                double offsetZ = localX * rightZ + localZ * fwdZ;
                double x2 = this.m_20185_() + (offsetX += fwdX * forwardOffset);
                double y = this.m_20186_() + 2.4 + random.m_188500_() * 0.3;
                double z = this.m_20189_() + (offsetZ += fwdZ * forwardOffset);
                double vy = 0.05 + random.m_188500_() * 0.02;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, x2, y, z, 0.0, vy, 0.0);
            }
        }
        Entity currentVehicle = this.m_20202_();
        if (!(this.previousVehicle instanceof StandEntity) && currentVehicle instanceof StandEntity) {
            this.setLastYaw(this.m_146908_());
        }
        this.previousVehicle = currentVehicle;
        Vec3 currentPos = this.m_20182_();
        Vec3 nextPos = currentPos.m_82549_(this.m_20184_());
        AABB sweptBox = this.m_20191_().m_82369_(this.m_20184_()).m_82400_((double)(this.m_20205_() * 1.0f) + 0.1);
        EntityHitResult entityHitResult = ProjectileUtil.m_37304_((Level)this.m_9236_(), (Entity)this, (Vec3)currentPos, (Vec3)nextPos, (AABB)sweptBox, this::canHitEntity);
        if (entityHitResult != null) {
            this.onHitEntity(entityHitResult);
        }
        AABB box = this.m_20191_().m_82400_(1.0);
        for (Entity e : this.m_9236_().m_6249_((Entity)this, box, this::canHitEntity)) {
            this.onHitEntity(new EntityHitResult(e));
        }
        boolean onGroundNow = this.m_20096_();
        double highestYValue = this.m_20186_();
        if (this.wasOnGround && !onGroundNow) {
            this.isThrown = true;
            this.highestY = highestYValue;
        }
        if (this.isThrown && highestYValue > this.highestY) {
            this.highestY = highestYValue;
        }
        this.wasOnGround = onGroundNow;
        if (this.m_6688_() == null) {
            this.setInputUp(false);
            this.inputDown = false;
            this.inputLeft = false;
            this.inputRight = false;
        }
        if (!this.m_9236_().f_46443_) {
            if (!this.m_9236_().m_46469_().m_46207_(ModGamerules.ROUNDABOUT_ROAD_ROLLER_BREAK_ICE)) {
                return;
            }
            if (this.m_20202_() instanceof StandEntity) {
                return;
            }
            BlockPos basePos = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, -0.5, 0.0));
            for (x = -1; x <= 1; ++x) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos blockPos = basePos.m_7918_(x, 0, z);
                    BlockState state = this.m_9236_().m_8055_(blockPos);
                    if (!state.m_60713_(Blocks.f_50126_) && !state.m_60713_(Blocks.f_50354_) && !state.m_60713_(Blocks.f_50568_) && !state.m_60713_(Blocks.f_50449_)) continue;
                    this.m_9236_().m_46961_(blockPos, false);
                }
            }
        }
        if (!this.getInputUp()) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            BlockPos sigmaPos;
            boolean willRaise = this.getPavingBoolean();
            if (willRaise) {
                block9: for (x = -1; x <= 1; ++x) {
                    for (int z = -1; z <= 1; ++z) {
                        sigmaPos = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, -0.5, 0.0));
                        BlockPos bp = sigmaPos.m_7918_(x, 0, z);
                        BlockState s = this.m_9236_().m_8055_(bp);
                        if (!s.m_60713_(Blocks.f_152481_)) continue;
                        willRaise = true;
                        break block9;
                    }
                }
            }
            if (willRaise) {
                double dy = 0.0626;
                this.m_6021_(this.m_20185_(), this.m_20186_() + dy, this.m_20189_());
            }
            for (int x3 = -1; x3 <= 1; ++x3) {
                for (int z = -1; z <= 1; ++z) {
                    sigmaPos = BlockPos.m_274446_((Position)this.m_20182_().m_82520_(0.0, -0.5, 0.0));
                    BlockPos blockPos = sigmaPos.m_7918_(x3, 0, z);
                    BlockState state = this.m_9236_().m_8055_(blockPos);
                    if (!state.m_60713_(Blocks.f_50440_) && !state.m_60713_(Blocks.f_50493_) && !state.m_60713_(Blocks.f_152481_)) continue;
                    if (!this.getPavingBoolean()) {
                        this.m_9236_().m_7731_(blockPos, Blocks.f_152481_.m_49966_(), 3);
                        continue;
                    }
                    ResourceLocation itemID = BuiltInRegistries.f_257033_.m_7981_((Object)this.getConcreteColour().m_41720_());
                    if (itemID == null) continue;
                    String fixedString = itemID.m_135815_().replace("_powder", "");
                    ResourceLocation blockID = new ResourceLocation(itemID.m_135827_(), fixedString);
                    Block actualConcrete = BuiltInRegistries.f_256975_.m_6612_(blockID).orElse(Blocks.f_50505_);
                    this.m_9236_().m_7731_(blockPos, actualConcrete.m_49966_(), 3);
                }
            }
        }
    }

    protected boolean canHitEntity(Entity $$0x) {
        if ($$0x == this.thrower) {
            return false;
        }
        return $$0x != this;
    }

    public float getLastYaw() {
        return this.lastYaw;
    }

    public void m_7324_(Entity $$0) {
        block4: {
            block3: {
                block2: {
                    Entity entity = this.m_20202_();
                    if (!(entity instanceof StandEntity)) break block2;
                    StandEntity stand = (StandEntity)entity;
                    break block3;
                }
                if (!this.getExploded()) break block4;
            }
            return;
        }
        super.m_7324_($$0);
    }

    public void sendOutMessage() {
        LivingEntity cpas = this.m_6688_();
        if (cpas instanceof ServerPlayer) {
            ServerPlayer SP = (ServerPlayer)cpas;
            ++this.rideLengthTicks;
            if (this.rideLengthTicks == 40) {
                SP.m_5661_((Component)Component.m_237115_((String)"text.roundabout.riding_road_roller").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            }
        } else {
            this.rideLengthTicks = 0;
        }
    }

    public void m_7334_(Entity $$0) {
        Entity entity = this.m_20202_();
        if (entity instanceof StandEntity) {
            StandEntity stand = (StandEntity)entity;
            return;
        }
        super.m_7334_($$0);
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (!this.isThrown) {
            return;
        }
        if ($$0 == this.m_6688_()) {
            return;
        }
        if ($$0 == this.m_20202_() || this.m_20365_($$0)) {
            return;
        }
        if (this.f_19794_ || $$0.f_19794_) {
            return;
        }
        Vec3 dir = this.m_20184_();
        if (dir.m_82556_() > 1.0E-4) {
            Vec3 n = dir.m_82541_();
            $$0.m_5997_(n.f_82479_ * 0.1, 0.2, n.f_82481_ * 0.1);
        }
    }

    protected float m_245547_(Player $$0) {
        return (float)(this.m_21133_(Attributes.f_22279_) * 0.0);
    }

    protected void m_274498_(Player $$0, Vec3 $$1) {
        super.m_274498_($$0, $$1);
        Vec2 $$2 = this.getRiddenRotation((LivingEntity)$$0);
        this.m_19915_($$2.f_82471_, $$2.f_82470_);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        Vec3 $$4 = this.m_20184_();
        if (!this.getInputUp()) {
            this.m_20256_($$4.m_82542_(0.85, 1.0, 0.85));
            return;
        }
        if (this.m_20096_()) {
            float sin = Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            float cos = Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)));
            this.m_20256_($$4.m_82520_((double)(-0.06f * sin), 0.0, (double)(0.06f * cos)));
        } else {
            this.m_20256_($$4.m_82542_(0.98, 1.0, 0.98));
        }
    }

    public double m_6048_() {
        return this.m_20206_() * 0.7f;
    }

    protected void m_19956_(Entity passenger, Entity.MoveFunction move) {
        double backOffset = 0.7;
        float yawRad = (float)Math.toRadians(this.m_146908_());
        double x = this.m_20185_() + (double)Mth.m_14031_((float)yawRad) * backOffset;
        double y = this.m_20186_() + 0.95;
        double z = this.m_20189_() - (double)Mth.m_14089_((float)yawRad) * backOffset;
        passenger.m_6034_(x, y, z);
    }

    public boolean m_142535_(float $$0, float $$1, DamageSource $$2) {
        int $$3;
        if ($$0 > 1.0f) {
            // empty if block
        }
        if (($$3 = this.m_5639_($$0, $$1)) <= 0) {
            return false;
        }
        this.m_6469_($$2, $$3);
        this.m_21229_();
        return true;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity;
        if (!this.m_20197_().isEmpty() && (entity = (Entity)this.m_20197_().get(0)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public float m_274421_() {
        float f = super.m_274421_();
        return this.m_6688_() instanceof Player ? Math.max(f, 1.5f) : f;
    }

    public void m_7601_(BlockState $$0, Vec3 $$1) {
        if (!$$0.m_60713_(Blocks.f_50033_)) {
            super.m_7601_($$0, $$1);
        }
    }

    protected Vec2 getRiddenRotation(LivingEntity $$0) {
        return new Vec2($$0.m_146909_() * 0.5f, $$0.m_146908_());
    }

    protected Vec3 m_274312_(Player $$0, Vec3 $$1) {
        boolean pressed;
        float forward = $$0.f_20902_;
        boolean bl = pressed = forward > 0.0f;
        if (!this.m_9236_().f_46443_) {
            this.setInputUp(pressed);
        }
        boolean bl2 = this.inputDown = forward < 0.0f;
        if (forward <= 0.0f) {
            forward *= 0.25f;
        }
        return Vec3.f_82478_;
    }

    protected void doPlayerRide(Player $$0) {
        if (!this.m_9236_().f_46443_) {
            $$0.m_146922_(this.m_146908_());
            $$0.m_146926_(this.m_146909_());
            $$0.m_20329_((Entity)this);
        }
    }

    @Nullable
    private Vec3 getDismountLocationInDirection(Vec3 $$0, LivingEntity $$1) {
        double $$2 = this.m_20185_() + $$0.f_82479_;
        double $$3 = this.m_20191_().f_82289_;
        double $$4 = this.m_20189_() + $$0.f_82481_;
        BlockPos.MutableBlockPos $$5 = new BlockPos.MutableBlockPos();
        block0: for (Pose $$6 : $$1.m_7431_()) {
            $$5.m_122169_($$2, $$3, $$4);
            double $$7 = this.m_20191_().f_82292_ + 0.75;
            do {
                double $$8 = this.m_9236_().m_45573_((BlockPos)$$5);
                if ((double)$$5.m_123342_() + $$8 > $$7) continue block0;
                if (DismountHelper.m_38439_((double)$$8)) {
                    AABB $$9 = $$1.m_21270_($$6);
                    Vec3 $$10 = new Vec3($$2, (double)$$5.m_123342_() + $$8, $$4);
                    if (DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)$$1, (AABB)$$9.m_82383_($$10))) {
                        $$1.m_20124_($$6);
                        return $$10;
                    }
                }
                $$5.m_122173_(Direction.UP);
            } while (!((double)$$5.m_123342_() < $$7));
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity $$0) {
        Vec3 $$1 = RoadRollerEntity.m_19903_((double)this.m_20205_(), (double)$$0.m_20205_(), (float)(this.m_146908_() + ($$0.m_5737_() == HumanoidArm.RIGHT ? 90.0f : -90.0f)));
        Vec3 $$2 = this.getDismountLocationInDirection($$1, $$0);
        if ($$2 != null) {
            return $$2;
        }
        Vec3 $$3 = RoadRollerEntity.m_19903_((double)this.m_20205_(), (double)$$0.m_20205_(), (float)(this.m_146908_() + ($$0.m_5737_() == HumanoidArm.LEFT ? 90.0f : -90.0f)));
        Vec3 $$4 = this.getDismountLocationInDirection($$3, $$0);
        return $$4 != null ? $$4 : this.m_20182_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PAVING_TIMER, (Object)0);
        this.f_19804_.m_135372_(PAVING_BOOLEAN, (Object)false);
        this.f_19804_.m_135372_(CONCRETE_COLOUR, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(INPUT_UP, (Object)false);
        this.f_19804_.m_135372_(EXPLODED, (Object)false);
        this.f_19804_.m_135372_(CRACKINESS, (Object)0);
        this.f_19804_.m_135372_(PICKUP_TIMER, (Object)0);
        this.f_19804_.m_135372_(PICKUP_BOOLEAN_INT, (Object)-1);
        this.f_19804_.m_135372_(EXPLOSION_TICKS, (Object)0);
    }

    public final void setPavingTimer(int PavingTimer) {
        this.f_19804_.m_135381_(PAVING_TIMER, (Object)PavingTimer);
    }

    public int getPavingTimer() {
        return (Integer)this.f_19804_.m_135370_(PAVING_TIMER);
    }

    public void setPavingBoolean(boolean value) {
        this.f_19804_.m_135381_(PAVING_BOOLEAN, (Object)value);
    }

    public boolean getPavingBoolean() {
        return (Boolean)this.f_19804_.m_135370_(PAVING_BOOLEAN);
    }

    public ItemStack getConcreteColour() {
        return (ItemStack)this.f_19804_.m_135370_(CONCRETE_COLOUR);
    }

    public void setConcreteColour(ItemStack stack) {
        this.f_19804_.m_135381_(CONCRETE_COLOUR, (Object)stack.m_41777_());
    }

    public void setInputUp(boolean value) {
        this.f_19804_.m_135381_(INPUT_UP, (Object)value);
    }

    public boolean getInputUp() {
        return (Boolean)this.f_19804_.m_135370_(INPUT_UP);
    }

    public void setExploded(boolean value) {
        this.f_19804_.m_135381_(EXPLODED, (Object)value);
    }

    public boolean getExploded() {
        return (Boolean)this.f_19804_.m_135370_(EXPLODED);
    }

    public byte getCrackiness() {
        return (Byte)this.f_19804_.m_135370_(CRACKINESS);
    }

    public void setCrackiness(byte level) {
        this.f_19804_.m_135381_(CRACKINESS, (Object)level);
    }

    public final void setPickupTimer(int PickupTimer) {
        this.f_19804_.m_135381_(PICKUP_TIMER, (Object)PickupTimer);
    }

    public int getPickupTimer() {
        return (Integer)this.f_19804_.m_135370_(PICKUP_TIMER);
    }

    public void setPickupBoolean(int value) {
        this.f_19804_.m_135381_(PICKUP_BOOLEAN_INT, (Object)value);
    }

    public int getPickupBoolean() {
        return (Integer)this.f_19804_.m_135370_(PICKUP_BOOLEAN_INT);
    }

    public void setExplosionTicks(int ticks) {
        this.f_19804_.m_135381_(EXPLOSION_TICKS, (Object)ticks);
    }

    public int getExplosionTicks() {
        return (Integer)this.f_19804_.m_135370_(EXPLOSION_TICKS);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6096_(Player $$0, InteractionHand $$1) {
        boolean wasPaving = this.getPavingBoolean();
        if (this.getExploded()) {
            return InteractionResult.FAIL;
        }
        if (((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this)) {
            return InteractionResult.FAIL;
        }
        if (this.m_20202_() instanceof StandEntity) {
            return InteractionResult.FAIL;
        }
        boolean concreteEnabled = false;
        boolean pickupEnabled = false;
        ItemStack item = $$0.m_21120_($$1);
        if ($$0.m_6047_() && !this.isConcrete(item)) {
            if (this.pickupPlayer != null) {
                return InteractionResult.FAIL;
            }
            if (this.getCrackiness() != 0) {
                return InteractionResult.FAIL;
            }
            pickupEnabled = true;
            this.setPickupTimer(0);
            this.pickupPlayer = $$0;
            this.setPickupBoolean(this.pickupPlayer != null ? this.pickupPlayer.m_19879_() : 0);
        }
        if (this.pickupPlayer != null) {
            return InteractionResult.FAIL;
        }
        if (this.isConcrete(item)) {
            concreteEnabled = true;
            if (this.getPavingBoolean()) {
                ItemStack current = this.getConcreteColour();
                if (!ItemStack.m_150942_((ItemStack)current, (ItemStack)item)) {
                    this.setConcreteColour(item);
                }
                if (this.m_9236_().f_46443_) {
                    if (this.getPavingBoolean() && !((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this)) {
                        this.mixingSoundStarted = true;
                        ClientUtil.stopRoadRollerMixingSound((Entity)this);
                        ClientUtil.handleRoadRollerMixingSound((Entity)this);
                    } else if (!this.getPavingBoolean()) {
                        this.mixingSoundStarted = false;
                        ClientUtil.stopRoadRollerMixingSound((Entity)this);
                    }
                }
                this.setPavingTimer(0);
            } else {
                this.setConcreteColour(item);
                this.setPavingBoolean(true);
                if (this.m_9236_().f_46443_) {
                    if (this.getPavingBoolean() && !((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this)) {
                        this.mixingSoundStarted = true;
                        ClientUtil.stopRoadRollerMixingSound((Entity)this);
                        ClientUtil.handleRoadRollerMixingSound((Entity)this);
                    } else if (!this.getPavingBoolean()) {
                        this.mixingSoundStarted = false;
                        ClientUtil.stopRoadRollerMixingSound((Entity)this);
                    }
                }
                this.setPavingTimer(0);
            }
            if ($$0.m_150110_().f_35937_ || this.m_9236_().f_46443_) return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            item.m_41774_(1);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if ($$0.m_20365_((Entity)this)) {
            return InteractionResult.PASS;
        }
        if ($$0.m_36341_()) {
            return InteractionResult.PASS;
        }
        if (!(this.outOfControlTicks < 60.0f)) return InteractionResult.PASS;
        if (this.m_9236_().f_46443_) return InteractionResult.SUCCESS;
        if (!concreteEnabled) {
            return $$0.m_20329_((Entity)this) ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (!concreteEnabled) return InteractionResult.PASS;
        this.setPavingBoolean(true);
        return InteractionResult.PASS;
    }

    public boolean isConcrete(ItemStack itemStack) {
        return CONCRETE.test(itemStack);
    }

    static {
        PAVING_TIMER = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PAVING_BOOLEAN = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        CONCRETE_COLOUR = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
        INPUT_UP = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        EXPLODED = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
        CRACKINESS = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
        PICKUP_TIMER = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        PICKUP_BOOLEAN_INT = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        EXPLOSION_TICKS = SynchedEntityData.m_135353_(RoadRollerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        CONCRETE = Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42278_, Items.f_42277_, Items.f_42326_, Items.f_42319_, Items.f_42325_, Items.f_42317_, Items.f_42316_, Items.f_42318_, Items.f_42322_, Items.f_42323_, Items.f_42320_, Items.f_42327_, Items.f_42324_, Items.f_42328_, Items.f_42321_, Items.f_42315_});
    }

    public static class Crackiness {
        public static final byte NONE = 0;
        public static final byte MEDIUM = 1;
        public static final byte HIGH = 2;

        public static byte byHealthFraction(float fraction) {
            if (fraction < 0.25f) {
                return 2;
            }
            if (fraction < 0.5f) {
                return 1;
            }
            return 0;
        }
    }
}

