/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity.client;

import com.mojang.authlib.GameProfile;
import java.util.stream.Stream;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.Input;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LocalPlayer.class}, priority=104)
public abstract class GravityLocalPlayerMixin
extends AbstractClientPlayer {
    @Shadow
    private int f_108613_;
    @Shadow
    public Input f_108618_;

    public GravityLocalPlayerMixin(ClientLevel world, GameProfile profile) {
        super(world, profile);
    }

    @Shadow
    protected abstract boolean m_108746_(BlockPos var1);

    @Shadow
    protected abstract void m_108743_(float var1, float var2);

    @Shadow
    protected abstract boolean m_108731_();

    @Inject(method={"suffocatesAt(Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$collision(BlockPos pos, CallbackInfoReturnable<Boolean> cir) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        AABB $$1 = this.m_20191_();
        AABB playerBox = this.m_20191_();
        Vec3 playerMask = RotationUtil.maskPlayerToWorld(0.0, 1.0, 0.0, gravityDirection);
        AABB posBox = new AABB(pos);
        Vec3 posMask = RotationUtil.maskPlayerToWorld(1.0, 0.0, 1.0, gravityDirection);
        AABB $$2 = new AABB(playerMask.m_82542_(playerBox.f_82288_, playerBox.f_82289_, playerBox.f_82290_).m_82549_(posMask.m_82542_(posBox.f_82288_, posBox.f_82289_, posBox.f_82290_)), playerMask.m_82542_(playerBox.f_82291_, playerBox.f_82292_, playerBox.f_82293_).m_82549_(posMask.m_82542_(posBox.f_82291_, posBox.f_82292_, posBox.f_82293_))).m_82406_(1.0E-7);
        cir.setReturnValue((Object)this.m_9236_().m_186437_((Entity)this, $$2));
    }

    @Inject(method={"move"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$updateAutoJumpmove(MoverType $$0, Vec3 $$1, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        if (gravityDirection == Direction.NORTH || gravityDirection == Direction.SOUTH) {
            double $$2 = this.m_20185_();
            double $$3 = this.m_20186_();
            super.m_6478_($$0, $$1);
            this.m_108743_((float)(this.m_20185_() - $$2), (float)(this.m_20186_() - $$3));
        } else if (gravityDirection == Direction.EAST || gravityDirection == Direction.WEST) {
            double $$2 = this.m_20186_();
            double $$3 = this.m_20189_();
            super.m_6478_($$0, $$1);
            this.m_108743_((float)(this.m_20186_() - $$2), (float)(this.m_20189_() - $$3));
        } else {
            double $$2 = this.m_20185_();
            double $$3 = this.m_20189_();
            super.m_6478_($$0, $$1);
            this.m_108743_((float)(this.m_20185_() - $$2), (float)(this.m_20189_() - $$3));
        }
    }

    @Inject(method={"updateAutoJump(FF)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$updateAutoJump(float $$0, float $$1, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
    }

    @Inject(method={"moveTowardsClosestSpace(DD)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void rdbt$inject_pushOutOfBlocks(double x, double z, CallbackInfo ci) {
        Direction gravityDirection = GravityAPI.getGravityDirection((Entity)this);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        ci.cancel();
        Vec3 pos = RotationUtil.vecPlayerToWorld(x - this.m_20185_(), 0.0, z - this.m_20189_(), gravityDirection).m_82549_(this.m_20182_());
        BlockPos blockPos = BlockPos.m_274446_((Position)pos);
        if (this.m_108746_(blockPos)) {
            Direction[] directions;
            double dx = pos.f_82479_ - (double)blockPos.m_123341_();
            double dy = pos.f_82480_ - (double)blockPos.m_123342_();
            double dz = pos.f_82481_ - (double)blockPos.m_123343_();
            Direction direction = null;
            double minDistToEdge = Double.MAX_VALUE;
            for (Direction playerDirection : directions = new Direction[]{Direction.WEST, Direction.EAST, Direction.NORTH, Direction.SOUTH}) {
                double distToEdge;
                Direction worldDirection = RotationUtil.dirPlayerToWorld(playerDirection, gravityDirection);
                double g = worldDirection.m_122434_().m_6150_(dx, dy, dz);
                double d = distToEdge = worldDirection.m_122421_() == Direction.AxisDirection.POSITIVE ? 1.0 - g : g;
                if (!(distToEdge < minDistToEdge) || this.m_108746_(blockPos.m_121945_(worldDirection))) continue;
                minDistToEdge = distToEdge;
                direction = playerDirection;
            }
            if (direction != null) {
                Vec3 velocity = this.m_20184_();
                if (direction.m_122434_() == Direction.Axis.X) {
                    this.m_20334_(0.1 * (double)direction.m_122429_(), velocity.f_82480_, velocity.f_82481_);
                } else if (direction.m_122434_() == Direction.Axis.Z) {
                    this.m_20334_(velocity.f_82479_, velocity.f_82480_, 0.1 * (double)direction.m_122431_());
                }
            }
        }
    }

    private static /* synthetic */ Stream lambda$rdbt$updateAutoJump$1(VoxelShape $$0x) {
        return $$0x.m_83299_().stream();
    }

    private static /* synthetic */ Stream lambda$rdbt$updateAutoJump$0(VoxelShape $$0x) {
        return $$0x.m_83299_().stream();
    }
}

