/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.ThrownWaterBottleEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.stand.SurvivorEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.CooldownInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.SplashPotionItem;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.phys.Vec3;

public class PowersSurvivor
extends NewDashPreset {
    public List<SurvivorEntity> survivorsSpawned = new ArrayList<SurvivorEntity>();
    public StandEntity displayStand = null;
    public SurvivorEntity SurvivorTarget = null;
    public Entity EntityTargetOne = null;
    public Entity EntityTargetTwo = null;
    public int lastPlacementTime = -1;
    boolean thisistheend = false;
    SurvivorEntity tempstand = null;
    public int meltDodgeTicks = -1;
    public static final byte BASE = 1;
    public static final byte GREEN = 2;
    public static final byte RED = 3;
    public static final byte PURPLE = 4;
    public static final byte BLUE = 5;
    public static final byte SILVER = 6;
    public static final byte GHAST = 7;
    public static final byte ENDER = 8;
    public static final byte CONDUIT = 9;
    public static final byte CAKE = 10;
    public static final byte SPONGE = 11;
    public static final byte SCULK = 12;
    public static final byte PLACE = 61;
    public static final byte RETRACT = 62;
    public static final byte SHOCK = 63;
    boolean holdAttack = false;

    public PowersSurvivor(LivingEntity self) {
        super(self);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().survivorSettings.enableSurvivor;
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersSurvivor(entity);
    }

    @Override
    public boolean interceptAttack() {
        return this.angerSelectionMode();
    }

    public boolean angerSelectionMode() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.BOTTLE, (byte)0);
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.DESPAWN, (byte)-1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.SPAWN, (byte)1);
        }
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            if (this.angerSelectionMode()) {
                this.setSkillIcon(context, x, y, 4, StandIcons.CUPID_ON, (byte)3);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.RAGE_SELECTION, (byte)3);
            }
        }
        super.renderIcons(context, x, y);
    }

    public void listInit() {
        if (this.survivorsSpawned == null) {
            this.survivorsSpawned = new ArrayList<SurvivorEntity>();
        }
    }

    @Override
    public Component getPosName(byte posID) {
        return Component.m_237119_();
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    @Override
    public void tickPowerEnd() {
        if (this.survivorsSpawned != null && !this.survivorsSpawned.isEmpty()) {
            this.offloadSurvivors();
        }
    }

    public void addSurvivorToList(SurvivorEntity che) {
        this.listInit();
        this.survivorsSpawned.add(che);
        ArrayList<SurvivorEntity> survivorsList2 = new ArrayList<SurvivorEntity>(this.survivorsSpawned){};
        int scount = ClientNetworking.getAppropriateConfig().survivorSettings.maxSurvivorsCount;
        if (!survivorsList2.isEmpty() && survivorsList2.size() > scount) {
            ((SurvivorEntity)survivorsList2.get(0)).forceDespawn(true);
            this.survivorsSpawned.remove(0);
        }
    }

    public void offloadSurvivors() {
        this.listInit();
        ArrayList<SurvivorEntity> survivorsList2 = new ArrayList<SurvivorEntity>(this.survivorsSpawned){};
        if (!survivorsList2.isEmpty()) {
            for (SurvivorEntity value : survivorsList2) {
                if (!value.m_213877_() && value.m_6084_() && (!this.self.m_9236_().m_5776_() || this.self.m_9236_().m_6815_(value.m_19879_()) != null)) continue;
                this.survivorsSpawned.remove(value);
            }
        }
    }

    public boolean removeAllSurvivors() {
        this.listInit();
        boolean success = false;
        ArrayList<SurvivorEntity> survivorsList2 = new ArrayList<SurvivorEntity>(this.survivorsSpawned){};
        if (!survivorsList2.isEmpty()) {
            for (SurvivorEntity value : survivorsList2) {
                value.forceDespawn(true);
                success = true;
                this.survivorsSpawned.remove(value);
            }
        }
        if (success) {
            this.playStandUserOnlySoundsIfNearby((byte)62, 100.0, false, false);
        }
        return true;
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.throwBottleClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.summonSurvivorClient();
                break;
            }
            case SKILL_2_CROUCH: {
                this.despawnSurvivorClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.switchModeClient();
            }
        }
    }

    public void switchModeClient() {
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            this.SurvivorTarget = null;
            this.EntityTargetOne = null;
            ((StandUser)this.getSelf()).roundabout$tryPower(27, true);
            this.tryPowerPacket((byte)27);
        }
    }

    public void throwBottleClient() {
        if (!this.onCooldown((byte)0) && this.canUseWaterBottleThrow()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
            this.tryPowerPacket((byte)21);
        }
    }

    public void throwBottleActually(ItemStack stack) {
        this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), SoundEvents.f_12437_, SoundSource.PLAYERS, 0.5f, 0.4f / (this.self.m_217043_().m_188501_() * 0.4f + 0.8f));
        ThrownWaterBottleEntity $$4 = new ThrownWaterBottleEntity(this.self.m_9236_(), this.self);
        $$4.m_37446_(stack);
        $$4.m_37251_((Entity)this.self, this.self.m_146909_(), this.self.m_146908_(), -0.1f, 1.5f, 0.2f);
        this.self.m_9236_().m_7967_((Entity)$$4);
    }

    public boolean throwWaterBottle() {
        LivingEntity livingEntity;
        int cooldown = 5;
        this.setCooldown((byte)0, cooldown);
        if (!this.self.m_9236_().m_5776_() && (livingEntity = this.self) instanceof Player) {
            Item item;
            ItemStack stack2;
            Item item2;
            Player PL = (Player)livingEntity;
            ItemStack stack = this.getSelf().m_21205_();
            if (!stack.m_41619_() && (item2 = stack.m_41720_()) instanceof PotionItem) {
                PotionItem PI = (PotionItem)item2;
                if (PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_ && !(stack.m_41720_() instanceof SplashPotionItem)) {
                    this.throwBottleActually(stack.m_41777_());
                    if (!PL.m_150110_().f_35937_) {
                        stack.m_41774_(1);
                    }
                    return true;
                }
            }
            if (!(stack2 = this.getSelf().m_21206_()).m_41619_() && (item = stack2.m_41720_()) instanceof PotionItem) {
                PotionItem PI = (PotionItem)item;
                if (PotionUtils.m_43579_((ItemStack)stack2) == Potions.f_43599_ && !(stack2.m_41720_() instanceof SplashPotionItem)) {
                    this.throwBottleActually(stack2.m_41777_());
                    if (!PL.m_150110_().f_35937_) {
                        stack2.m_41774_(1);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean tryTripleIntPower(int move, boolean forced, int chargeTime, int move2, int move3) {
        switch (move) {
            case 37: {
                this.initializeTargets(chargeTime, move2, move3);
            }
        }
        return this.tryPower(move, forced);
    }

    public void initializeTargets(int x, int y, int z) {
        Entity targ = this.self.m_9236_().m_6815_(x);
        if (targ instanceof SurvivorEntity) {
            SurvivorEntity SE;
            this.SurvivorTarget = SE = (SurvivorEntity)targ;
        }
        this.EntityTargetOne = this.self.m_9236_().m_6815_(y);
        this.EntityTargetTwo = this.self.m_9236_().m_6815_(z);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                return this.throwWaterBottle();
            }
            case 24: {
                return this.removeAllSurvivors();
            }
            case 27: {
                return this.switchAngerSelectionMode();
            }
            case 37: {
                return this.selectTarget();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public boolean highlightsEntity(Entity ent, Player player) {
        if (ent != null && this.angerSelectionMode()) {
            if (this.SurvivorTarget != null && ent.m_7306_((Entity)this.SurvivorTarget) || this.EntityTargetOne != null && ent.m_7306_(this.EntityTargetOne)) {
                return true;
            }
            Entity highlights = this.getHighlighter();
            if (highlights != null && highlights.m_7306_(ent)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int highlightsEntityColor(Entity ent, Player player) {
        if (this.SurvivorTarget != null && ent != null && ent.m_7306_((Entity)this.SurvivorTarget) || this.EntityTargetOne != null && ent != null && ent.m_7306_(this.EntityTargetOne)) {
            return 4971295;
        }
        return 11283968;
    }

    @Override
    public boolean returnFakeStandForHud() {
        return true;
    }

    public boolean selectTarget() {
        Entity entity;
        this.setRageCupidCooldown();
        this.unloadTargets();
        SurvivorEntity surv = this.SurvivorTarget;
        if (surv != null && (entity = this.EntityTargetOne) instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            entity = this.EntityTargetTwo;
            if (entity instanceof LivingEntity) {
                LivingEntity LE2 = (LivingEntity)entity;
                surv.matchEntities(LE, LE2);
            }
        }
        return true;
    }

    public void selectTargetClient() {
        Entity TE = MainUtil.getTargetEntity(this.self, this.getCupidHighlightRange(), 15);
        if (this.SurvivorTarget == null) {
            SurvivorEntity SE;
            if (TE instanceof SurvivorEntity && ((SE = (SurvivorEntity)TE).getActivated() || this.getCreative())) {
                this.SurvivorTarget = SE;
                this.self.m_5496_(ModSounds.SURVIVOR_PLACE_EVENT, 1.0f, 1.5f);
            }
        } else if (this.EntityTargetOne == null) {
            if (SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && TE.m_20270_((Entity)this.SurvivorTarget) <= (float)this.getCupidRange()) {
                this.EntityTargetOne = TE;
                this.self.m_5496_(ModSounds.SURVIVOR_PLACE_EVENT, 1.0f, 1.5f);
            }
        } else if (SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && TE.m_20270_((Entity)this.SurvivorTarget) <= (float)this.getCupidRange() && !this.EntityTargetOne.m_7306_(TE) && !this.onCooldown((byte)3)) {
            this.setRageCupidCooldown();
            this.tryTripleIntPacket((byte)37, this.SurvivorTarget.m_19879_(), this.EntityTargetOne.m_19879_(), TE.m_19879_());
            this.SurvivorTarget = null;
            this.EntityTargetOne = null;
        }
    }

    @Override
    public boolean canUseStillStandingRecharge(byte bt) {
        if (bt == 1) {
            return false;
        }
        return super.canUseStillStandingRecharge(bt);
    }

    public void summonSurvivorClient() {
        Vec3 pos;
        if (!this.onCooldown((byte)1) && (pos = MainUtil.getRaytracePointOnMobOrBlockIfNotUp((Entity)this.self, 30.0f, 0.3f)) != null) {
            this.tryPosPower(23, true, pos);
            this.tryPosPowerPacket((byte)23, pos);
        }
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        --this.lastPlacementTime;
        if (this.lastPlacementTime <= -1) {
            this.lastPlacementTime = 600;
            this.createSurvivor(this.self.m_20318_(1.0f), true);
        }
    }

    public void despawnSurvivorClient() {
        this.tryPowerPacket((byte)24);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, Vec3 pos) {
        if (move == 23) {
            this.createSurvivor(pos, false);
            return true;
        }
        return this.tryPower(move, forced);
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_() && effect.m_19557_() == 50) {
            this.createSurvivor(this.self.m_20318_(1.0f), true);
            if (this.tempstand != null) {
                List<Entity> mobsInRange = MainUtil.getEntitiesInRange(this.self.m_9236_(), this.self.m_20183_(), ClientNetworking.getAppropriateConfig().survivorSettings.survivorRange.intValue(), (Entity)this.self);
                Object firstTarget = null;
                if (!mobsInRange.isEmpty()) {
                    for (Entity ent : mobsInRange) {
                        if (!SurvivorEntity.canZapEntity(ent) || !this.canUseZap(ent) || !(ent instanceof LivingEntity)) continue;
                        LivingEntity LE = (LivingEntity)ent;
                        this.tempstand.matchEntities(this.self, LE);
                    }
                }
            }
        }
    }

    public boolean canUseZap(Entity ent) {
        LivingEntity LE;
        return !(ent instanceof LivingEntity) || !MainUtil.isBossMob(LE = (LivingEntity)ent) || ClientNetworking.getAppropriateConfig().survivorSettings.canUseSurvivorOnBossesInSurvival != false || this.getCreative();
    }

    public void createSurvivor(Vec3 pos, boolean activated) {
        if (this.isClient() || !this.onCooldown((byte)1) || !ClientNetworking.getAppropriateConfig().survivorSettings.SummonSurvivorCooldownCooldownUsesServerLatency.booleanValue()) {
            int cooldown = ClientNetworking.getAppropriateConfig().survivorSettings.SummonSurvivorCooldownV2;
            this.setCooldown((byte)1, cooldown);
            if (!this.isClient()) {
                this.blipStand(pos, activated);
            }
        }
    }

    public void setRageCupidCooldown() {
        int cooldown = ClientNetworking.getAppropriateConfig().survivorSettings.rageCupidCooldown;
        this.setCooldown((byte)3, cooldown);
    }

    public Entity getHighlighter() {
        Entity TE = MainUtil.getTargetEntity(this.self, this.getCupidHighlightRange(), 15);
        if (this.SurvivorTarget == null) {
            SurvivorEntity SE;
            if (TE instanceof SurvivorEntity && ((SE = (SurvivorEntity)TE).getActivated() || this.getCreative())) {
                return SE;
            }
        } else if (this.EntityTargetOne == null ? SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && !TE.m_20145_() && TE.m_20270_((Entity)this.SurvivorTarget) <= (float)this.getCupidRange() : SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && !TE.m_20145_() && TE.m_20270_((Entity)this.SurvivorTarget) <= (float)this.getCupidRange() && !this.EntityTargetOne.m_7306_(TE)) {
            return TE;
        }
        return null;
    }

    public void blipStand(Vec3 pos, boolean activated) {
        StandEntity stand = (StandEntity)ModEntities.SURVIVOR.m_20615_(this.getSelf().m_9236_());
        if (stand instanceof SurvivorEntity) {
            SurvivorEntity SE = (SurvivorEntity)stand;
            StandUser user = this.getStandUserSelf();
            stand.m_20248_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            stand.setSkin(user.roundabout$getStandSkin());
            stand.setIdleAnimation(user.roundabout$getIdlePos());
            stand.setMaster(this.self);
            this.addSurvivorToList(SE);
            SE.setRandomSize((float)(Math.random() * (double)0.4f));
            SE.m_146922_(this.self.m_6080_() % 360.0f);
            if (activated) {
                SE.setActivated(true);
            }
            this.tempstand = SE;
            this.self.m_9236_().m_7967_((Entity)stand);
            this.playStandUserOnlySoundsIfNearby((byte)61, 100.0, false, false);
        }
    }

    @Override
    public boolean isServerControlledCooldown(CooldownInstance ci, byte num) {
        if (num == 1 && ClientNetworking.getAppropriateConfig().survivorSettings.SummonSurvivorCooldownCooldownUsesServerLatency.booleanValue()) {
            return true;
        }
        if (num == 3 && ClientNetworking.getAppropriateConfig().survivorSettings.rageCupidCooldownCooldownUsesServerLatency.booleanValue()) {
            return true;
        }
        return super.isServerControlledCooldown(ci, num);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    public int getCupidRange() {
        if (this.getCreative()) {
            return ClientNetworking.getAppropriateConfig().survivorSettings.survivorCupidCreativeRange;
        }
        return ClientNetworking.getAppropriateConfig().survivorSettings.survivorCupidRange;
    }

    public int getCupidHighlightRange() {
        return 100;
    }

    public void unloadTargets() {
        if (this.SurvivorTarget != null && (!this.SurvivorTarget.getActivated() && !this.getCreative() || this.SurvivorTarget.m_213877_() || !this.SurvivorTarget.m_6084_())) {
            this.SurvivorTarget = null;
        }
        if (this.EntityTargetOne != null && (this.SurvivorTarget == null || this.EntityTargetOne.m_213877_() || !this.EntityTargetOne.m_6084_() || this.EntityTargetOne.m_20270_((Entity)this.SurvivorTarget) > (float)this.getCupidRange())) {
            this.SurvivorTarget = null;
        }
        if (this.EntityTargetTwo != null && (this.SurvivorTarget == null || this.EntityTargetOne == null || this.EntityTargetTwo.m_213877_() || !this.EntityTargetTwo.m_6084_() || this.EntityTargetTwo.m_20270_((Entity)this.SurvivorTarget) > (float)this.getCupidRange() || this.EntityTargetOne != null && this.EntityTargetOne.m_7306_(this.EntityTargetTwo))) {
            this.EntityTargetTwo = null;
        }
    }

    @Override
    public void tickPower() {
        if (this.self.m_9236_().m_5776_()) {
            this.unloadTargets();
        }
        super.tickPower();
    }

    @Override
    public void updateIntMove(int in) {
        super.updateIntMove(in);
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10, (byte)11, (byte)12);
    }

    @Override
    public int getDisplayPowerInventoryScale() {
        return 60;
    }

    @Override
    public int getDisplayPowerInventoryYOffset() {
        return 7;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> Component.m_237115_((String)"skins.roundabout.survivor.green");
            case 3 -> Component.m_237115_((String)"skins.roundabout.survivor.red");
            case 4 -> Component.m_237115_((String)"skins.roundabout.survivor.purple");
            case 5 -> Component.m_237115_((String)"skins.roundabout.survivor.blue");
            case 6 -> Component.m_237115_((String)"skins.roundabout.survivor.silver");
            case 7 -> Component.m_237115_((String)"skins.roundabout.survivor.ghast");
            case 8 -> Component.m_237115_((String)"skins.roundabout.survivor.ender");
            case 9 -> Component.m_237115_((String)"skins.roundabout.survivor.conduit");
            case 10 -> Component.m_237115_((String)"skins.roundabout.survivor.cake");
            case 11 -> Component.m_237115_((String)"skins.roundabout.survivor.sponge");
            case 12 -> Component.m_237115_((String)"skins.roundabout.survivor.sculk");
            default -> Component.m_237115_((String)"skins.roundabout.survivor.base");
        };
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        switch (soundChoice) {
            case 18: {
                return ModSounds.SURVIVOR_SUMMON_EVENT;
            }
            case 61: {
                return ModSounds.SURVIVOR_PLACE_EVENT;
            }
            case 62: {
                return ModSounds.SURVIVOR_REMOVE_EVENT;
            }
            case 63: {
                return ModSounds.SURVIVOR_SHOCK_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseWaterBottleThrow() {
        Item item;
        ItemStack stack = this.getSelf().m_21205_();
        ItemStack stack2 = this.getSelf().m_21206_();
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof PotionItem) {
            PotionItem PI = (PotionItem)item;
            if (PotionUtils.m_43579_((ItemStack)stack) == Potions.f_43599_) {
                if (!(PI instanceof SplashPotionItem)) return true;
            }
        }
        if (stack2.m_41619_()) return false;
        item = stack2.m_41720_();
        if (!(item instanceof PotionItem)) return false;
        PotionItem PI2 = (PotionItem)item;
        if (PotionUtils.m_43579_((ItemStack)stack2) != Potions.f_43599_) return false;
        if (PI2 instanceof SplashPotionItem) return false;
        return true;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (slot == 1 && !this.canUseWaterBottleThrow()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.throw_bottle", "instruction.roundabout.press_skill", StandIcons.BOTTLE, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.summon_survivor", "instruction.roundabout.press_skill", StandIcons.SPAWN, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.desummon_survivor", "instruction.roundabout.press_skill_crouch", StandIcons.DESPAWN, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.target_zap", "instruction.roundabout.press_skill", StandIcons.RAGE_SELECTION, 4, level, bypass));
        }
        return $$1;
    }

    public boolean switchAngerSelectionMode() {
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            LivingEntity livingEntity;
            this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.angerSelectionMode());
            if (!this.isClient() && (livingEntity = this.self) instanceof ServerPlayer) {
                ServerPlayer PE = (ServerPlayer)livingEntity;
                if (this.angerSelectionMode()) {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.survivor.anger_selection").m_130940_(ChatFormatting.RED), true);
                } else {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.survivor.anger_selection_off").m_130940_(ChatFormatting.RED), true);
                }
            }
        }
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (!this.holdAttack) {
                this.holdAttack = true;
                if (this.angerSelectionMode()) {
                    this.selectTargetClient();
                }
            }
        } else if (this.holdAttack) {
            this.holdAttack = false;
        }
    }
}

