/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util;

import com.google.common.collect.Sets;
import com.google.common.primitives.Floats;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.hydra.jojomod.access.IAbstractFurnaceBlockEntity;
import net.hydra.jojomod.access.IAbstractFurnaceMenu;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.access.IPlayerEntityServer;
import net.hydra.jojomod.block.BarbedWireBundleBlock;
import net.hydra.jojomod.block.GasolineBlock;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.block.StereoBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.gui.FogInventoryMenu;
import net.hydra.jojomod.client.gui.PowerInventoryMenu;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.entity.projectile.GasolineCanEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.stand.StarPlatinumEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.index.Corpses;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.stand.PowersJustice;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.item.StandDiscItem;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.Networking;
import net.minecraft.class_1263;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1429;
import net.minecraft.class_1477;
import net.minecraft.class_1480;
import net.minecraft.class_1506;
import net.minecraft.class_1507;
import net.minecraft.class_1508;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1543;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1593;
import net.minecraft.class_1614;
import net.minecraft.class_1628;
import net.minecraft.class_1634;
import net.minecraft.class_1640;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1720;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1798;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2231;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2309;
import net.minecraft.class_2337;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2362;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2383;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_2484;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2510;
import net.minecraft.class_2523;
import net.minecraft.class_2527;
import net.minecraft.class_2541;
import net.minecraft.class_2542;
import net.minecraft.class_2560;
import net.minecraft.class_2561;
import net.minecraft.class_2577;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3709;
import net.minecraft.class_3737;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_3989;
import net.minecraft.class_4019;
import net.minecraft.class_4051;
import net.minecraft.class_4466;
import net.minecraft.class_4865;
import net.minecraft.class_5134;
import net.minecraft.class_5418;
import net.minecraft.class_5546;
import net.minecraft.class_5635;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7113;
import net.minecraft.class_7260;
import net.minecraft.class_8238;
import org.joml.Vector3f;

public class MainUtil {
    public static final class_4051 attackTargeting = class_4051.method_36625().method_18418(20.0);
    public static final class_4051 followTargetting = class_4051.method_36625().method_18418(50.0);
    public static final class_4051 plsWorkTargetting = class_4051.method_36625().method_18418(20.0).method_18424();
    private static final class_4051 OFFER_TARGER_CONTEXT = class_4051.method_36626().method_18418(64.0);

    public static float controlledLerp(float delta, float start, float end, float multiplier) {
        delta = Math.min(delta, 1.0f);
        return start + delta * (end - start) * multiplier;
    }

    public static boolean isDreadBook(class_1799 stack) {
        class_2561 name;
        String str;
        return stack != null && !stack.method_7960() && stack.method_31574(class_1802.field_8529) && ("cha'garoth".equals(str = (name = stack.method_7964()).getString().toLowerCase()) || "chagaroth".equals(str) || "dreadbeast".equals(str));
    }

    public static float controlledLerpAngleDegrees(float delta, float start, float end, float multiplier) {
        delta = Math.min(delta, 1.0f);
        return start + delta * class_3532.method_15393((float)(end - start)) * multiplier;
    }

    public static float controlledLerpRadianDegrees(float delta, float start, float end, float multiplier) {
        delta = Math.min(delta, 1.0f);
        return start + delta * MainUtil.wrapRadians(end - start) * multiplier;
    }

    public static double getWorthyOdds(class_1308 mob) {
        if (mob instanceof class_7260 || mob instanceof class_1528 || mob instanceof class_1510) {
            return 0.0;
        }
        return ClientNetworking.getAppropriateConfig().worthyMobOdds.floatValue();
    }

    public static double getStandUserOdds(class_1308 mob) {
        if (mob instanceof class_7260 || mob instanceof class_1528 || mob instanceof class_1510 || mob instanceof class_1634) {
            return 0.0;
        }
        if (mob instanceof class_3988) {
            return ClientNetworking.getAppropriateConfig().standUserVillagerOdds.floatValue();
        }
        return ClientNetworking.getAppropriateConfig().standUserOdds.floatValue();
    }

    public static double getWorthyBreedBonus(class_1308 mob) {
        if (mob instanceof class_3988) {
            return ClientNetworking.getAppropriateConfig().userAndWorthyBreedingOddsBonus.floatValue() * (float)ClientNetworking.getAppropriateConfig().multiplyAboveForVillagerBreeding.intValue();
        }
        return ClientNetworking.getAppropriateConfig().userAndWorthyBreedingOddsBonus.floatValue();
    }

    public static double getStandUserBreedBonus(class_1308 mob) {
        if (mob instanceof class_3988) {
            return ClientNetworking.getAppropriateConfig().userAndWorthyBreedingOddsBonus.floatValue() * (float)ClientNetworking.getAppropriateConfig().multiplyAboveForVillagerBreeding.intValue();
        }
        return ClientNetworking.getAppropriateConfig().userAndWorthyBreedingOddsBonus.floatValue();
    }

    public static class_1309 homeOnWorthy(class_1937 level, class_243 vec3, double range) {
        List<class_1297> EntitiesInRange = MainUtil.genHitbox(level, vec3.field_1352, vec3.field_1351, vec3.field_1350, range, range, range);
        ArrayList<class_1297> hitEntities = new ArrayList<class_1297>(EntitiesInRange){};
        class_1309 mm = null;
        double distance = -1.0;
        for (class_1297 value : hitEntities) {
            class_1309 mb;
            if (!(value instanceof class_1309) || !MainUtil.canGrantStand((class_1297)(mb = (class_1309)value)) || distance != -1.0 && !(mb.method_5707(vec3) < distance)) continue;
            mm = mb;
            distance = mb.method_5707(vec3);
        }
        return mm;
    }

    public static class_1799 saveToDiscData(class_1309 ent, class_1799 stack) {
        if (ent instanceof class_1657) {
            class_1657 PE = (class_1657)ent;
            if (!(stack.method_7909() instanceof MaxStandDiscItem)) {
                IPlayerEntity IPE = (IPlayerEntity)PE;
                stack.method_7911("Memory").method_10567("Level", (byte)Math.max(IPE.roundabout$getStandLevel() - 1, 0));
                stack.method_7911("Memory").method_10569("Experience", IPE.roundabout$getStandExp());
                stack.method_7911("Memory").method_10556("BonusSkin", IPE.roundabout$getUnlockedBonusSkin());
            }
        }
        stack.method_7911("Memory").method_10567("Skin", ((StandUser)ent).roundabout$getStandSkin());
        stack.method_7911("Memory").method_10567("Pose", ((StandUser)ent).roundabout$getIdlePos());
        return stack;
    }

    public static void handleChangeItem(class_1657 player, byte context, class_1799 stack, byte context2, Vector3f vec) {
        if (context2 == 3) {
            boolean offh = class_1799.method_31577((class_1799)player.method_6079(), (class_1799)stack);
            if (player.method_31548().method_7379(stack) || offh || stack.method_31574(ModItems.CREATIVE_BODY_BAG)) {
                class_1799 item;
                int zombies = 1;
                int skeletons = 1;
                int spiders = 1;
                int villagers = 1;
                int creepers = 1;
                if (!stack.method_31574(ModItems.CREATIVE_BODY_BAG)) {
                    item = offh ? player.method_6079() : player.method_31548().method_5438(player.method_31548().method_7395(stack));
                    class_2487 $$1 = item.method_7911("bodies");
                    zombies = $$1.method_10550("zombie");
                    skeletons = $$1.method_10550("skeleton");
                    spiders = $$1.method_10550("spider");
                    villagers = $$1.method_10550("villager");
                    creepers = $$1.method_10550("creeper");
                }
                FallenMob fm = null;
                boolean yElevation = false;
                if (context == Corpses.ZOMBIE.id) {
                    if (--zombies >= 0) {
                        fm = (FallenMob)ModEntities.FALLEN_ZOMBIE.method_5883(player.method_37908());
                    }
                } else if (context == Corpses.SKELETON.id) {
                    if (--skeletons >= 0) {
                        fm = (FallenMob)ModEntities.FALLEN_SKELETON.method_5883(player.method_37908());
                    }
                } else if (context == Corpses.SPIDER.id) {
                    if (--spiders >= 0) {
                        fm = (FallenMob)ModEntities.FALLEN_SPIDER.method_5883(player.method_37908());
                    }
                } else if (context == Corpses.VILLAGER.id) {
                    if (--villagers >= 0) {
                        fm = (FallenMob)ModEntities.FALLEN_VILLAGER.method_5883(player.method_37908());
                    }
                } else if (context == Corpses.CREEPER.id && --creepers >= 0) {
                    fm = (FallenMob)ModEntities.FALLEN_CREEPER.method_5883(player.method_37908());
                }
                if (fm != null) {
                    fm.method_5814(vec.x, vec.y + (float)yElevation, vec.z);
                    fm.placer = player;
                    fm.setPhasesFull(true);
                    fm.tickThroughPlacerStart();
                    fm.setForcedRotation(player.method_36454() % 360.0f);
                    fm.method_36456(player.method_36454() % 360.0f);
                    fm.method_5636(player.field_6283 % 360.0f);
                    player.method_37908().method_8649((class_1297)fm);
                    if (!stack.method_31574(ModItems.CREATIVE_BODY_BAG)) {
                        item = offh ? player.method_6079() : player.method_31548().method_5438(player.method_31548().method_7395(stack));
                        if (!player.method_7337() && player instanceof class_3222) {
                            class_3222 SP = (class_3222)player;
                            if (context == Corpses.ZOMBIE.id) {
                                item.method_7911("bodies").method_10569("zombie", zombies);
                            } else if (context == Corpses.SKELETON.id) {
                                item.method_7911("bodies").method_10569("skeleton", skeletons);
                            } else if (context == Corpses.SPIDER.id) {
                                item.method_7911("bodies").method_10569("spider", spiders);
                            } else if (context == Corpses.VILLAGER.id) {
                                item.method_7911("bodies").method_10569("villager", villagers);
                            } else if (context == Corpses.CREEPER.id) {
                                item.method_7911("bodies").method_10569("creeper", creepers);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void handleSetCreativeModeSlot(class_1657 player, int integer, class_1799 stack, byte context) {
        if (context == 1) {
            boolean flag2;
            boolean flag = integer < 0;
            class_1799 itemstack = stack;
            if (!itemstack.method_45435(player.method_37908().method_45162())) {
                return;
            }
            class_2487 compoundtag = class_1747.method_38072((class_1799)itemstack);
            if (!itemstack.method_7960() && compoundtag != null && compoundtag.method_10545("x") && compoundtag.method_10545("y") && compoundtag.method_10545("z")) {
                class_2586 blockentity;
                class_2338 blockpos = class_2586.method_38239((class_2487)compoundtag);
                if (player.method_37908().method_8477(blockpos) && (blockentity = player.method_37908().method_8321(blockpos)) != null) {
                    blockentity.method_38240(itemstack);
                }
            }
            boolean flag1 = integer >= 1 && integer <= 45;
            boolean bl = flag2 = itemstack.method_7960() || itemstack.method_7919() >= 0 && itemstack.method_7947() <= 64 && !itemstack.method_7960();
            if (flag1 && flag2) {
                player.field_7498.method_7611(integer).method_48931(itemstack);
                player.field_7498.method_7623();
            } else if (flag && flag2) {
                player.method_7328(itemstack, true);
            }
        }
    }

    public static void extractDiscData(class_1309 ent, StandDiscItem SD, class_1799 stack) {
        StandUser user = (StandUser)ent;
        class_2487 $$4 = stack.method_7941("Memory");
        if ($$4 != null) {
            if (SD instanceof MaxStandDiscItem) {
                if (ent instanceof class_1657) {
                    PE = (class_1657)ent;
                    IPlayerEntity IPE = (IPlayerEntity)PE;
                    IPE.roundabout$setStandLevel(SD.standPowers.getMaxLevel());
                }
            } else if (ent instanceof class_1657) {
                PE = (class_1657)ent;
                IPlayerEntity IPE = (IPlayerEntity)PE;
                if ($$4.method_10545("Level")) {
                    byte lvl = (byte)($$4.method_10571("Level") + 1);
                    lvl = (byte)class_3532.method_15340((int)lvl, (int)1, (int)SD.standPowers.getMaxLevel());
                    IPE.roundabout$setStandLevel(lvl);
                    if ($$4.method_10545("Experience")) {
                        byte exp = (byte)$$4.method_10550("Experience");
                        exp = (byte)class_3532.method_15340((int)exp, (int)0, (int)SD.standPowers.getExpForLevelUp(lvl));
                        IPE.roundabout$setStandExp(exp);
                    } else {
                        IPE.roundabout$setStandExp(0);
                    }
                } else {
                    IPE.roundabout$setStandLevel((byte)1);
                    IPE.roundabout$setStandExp(0);
                }
                if ($$4.method_10545("BonusSkin")) {
                    IPE.roundabout$setUnlockedBonusSkin($$4.method_10577("BonusSkin"));
                } else {
                    IPE.roundabout$setUnlockedBonusSkin(false);
                }
            }
            if ($$4.method_10545("Skin")) {
                byte skn = $$4.method_10571("Skin");
                user.roundabout$setStandSkin(skn);
            } else {
                user.roundabout$setStandSkin((byte)0);
            }
            if ($$4.method_10545("Pose")) {
                byte skn = $$4.method_10571("Pose");
                user.roundabout$setIdlePosX(skn);
            } else {
                user.roundabout$setIdlePosX((byte)0);
            }
        } else {
            if (ent instanceof class_1657) {
                class_1657 PE = (class_1657)ent;
                IPlayerEntity IPE = (IPlayerEntity)PE;
                IPE.roundabout$setStandLevel((byte)1);
                IPE.roundabout$setStandExp(0);
                IPE.roundabout$setUnlockedBonusSkin(false);
            }
            user.roundabout$setStandSkin((byte)0);
            user.roundabout$setIdlePosX((byte)0);
        }
    }

    public static class_1309 homeOnFlier(class_1937 level, class_243 vec3, double range, class_1297 owner) {
        List<class_1297> EntitiesInRange = MainUtil.genHitbox(level, vec3.field_1352, vec3.field_1351, vec3.field_1350, range, range, range);
        ArrayList<class_1297> hitEntities = new ArrayList<class_1297>(EntitiesInRange){};
        for (class_1297 value : hitEntities) {
            class_1309 mb;
            if (!(value instanceof class_1309) || !(mb = (class_1309)value).method_6128() && !(mb instanceof class_1593) || mb instanceof StandEntity || owner != null && owner.method_5667() == mb.method_5667()) continue;
            return mb;
        }
        return null;
    }

    public static boolean getMobBleed(class_1297 Mob) {
        if (ClientNetworking.getAppropriateConfig().disableBleedingAndBloodSplatters.booleanValue()) {
            return false;
        }
        if (Mob instanceof class_1309) {
            return Mob instanceof class_1642 || Mob instanceof class_1429 && !(Mob instanceof class_1506) && !(Mob instanceof class_1507) || Mob instanceof class_1646 || Mob instanceof class_1480 || Mob instanceof class_3989 || Mob instanceof class_1640 || Mob instanceof class_1543 || Mob instanceof class_1548 || Mob instanceof class_1657 || Mob instanceof class_5418 || Mob instanceof class_1628 || Mob instanceof class_1510 || Mob instanceof class_1560;
        }
        return false;
    }

    public static void makeMobBleed(class_1297 target) {
        int variety = (int)Math.round(Math.random() * 4.0);
        class_2248 modBlock = ModBlocks.BLOOD_SPLATTER;
        if (MainUtil.hasBlueBlood(target)) {
            modBlock = ModBlocks.BLUE_BLOOD_SPLATTER;
        } else if (MainUtil.hasEnderBlood(target)) {
            modBlock = ModBlocks.ENDER_BLOOD_SPLATTER;
        }
        if (variety != 1) {
            MainUtil.setSplatter(target.method_37908(), target.method_23312(), (int)Math.floor(Math.random() * 3.0) - 1, 0, (class_2680)modBlock.method_9564().method_11657((class_2769)ModBlocks.BLOOD_LEVEL, (Comparable)Integer.valueOf((int)Math.round(Math.random() * 3.0))));
        }
        if (variety != 2) {
            MainUtil.setSplatter(target.method_37908(), target.method_23312(), (int)Math.floor(Math.random() * 3.0) - 1, -1, (class_2680)modBlock.method_9564().method_11657((class_2769)ModBlocks.BLOOD_LEVEL, (Comparable)Integer.valueOf((int)Math.round(Math.random() * 3.0))));
        }
        if (variety != 3) {
            MainUtil.setSplatter(target.method_37908(), target.method_23312(), (int)Math.floor(Math.random() * 3.0) - 1, 1, (class_2680)modBlock.method_9564().method_11657((class_2769)ModBlocks.BLOOD_LEVEL, (Comparable)Integer.valueOf((int)Math.round(Math.random() * 3.0))));
        }
    }

    public static boolean hasBlueBlood(class_1297 target) {
        return target instanceof class_1628 || target instanceof class_4466 || target instanceof class_1614 || target instanceof class_1477;
    }

    public static boolean hasEnderBlood(class_1297 target) {
        return target instanceof class_1560 || target instanceof class_1559 || target instanceof class_1510;
    }

    private static boolean containsInvalidValues(double $$0, double $$1, double $$2, float $$3, float $$4) {
        return Double.isNaN($$0) || Double.isNaN($$1) || Double.isNaN($$2) || !Floats.isFinite((float)$$4) || !Floats.isFinite((float)$$3);
    }

    private static double clampHorizontal(double $$0) {
        return class_3532.method_15350((double)$$0, (double)-3.0E7, (double)3.0E7);
    }

    private static double clampVertical(double $$0) {
        return class_3532.method_15350((double)$$0, (double)-2.0E7, (double)2.0E7);
    }

    public static void handleMovePilot(double getX, double getY, double getZ, float getYRot, float getXRot, class_1657 player, int entityInt) {
        class_1297 entity = player.method_37908().method_8469(entityInt);
        if (entity != null && !MainUtil.containsInvalidValues(getX, getY, getZ, getYRot, getXRot) && entity != player) {
            class_1309 livingentity;
            class_3218 serverlevel = (class_3218)player.method_37908();
            double d0 = entity.method_23317();
            double d1 = entity.method_23318();
            double d2 = entity.method_23321();
            double d3 = MainUtil.clampHorizontal(getX);
            double d4 = MainUtil.clampVertical(getY);
            double d5 = MainUtil.clampHorizontal(getZ);
            float f = class_3532.method_15393((float)getYRot);
            float f1 = class_3532.method_15393((float)getXRot);
            boolean flag = serverlevel.method_8587(entity, entity.method_5829().method_1011(0.0625));
            boolean flag1 = entity.field_36331;
            if (entity instanceof class_1309 && (livingentity = (class_1309)entity).method_6101()) {
                livingentity.method_38785();
            }
            entity.method_5641(d3, d4, d5, f, f1);
            entity.method_5808(d3, d4, d5, f, f1);
        }
    }

    public static boolean canCauseRejection(class_1297 ent) {
        if (ent instanceof class_1308) {
            class_1308 ME = (class_1308)ent;
            if (!(ME instanceof class_1528) && !(ME instanceof class_1510) && !(ME instanceof class_7260) && ((StandUser)ME).roundabout$getStandDisc().method_7960()) {
                return true;
            }
        } else if (ent instanceof class_1657) {
            class_1657 PE = (class_1657)ent;
            if (PE.field_7520 < ClientNetworking.getAppropriateConfig().levelsToGetStand && ((StandUser)PE).roundabout$getStandDisc().method_7960()) {
                return true;
            }
        }
        return false;
    }

    public static boolean canGrantStand(class_1297 ent) {
        if (ent instanceof class_1308) {
            class_1308 ME = (class_1308)ent;
            if (!(ME instanceof StandEntity) && ((StandUser)ME).roundabout$getStandDisc().method_7960()) {
                return ((IMob)ME).roundabout$isWorthy();
            }
        } else if (ent instanceof class_1657) {
            class_1657 PL = (class_1657)ent;
            if (ClientNetworking.getAppropriateConfig().canAwakenOtherPlayersWithArrows.booleanValue() && ((StandUser)PL).roundabout$getStandDisc().method_7960()) {
                return PL.field_7520 >= ClientNetworking.getAppropriateConfig().levelsToGetStand;
            }
        }
        return false;
    }

    public static float gasDamageMultiplier() {
        return (float)((double)0.83f * ((double)ClientNetworking.getAppropriateConfig().damageMultipliers.gasolineExplosion.intValue() * 0.01));
    }

    public static void makeBleed(class_1297 entity, int level, int ticks, class_1297 source) {
        if (ClientNetworking.getAppropriateConfig().disableBleedingAndBloodSplatters.booleanValue()) {
            return;
        }
        if (MainUtil.getMobBleed(entity)) {
            ((StandUser)entity).roundabout$setBleedLevel(level);
            ((class_1309)entity).method_37222(new class_1293(ModEffects.BLEED, ticks, level), source);
        }
    }

    public static void randomChorusTeleport(class_1309 entity) {
        class_1937 $$1 = entity.method_37908();
        if (!$$1.field_9236) {
            double $$4 = entity.method_23317();
            double $$5 = entity.method_23318();
            double $$6 = entity.method_23321();
            for (int $$7 = 0; $$7 < 16; ++$$7) {
                double $$8 = entity.method_23317() + (entity.method_6051().method_43058() - 0.5) * 16.0;
                double $$9 = class_3532.method_15350((double)(entity.method_23318() + (double)(entity.method_6051().method_43048(16) - 8)), (double)$$1.method_31607(), (double)($$1.method_31607() + ((class_3218)$$1).method_32819() - 1));
                double $$10 = entity.method_23321() + (entity.method_6051().method_43058() - 0.5) * 16.0;
                if (entity.method_5765()) {
                    entity.method_5848();
                }
                class_243 $$11 = entity.method_19538();
                if (!MainUtil.randomTeleport(entity, $$8, $$9, $$10, true)) continue;
                entity.field_6037 = true;
                entity.field_6007 = true;
                $$1.method_32888(class_5712.field_39446, $$11, class_5712.class_7397.method_43285((class_1297)entity));
                class_3414 $$12 = entity instanceof class_4019 ? class_3417.field_24630 : class_3417.field_14890;
                $$1.method_43128(null, $$4, $$5, $$6, $$12, class_3419.field_15248, 1.0f, 1.0f);
                entity.method_5783($$12, 1.0f, 1.0f);
                break;
            }
        }
    }

    public static boolean randomTeleport(class_1309 ent, double $$0, double $$1, double $$2, boolean $$3) {
        double $$4 = ent.method_23317();
        double $$5 = ent.method_23318();
        double $$6 = ent.method_23321();
        double $$7 = $$1;
        boolean $$8 = false;
        class_2338 $$9 = class_2338.method_49637((double)$$0, (double)$$1, (double)$$2);
        class_1937 $$10 = ent.method_37908();
        if ($$10.method_22340($$9)) {
            boolean $$11 = false;
            while (!$$11 && $$9.method_10264() > $$10.method_31607()) {
                class_2338 $$12 = $$9.method_10074();
                class_2680 $$13 = $$10.method_8320($$12);
                if ($$13.method_51366()) {
                    $$11 = true;
                    continue;
                }
                $$7 -= 1.0;
                $$9 = $$12;
            }
            if ($$11) {
                ent.method_5859($$0, $$7, $$2);
                if (ent instanceof class_1657) {
                    ((IEntityAndData)ent).roundabout$setQVec2Params(new class_243($$0, $$7, $$2));
                }
                if ($$10.method_17892((class_1297)ent) && !$$10.method_22345(ent.method_5829())) {
                    $$8 = true;
                }
            }
        }
        if (!$$8) {
            ent.method_5859($$4, $$5, $$6);
            if (ent instanceof class_1657) {
                ((IEntityAndData)ent).roundabout$setQVec2Params(new class_243($$0, $$7, $$2));
            }
            return false;
        }
        if ($$3) {
            $$10.method_8421((class_1297)ent, (byte)46);
        }
        if (ent instanceof class_1314) {
            ((class_1314)ent).method_5942().method_6340();
        }
        return true;
    }

    public static List<class_1297> genHitbox(class_1937 level, double startX, double startY, double startZ, double radiusX, double radiusY, double radiusZ) {
        double k = class_3532.method_15357((double)(startX - radiusX));
        double l = class_3532.method_15357((double)(startX + radiusX));
        double r = startY - radiusY;
        double s = startY + radiusY;
        double t = startZ - radiusZ;
        double u = startZ + radiusZ;
        return level.method_8335(null, new class_238(k, r, t, l, s, u));
    }

    public static List<class_1297> hitbox(List<class_1297> entities) {
        ArrayList<class_1297> hitEntities = new ArrayList<class_1297>(entities){};
        for (class_1297 value : entities) {
            if (value.method_5709() && !value.method_5655() && value.method_5805() && !(value instanceof StandEntity)) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public static List<class_1297> hitboxGas(List<class_1297> entities) {
        ArrayList<class_1297> hitEntities = new ArrayList<class_1297>(entities){};
        for (class_1297 value : entities) {
            if ((value.method_5709() || value instanceof GasolineCanEntity) && !value.method_5655() && value.method_5805()) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public static float wrapRadians(float radians) {
        float f = (radians *= 57.295776f) % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f * ((float)Math.PI / 180);
    }

    public static class_243 getMoveRelative(float $$0, class_243 $$1, class_1297 ett) {
        return MainUtil.getInputVector($$1, $$0, ett.method_36454());
    }

    private static class_243 getInputVector(class_243 $$0, float $$1, float $$2) {
        double $$3 = $$0.method_1027();
        if ($$3 < 1.0E-7) {
            return class_243.field_1353;
        }
        class_243 $$4 = ($$3 > 1.0 ? $$0.method_1029() : $$0).method_1021((double)$$1);
        float $$5 = class_3532.method_15374((float)($$2 * ((float)Math.PI / 180)));
        float $$6 = class_3532.method_15362((float)($$2 * ((float)Math.PI / 180)));
        return new class_243($$4.field_1352 * (double)$$6 - $$4.field_1350 * (double)$$5, $$4.field_1351, $$4.field_1350 * (double)$$6 + $$4.field_1352 * (double)$$5);
    }

    public static double fixAngle(float angle) {
        return Math.abs(angle) % 360.0f;
    }

    public static void takeKnockbackWithY(class_1297 entity, double strength, double x, double y, double z) {
        if (entity instanceof class_1309) {
            double d;
            strength *= (double)((float)(1.0 - ((class_1309)entity).method_26825(class_5134.field_23718)));
            if (d <= 0.0) {
                return;
            }
        }
        MainUtil.takeUnresistableKnockbackWithY(entity, strength, x, y, z);
    }

    public static void takeUnresistableKnockbackWithY(class_1297 entity, double strength, double x, double y, double z) {
        entity.field_6037 = true;
        class_243 vec3d2 = new class_243(x, y, z).method_1029().method_1021(strength);
        entity.method_18800(-vec3d2.field_1352, -vec3d2.field_1351, -vec3d2.field_1350);
        entity.field_6007 = true;
    }

    public static void takeUnresistableKnockbackWithYBias(class_1297 entity, double strength, double x, double y, double z, float yBias) {
        entity.field_6037 = true;
        class_243 vec3d2 = new class_243(x, y, z).method_1029().method_1021(strength);
        class_243 vec3d3 = vec3d2.method_18805((double)yBias, 1.0, (double)yBias);
        entity.method_18800(-vec3d3.field_1352, -vec3d3.field_1351, -vec3d3.field_1350);
        entity.field_6007 = true;
    }

    public static void takeUnresistableKnockbackWithY2(class_1297 entity, double x, double y, double z) {
        entity.field_6037 = true;
        entity.method_18800(x, y, z);
        entity.field_6007 = true;
    }

    public static void ejectInFront(StandEntity stand) {
        if (stand.method_31483() != null && stand.getUser() != null) {
            class_1297 entity = stand.method_31483();
            stand.method_5772();
            if (entity.method_37908().method_44013() == stand.getUser().method_37908().method_44013()) {
                if (entity instanceof class_1657) {
                    class_1657 ent = (class_1657)entity;
                    ((IEntityAndData)ent).roundabout$setQVec2Params(new class_243(stand.getUser().method_23317(), stand.getUser().method_23318(), stand.getUser().method_23321()));
                } else {
                    entity.method_33567(stand.getUser().method_23317(), stand.getUser().method_23318(), stand.getUser().method_23321());
                }
            }
        }
    }

    public static void knockback(class_1297 entity, double d, double e, double f) {
        if (entity instanceof class_1309) {
            double d2;
            class_1309 le = (class_1309)entity;
            d *= 1.0 - le.method_26825(class_5134.field_23718);
            if (d2 <= 0.0) {
                return;
            }
        }
        entity.field_6007 = true;
        class_243 vec3 = entity.method_18798();
        class_243 vec32 = new class_243(e, 0.0, f).method_1029().method_1021(d);
        entity.method_18800(vec3.field_1352 / 2.0 - vec32.field_1352, entity.method_24828() ? Math.min(0.4, vec3.field_1351 / 2.0 + d) : vec3.field_1351, vec3.field_1350 / 2.0 - vec32.field_1350);
        entity.field_6037 = true;
    }

    public static void knockbackWithoutBumpUp(class_1297 entity, double d, double e, double f) {
        if (entity instanceof class_1309) {
            double d2;
            class_1309 le = (class_1309)entity;
            d *= 1.0 - le.method_26825(class_5134.field_23718);
            if (d2 <= 0.0) {
                return;
            }
        }
        entity.field_6007 = true;
        class_243 vec3 = entity.method_18798();
        class_243 vec32 = new class_243(e, 0.0, f).method_1029().method_1021(d);
        entity.method_18800(vec3.field_1352 / 2.0 - vec32.field_1352, vec3.field_1351, vec3.field_1350 / 2.0 - vec32.field_1350);
        entity.field_6037 = true;
    }

    public static double lengthdir_x(double length, double angle) {
        return length * Math.cos(MainUtil.toRadians(angle)) * -1.0;
    }

    public static double lengthdir_z(double length, double angle) {
        return length * Math.sin(MainUtil.toRadians(angle));
    }

    public static double toRadians(double angle) {
        return angle * (Math.PI / 180);
    }

    public static double cheapDistanceTo(double x, double y, double z, double x2, double y2, double z2) {
        double mdist = 0.0;
        double cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(y - y2)) > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static double cheapDistanceTo2(double x, double z, double x2, double z2) {
        double mdist = 0.0;
        double cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static int cheapDistanceTo2(int x, int z, int x2, int z2) {
        int mdist = 0;
        int cdist = Math.abs(x - x2);
        if (cdist > mdist) {
            mdist = cdist;
        }
        if ((cdist = Math.abs(z - z2)) > mdist) {
            mdist = cdist;
        }
        return mdist;
    }

    public static boolean isPlayerNearby(class_243 pos, class_1937 level, double range, int exemptID) {
        if (level instanceof class_3218) {
            class_3218 serverWorld = (class_3218)level;
            for (int j = 0; j < serverWorld.method_18456().size(); ++j) {
                class_3222 serverPlayerEntity = (class_3222)serverWorld.method_18456().get(j);
                if (serverPlayerEntity.method_37908() != serverWorld) continue;
                class_2338 blockPos = serverPlayerEntity.method_24515();
                if (serverPlayerEntity.method_5628() == exemptID || !blockPos.method_19769((class_2374)pos, range)) continue;
                return true;
            }
        }
        return false;
    }

    public static void gasExplode(class_2680 blk, class_3218 level, class_2338 blkPos, int iteration, int hitRadius, int blockRadius, float power) {
        if (!level.field_9236) {
            List<class_1297> entities;
            level.method_14199((class_2394)class_2398.field_11239, (double)blkPos.method_10263() + 0.5, (double)blkPos.method_10264(), (double)blkPos.method_10260() + 0.5, 2, 0.0, 0.0, 0.0, 0.4);
            if (iteration == 0) {
                class_3414 $$6 = ModSounds.GASOLINE_EXPLOSION_EVENT;
                level.method_8396(null, blkPos, $$6, class_3419.field_15245, 10.0f, 1.0f);
                level.method_14199((class_2394)class_2398.field_11236, (double)((float)blkPos.method_10263() + 0.5f), (double)((float)blkPos.method_10264() + 0.5f), (double)((float)blkPos.method_10260() + 0.5f), 1, 0.1, 0.1, 0.1, 0.2);
            }
            if (!(entities = MainUtil.hitboxGas(MainUtil.genHitbox((class_1937)level, blkPos.method_10263(), blkPos.method_10264(), blkPos.method_10260(), hitRadius, hitRadius + 1, hitRadius))).isEmpty()) {
                class_1282 $$5 = ModDamageTypes.of((class_1937)level, ModDamageTypes.GASOLINE_EXPLOSION);
                for (class_1297 value : entities) {
                    if (value instanceof GasolineCanEntity) {
                        value.method_5650(class_1297.class_5529.field_26999);
                        MainUtil.gasExplode(null, level, value.method_23312(), iteration + 1, 1, blockRadius, power);
                        break;
                    }
                    if (value.method_5753()) continue;
                    value.method_5639(15);
                    float np = power;
                    if (value instanceof class_1309) {
                        ((StandUser)value).roundabout$setGasolineTime(-1);
                        if (value instanceof class_1657) {
                            np *= 0.31f;
                        }
                        int f = class_1890.method_8203((class_1887)class_1893.field_9095, (class_1309)((class_1309)value));
                        np = (float)((double)np * (1.0 - (double)f * 0.045));
                    }
                    if (value instanceof class_1309 && ((class_1309)value).method_6059(class_1294.field_5918)) {
                        class_1293 instance = ((class_1309)value).method_6112(class_1294.field_5918);
                        ((class_1309)value).method_6016(class_1294.field_5918);
                        value.method_5643($$5, np);
                        ((class_1309)value).method_6092(instance);
                        continue;
                    }
                    value.method_5643($$5, np);
                }
            }
        }
        if (blk != null) {
            level.method_8650(blkPos, false);
        }
        HashSet gasList = Sets.newHashSet();
        if (!level.field_9236 && iteration < 8) {
            for (int x = -blockRadius; x < blockRadius; ++x) {
                for (int y = -blockRadius; y < blockRadius; ++y) {
                    for (int z = -blockRadius; z < blockRadius; ++z) {
                        boolean ignited;
                        class_2338 blkPo2 = new class_2338(blkPos.method_10263() + x, blkPos.method_10264() + y, blkPos.method_10260() + z);
                        class_2680 state = level.method_8320(blkPo2);
                        class_2248 block = state.method_26204();
                        if (!(block instanceof GasolineBlock) || (ignited = ((Boolean)state.method_11654((class_2769)GasolineBlock.IGNITED)).booleanValue())) continue;
                        state = (class_2680)state.method_11657((class_2769)GasolineBlock.IGNITED, (Comparable)Boolean.valueOf(true));
                        level.method_8652(blkPo2, state, 1);
                        gasList.add(blkPo2);
                    }
                }
            }
            if (!gasList.isEmpty()) {
                for (class_2338 gasPuddle : gasList) {
                    class_2680 state = level.method_8320(gasPuddle);
                    MainUtil.gasExplode(state, level, gasPuddle, iteration + 1, hitRadius, blockRadius, power);
                }
            }
        }
    }

    public static class_1309 getStoneTarget(class_1937 $$0, class_1309 $$1) {
        List<class_1297> entities = MainUtil.hitbox(MainUtil.genHitbox($$0, $$1.method_23317(), $$1.method_23318(), $$1.method_23321(), 5.0, 5.0, 5.0));
        double maxDistance = 5.0;
        class_1309 target = null;
        if (!entities.isEmpty()) {
            for (class_1297 value : entities) {
                double distance;
                if (!(value instanceof class_1309) || value.method_5667() == $$1.method_5667() || value instanceof StandEntity || value instanceof FallenMob || !((distance = value.method_19538().method_1022($$1.method_19538())) <= maxDistance) || ((StandUser)value).roundabout$getLocacacaCurse() >= 0) continue;
                target = (class_1309)value;
                maxDistance = distance;
            }
        }
        return target;
    }

    public static class_1297 getTargetEntity(class_1309 User, float distance) {
        return MainUtil.getTargetEntity(User, distance, 25);
    }

    public static class_1297 getTargetEntity(class_1309 User, float distance, int angle) {
        MainUtil.getDistanceOut(User, distance, false);
        class_1297 targetEntity = MainUtil.rayCastEntity((class_1297)User, distance);
        if (targetEntity == null) {
            float halfReach = (float)((double)distance * 0.5);
            class_243 pointVec = DamageHandler.getRayPoint(User, halfReach);
            targetEntity = MainUtil.AttackHitboxNear((class_1297)User, MainUtil.GrabHitbox(User, DamageHandler.genHitbox(User, pointVec.field_1352, pointVec.field_1351, pointVec.field_1350, halfReach, halfReach, halfReach), distance, angle), distance);
        }
        if (targetEntity instanceof class_1508) {
            class_1508 EDP = (class_1508)targetEntity;
            targetEntity = EDP.field_7007;
        }
        return targetEntity;
    }

    public static float getDistanceOut(class_1309 entity, float range, boolean offset) {
        float distanceFront = MainUtil.getRayDistance(entity, range);
        if (offset) {
            class_1297 targetEntity = MainUtil.rayCastEntity((class_1297)entity, range);
            if (targetEntity != null && targetEntity.method_5739((class_1297)entity) < distanceFront) {
                distanceFront = targetEntity.method_5739((class_1297)entity);
            }
            distanceFront -= 1.0f;
            distanceFront = Math.max(Math.min(distanceFront, 1.7f), 0.4f);
        }
        return distanceFront;
    }

    public static float getRayDistance(class_1309 entity, float range) {
        class_243 vec3d = entity.method_5836(0.0f);
        class_243 vec3d2 = entity.method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * (double)range, vec3d2.field_1351 * (double)range, vec3d2.field_1350 * (double)range);
        class_3965 blockHit = entity.method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)entity));
        if (blockHit.method_17783() != class_239.class_240.field_1333) {
            return class_3532.method_15355((float)((float)entity.method_5707(blockHit.method_17784())));
        }
        return range;
    }

    public static boolean isThrownBlockItem(class_1792 item) {
        if (item instanceof class_1747) {
            class_2248 blk = ((class_1747)item).method_7711();
            return !(item instanceof class_1798) && !(blk instanceof class_2261) && !(blk instanceof class_2560) && !(blk instanceof BarbedWireBundleBlock) && !(blk instanceof class_2527) && !(blk instanceof class_7113) && !(blk instanceof class_5546) && !(blk instanceof class_3709) && !(blk instanceof class_2488) && !(blk instanceof class_2542) && !(blk instanceof class_2577) && !(blk instanceof class_2523) && !(blk instanceof class_4865) && !(blk instanceof StereoBlock) && !(blk instanceof class_2362) && !(blk instanceof class_2309) && !(blk instanceof class_2541) && !(blk instanceof class_8238) && !(blk instanceof class_2231) && !(blk instanceof class_5635) && !(blk instanceof class_2484) && !(blk instanceof class_2337) && !(blk instanceof class_2383) && (!(blk instanceof class_3737) || blk instanceof class_2397);
        }
        return false;
    }

    public static List<class_1297> GrabHitbox(class_1309 User, List<class_1297> entities, float maxDistance, int angle) {
        ArrayList<class_1297> hitEntities = new ArrayList<class_1297>(entities){};
        for (class_1297 value : entities) {
            if (!value.method_5709() || value.method_5655() || !value.method_5805() || User.method_5765() && User.method_5854().method_5667() == value.method_5667()) {
                hitEntities.remove(value);
                continue;
            }
            if (MainUtil.angleDistance(MainUtil.getLookAtEntityYaw((class_1297)User, value), User.method_5791() % 360.0f) <= (float)angle && MainUtil.angleDistance(MainUtil.getLookAtEntityPitch((class_1297)User, value), User.method_36455()) <= (float)angle) continue;
            hitEntities.remove(value);
        }
        return hitEntities;
    }

    public static int getTargetEntityId(class_1309 User, float distance) {
        return MainUtil.getTargetEntityId(User, distance, 25);
    }

    public static int getTargetEntityId(class_1309 User, float distance, int angle) {
        class_1297 targetEntity = MainUtil.getTargetEntity(User, distance, angle);
        int id = targetEntity != null ? targetEntity.method_5628() : -1;
        return id;
    }

    public static boolean isStandDamage(class_1282 sauce) {
        return sauce.method_49708(ModDamageTypes.STAND) || sauce.method_49708(ModDamageTypes.PENETRATING_STAND) || sauce.method_49708(ModDamageTypes.STAR_FINGER) || sauce.method_49708(ModDamageTypes.STAND_RUSH) || sauce.method_49708(ModDamageTypes.CROSSFIRE) || sauce.method_49708(ModDamageTypes.CORPSE) || sauce.method_49708(ModDamageTypes.CORPSE_EXPLOSION) || sauce.method_49708(ModDamageTypes.CORPSE_ARROW);
    }

    public static float getLookAtEntityPitch(class_1297 user, class_1297 targetEntity) {
        double f;
        double d = targetEntity.method_23317() - user.method_23317();
        double e = targetEntity.method_23321() - user.method_23321();
        if (targetEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)targetEntity;
            f = livingEntity.method_23320() - user.method_23320();
        } else {
            f = (targetEntity.method_5829().field_1322 + targetEntity.method_5829().field_1325) / 2.0 - user.method_23320();
        }
        double g = Math.sqrt(d * d + e * e);
        return (float)(-(class_3532.method_15349((double)f, (double)g) * 57.2957763671875));
    }

    public static float getLookAtEntityYaw(class_1297 user, class_1297 targetEntity) {
        double d = targetEntity.method_23317() - user.method_23317();
        double e = targetEntity.method_23321() - user.method_23321();
        return (float)(class_3532.method_15349((double)e, (double)d) * 57.2957763671875) - 90.0f;
    }

    public static float angleDistance(float alpha, float beta) {
        float phi = Math.abs(beta - alpha) % 360.0f;
        float distance = phi > 180.0f ? 360.0f - phi : phi;
        return distance;
    }

    public static class_1297 AttackHitboxNear(class_1297 User, List<class_1297> entities, float distance) {
        float nearestDistance = -1.0f;
        class_1297 nearestMob = null;
        if (entities != null) {
            for (class_1297 value : entities) {
                if (value.method_5655() || !value.method_5805() || value.method_5667() == User.method_5667()) continue;
                float distanceTo = value.method_5739(User);
                if (!(nearestDistance < 0.0f) && !(distanceTo < nearestDistance) || !(distanceTo <= distance)) continue;
                nearestDistance = distanceTo;
                nearestMob = value;
            }
        }
        return nearestMob;
    }

    public static class_1297 rayCastEntity(class_1297 entityX, float reach) {
        class_1297 hitResult;
        float tickDelta = 0.0f;
        if (entityX.method_37908().method_8608()) {
            tickDelta = ClientUtil.getDelta();
        }
        class_243 vec3d = entityX.method_5836(tickDelta);
        class_243 vec3d2 = entityX.method_5828(1.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * (double)reach, vec3d2.field_1351 * (double)reach, vec3d2.field_1350 * (double)reach);
        float f = 1.0f;
        class_238 box = new class_238(vec3d.field_1352 + (double)reach, vec3d.field_1351 + (double)reach, vec3d.field_1350 + (double)reach, vec3d.field_1352 - (double)reach, vec3d.field_1351 - (double)reach, vec3d.field_1350 - (double)reach);
        class_3966 entityHitResult = class_1675.method_18075((class_1297)entityX, (class_243)vec3d, (class_243)vec3d3, (class_238)box, entity -> !entity.method_7325() && entity.method_5863() && !entity.method_5655(), (double)(reach * reach));
        if (entityHitResult != null && (hitResult = entityHitResult.method_17782()).method_5805() && !hitResult.method_31481()) {
            return hitResult;
        }
        return null;
    }

    public static StandUser getUserData(class_1309 User) {
        return (StandUser)User;
    }

    public static boolean knockShield(class_1297 entity, int duration) {
        if (entity != null && entity.method_5805() && !entity.method_31481() && entity instanceof class_1309 && ((class_1309)entity).method_6039()) {
            StandUser standUser = MainUtil.getUserData((class_1309)entity);
            if (!standUser.roundabout$isGuarding() && entity instanceof class_1657) {
                class_1799 itemStack = ((class_1309)entity).method_6030();
                class_1792 item = itemStack.method_7909();
                if (item.method_7853(itemStack) == class_1839.field_8949) {
                    ((class_1309)entity).method_6075();
                    ((class_1657)entity).method_6021();
                }
                ((class_1657)entity).method_7357().method_7906(class_1802.field_8255, duration);
                entity.method_37908().method_8421(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public static boolean knockShieldPlusStand(class_1297 entity, int duration) {
        if (entity != null && entity.method_5805() && !entity.method_31481() && entity instanceof class_1309 && ((class_1309)entity).method_6039()) {
            StandUser standUser = MainUtil.getUserData((class_1309)entity);
            if (standUser.roundabout$isGuarding() && !standUser.roundabout$getGuardBroken()) {
                standUser.roundabout$breakGuard();
            }
            if (entity instanceof class_1657) {
                class_1799 itemStack = ((class_1309)entity).method_6030();
                class_1792 item = itemStack.method_7909();
                if (item.method_7853(itemStack) == class_1839.field_8949) {
                    ((class_1309)entity).method_6075();
                    ((class_1657)entity).method_6021();
                }
                ((class_1657)entity).method_7357().method_7906(class_1802.field_8255, duration);
                entity.method_37908().method_8421(entity, (byte)30);
            }
            return true;
        }
        return false;
    }

    public static boolean canPlaceSplatter(class_1937 level, class_2338 pos, int offsetX, int offsetY, int offsetZ) {
        class_2338 $$8;
        class_2338 blk = new class_2338(pos.method_10263() + offsetX, pos.method_10264() + offsetY, pos.method_10260() + offsetZ);
        return level.method_22347(blk) && level.method_8320($$8 = blk.method_10074()).method_26206((class_1922)level, $$8, class_2350.field_11036);
    }

    public static void setSplatter(class_1937 level, class_2338 pos, int offsetX, int offsetZ, class_2680 state) {
        class_2338 blockPos = null;
        if (MainUtil.canPlaceSplatter(level, pos, offsetX, 1, offsetZ)) {
            blockPos = new class_2338(pos.method_10263() + offsetX, pos.method_10264() + 1, pos.method_10260() + offsetZ);
        } else if (MainUtil.canPlaceSplatter(level, pos, offsetX, 2, offsetZ)) {
            blockPos = new class_2338(pos.method_10263() + offsetX, pos.method_10264() + 2, pos.method_10260() + offsetZ);
        } else if (MainUtil.canPlaceSplatter(level, pos, offsetX, 0, offsetZ)) {
            blockPos = new class_2338(pos.method_10263() + offsetX, pos.method_10264(), pos.method_10260() + offsetZ);
        } else if (MainUtil.canPlaceSplatter(level, pos, offsetX, -1, offsetZ)) {
            blockPos = new class_2338(pos.method_10263() + offsetX, pos.method_10264() - 1, pos.method_10260() + offsetZ);
        }
        if (blockPos != null) {
            level.method_8501(new class_2338(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260()), state);
        }
    }

    public static void handShake(class_3222 player) {
        Networking.sendConfigToPlayer(player);
    }

    public static void handleBytePacketC2S(class_1657 player, byte data, byte context) {
        if (context == 8) {
            ((StandUser)player).roundabout$getStandPowers().setCooldown(data, -1);
        } else if (context == 7) {
            ((IPlayerEntity)player).roundabout$SetPoseEmote(data);
        } else if (context == 10) {
            StandPowers standPowers = ((StandUser)player).roundabout$getStandPowers();
            if (standPowers instanceof PowersJustice) {
                PowersJustice PJ = (PowersJustice)standPowers;
                PJ.justiceTacticsUse(data);
            }
        } else if (context == 6) {
            StandPowers sp = ((StandUser)player).roundabout$getStandPowers();
            ShapeShifts shift = ShapeShifts.getShiftFromByte(data);
            if (sp instanceof PowersJustice) {
                PowersJustice pj = (PowersJustice)sp;
                if (ShapeShifts.isVillager(shift) && !sp.canExecuteMoveWithLevel(pj.getVillagerMorphLevel())) {
                    return;
                }
                if (ShapeShifts.isZombie(shift) && !sp.canExecuteMoveWithLevel(pj.getZombieMorphLevel())) {
                    return;
                }
                if (ShapeShifts.isSkeleton(shift) && !sp.canExecuteMoveWithLevel(pj.getSkeletonMorphLevel())) {
                    return;
                }
                if (shift == ShapeShifts.VILLAGER) {
                    byte totalMorph = 0;
                    class_1646 ent = (class_1646)player.method_37908().method_21726(class_1646.class, OFFER_TARGER_CONTEXT, (class_1309)player, player.method_23317(), player.method_23318(), player.method_23321(), player.method_5829().method_1009(12.0, 2.0, 12.0));
                    if (ent != null) {
                        class_3854 VT = ent.method_7231().method_16919();
                        class_3852 VP = ent.method_7231().method_16924();
                        totalMorph = (byte)(ShapeShifts.getByteFromType(VT) + ShapeShifts.getByteFromProfession(VP));
                    } else {
                        class_3854 VT = class_3854.method_16930((class_6880)player.method_37908().method_23753(player.method_24515()));
                        totalMorph = (byte)(ShapeShifts.getByteFromType(VT) + 1);
                    }
                    ((IPlayerEntity)player).roundabout$setShapeShiftExtraData(totalMorph);
                }
                ((IPlayerEntity)player).roundabout$shapeShift();
                ((IPlayerEntity)player).roundabout$setShapeShift(data);
            }
        } else if (context == 6) {
            // empty if block
        }
    }

    public static void handleSingleBytePacketC2S(class_1657 player, byte context) {
        class_1720 fm;
        class_1263 ct;
        class_1703 ME2;
        if (context == 7) {
            ((StandUser)player).roundabout$summonStand(player.method_37908(), false, false);
        } else if (context == 10) {
            StandUser user = (StandUser)player;
            user.roundabout$getStandPowers().getSkinInDirection(false);
        } else if (context == 11) {
            StandUser user = (StandUser)player;
            user.roundabout$getStandPowers().getSkinInDirection(true);
        } else if (context == 12) {
            StandUser user = (StandUser)player;
            user.roundabout$getStandPowers().getPoseInDirection(false);
        } else if (context == 13) {
            StandUser user = (StandUser)player;
            user.roundabout$getStandPowers().getPoseInDirection(true);
        } else if (context == 9) {
            StandUser standUser = (StandUser)player;
            standUser.roundabout$getStandPowers().setCooldown(context, -1);
            IPlayerEntity iplay = (IPlayerEntity)player;
            byte unlocked = 0;
            if (iplay.roundabout$getUnlockedBonusSkin()) {
                unlocked = 1;
            }
            ModPacketHandler.PACKET_ACCESS.sendBundlePacket((class_3222)player, (byte)1, standUser.roundabout$getStandSkin(), unlocked, (byte)0);
            if (player.field_7512 != player.field_7498) {
                player.field_7512 = player.field_7498;
            }
            ((IPlayerEntityServer)player).roundabout$nextContainerCounter();
            int cid = ((IPlayerEntityServer)player).roundabout$getCounter();
            ModPacketHandler.PACKET_ACCESS.sendIntPacket((class_3222)player, (byte)6, cid);
            player.field_7512 = new PowerInventoryMenu(player.method_31548(), true, player, cid);
            ((IPlayerEntityServer)player).roundabout$initMenu(player.field_7512);
        } else if (context == 14) {
            player.field_7512 = new FogInventoryMenu(player.method_31548(), !player.method_37908().field_9236, player);
            ((IPlayerEntityServer)player).roundabout$initMenu(player.field_7512);
        } else if (context == 1) {
            ((StandUser)player).roundabout$getStandPowers().playSoundsIfNearby((byte)-2, 10.0, false);
        } else if (context == 2) {
            ((StandUser)player).roundabout$getStandPowers().stopSoundsIfNearby((byte)104, 30.0, false);
        } else if (context == 3) {
            ((StandUser)player).roundabout$getStandPowers().playSoundsIfNearby((byte)-3, 10.0, false);
        } else if (context == 4) {
            StandEntity iplay;
            if (player != null && (iplay = ((StandUser)player).roundabout$getStand()) instanceof StarPlatinumEntity) {
                StarPlatinumEntity SE = (StarPlatinumEntity)iplay;
                SE.setScoping(true);
                if (ClientNetworking.getAppropriateConfig().starPlatinumScopeUsesPotionEffectForNightVision.booleanValue()) {
                    player.method_37222(new class_1293(class_1294.field_5925, 1000000, 0, false, false), null);
                }
            }
        } else if (context == 5) {
            StandEntity iplay;
            if (player != null && (iplay = ((StandUser)player).roundabout$getStand()) instanceof StarPlatinumEntity) {
                class_1293 ME2;
                StarPlatinumEntity SE = (StarPlatinumEntity)iplay;
                SE.setScoping(false);
                if (ClientNetworking.getAppropriateConfig().starPlatinumScopeUsesPotionEffectForNightVision.booleanValue() && (ME2 = player.method_6112(class_1294.field_5925)) != null && ME2.method_5584() >= 100000) {
                    player.method_6016(class_1294.field_5925);
                }
            }
        } else if (context == 6) {
            if (player != null) {
                ((StandUser)player).roundabout$getStandPowers().forwardBarrage = true;
                ((StandUser)player).roundabout$getStandPowers().moveStarted = true;
                ((StandUser)player).roundabout$getStandPowers().poseStand((byte)3);
                StandEntity SE = ((StandUser)player).roundabout$getStand();
                if (SE != null) {
                    SE.method_33574(player.method_30950(0.0f).method_1019(player.method_5663().method_1021(2.0)).method_1031(0.0, (double)0.2f, 0.0));
                    SE.method_36456(player.method_5791() % 360.0f);
                }
            }
        } else if (context == 15 && player != null && (ME2 = player.field_7512) instanceof class_1720 && (ct = ((IAbstractFurnaceMenu)(fm = (class_1720)ME2)).roundabout$getContainer()) instanceof class_2609) {
            class_2609 fbe = (class_2609)ct;
            ((IAbstractFurnaceBlockEntity)fbe).roundabout$setFurnaceHeatingTime(1000);
        }
    }

    public static void handleFloatPacketC2S(class_1657 player, float data, byte context) {
        if (context == 1) {
            if (player.method_5854() != null) {
                if (player.method_5854().method_5643(ModDamageTypes.of(player.method_37908(), ModDamageTypes.BARBED_WIRE), data)) {
                    MainUtil.makeBleed(player.method_5854(), 0, 200, null);
                }
            } else if (player.method_5643(ModDamageTypes.of(player.method_37908(), ModDamageTypes.BARBED_WIRE), data)) {
                MainUtil.makeBleed((class_1297)player, 0, 200, null);
            }
        } else if (context == 2) {
            StandEntity standEntity = ((StandUser)player).roundabout$getStand();
            if (standEntity instanceof StarPlatinumEntity) {
                StarPlatinumEntity SP = (StarPlatinumEntity)standEntity;
                SP.setFingerLength(data);
            }
        } else if (context == 3) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setDistanceOut(data);
        } else if (context == 4) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setSizePercent(data);
        } else if (context == 5) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setIdleRotation(data);
        } else if (context == 6) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setIdleYOffset(data);
        } else if (context == 7) {
            ((StandUser)player).roundabout$getStandPowers().updateMove(data);
        }
    }

    public static void handleIntPacketC2S(class_1657 player, int data, byte context) {
        if (context == 1) {
            class_1297 target = player.method_37908().method_8469(data);
            target.method_5643(ModDamageTypes.of(player.method_37908(), ModDamageTypes.GLAIVE), (float)data);
        } else if (context == 2) {
            if (((StandUser)player).roundabout$getStandPowers().getChargedTSTicks() > data) {
                ((StandUser)player).roundabout$getStandPowers().setChargedTSTicks(data);
            }
        } else if (context == 3) {
            ((StandUser)player).roundabout$setRestrainedTicks(data);
        } else if (context == 4) {
            class_1297 target = player.method_37908().method_8469(data);
            ((StandUser)player).roundabout$getStandPowers().handleStandAttack(player, target);
        } else if (context == 5) {
            class_1297 target = player.method_37908().method_8469(data);
            ((StandUser)player).roundabout$getStandPowers().handleStandAttack2(player, target);
        } else if (context == 6) {
            IPlayerEntity ple = (IPlayerEntity)player;
            ple.roundabout$setAnchorPlace(data);
        } else if (context == 7) {
            ((StandUser)player).roundabout$getStandPowers().updateIntMove(data);
        } else if (context == 8) {
            StandEntity SE = ((StandUser)player).roundabout$getStand();
            if (SE != null) {
                class_2338 veci3 = class_2338.method_49638((class_2374)new class_243(SE.method_23317(), SE.method_23318() + (double)SE.method_5751(), SE.method_23321()));
                class_2680 bl3 = SE.method_37908().method_8320(veci3);
                if (!bl3.method_51367() || !bl3.method_26204().method_37403(bl3, (class_1922)player.method_37908(), veci3) && !(bl3.method_26204() instanceof class_2482) && !(bl3.method_26204() instanceof class_2510)) {
                    ((StandUser)player).roundabout$getStandPowers().setPiloting(data);
                }
            } else {
                ((StandUser)player).roundabout$getStandPowers().setPiloting(data);
            }
        }
    }

    public static void syncCooldownsForAttacks(int attackTime, int attackTimeMax, int attackTimeDuring, byte activePower, byte activePowerPhase, class_1657 pl) {
        StandPowers powers = ((StandUser)pl).roundabout$getStandPowers();
        if (powers.activePower != activePower) {
            if (activePower == 0) {
                powers.setAttackTimeDuring(-1);
            } else {
                powers.setAttackTimeDuring(0);
            }
        }
        powers.updateMovesFromPacket(activePower);
        powers.setActivePower(activePower);
        powers.kickStartClient();
    }
}

