/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod;

import java.io.InputStreamReader;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.datagen.RoundaboutBlockModelProvider;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.zetalasis.hjson.JsonObject;
import net.zetalasis.hjson.JsonValue;

@Mod.EventBusSubscriber(modid="roundabout", bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenerators {
    public static Optional<InputStreamReader> getJsonResourceStream(String resource) {
        try {
            return Optional.of(new InputStreamReader(Thread.currentThread().getContextClassLoader().getResource("assets/minecraft/" + resource + ".json").openStream()));
        }
        catch (Exception e) {
            Roundabout.LOGGER.info("Failed to get resource stream: " + resource);
            return Optional.empty();
        }
    }

    /*
     * Exception decompiling
     */
    public static Optional<String> getModelFromBStateStream(InputStreamReader is) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Optional<String> getTexturefromModelName(String mname) {
        InputStreamReader assetResource = DataGenerators.getJsonResourceStream("models/block/" + mname.replace("minecraft:block/", "")).get();
        JsonObject obj = JsonValue.readJSON(assetResource).asObject().get("textures").asObject();
        for (JsonObject.Member mb : obj) {
            String model = "";
            try {
                model = mb.getValue().asObject().get("texture").asString();
                return Optional.of(model);
            }
            catch (Exception e) {
                try {
                    model = mb.getValue().asArray().get(0).asObject().get("texture").asString();
                    return Optional.of(model);
                }
                catch (Exception e2) {
                    try {
                        model = mb.getValue().asString();
                        return Optional.of(model);
                    }
                    catch (Exception e3) {
                        try {
                        }
                        catch (Exception e4) {
                            return Optional.empty();
                        }
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeClient(), (DataProvider)new RoundaboutBlockModelProvider(packOutput, "roundabout", existingFileHelper));
    }
}

