/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import java.util.List;
import net.hydra.jojomod.block.FogBlock;
import net.hydra.jojomod.block.FogTrapBlockEntity;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.entity.corpses.FallenMob;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.PowersJustice;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FogTrapBlock
extends FogBlock
implements EntityBlock {
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected static final VoxelShape AABB = Block.m_49796_((double)0.0, (double)1.0, (double)0.0, (double)16.0, (double)2.5, (double)16.0);
    protected static final VoxelShape NOT_ATTACHED_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);

    public FogTrapBlock(BlockBehaviour.Properties $$0) {
        super($$0);
    }

    public FogTrapBlock(BlockBehaviour.Properties $$0, boolean untrue) {
        super($$0, untrue);
    }

    @Override
    public void m_6807_(BlockState $$0, Level $$1, BlockPos $$2, BlockState $$3, boolean $$4) {
        super.m_6807_($$0, $$1, $$2, $$3, $$4);
    }

    private boolean checkWire(ServerLevel lv, BlockPos pos, BooleanProperty prop) {
        if (lv.m_8055_(pos).m_60713_(ModBlocks.FOG_TRAP) || lv.m_8055_(pos).m_60713_(Blocks.f_50267_)) {
            BlockState bstate = lv.m_8055_(pos);
            if (!((Boolean)bstate.m_61143_((Property)prop)).booleanValue()) {
                bstate = (BlockState)bstate.m_61124_((Property)prop, (Comparable)Boolean.valueOf(true));
                lv.m_46597_(pos, bstate);
            }
            return true;
        }
        return false;
    }

    @Override
    public void m_213897_(BlockState $$0, ServerLevel $$1, BlockPos $$2, RandomSource $$3) {
        if (((Boolean)$$0.m_61143_((Property)IN_FOG)).booleanValue()) {
            List entsIn = $$1.m_45933_((Entity)null, $$0.m_60808_((BlockGetter)$$1, $$2).m_83215_().m_82338_($$2));
            if (!entsIn.isEmpty() && !((Entity)entsIn.get(0)).m_6090_()) {
                this.stepped($$1, $$2, $$0, (Entity)entsIn.get(0));
            }
            boolean isNorth = this.checkWire($$1, $$2.m_122012_(), SOUTH);
            boolean isSouth = this.checkWire($$1, $$2.m_122019_(), NORTH);
            boolean isEast = this.checkWire($$1, $$2.m_122029_(), WEST);
            boolean isWest = this.checkWire($$1, $$2.m_122024_(), EAST);
            if ((Boolean)$$0.m_61143_((Property)NORTH) != isNorth || (Boolean)$$0.m_61143_((Property)SOUTH) != isSouth || (Boolean)$$0.m_61143_((Property)EAST) != isEast || (Boolean)$$0.m_61143_((Property)WEST) != isWest) {
                $$0 = (BlockState)$$0.m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(isNorth));
                $$0 = (BlockState)$$0.m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(isSouth));
                $$0 = (BlockState)$$0.m_61124_((Property)EAST, (Comparable)Boolean.valueOf(isEast));
                $$0 = (BlockState)$$0.m_61124_((Property)WEST, (Comparable)Boolean.valueOf(isWest));
                $$1.m_46597_($$2, $$0);
            }
        }
        super.m_213897_($$0, $$1, $$2, $$3);
    }

    @Override
    public boolean m_7357_(BlockState $$0, BlockGetter $$1, BlockPos $$2, PathComputationType $$3) {
        return true;
    }

    public void stepped(ServerLevel $$0, BlockPos $$1, BlockState $$2, Entity stepper) {
        PowersJustice justice;
        StandUser se;
        StandPowers standPowers;
        FogTrapBlockEntity fbe = (FogTrapBlockEntity)$$0.m_7702_($$1);
        Entity ownerEntity = null;
        String name = "";
        if (fbe != null && fbe.getOwner() != null) {
            ownerEntity = $$0.m_8791_(fbe.getOwner());
            name = fbe.getName();
        }
        if (((Boolean)$$2.m_61143_((Property)IN_FOG)).booleanValue() && ownerEntity != null && !stepper.m_7306_(ownerEntity) && ownerEntity instanceof StandUser && (standPowers = (se = (StandUser)ownerEntity).roundabout$getStandPowers()) instanceof PowersJustice && !(justice = (PowersJustice)standPowers).queryJusticeEntities().contains(stepper)) {
            if (stepper instanceof ServerPlayer) {
                ServerPlayer stp = (ServerPlayer)stepper;
                stp.m_216990_(SoundEvents.f_12524_);
            }
            if (ownerEntity instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)ownerEntity;
                if (name != null && !name.isEmpty() && !name.equals("[Fog Trap]")) {
                    sp.m_5661_((Component)Component.m_237113_((String)name).m_7220_((Component)Component.m_237115_((String)"text.roundabout.warn_trap_triggered").m_130940_(ChatFormatting.YELLOW)), true);
                } else {
                    sp.m_5661_((Component)Component.m_237115_((String)"text.roundabout.warn_unnamed_trap_triggered").m_130940_(ChatFormatting.YELLOW), true);
                }
                sp.m_216990_(ModSounds.SUMMON_SOUND_EVENT);
                for (LivingEntity e : justice.queryJusticeEntities()) {
                    if (!(e instanceof FallenMob)) continue;
                    FallenMob m = (FallenMob)e;
                    if (!(stepper instanceof LivingEntity)) continue;
                    LivingEntity enemy = (LivingEntity)stepper;
                    if (!(e.m_20275_((double)$$1.m_123341_(), (double)$$1.m_123342_(), (double)$$1.m_123343_()) < (double)fbe.getRange())) continue;
                    m.m_6710_(enemy);
                }
            }
        }
        super.m_141947_((Level)$$0, $$1, $$2, stepper);
    }

    public void m_6402_(Level $$0, BlockPos $$1, BlockState $$2, @Nullable LivingEntity $$3, ItemStack $$4) {
        BlockEntity blockEntity;
        if ($$3 != null && (blockEntity = $$0.m_7702_($$1)) instanceof FogTrapBlockEntity) {
            FogTrapBlockEntity fe = (FogTrapBlockEntity)blockEntity;
            fe.setValues((Entity)$$3, $$3.m_21120_($$3.m_7655_()).m_41611_().getString());
        }
        super.m_6402_($$0, $$1, $$2, $$3, $$4);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> $$0) {
        $$0.m_61104_(new Property[]{POWERED, IN_FOG, NORTH, EAST, WEST, SOUTH});
    }

    @Override
    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        if (((Boolean)blockState.m_61143_((Property)IN_FOG)).booleanValue()) {
            return NOT_ATTACHED_AABB;
        }
        return Shapes.m_83040_();
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos blockPos, BlockState blockState) {
        return new FogTrapBlockEntity(blockPos, blockState);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level $$0, BlockState $$1, BlockEntityType<T> $$2) {
        return super.m_142354_($$0, $$1, $$2);
    }

    @Nullable
    public <T extends BlockEntity> GameEventListener m_214009_(ServerLevel $$0, T $$1) {
        return super.m_214009_($$0, $$1);
    }
}

