/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.gui.config;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.gui.config.ConfigScreen;
import net.hydra.jojomod.client.gui.config.ConfigType;
import net.hydra.jojomod.client.gui.config.EditValueScreen;
import net.hydra.jojomod.util.config.ClientConfig;
import net.hydra.jojomod.util.config.Config;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ConfigListWidget
extends ContainerObjectSelectionList<Entry> {
    private final ConfigScreen parent;
    private final HashMap<String, Object> configFields = new HashMap();
    private final ConfigType configType;
    public static int constant1 = 340;
    public static int constant2 = constant1 - 40;

    public ConfigListWidget(ConfigScreen parent, Minecraft client, ConfigType selectedType) {
        super(client, constant1, parent.f_96544_, 20, parent.f_96544_ - 40, 32);
        Field[] fields;
        this.m_93507_((parent.f_96543_ - constant1) / 2);
        this.parent = parent;
        this.configType = selectedType;
        switch (selectedType) {
            case COMMON: {
                this.m_7085_((AbstractSelectionList.Entry)new CommentEntry("\u00a7r\u00a76\u00a7l" + Component.m_237115_((String)"config.roundabout.major.common_config").getString()));
                break;
            }
            case CLIENT: {
                this.m_7085_((AbstractSelectionList.Entry)new CommentEntry("\u00a7r\u00a76\u00a7l" + Component.m_237115_((String)"config.roundabout.major.client_config").getString()));
            }
        }
        Cloneable instance = null;
        switch (selectedType) {
            case COMMON: {
                instance = Config.getLocalInstance();
                break;
            }
            case CLIENT: {
                instance = ClientConfig.getLocalInstance();
            }
        }
        Class<?> clazz = instance.getClass();
        for (Field field : fields = clazz.getFields()) {
            field.setAccessible(true);
            try {
                Object value = field.get(instance);
                this.configFields.put(field.getName(), value);
                if (value instanceof Boolean) {
                    this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry(field, instance));
                    continue;
                }
                if (value instanceof Integer || value instanceof Float) {
                    this.m_7085_((AbstractSelectionList.Entry)new NumberEntry(field, instance));
                    continue;
                }
                if (value instanceof String) {
                    this.m_7085_((AbstractSelectionList.Entry)new StringEntry(field, instance));
                    continue;
                }
                Object nestedObject = field.get(instance);
                this.m_7085_((AbstractSelectionList.Entry)new CommentEntry(Component.m_237115_((String)("config.roundabout." + field.getName() + ".name")).getString()));
                if (nestedObject == null) continue;
                for (Field clazzField : nestedObject.getClass().getFields()) {
                    clazzField.setAccessible(true);
                    Object clazzValue = clazzField.get(nestedObject);
                    if (clazzValue instanceof Boolean) {
                        this.m_7085_((AbstractSelectionList.Entry)new BooleanEntry(clazzField, nestedObject));
                        continue;
                    }
                    if (clazzValue instanceof Integer || clazzValue instanceof Float) {
                        this.m_7085_((AbstractSelectionList.Entry)new NumberEntry(clazzField, nestedObject));
                        continue;
                    }
                    if (!(clazzValue instanceof String)) continue;
                    this.m_7085_((AbstractSelectionList.Entry)new StringEntry(clazzField, nestedObject));
                }
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Failed to parse configFields", e);
            }
        }
    }

    public int m_5759_() {
        return constant2;
    }

    protected int m_5756_() {
        return this.m_5747_() + 20 + this.m_5759_() - 6;
    }

    public void renderHover(GuiGraphics drawContext, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTic, Field field, Button editButton) {
        if (editButton.m_274382_()) {
            String[] strung2;
            ArrayList compList = Lists.newArrayList();
            for (String s : strung2 = ClientUtil.splitIntoLine(Component.m_237115_((String)("config.roundabout." + field.getName() + ".desc")).getString(), 35)) {
                compList.add(Component.m_237113_((String)s).m_130940_(ChatFormatting.BLUE));
            }
            drawContext.m_280677_(Minecraft.m_91087_().f_91062_, (List)compList, Optional.empty(), x, y + 8 - 10 * strung2.length);
        }
    }

    public class CommentEntry
    extends Entry {
        private final String comment;

        public CommentEntry(String comment) {
            this.comment = comment;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            guiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237113_((String)("\u00a7e\u00a7l" + this.comment + "\u00a7r")), x + entryWidth / 2, y + 6, 0xFFFFFF);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of();
        }
    }

    public class BooleanEntry
    extends Entry {
        private final Field field;
        private final Object instance;
        private final Button toggleButton;

        public BooleanEntry(Field field, Object instance) {
            this.field = field;
            this.instance = instance;
            boolean currentValue = false;
            try {
                currentValue = (Boolean)field.get(instance);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            this.toggleButton = Button.m_253074_((Component)Component.m_237115_((String)("config.roundabout." + field.getName() + ".name")).m_7220_(this.getNewValueRender(currentValue)), btn -> {
                try {
                    Boolean newVal = (Boolean)field.get(instance) == false;
                    field.set(instance, newVal);
                    switch (ConfigListWidget.this.configType) {
                        case COMMON: {
                            ConfigManager.saveLocalConfig();
                            break;
                        }
                        case CLIENT: {
                            ConfigManager.saveClientConfig();
                        }
                    }
                    btn.m_93666_((Component)Component.m_237115_((String)("config.roundabout." + field.getName() + ".name")).m_7220_(this.getNewValueRender(newVal)));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }).m_253046_(constant2, 20).m_253136_();
        }

        public Component getNewValueRender(boolean newVal) {
            if (newVal) {
                return Component.m_237113_((String)": ").m_7220_((Component)Component.m_237113_((String)("" + newVal)).m_130940_(ChatFormatting.AQUA));
            }
            return Component.m_237113_((String)": ").m_7220_((Component)Component.m_237113_((String)("" + newVal)).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }

        public void m_6311_(GuiGraphics drawContext, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float delta) {
            this.toggleButton.m_252865_(x);
            this.toggleButton.m_253211_(y);
            this.toggleButton.m_88315_(drawContext, mouseX, mouseY, delta);
            ConfigListWidget.this.renderHover(drawContext, index, y, x, ConfigListWidget.this.f_93388_, ConfigListWidget.this.f_93389_, mouseX, mouseY, hovered, delta, this.field, this.toggleButton);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.toggleButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of(this.toggleButton);
        }
    }

    public class NumberEntry
    extends Entry {
        private final Field field;
        private final Object instance;
        private final Button editButton;

        public NumberEntry(Field field, Object instance) {
            this.field = field;
            this.instance = instance;
            String display = this.getFieldDisplay();
            this.editButton = Button.m_253074_((Component)Component.m_237113_((String)display), btn -> Minecraft.m_91087_().m_91152_((Screen)new EditValueScreen(ConfigListWidget.this.parent, field, instance, ConfigListWidget.this.configType, ConfigListWidget.this.m_93517_()))).m_253046_(constant2, 20).m_253136_();
        }

        private String getFieldDisplay() {
            try {
                return this.field.getName() + ": " + String.valueOf(this.field.get(this.instance));
            }
            catch (IllegalAccessException e) {
                return this.field.getName() + ": [error]";
            }
        }

        public void m_6311_(GuiGraphics drawContext, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editButton.m_252865_(x);
            this.editButton.m_253211_(y);
            this.editButton.m_93666_((Component)Component.m_237115_((String)("config.roundabout." + this.field.getName() + ".name")));
            this.editButton.m_88315_(drawContext, mouseX, mouseY, partialTick);
            ConfigListWidget.this.renderHover(drawContext, index, y, x, width, height, mouseX, mouseY, hovering, partialTick, this.field, this.editButton);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.editButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of(this.editButton);
        }
    }

    public class StringEntry
    extends Entry {
        private final Field field;
        private final Object instance;
        private final Button editButton;

        public StringEntry(Field field, Object instance) {
            this.field = field;
            this.instance = instance;
            String display = this.getFieldDisplay();
            this.editButton = Button.m_253074_((Component)Component.m_237113_((String)display), btn -> Minecraft.m_91087_().m_91152_((Screen)new EditValueScreen(ConfigListWidget.this.parent, field, instance, ConfigListWidget.this.configType, ConfigListWidget.this.m_93517_()))).m_253046_(constant2, 20).m_253136_();
        }

        private String getFieldDisplay() {
            try {
                return this.field.getName() + ": " + String.valueOf(this.field.get(this.instance));
            }
            catch (IllegalAccessException e) {
                return this.field.getName() + ": [error]";
            }
        }

        public void m_6311_(GuiGraphics drawContext, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean hovering, float partialTick) {
            this.editButton.m_252865_(x);
            this.editButton.m_253211_(y);
            this.editButton.m_93666_((Component)Component.m_237115_((String)("config.roundabout." + this.field.getName() + ".name")));
            this.editButton.m_88315_(drawContext, mouseX, mouseY, partialTick);
            ConfigListWidget.this.renderHover(drawContext, index, y, x, width, height, mouseX, mouseY, hovering, partialTick, this.field, this.editButton);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return List.of(this.editButton);
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of(this.editButton);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

