/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.corpses.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.hydra.jojomod.client.models.corpses.FallenVillagerModel;
import net.hydra.jojomod.entity.corpses.FallenVillager;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CrossedArmsItemLayer;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;

public class FallenVillagerRenderer
extends MobRenderer<FallenVillager, FallenVillagerModel<FallenVillager>> {
    private static final ResourceLocation FALLEN_VILLAGER_LOCATION = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_villager.png");
    private static final ResourceLocation FALLEN_VILLAGER_LOCATION_2 = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_villager_holes.png");
    private static final ResourceLocation FALLEN_VILLAGER_LOCATION_B = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_villager_blue.png");
    private static final ResourceLocation FALLEN_VILLAGER_LOCATION_R = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_villager_red.png");
    private static final ResourceLocation FALLEN_VILLAGER_LOCATION_G = new ResourceLocation("roundabout", "textures/entity/justice_corpses/justice_villager_green.png");
    private static final ResourceLocation VILLAGER_BASE_SKIN = new ResourceLocation("textures/entity/villager/villager.png");

    public FallenVillagerRenderer(EntityRendererProvider.Context $$0) {
        super($$0, new FallenVillagerModel($$0.m_174023_(ModelLayers.f_171210_)), 0.5f);
        this.m_115326_((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, $$0.m_174027_(), $$0.m_234598_()));
        this.m_115326_((RenderLayer)new CrossedArmsItemLayer((RenderLayerParent)this, $$0.m_234598_()));
    }

    public ResourceLocation getTextureLocation(FallenVillager var1) {
        if (var1.getTurned()) {
            if (var1.getActivated()) {
                byte bt = var1.getJusticeTeamColor();
                if (bt == 1) {
                    return FALLEN_VILLAGER_LOCATION_B;
                }
                if (bt == 2) {
                    return FALLEN_VILLAGER_LOCATION_R;
                }
                if (bt == 3) {
                    return FALLEN_VILLAGER_LOCATION_G;
                }
                if (bt == 4) {
                    return VILLAGER_BASE_SKIN;
                }
            }
            return FALLEN_VILLAGER_LOCATION_2;
        }
        return FALLEN_VILLAGER_LOCATION;
    }

    protected void scale(FallenVillager $$0, PoseStack $$1, float $$2) {
        float $$3 = 0.9375f;
        if ($$0.m_6162_()) {
            $$3 *= 0.5f;
            this.f_114477_ = 0.25f;
        } else {
            this.f_114477_ = 0.5f;
        }
        $$1.m_85841_($$3, $$3, $$3);
    }

    protected void setupRotations(FallenVillager FM, PoseStack pose, float $$2, float $$3, float $$4) {
        super.m_7523_((LivingEntity)FM, pose, $$2, $$3, $$4);
        int tickTock = FM.ticksThroughPhases;
        if (FM.getPhasesFull()) {
            tickTock = 10;
            FM.ticksThroughPhases = 10;
        }
        float yes = Math.min(10.0f, (float)tickTock + $$4);
        if (FM.getActivated()) {
            yes = Math.max(0.0f, (float)tickTock - $$4);
        }
        float $$5 = yes / 10.0f;
        pose.m_252781_(Axis.f_252529_.m_252977_($$5 * 90.0f));
        pose.m_85837_(0.0, (double)(-$$5) * (0.5 * (double)FM.m_20206_()), -((double)$$5 * 0.15));
    }
}

