/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.Map;
import net.hydra.jojomod.client.ModStrayModels;
import net.hydra.jojomod.item.FirearmItem;
import net.hydra.jojomod.item.SnubnoseRevolverItem;
import net.hydra.jojomod.item.TommyGunItem;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class FirearmLayer<T extends LivingEntity, A extends HumanoidModel<T>>
extends RenderLayer<T, A> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final EntityRenderDispatcher dispatcher;
    float scale = 1.0f;

    public FirearmLayer(EntityRendererProvider.Context context, LivingEntityRenderer<T, A> livingEntityRenderer) {
        super(livingEntityRenderer);
        this.dispatcher = context.m_174022_();
    }

    private void renderFirearm(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, LivingEntity entity, float partialTicks, ItemStack stack, boolean rightSide, boolean mainArmRight) {
        boolean actualRightArm;
        boolean isSnub = stack.m_41720_() instanceof SnubnoseRevolverItem;
        boolean isTommy = stack.m_41720_() instanceof TommyGunItem;
        if (!isSnub && !isTommy) {
            return;
        }
        boolean bl = actualRightArm = rightSide == mainArmRight;
        if (actualRightArm) {
            ((HumanoidModel)this.m_117386_()).f_102811_.m_104299_(poseStack);
        } else {
            ((HumanoidModel)this.m_117386_()).f_102812_.m_104299_(poseStack);
        }
        if (isSnub) {
            poseStack.m_252880_(actualRightArm ? -0.032f : 0.032f, 0.55f, -0.66f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            ModStrayModels.SNUBNOSE_REVOLVER_MODEL.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, 1.0f, entity.f_20916_ > 0 ? 0.0f : 1.0f, entity.f_20916_ > 0 ? 0.0f : 1.0f, 1.0f);
        }
        if (isTommy) {
            poseStack.m_252880_(actualRightArm ? 0.09f : -0.09f, 0.77f, -1.2f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            poseStack.m_85841_(0.9f, 0.9f, 0.9f);
            ModStrayModels.TOMMY_GUN_MODEL.render((Entity)entity, partialTicks, poseStack, bufferSource, packedLight, 1.0f, entity.f_20916_ > 0 ? 0.0f : 1.0f, entity.f_20916_ > 0 ? 0.0f : 1.0f, 1.0f);
        }
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, T entity, float var5, float var6, float var7, float partialTicks, float var9, float var10) {
        Player player;
        Player player2;
        if (entity instanceof Player) {
            Player player3 = (Player)entity;
            if (entity.m_20145_() || entity.m_20177_(player3)) {
                return;
            }
        }
        T livent = entity;
        ItemStack held = entity.m_21205_();
        ItemStack offHeld = entity.m_21206_();
        boolean isHoldingFirearmRight = held.m_41720_() instanceof FirearmItem;
        boolean isHoldingFirearmLeft = offHeld.m_41720_() instanceof FirearmItem;
        if (!isHoldingFirearmRight && !isHoldingFirearmLeft || ConfigManager.getClientConfig() == null || !ConfigManager.getClientConfig().enableFirearmRender.booleanValue()) {
            return;
        }
        boolean mainArmRight = entity instanceof Player && (player2 = (Player)entity).m_5737_() == HumanoidArm.RIGHT;
        poseStack.m_85836_();
        if (isHoldingFirearmRight) {
            poseStack.m_85836_();
            this.renderFirearm(poseStack, bufferSource, packedLight, (LivingEntity)entity, partialTicks, held, true, mainArmRight);
            poseStack.m_85849_();
        }
        boolean skipOffhand = false;
        if (entity instanceof Player && (player = (Player)entity).m_6117_() && player.m_21211_() == held) {
            skipOffhand = true;
        }
        if (isHoldingFirearmLeft && !skipOffhand) {
            poseStack.m_85836_();
            this.renderFirearm(poseStack, bufferSource, packedLight, (LivingEntity)entity, partialTicks, offHeld, false, mainArmRight);
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }
}

