/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.projectile.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.hydra.jojomod.entity.projectile.BloodSplatterEntity;
import net.hydra.jojomod.event.powers.TimeStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BloodSplatterRenderer
extends EntityRenderer<BloodSplatterEntity> {
    private static final ResourceLocation ITEM_1 = new ResourceLocation("roundabout", "textures/entity/projectile/blood_1.png");
    private static final ResourceLocation ITEM_2 = new ResourceLocation("roundabout", "textures/entity/projectile/blood_2.png");
    private static final ResourceLocation ITEM_3 = new ResourceLocation("roundabout", "textures/entity/projectile/blood_3.png");
    private static final ResourceLocation ITEM_4 = new ResourceLocation("roundabout", "textures/entity/projectile/blood_4.png");
    private static final ResourceLocation ITEM_5 = new ResourceLocation("roundabout", "textures/entity/projectile/blood_5.png");
    private static final ResourceLocation ITEM_6 = new ResourceLocation("roundabout", "textures/entity/projectile/blood_6.png");
    private final float scale;

    public BloodSplatterRenderer(EntityRendererProvider.Context context, float scale) {
        super(context);
        this.scale = scale;
    }

    public BloodSplatterRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.scale = 1.0f;
    }

    public void render(BloodSplatterEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (((TimeStop)entity.m_9236_()).inTimeStopRange((Entity)entity)) {
            partialTicks = 0.0f;
        }
        if (entity != null) {
            poseStack.m_85836_();
            poseStack.m_85841_(this.scale, this.scale, this.scale);
            poseStack.m_252781_(this.f_114476_.m_253208_());
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            poseStack.m_252880_(0.0f, entity.m_20205_() / 2.0f, 0.0f);
            VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity)));
            Matrix4f matrix = poseStack.m_85850_().m_252922_();
            Vector3f normal = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
            normal.normalize();
            Vector3f coursecorrect = new Vector3f(0.577f, 0.577f, 0.577f);
            if (normal.y > 0.0f) {
                coursecorrect = new Vector3f(0.01f, 1.0f, 0.01f);
                if ((double)normal.y > 0.95) {
                    coursecorrect = new Vector3f(-0.577f, -0.577f, -0.577f);
                }
            }
            float size = 0.4f;
            vertexConsumer.m_252986_(matrix, -size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            vertexConsumer.m_252986_(matrix, -size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
            poseStack.m_85849_();
            super.m_7392_((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public ResourceLocation getTextureLocation(BloodSplatterEntity entity) {
        int div = entity.f_19797_;
        return switch (div) {
            case 0, 1 -> ITEM_1;
            case 2, 3 -> ITEM_2;
            case 4, 5 -> ITEM_3;
            case 6, 7 -> ITEM_4;
            case 8, 9 -> ITEM_5;
            default -> ITEM_6;
        };
    }
}

