/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.ISuperThrownAbstractArrow;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BladedBowlerHatEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(BladedBowlerHatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(BladedBowlerHatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private ItemStack bowlerHatItem = ItemStack.f_41583_;
    private boolean dealtDamage;
    public boolean isThrown = false;
    public int clientSideReturnTridentTickCount;
    boolean isHoldingItem;
    int holdingCheck;
    private int bounceCount = 0;
    private int critBounceCount = 0;
    private static final int max_bounces = 3;
    public boolean skyHit = false;

    public void setItem(ItemStack stack) {
        this.bowlerHatItem = stack == null ? ItemStack.f_41583_ : stack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.bowlerHatItem)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)this.bowlerHatItem.m_41790_());
    }

    public BladedBowlerHatEntity(EntityType<? extends BladedBowlerHatEntity> type, Level level) {
        super(type, level);
    }

    public BladedBowlerHatEntity(Level level, LivingEntity livingEntity, ItemStack itemStack) {
        super(ModEntities.BLADED_BOWLER_HAT, livingEntity, level);
        this.bowlerHatItem = itemStack;
        this.bowlerHatItem = itemStack.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)itemStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)itemStack.m_41790_());
    }

    public BladedBowlerHatEntity(Level $$0, LivingEntity $$1, ItemStack $$2, double p_36862_, double p_36863_, double p_36864_) {
        super(ModEntities.BLADED_BOWLER_HAT, p_36862_, p_36863_, p_36864_, $$0);
        this.bowlerHatItem = $$2.m_41777_();
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)$$2)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)$$2.m_41790_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
    }

    public void m_8119_() {
        Entity $$0 = this.m_19749_();
        int $$1 = 2;
        Vec3 $$26 = this.m_20184_();
        if ($$1 <= 0 || !this.dealtDamage && !this.m_36797_() || $$0 == null) {
            this.m_20334_($$26.f_82479_, $$26.f_82480_ + (double)0.01f, $$26.f_82481_);
        }
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            boolean isFlying;
            boolean bl = isFlying = this.m_20184_().m_82556_() > 0.01;
            if (isFlying && this.f_19797_ % 80 == 1 && !((TimeStop)this.m_9236_()).inTimeStopRange((Entity)this)) {
                ClientUtil.handleBowlerHatFlySound((Entity)this);
            }
        }
        if (this.holdingCheck < 1) {
            ++this.holdingCheck;
            this.isHoldingItem = false;
        }
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= 200) {
            Player player;
            Entity entity = this.m_19749_();
            if (entity instanceof Player && (player = (Player)entity).m_6084_()) {
                if (!player.m_150109_().m_36054_(this.m_7941_())) {
                    player.m_36176_(this.m_7941_(), false);
                }
            } else {
                ItemEntity $$4 = new ItemEntity(this.m_9236_(), this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_(), this.m_7941_());
                $$4.m_32010_(0);
                this.m_9236_().m_7967_((Entity)$$4);
            }
            this.m_146870_();
            return;
        }
        if (!this.m_9236_().f_46443_ && !this.isHoldingItem) {
            List tntNearby;
            double pickupRadius = 1.0;
            double tntPickupRadius = 2.0;
            List itemsNearby = this.m_9236_().m_6443_(ItemEntity.class, this.m_20191_().m_82400_(pickupRadius), item -> !item.m_213877_() && !item.m_32063_());
            if (!itemsNearby.isEmpty()) {
                ItemEntity itemEntity = (ItemEntity)itemsNearby.get(0);
                itemEntity.m_7998_((Entity)this, true);
                this.isHoldingItem = true;
            }
            if (!(tntNearby = this.m_9236_().m_6443_(PrimedTnt.class, this.m_20191_().m_82400_(tntPickupRadius), tnt -> !tnt.m_213877_())).isEmpty()) {
                PrimedTnt tntEntity = (PrimedTnt)tntNearby.get(0);
                tntEntity.m_7998_((Entity)this, true);
                this.isHoldingItem = true;
            }
        }
        if (!this.m_9236_().f_46443_) {
            if ((float)this.f_36704_ > 0.1f) {
                this.dealtDamage = true;
            }
            if ($$1 > 0 && (this.dealtDamage || this.m_36797_()) && $$0 != null) {
                if (!this.isAcceptibleReturnOwner()) {
                    if (this.f_36705_ == AbstractArrow.Pickup.DISALLOWED) {
                        this.m_5552_(this.m_7941_(), 0.1f);
                    }
                    this.m_146870_();
                } else {
                    this.m_36790_(true);
                    Vec3 $$2 = $$0.m_146892_().m_82546_(this.m_20182_());
                    this.m_20343_(this.m_20185_(), this.m_20186_() + $$2.f_82480_ * 0.015 * (double)$$1, this.m_20189_());
                    double $$3 = 0.05 * (double)$$1;
                    this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_($$2.m_82541_().m_82490_($$3)));
                    if (this.clientSideReturnTridentTickCount == 0 && this.m_9236_().f_46443_) {
                        this.m_5496_(ModSounds.HARPOON_RETURN_EVENT, 10.0f, 1.0f);
                    }
                    ++this.clientSideReturnTridentTickCount;
                }
            }
        }
    }

    private boolean isAcceptibleReturnOwner() {
        Entity $$0 = this.m_19749_();
        return $$0 == null ? false : !($$0 instanceof ServerPlayer) || !$$0.m_5833_();
    }

    protected ItemStack m_7941_() {
        if (this.bowlerHatItem.m_41619_()) {
            return ItemStack.f_41583_;
        }
        Entity owner = this.m_19749_();
        ItemStack stack = this.bowlerHatItem.m_41777_();
        if (owner instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)owner;
            stack.m_41622_(1, livingEntity, e -> {});
        }
        return stack;
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 $$0, Vec3 $$1) {
        return this.dealtDamage ? null : super.m_6351_($$0, $$1);
    }

    protected void m_8060_(BlockHitResult hitResult) {
        EntityHitResult entityHitResult;
        Vec3 end;
        Vec3 start;
        this.m_5496_(ModSounds.HARPOON_GROUND_EVENT, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        if (this.bounceCount >= 3) {
            super.m_8060_(hitResult);
            this.f_36703_ = true;
            return;
        }
        Vec3 velocity = this.m_20184_();
        Direction hitDir = hitResult.m_82434_();
        Vec3 normal = Vec3.m_82528_((Vec3i)hitDir.m_122436_());
        Vec3 reflected = velocity.m_82546_(normal.m_82490_(2.0 * velocity.m_82526_(normal)));
        reflected = reflected.m_82490_(0.7);
        this.m_20256_(reflected);
        Vec3 hitLoc = hitResult.m_82450_();
        Vec3 pushOut = normal.m_82490_(0.5);
        this.m_6034_(hitLoc.f_82479_ + pushOut.f_82479_, hitLoc.f_82480_ + pushOut.f_82480_, hitLoc.f_82481_ + pushOut.f_82481_);
        this.f_36703_ = false;
        this.f_36706_ = 0;
        this.dealtDamage = false;
        ++this.bounceCount;
        if (hitResult.m_82434_() != Direction.UP) {
            ++this.critBounceCount;
        }
        if (!this.m_9236_().f_46443_) {
            start = this.m_20182_();
            end = start.m_82549_(reflected);
            BlockHitResult extraHit = this.m_9236_().m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            if (extraHit.m_6662_() == HitResult.Type.BLOCK) {
                Vec3 n2 = Vec3.m_82528_((Vec3i)extraHit.m_82434_().m_122436_());
                Vec3 reflected2 = reflected.m_82546_(n2.m_82490_(2.0 * reflected.m_82526_(n2))).m_82490_(0.6);
                this.m_20256_(reflected2);
                Vec3 pushOut2 = n2.m_82490_(0.5);
                this.m_6034_(extraHit.m_82450_().f_82479_ + pushOut2.f_82479_, extraHit.m_82450_().f_82480_ + pushOut2.f_82480_, extraHit.m_82450_().f_82481_ + pushOut2.f_82481_);
            }
        }
        if (!this.m_9236_().f_46443_ && (entityHitResult = this.m_6351_(start = this.m_20182_(), end = start.m_82549_(reflected))) != null) {
            this.m_5790_(entityHitResult);
        }
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity $$1 = $$0.m_82443_();
        if ($$1 instanceof SoftAndWetBubbleEntity) {
            return;
        }
        if ($$1 instanceof PrimedTnt) {
            return;
        }
        float $$2 = 4.0f;
        Entity $$4 = this.m_19749_();
        DamageSource $$5 = ModDamageTypes.of(this.m_9236_(), ModDamageTypes.BLADED_BOWLER_HAT, (Entity)this, (Entity)($$4 == null ? this : $$4));
        this.dealtDamage = true;
        this.skyHit = false;
        $$2 = this.addSkyAndBounceDamage($$1, $$2);
        if (this.isThrown) {
            $$2 = ((ISuperThrownAbstractArrow)((Object)this)).roundabout$getSuperThrow() ? ($$2 *= 2.0f) : ($$2 *= 1.5f);
        }
        if ($$1.m_6469_($$5, $$2)) {
            if ($$1.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if ($$1 instanceof LivingEntity) {
                LivingEntity $$7 = (LivingEntity)$$1;
                if ($$4 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)$$7, (Entity)$$4);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)$$4), (Entity)$$7);
                }
                this.m_7761_($$7);
            }
        }
        ((ISuperThrownAbstractArrow)((Object)this)).roundabout$cancelSuperThrow();
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        float $$8 = 1.0f;
        if (this.skyHit) {
            this.m_5496_(ModSounds.HARPOON_CRIT_EVENT, $$8, 1.0f);
        } else {
            this.m_5496_(ModSounds.HARPOON_HIT_EVENT, $$8, 1.0f);
        }
    }

    public float addSkyAndBounceDamage(Entity target, float damage) {
        if (this.critBounceCount == 1) {
            damage += 6.0f;
            this.skyHit = true;
        } else if (this.critBounceCount == 2) {
            damage += 8.0f;
            this.skyHit = true;
        } else if (this.critBounceCount == 3) {
            damage += 12.0f;
            this.skyHit = true;
        }
        if (MainUtil.getMobBleed(target)) {
            LivingEntity livingEntity = (LivingEntity)target;
            float healthBefore = livingEntity.m_21223_();
            boolean didHurt = livingEntity.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.BLADED_BOWLER_HAT, (Entity)this, this.m_19749_()), damage);
            float healthAfter = livingEntity.m_21223_();
            if (didHurt && healthAfter < healthBefore) {
                ((StandUser)target).roundabout$setBleedLevel(1);
                livingEntity.m_147207_(new MobEffectInstance(ModEffects.BLEED, 400, 0), (Entity)this);
            }
        }
        return damage;
    }

    public boolean isChanneling() {
        return EnchantmentHelper.m_44936_((ItemStack)this.bowlerHatItem);
    }

    protected boolean m_142470_(Player $$0) {
        return super.m_142470_($$0) || this.m_36797_() && this.m_150171_((Entity)$$0) && $$0.m_150109_().m_36054_(this.m_7941_());
    }

    public void m_6123_(Player $$0) {
        if (this.m_150171_((Entity)$$0) || this.m_19749_() == null) {
            super.m_6123_($$0);
        }
    }

    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
        if ($$0.m_128425_("BladedBowlerHat", 10)) {
            this.bowlerHatItem = ItemStack.m_41712_((CompoundTag)$$0.m_128469_("BladedBowlerHat"));
        }
        this.dealtDamage = $$0.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)this.bowlerHatItem)));
    }

    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
        if (!this.bowlerHatItem.m_41619_()) {
            $$0.m_128365_("BladedBowlerHat", (Tag)this.bowlerHatItem.m_41739_(new CompoundTag()));
        }
        $$0.m_128379_("DealtDamage", this.dealtDamage);
    }

    public void m_6901_() {
        int $$0 = 1;
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || $$0 <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double $$0, double $$1, double $$2) {
        return true;
    }
}

