/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import net.hydra.jojomod.access.IAbstractArrowAccess;
import net.hydra.jojomod.access.IEnderMan;
import net.hydra.jojomod.access.IProjectileAccess;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.RoadRollerEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractGlassBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class RoundaboutBulletEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Boolean> ROUNDABOUT$SUPER_THROWN = SynchedEntityData.m_135353_(RoundaboutBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Byte> AMMO_TYPE = SynchedEntityData.m_135353_(RoundaboutBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> DEFLECTED = SynchedEntityData.m_135353_(RoundaboutBulletEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static final byte NONE = 0;
    public static final byte REVOLVER = 1;
    public static final byte TOMMY_GUN = 2;
    public static final byte SNIPER = 3;
    boolean timeStopShot = false;
    int outsideOfTimeStop = 0;
    private int superThrownTimer = 0;
    boolean deflectSoundPlayed = false;

    public RoundaboutBulletEntity(EntityType<? extends RoundaboutBulletEntity> type, Level level) {
        super(type, level);
    }

    public RoundaboutBulletEntity(Level level, LivingEntity livingEntity) {
        super(ModEntities.ROUNDABOUT_BULLET_ENTITY, livingEntity, level);
    }

    public RoundaboutBulletEntity(Level $$0, LivingEntity $$1, ItemStack $$2, double p_36862_, double p_36863_, double p_36864_) {
        super(ModEntities.ROUNDABOUT_BULLET_ENTITY, p_36862_, p_36863_, p_36864_, $$0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("SuperThrown", ((Boolean)this.f_19804_.m_135370_(ROUNDABOUT$SUPER_THROWN)).booleanValue());
        tag.m_128344_("AmmoType", ((Byte)this.f_19804_.m_135370_(AMMO_TYPE)).byteValue());
        tag.m_128379_("TimeStopShot", this.timeStopShot);
        tag.m_128405_("OutsideTimeStop", this.outsideOfTimeStop);
        tag.m_128405_("SuperThrownTimer", this.superThrownTimer);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)tag.m_128471_("SuperThrown"));
        this.f_19804_.m_135381_(AMMO_TYPE, (Object)tag.m_128445_("AmmoType"));
        this.timeStopShot = tag.m_128471_("TimeStopShot");
        this.outsideOfTimeStop = tag.m_128451_("OutsideTimeStop");
        this.superThrownTimer = tag.m_128451_("SuperThrownTimer");
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROUNDABOUT$SUPER_THROWN, (Object)true);
        this.f_19804_.m_135372_(AMMO_TYPE, (Object)0);
        this.f_19804_.m_135372_(DEFLECTED, (Object)false);
    }

    public boolean getSuperThrown() {
        return (Boolean)this.f_19804_.m_135370_(ROUNDABOUT$SUPER_THROWN);
    }

    public void setSuperThrown(boolean value) {
        this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)value);
    }

    public boolean getDeflected() {
        return (Boolean)this.f_19804_.m_135370_(DEFLECTED);
    }

    public void setDeflected(boolean value) {
        this.f_19804_.m_135381_(DEFLECTED, (Object)value);
    }

    public final void setAmmoType(byte ammoType) {
        this.f_19804_.m_135381_(AMMO_TYPE, (Object)ammoType);
    }

    public byte getAmmoType() {
        return (Byte)this.f_19804_.m_135370_(AMMO_TYPE);
    }

    public ItemStack getBulletItemStack() {
        if (this.getAmmoType() == 0) {
            return ItemStack.f_41583_;
        }
        if (this.getAmmoType() == 1) {
            ItemStack itemStack = ModItems.SNUBNOSE_AMMO.m_7968_();
            return itemStack;
        }
        if (this.getAmmoType() == 2) {
            ItemStack itemStack = ModItems.TOMMY_AMMO.m_7968_();
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public void applyEffect(LivingEntity target) {
        if (!MainUtil.isBossMob(target) && !(target instanceof RoadRollerEntity) && MainUtil.getMobBleed((Entity)target)) {
            ((StandUser)target).roundabout$setBleedLevel(1);
            target.m_147207_(new MobEffectInstance(ModEffects.BLEED, 400, 0), (Entity)this);
        }
    }

    private float getBulletDamage() {
        return switch (this.getAmmoType()) {
            case 1 -> {
                if (this.timeStopShot) {
                    yield 3.7f;
                }
                yield 4.0f;
            }
            case 2 -> {
                if (this.timeStopShot) {
                    yield 0.74f;
                }
                yield 0.82f;
            }
            case 3 -> {
                if (this.timeStopShot) {
                    yield 3.7f;
                }
                yield 4.0f;
            }
            default -> 0.0f;
        };
    }

    public void m_5790_(EntityHitResult result) {
        LivingEntity $$3;
        StandPowers entityPowers;
        Entity entity = result.m_82443_();
        if (!this.m_9236_().f_46443_ && entity instanceof EnderMan) {
            EnderMan em = (EnderMan)entity;
            if (((IEnderMan)em).roundabout$teleport()) {
                return;
            }
            for (int i = 0; i < 64; ++i) {
                if (!((IEnderMan)em).roundabout$teleport()) continue;
                return;
            }
        }
        if (entity instanceof LivingEntity && (entityPowers = ((StandUser)($$3 = (LivingEntity)entity)).roundabout$getStandPowers()) != null && entityPowers.dealWithProjectile((Entity)this, (HitResult)result)) {
            return;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (livingEntity.m_20147_()) {
                return;
            }
            if (this.outsideOfTimeStop > 0) {
                livingEntity.f_20916_ = 0;
                livingEntity.f_19802_ = 0;
            }
            float damage = this.getBulletDamage();
            boolean didDamage = livingEntity.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.BULLET, (Entity)this, this.m_19749_()), damage);
            if (didDamage) {
                this.applyEffect(livingEntity);
            }
        }
        Entity $$2 = this.m_19749_();
        DamageSource damageSource = ModDamageTypes.of(this.m_9236_(), ModDamageTypes.BULLET, (Entity)this, $$2);
        if ($$2 instanceof LivingEntity) {
            LivingEntity livingOwner = (LivingEntity)$$2;
            livingOwner.m_21335_(entity);
        }
        this.m_9236_().m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ModSounds.BULLET_PENTRATION_EVENT, this.m_5720_(), 1.0f, 1.0f);
        this.m_146870_();
    }

    protected void onHitBlock2(BlockHitResult $$0) {
        ((IAbstractArrowAccess)((Object)this)).roundabout$setLastState(this.m_9236_().m_8055_($$0.m_82425_()));
        BlockState BSS = this.m_9236_().m_8055_($$0.m_82425_());
        BSS.m_60669_(this.m_9236_(), BSS, $$0, (Projectile)this);
        Vec3 $$1 = $$0.m_82450_().m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        this.m_20256_($$1);
        Vec3 $$2 = $$1.m_82541_().m_82490_((double)0.05f);
        this.m_20343_(this.m_20185_() - $$2.f_82479_, this.m_20186_() - $$2.f_82480_, this.m_20189_() - $$2.f_82481_);
        this.m_5496_(ModSounds.BULLET_PENTRATION_EVENT, 1.0f, 1.2f / (this.f_19796_.m_188501_() * 0.2f + 0.9f));
        this.f_36703_ = true;
        this.f_36706_ = 7;
        this.m_36762_(false);
        this.m_36767_((byte)0);
        this.m_36740_(SoundEvents.f_11685_);
        this.m_36793_(false);
        ((IAbstractArrowAccess)((Object)this)).roundabout$resetPiercedEntities();
    }

    protected void m_7761_(LivingEntity target) {
    }

    public void m_8119_() {
        Vec3 delta = this.m_20184_();
        if (((IProjectileAccess)((Object)this)).roundabout$getRoundaboutIsTimeStopCreated()) {
            this.timeStopShot = true;
        }
        if (this.getSuperThrown() && this.getAmmoType() != 3) {
            ++this.superThrownTimer;
            if (this.superThrownTimer >= 20) {
                this.setSuperThrown(false);
                this.superThrownTimer = 0;
            }
        } else {
            this.superThrownTimer = 0;
        }
        if (this.timeStopShot) {
            if (this.outsideOfTimeStop < 5) {
                ++this.outsideOfTimeStop;
            } else if (this.outsideOfTimeStop >= 5) {
                this.timeStopShot = false;
                this.outsideOfTimeStop = 0;
            }
        }
        if (this.f_36704_ >= 160) {
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        if (this.m_20069_()) {
            this.f_19804_.m_135381_(ROUNDABOUT$SUPER_THROWN, (Object)false);
        }
        super.m_8119_();
        if (this.getSuperThrown()) {
            this.m_20256_(delta);
        }
        if (!this.m_9236_().f_46443_ && !this.f_36703_) {
            boolean isFlying;
            boolean bl = isFlying = this.m_20184_().m_82556_() > 1.0;
            if (isFlying) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.2f, 0.2f, 0.2f), 1.0f), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }

    public void blockBreakParticles(Block block, Vec3 pos) {
        if (!this.m_9236_().m_5776_()) {
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block.m_49966_()), pos.f_82479_, pos.f_82480_, pos.f_82481_, 100, 0.0, 0.0, 0.0, 0.5);
        }
    }

    protected void m_8060_(BlockHitResult $$0) {
        Block blkk;
        this.setSuperThrown(false);
        this.m_20256_(Vec3.f_82478_);
        if (!this.m_9236_().f_46443_ && ((blkk = this.m_9236_().m_8055_($$0.m_82425_()).m_60734_()) instanceof AbstractGlassBlock || blkk instanceof StainedGlassPaneBlock || blkk.m_49966_().m_60713_(Blocks.f_50185_)) && this.m_9236_().m_7471_($$0.m_82425_(), false)) {
            this.blockBreakParticles(blkk, new Vec3((double)$$0.m_82425_().m_123341_() + 0.5, (double)$$0.m_82425_().m_123342_() + 0.5, (double)$$0.m_82425_().m_123343_() + 0.5));
            this.m_5496_(blkk.m_49966_().m_60827_().m_56775_(), 1.0f, 0.9f);
            return;
        }
        this.onHitBlock2($$0);
    }

    protected boolean m_142470_(Player $$0) {
        return false;
    }

    public void m_6901_() {
        int $$0 = 1;
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || $$0 <= 0) {
            super.m_6901_();
        }
    }

    protected float m_6882_() {
        return 0.99f;
    }

    public boolean m_6000_(double $$0, double $$1, double $$2) {
        return true;
    }
}

