/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.event.index;

import net.hydra.jojomod.access.IFatePlayer;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.fates.FatePowers;
import net.hydra.jojomod.fates.powers.VampireFate;
import net.hydra.jojomod.fates.powers.VampiricFate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;

public enum FateTypes {
    HUMAN(0, new FatePowers()),
    VAMPIRE(1, new VampireFate()),
    ZOMBIE(2, new FatePowers()),
    SHADOW_CREATURE(3, new FatePowers()),
    PILLAR_MAN(4, new FatePowers()),
    ULTIMATE_LIFEFORM(5, new FatePowers()),
    ROCK_HUMAN(6, new FatePowers()),
    GHOST(7, new FatePowers()),
    DOG(8, new FatePowers()),
    RAT(9, new FatePowers()),
    FALCON(10, new FatePowers()),
    PLANKTON_COLONY(11, new FatePowers());

    public final byte id;
    public final FatePowers fatePowers;

    private FateTypes(byte $$0, FatePowers $$1) {
        this.id = $$0;
        this.fatePowers = $$1;
    }

    public static FateTypes getFateFromByte(byte bt) {
        if (bt == FateTypes.VAMPIRE.id) {
            return VAMPIRE;
        }
        if (bt == FateTypes.SHADOW_CREATURE.id) {
            return SHADOW_CREATURE;
        }
        if (bt == FateTypes.PILLAR_MAN.id) {
            return PILLAR_MAN;
        }
        if (bt == FateTypes.ULTIMATE_LIFEFORM.id) {
            return ULTIMATE_LIFEFORM;
        }
        if (bt == FateTypes.ROCK_HUMAN.id) {
            return ROCK_HUMAN;
        }
        if (bt == FateTypes.GHOST.id) {
            return GHOST;
        }
        if (bt == FateTypes.DOG.id) {
            return DOG;
        }
        if (bt == FateTypes.RAT.id) {
            return RAT;
        }
        if (bt == FateTypes.FALCON.id) {
            return FALCON;
        }
        if (bt == FateTypes.PLANKTON_COLONY.id) {
            return PLANKTON_COLONY;
        }
        return HUMAN;
    }

    public static boolean isHuman(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IPlayerEntity)PE).roundabout$getFate() <= FateTypes.HUMAN.id;
        }
        return false;
    }

    public static boolean isVampire(LivingEntity entity) {
        Mob mb;
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IPlayerEntity)PE).roundabout$getFate() == FateTypes.VAMPIRE.id;
        }
        return entity instanceof Mob && ((IMob)(mb = (Mob)entity)).roundabout$isVampire();
    }

    public static float getDamageResist(LivingEntity entity, DamageSource source, float amt) {
        Mob mb;
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IFatePlayer)PE).rdbt$getFatePowers().getDamageReduction(source, amt);
        }
        if (entity instanceof Mob && ((IMob)(mb = (Mob)entity)).roundabout$isVampire()) {
            if (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_)) {
                return 0.15f;
            }
            if (source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(ModDamageTypes.BULLET)) {
                return 0.2f;
            }
        }
        return 0.0f;
    }

    public static float getDamageAdd(LivingEntity entity, DamageSource source, float amt) {
        if (source.m_7639_() != null) {
            Mob mb;
            Entity entity2 = source.m_7639_();
            if (entity2 instanceof Player) {
                Player PE = (Player)entity2;
                return ((IFatePlayer)PE).rdbt$getFatePowers().getDamageAdd(source, amt, (Entity)entity);
            }
            entity2 = source.m_7639_();
            if (entity2 instanceof Mob && ((IMob)(mb = (Mob)entity2)).roundabout$isVampire() && (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_))) {
                return 0.4f;
            }
        }
        return 0.0f;
    }

    public static boolean isEvil(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            Byte fate = ((IPlayerEntity)PE).roundabout$getFate();
            return fate == FateTypes.VAMPIRE.id || fate == FateTypes.ZOMBIE.id || fate == FateTypes.PILLAR_MAN.id || fate == FateTypes.ULTIMATE_LIFEFORM.id;
        }
        return false;
    }

    public static boolean isDaggerUpgraded(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            Byte fate = ((IPlayerEntity)PE).roundabout$getFate();
            return fate == FateTypes.VAMPIRE.id;
        }
        return false;
    }

    public static boolean isScary(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IPlayerEntity)PE).roundabout$getFate() == FateTypes.ZOMBIE.id;
        }
        return false;
    }

    public static boolean isVampireStrong(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IPlayerEntity)PE).roundabout$getFate() == FateTypes.VAMPIRE.id;
        }
        return false;
    }

    public static boolean hasBloodHunger(LivingEntity entity) {
        Mob mb;
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IPlayerEntity)PE).roundabout$getFate() == FateTypes.VAMPIRE.id;
        }
        return entity instanceof Mob && ((IMob)(mb = (Mob)entity)).roundabout$isVampire();
    }

    public static boolean canSeeInTheDark(LivingEntity entity) {
        if (entity instanceof Player) {
            VampiricFate VP;
            Player PE = (Player)entity;
            FatePowers fatePowers = ((IFatePlayer)PE).rdbt$getFatePowers();
            return fatePowers instanceof VampiricFate && (VP = (VampiricFate)fatePowers).isVisionOn();
        }
        return false;
    }

    public static boolean takesSunlightDamage(LivingEntity entity) {
        Mob mb;
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IPlayerEntity)PE).roundabout$getFate() == FateTypes.VAMPIRE.id;
        }
        return entity instanceof Mob && ((IMob)(mb = (Mob)entity)).roundabout$isVampire();
    }

    public static boolean isTransforming(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IFatePlayer)PE).rdbt$isTransforming();
        }
        return false;
    }

    public static void setVampire(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            ((IPlayerEntity)PE).roundabout$setFate(FateTypes.VAMPIRE.id);
        }
    }

    public static void setHuman(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            ((IPlayerEntity)PE).roundabout$setFate(FateTypes.HUMAN.id);
        }
    }

    public static float getJumpHeightAddon(LivingEntity entity) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IFatePlayer)PE).rdbt$getFatePowers().getJumpHeightAddon();
        }
        return 0.0f;
    }

    public static float getJumpHeightPower(LivingEntity entity, boolean isOverOriginal) {
        if (entity instanceof Player) {
            Player PE = (Player)entity;
            return ((IFatePlayer)PE).rdbt$getFatePowers().getJumpHeightPower(isOverOriginal);
        }
        return 0.0f;
    }

    public static boolean isInSunlight(LivingEntity ent) {
        if (!((TimeStop)ent.m_9236_()).inTimeStopRange((Entity)ent)) {
            long timeOfDay;
            Vec3 yes = ent.m_146892_();
            Vec3 yes2 = ent.m_20182_();
            int waterReach = ClientNetworking.getAppropriateConfig().vampireSettings.sunDamageUnderwaterReach;
            if (waterReach > 0) {
                for (int i = 0; i < waterReach; ++i) {
                    if (ent.m_9236_().m_8055_(BlockPos.m_274446_((Position)yes)).m_278721_()) {
                        yes = yes.m_82520_(0.0, 1.0, 0.0);
                        continue;
                    }
                    i = 100;
                }
            }
            boolean isDay = (timeOfDay = ent.m_9236_().m_46468_() % 24000L) < 12555L || timeOfDay > 23360L;
            BlockPos atVec = BlockPos.m_274446_((Position)yes);
            BlockPos atVec2 = BlockPos.m_274446_((Position)yes2);
            return (ent.m_9236_().m_45527_(atVec) || ent.m_9236_().m_45527_(atVec2)) && ent.m_9236_().m_46472_().m_135782_().m_135815_().equals("overworld") && isDay;
        }
        return false;
    }
}

