/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.fates.powers;

import java.util.List;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.fates.FatePowers;
import net.hydra.jojomod.fates.powers.VampiricFate;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class VampireFate
extends VampiricFate {
    public static final byte HYPNOSIS = 50;
    public static final byte HAIR_EXTENDED = 51;
    public int animationProgress = 0;
    public static final int hairChargeLength = 20;
    public boolean isHypnotizing = false;
    public int hypnoTicks = 0;
    public boolean rechargeJump = false;
    private final TargetingConditions hypnosisTargeting = TargetingConditions.m_148352_().m_26883_(7.0);

    public VampireFate() {
    }

    public VampireFate(LivingEntity self) {
        super(self);
    }

    @Override
    public FatePowers generateFatePowers(LivingEntity entity) {
        return new VampireFate(entity);
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                this.hypnosis();
                break;
            }
            case SKILL_1_CROUCH: {
                this.hairExtendClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.suckBlood();
                break;
            }
            case SKILL_2_CROUCH: {
                this.regenClient();
                break;
            }
            case SKILL_3_CROUCH: {
                this.bloodSpeedClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.dashOrWallWalk();
                break;
            }
            case SKILL_4_NORMAL: {
                this.setSuperHearingClient();
                break;
            }
            case SKILL_4_CROUCH: {
                this.clientChangeVision();
            }
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        if (move != 51 && !this.self.m_9236_().m_5776_() && this.getPlayerPos2() == 3) {
            super.setPlayerPos2((byte)0);
        }
        switch (move) {
            case 30: {
                this.wallLatch();
                break;
            }
            case 51: {
                this.hairExtendServer();
            }
        }
        return super.tryPower(move, forced);
    }

    public void hairExtendClient() {
        if (this.isHearing()) {
            this.stopHearingClient();
        }
        if (!this.onCooldown((byte)14) || this.activePower == 51) {
            if (this.activePower != 51) {
                this.setCooldown((byte)14, 44);
            }
            this.tryPowerPacket((byte)51);
        }
    }

    public void hypnosis() {
        if (this.isHearing()) {
            this.stopHearingClient();
        }
        this.tryPowerPacket((byte)50);
    }

    public int getProgressIntoAnimation() {
        return this.animationProgress;
    }

    public boolean hasHairExtended() {
        return this.getActivePower() == 51;
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        if (move == 50) {
            this.hypnosisServer();
        }
        return super.setPowerOther(move, lastMove);
    }

    public void hypnosisServer() {
        if (this.isHypnotizing) {
            this.isHypnotizing = false;
            this.hypnoTicks = 0;
        } else {
            this.isHypnotizing = true;
            this.hypnoTicks = 0;
        }
    }

    public void hairExtendServer() {
        if (this.getActivePower() != 29) {
            if (this.hasHairExtended()) {
                this.xTryPower((byte)0, true);
            } else {
                this.setActivePower((byte)51);
                this.setPlayerPos2((byte)3);
                this.attackTimeDuring = 0;
                this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.HAIR_TOGGLE_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (slot == 3 && this.isPlantedInWall() && !this.isHoldingSneak() && !this.canLatchOntoWall()) {
            return true;
        }
        if (slot == 3 && this.isHoldingSneak() && !this.canUseBloodSpeed() && !this.canLatchOntoWall()) {
            return true;
        }
        if (slot == 2 && this.isHoldingSneak() && !this.canUseRegen()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public float getJumpHeightAddon() {
        if (this.self.m_9236_().m_5776_() && !this.isVisionOn()) {
            return super.getJumpHeightAddon();
        }
        return super.getJumpHeightAddon() + this.getAddon();
    }

    @Override
    public float getJumpHeightAddonMax() {
        return 4.0f;
    }

    public float getAddon() {
        if (this.self.m_6047_() && this.rechargeJump) {
            return 4.0f;
        }
        if (this.jumpedOffWall) {
            return 0.0f;
        }
        return 2.0f;
    }

    @Override
    public void tickPower() {
        if (this.self.m_20096_()) {
            this.rechargeJump = true;
        } else if (!this.self.m_6047_()) {
            this.rechargeJump = false;
        }
        this.tickHypnosis();
        this.tickHair();
        super.tickPower();
    }

    public void tickHair() {
        if (this.self.m_9236_().m_5776_()) {
            this.animationProgress = this.getPlayerPos2() == 3 ? ++this.animationProgress : 0;
        }
        if (this.activePower == 51 && this.attackTimeDuring >= this.getMaxAttackTimeDuringHair() && !this.isClient()) {
            Entity TE = this.getTargetEntity(this.self, 7.0f, 15.0f);
            if (TE != null && MainUtil.canPlantBud(TE, (Entity)this.self)) {
                if (((StandUser)TE).rdbt$getFleshBud() == null) {
                    LivingEntity livingEntity;
                    if (this.canPlantDrink(TE) || this.canPlantHealth(TE)) {
                        this.fleshBudIfNearby(100.0, TE.m_19879_());
                        ((StandUser)TE).rdbt$setFleshBud(this.self.m_20148_());
                        if (TE instanceof Mob) {
                            Mob mb = (Mob)TE;
                            ((StandUser)mb).roundabout$deeplyRemoveAttackTarget();
                        }
                    } else if (!this.canPlantHealth(TE) && (livingEntity = this.self) instanceof Player) {
                        Player PE = (Player)livingEntity;
                        PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.vampire.flesh_bud_fail").m_130940_(ChatFormatting.RED), true);
                    }
                } else {
                    LivingEntity livingEntity = this.self;
                    if (livingEntity instanceof Player) {
                        Player PE = (Player)livingEntity;
                        PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.vampire.flesh_bud_fail_already").m_130940_(ChatFormatting.RED), true);
                    }
                }
            }
            this.setAttackTimeDuring(-20);
        }
    }

    @Override
    public float getDamageReduction(DamageSource source, float amt) {
        if (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_)) {
            return 0.15f;
        }
        if (source.m_276093_(DamageTypes.f_268739_) || source.m_276093_(ModDamageTypes.BULLET)) {
            return 0.2f;
        }
        return super.getDamageReduction(source, amt);
    }

    @Override
    public float getDamageAdd(DamageSource source, float amt, Entity target) {
        if (source.m_276093_(DamageTypes.f_268566_) || source.m_276093_(DamageTypes.f_268464_)) {
            if (target instanceof Player) {
                Player pl = (Player)target;
                return 0.2f;
            }
            return 0.4f;
        }
        return super.getDamageAdd(source, amt, target);
    }

    @Override
    public float getBonusAttackSpeed() {
        return 1.15f;
    }

    @Override
    public float getBonusPassiveMiningSpeed() {
        return 1.4f;
    }

    public boolean canPlantDrink(Entity ent) {
        Mob mb;
        return MainUtil.canDrinkBloodCritAggro(ent, (Entity)this.self) && !(ent instanceof Monster) && (!(ent instanceof Mob) || !((IMob)(mb = (Mob)ent)).roundabout$isVampire());
    }

    public boolean canPlantHealth(Entity ent) {
        LivingEntity LE;
        return ent instanceof LivingEntity && (LE = (LivingEntity)ent).m_21223_() - this.getSuckDamage() <= 0.0f;
    }

    public final void fleshBudIfNearby(double range, int entid) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                S2CPacketUtil.sendGenericIntToClientPacket((Player)serverPlayerEntity, (byte)11, entid);
            }
        }
    }

    public void tickHypnosis() {
        if (!this.self.m_9236_().m_5776_() && this.isHypnotizing) {
            if (this.hypnoTicks % 9 == 0) {
                Vec3 lvec = this.self.m_20154_();
                Vec3 pn = this.self.m_146892_().m_82549_(lvec.m_82490_(3.0));
                Vec3 rev = lvec.m_82548_();
                ((ServerLevel)this.self.m_9236_()).m_8767_((ParticleOptions)ModParticles.HYPNO_SWIRL, pn.m_7096_(), pn.m_7098_(), pn.m_7094_(), 0, rev.f_82479_, rev.f_82480_, rev.f_82481_, 0.08);
                this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.HYPNOSIS_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                AABB aab = this.getSelf().m_20191_().m_82377_(10.0, 8.0, 10.0);
                List le = this.self.m_9236_().m_45971_(Mob.class, this.hypnosisTargeting, this.self, aab);
                for (Mob nle : le) {
                    if (nle.m_213877_() || !nle.m_6084_() || nle.m_5803_() || MainUtil.isHypnotismTargetBlacklisted((Entity)nle) || nle.m_5448_() != null && nle.m_5448_().m_6084_() && !nle.m_5448_().m_213877_()) continue;
                    ((IMob)nle).roundabout$setHypnotizedBy(this.self);
                }
            }
            ++this.hypnoTicks;
        }
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.hasHairExtended()) {
            basis *= 0.8f;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.FLESH_BUD, (byte)14);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.HYPNOTISM, (byte)10);
        }
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.REGENERATE, (byte)15);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.BLOOD_DRINK, (byte)11);
        }
        if ((this.canLatchOntoWall() || this.isPlantedInWall() && !this.isHoldingSneak()) && this.canWallWalkConfig()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.WALL_WALK_VAMP, (byte)12);
        } else if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.CHEETAH_SPEED, (byte)15);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        if (!this.isHoldingSneak() || this.isHearing()) {
            this.setSkillIcon(context, x, y, 4, StandIcons.HEARING_MODE, (byte)17);
        } else if (this.isVisionOn()) {
            this.setSkillIcon(context, x, y, 4, StandIcons.VAMP_VISION_ON, (byte)13);
        } else {
            this.setSkillIcon(context, x, y, 4, StandIcons.VAMP_VISION_OFF, (byte)13);
        }
    }

    public int getMaxAttackTimeDuringHair() {
        return 20;
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (!standOn) {
            Entity TE = this.getTargetEntity((LivingEntity)playerEntity, 7.0f, 15.0f);
            if (this.getActivePower() == 51) {
                float finalATime = Math.min((float)this.attackTimeDuring, (float)this.getMaxAttackTimeDuringHair()) / (float)this.getMaxAttackTimeDuringHair();
                int barTexture = 0;
                if (TE != null && MainUtil.canDrinkBloodFair(TE, (Entity)this.self)) {
                    barTexture = 68;
                }
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
                return;
            }
        }
        super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
    }
}

