/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.item;

import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.entity.projectile.RoundaboutBulletEntity;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.FirearmItem;
import net.hydra.jojomod.item.SnubnoseRevolverItem;
import net.hydra.jojomod.item.TommyAmmoItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TommyGunItem
extends FirearmItem
implements Vanishable {
    private static final String AMMO_COUNT_TAG = "AmmoCount";
    private static final String RELOADING_TAG = "IsReloading";
    int maxAmmo = 30;

    public TommyGunItem(Item.Properties $$0) {
        super($$0);
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return false;
    }

    private int getAmmo(ItemStack stack) {
        return stack.m_41784_().m_128451_(AMMO_COUNT_TAG);
    }

    private void setAmmo(ItemStack stack, int count) {
        stack.m_41784_().m_128405_(AMMO_COUNT_TAG, count);
    }

    private boolean getReloading(ItemStack stack) {
        return stack.m_41784_().m_128471_(RELOADING_TAG);
    }

    private void setReloading(ItemStack stack, boolean value) {
        stack.m_41784_().m_128379_(RELOADING_TAG, value);
    }

    private boolean isReloading(ItemStack stack) {
        return stack.m_41784_().m_128471_(RELOADING_TAG);
    }

    public UseAnim m_6164_(ItemStack $$0) {
        return UseAnim.BOW;
    }

    private boolean hasTommyAmmo(Player player) {
        Inventory inv = player.m_150109_();
        for (ItemStack stack : inv.f_35974_) {
            if (!(stack.m_41720_() instanceof TommyAmmoItem) || stack.m_41613_() <= 0) continue;
            return true;
        }
        for (ItemStack stack : inv.f_35976_) {
            if (!(stack.m_41720_() instanceof TommyAmmoItem) || stack.m_41613_() <= 0) continue;
            return true;
        }
        return player.m_7500_();
    }

    private int consumeTommyAmmo(Player player, int amount) {
        int remove;
        ItemStack stack;
        int i;
        Inventory inv = player.m_150109_();
        int consumed = 0;
        for (i = 0; i < inv.f_35974_.size() && amount > 0; ++i) {
            stack = (ItemStack)inv.f_35974_.get(i);
            if (!(stack.m_41720_() instanceof TommyAmmoItem) || player.m_7500_()) continue;
            remove = Math.min(stack.m_41613_(), amount);
            stack.m_41774_(remove);
            consumed += remove;
            if ((amount -= remove) <= 0) break;
        }
        for (i = 0; i < inv.f_35976_.size() && amount > 0; ++i) {
            stack = (ItemStack)inv.f_35976_.get(i);
            if (!(stack.m_41720_() instanceof TommyAmmoItem) || player.m_7500_()) continue;
            remove = Math.min(stack.m_41613_(), amount);
            stack.m_41774_(remove);
            consumed += remove;
            if ((amount -= remove) <= 0) break;
        }
        if (player.m_7500_()) {
            return this.maxAmmo;
        }
        return consumed;
    }

    public void cancelReload(ItemStack stack, Player player) {
        if (this.isReloading(stack)) {
            ((StandUser)player).roundabout$getStandPowers().stopSoundsIfNearby((byte)104, 10.0, false);
            this.setReloading(stack, false);
            player.m_36335_().m_41527_((Item)this);
            player.m_9236_().m_5594_(null, player.m_20183_(), SoundEvents.f_12018_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void fireBullet(Level level, Player player, InteractionHand hand) {
        if (player.m_36335_().m_41519_((Item)this)) {
            return;
        }
        ItemStack itemStack = player.m_21120_(hand);
        if (this.getAmmo(itemStack) > 0) {
            player.m_36335_().m_41524_((Item)this, 2);
            if (!player.m_7500_()) {
                this.setAmmo(itemStack, this.getAmmo(itemStack) - 1);
            }
            Player livingEntity = player;
            RoundaboutBulletEntity $$7 = new RoundaboutBulletEntity(level, (LivingEntity)livingEntity);
            $$7.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 4.0f, 5.0f);
            $$7.setAmmoType((byte)2);
            level.m_7967_((Entity)$$7);
            S2CPacketUtil.gunRecoil(player);
            level.m_6269_(null, (Entity)player, ModSounds.SNUBNOSE_FIRE_EVENT, SoundSource.PLAYERS, 100.0f, 1.0f);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Vec3 look = player.m_20154_().m_82541_();
                Vec3 up = new Vec3(0.0, 1.0, 0.0);
                Vec3 right = look.m_82537_(up).m_82541_();
                double forwardOffset = 1.5;
                double sideOffset = 0.1;
                double verticalOffset = -0.15;
                if (player.m_5737_() == HumanoidArm.LEFT && player.m_21205_().m_41720_() instanceof SnubnoseRevolverItem || player.m_5737_() == HumanoidArm.RIGHT && player.m_21206_().m_41720_() instanceof SnubnoseRevolverItem) {
                    sideOffset -= sideOffset * 2.0;
                }
                Vec3 pos = player.m_146892_().m_82549_(look.m_82490_(forwardOffset)).m_82549_(right.m_82490_(sideOffset)).m_82520_(0.0, verticalOffset, 0.0);
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123762_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
            }
            if (livingEntity != null && ((StandUser)livingEntity).roundabout$isBubbleEncased()) {
                StandUser SE = (StandUser)livingEntity;
                if (!level.m_5776_()) {
                    SE.roundabout$setBubbleEncased((byte)0);
                    level.m_5594_(null, livingEntity.m_20183_(), ModSounds.BUBBLE_POP_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
                    ((ServerLevel)level).m_8767_((ParticleOptions)ModParticles.BUBBLE_POP, livingEntity.m_20185_(), livingEntity.m_20186_() + (double)livingEntity.m_20206_() * 0.5, livingEntity.m_20189_(), 5, 0.25, 0.25, 0.25, 0.025);
                }
            }
        } else {
            level.m_6269_(null, (Entity)player, ModSounds.SNUBNOSE_DRY_FIRE_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer SP = (ServerPlayer)player;
                SP.m_5661_((Component)Component.m_237115_((String)"text.roundabout.out_of_bullets").m_130940_(ChatFormatting.LIGHT_PURPLE), true);
            }
        }
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        super.m_7203_(level, player, hand);
        ItemStack itemStack = player.m_21120_(hand);
        if (!(itemStack.m_41720_() instanceof TommyGunItem)) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (player.m_21211_() != itemStack) {
            if (player.m_6047_() && this.hasTommyAmmo(player) && this.getAmmo(itemStack) != this.maxAmmo || player.m_6047_() && player.m_7500_()) {
                if (!this.isReloading(itemStack)) {
                    this.setReloading(itemStack, true);
                    player.m_36335_().m_41524_((Item)this, 60);
                    ((StandUser)player).roundabout$getStandPowers().playSoundsIfNearby((byte)-23, 10.0, false);
                }
                return InteractionResultHolder.m_19096_((Object)itemStack);
            }
            if (player.m_6047_() && this.getAmmo(itemStack) == this.maxAmmo) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer SP = (ServerPlayer)player;
                    SP.m_5661_((Component)Component.m_237115_((String)"text.roundabout.already_reloaded").m_130940_(ChatFormatting.GRAY), true);
                }
            } else if (player.m_6047_() && this.getAmmo(itemStack) != this.maxAmmo && !this.hasTommyAmmo(player)) {
                if (player instanceof ServerPlayer) {
                    ServerPlayer SP = (ServerPlayer)player;
                    SP.m_5661_((Component)Component.m_237115_((String)"text.roundabout.no_more_usable_ammo").m_130940_(ChatFormatting.GRAY), true);
                }
            } else {
                player.m_6672_(hand);
            }
        }
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, level, entity, slot, selected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (level.f_46443_) {
            return;
        }
        if (this.isReloading(stack)) {
            DamageSource last;
            boolean justTookDamage;
            boolean bl = justTookDamage = player.f_20916_ == player.f_20917_ - 1;
            if (justTookDamage && (last = player.m_21225_()) != null && last.m_7639_() instanceof Entity) {
                this.cancelReload(stack, player);
                return;
            }
        }
        if (this.isReloading(stack) && player.m_21205_() != stack && this.isReloading(stack) && player.m_21206_() != stack) {
            this.cancelReload(stack, player);
            return;
        }
        if (this.isReloading(stack) && !player.m_36335_().m_41519_((Item)this) && player.m_21205_() == stack || this.isReloading(stack) && !player.m_36335_().m_41519_((Item)this) && player.m_21206_() == stack) {
            int currentAmmo = this.getAmmo(stack);
            int ammoNeeded = this.maxAmmo - currentAmmo;
            int ammoLoaded = this.consumeTommyAmmo(player, ammoNeeded);
            if (ammoLoaded > 0) {
                if (player.m_7500_()) {
                    this.setAmmo(stack, this.maxAmmo);
                } else {
                    this.setAmmo(stack, currentAmmo + ammoLoaded);
                }
            }
            this.setReloading(stack, false);
        }
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag flag) {
        int ammo = this.getAmmo(stack);
        tooltip.add((Component)Component.m_237113_((String)("Ammo: " + ammo + " / " + this.maxAmmo)).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237115_((String)"leveling.roundabout.disc_wip").m_130940_(ChatFormatting.RED));
    }
}

