/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.gravity;

import net.hydra.jojomod.util.gravity.GravityAPI;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.EntityCollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EntityCollisionContext.class}, priority=104)
public abstract class GravityEntityCollisionContextMixin {
    @Shadow
    @Final
    private Entity f_166002_;
    @Shadow
    @Final
    private double f_82867_;

    @Inject(method={"isAbove(Lnet/minecraft/world/phys/shapes/VoxelShape;Lnet/minecraft/core/BlockPos;Z)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$isAbove(VoxelShape shape, BlockPos pos, boolean defaultValue, CallbackInfoReturnable<Boolean> cir) {
        if (this.f_166002_ == null) {
            return;
        }
        Direction gravityDirection = GravityAPI.getGravityDirection(this.f_166002_);
        if (gravityDirection == Direction.DOWN) {
            return;
        }
        double realBottom = RotationUtil.boxWorldToPlayer((AABB)this.f_166002_.m_20191_(), (Direction)gravityDirection).f_82289_;
        if (shape.m_83281_()) {
            cir.setReturnValue((Object)true);
            return;
        }
        AABB shapeBox = RotationUtil.boxWorldToPlayer(shape.m_83215_().m_82400_((double)-1.0E-5f), gravityDirection);
        AABB posBox = RotationUtil.boxWorldToPlayer(new AABB(pos), gravityDirection);
        cir.setReturnValue((Object)(realBottom > posBox.f_82289_ + shapeBox.f_82291_ ? 1 : 0));
    }
}

