/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.mixin.piloting;

import net.hydra.jojomod.access.ICamera;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.RotationAnimation;
import net.hydra.jojomod.util.gravity.GravityAPI;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Camera.class})
public abstract class PilotingCamera
implements ICamera {
    @Unique
    private Entity roundabout$povSwitch;
    @Unique
    public boolean roundabout$cleared = false;
    @Shadow
    private boolean f_90549_;
    @Shadow
    private boolean f_90560_;
    @Shadow
    private float f_90558_;
    @Shadow
    private float f_90557_;
    @Shadow
    private float f_90562_;
    @Shadow
    private float f_90563_;
    @Shadow
    private Entity f_90551_;
    @Shadow
    private BlockGetter f_90550_;

    @Override
    @Unique
    public void roundabout$setEntity(Entity entity) {
        if (this.roundabout$povSwitch != entity) {
            this.roundabout$povSwitch = entity;
        }
    }

    @Override
    @Unique
    public Entity roundabout$getPovSwitch() {
        return this.roundabout$povSwitch;
    }

    @Unique
    public float roundabout$getViewXRot(Entity ent, float $$0) {
        return $$0 == 1.0f ? ent.m_146909_() : MainUtil.controlledLerpAngleDegrees(ClientUtil.getFrameTime(), ent.f_19860_, ent.m_146909_(), 1.0f);
    }

    @Unique
    public float roundabout$getViewYRot(Entity ent, float $$0) {
        return $$0 == 1.0f ? ent.m_146908_() : MainUtil.controlledLerpAngleDegrees(ClientUtil.getFrameTime(), ent.f_19859_, ent.m_146908_(), 1.0f);
    }

    @Unique
    public void roundabout$setup(BlockGetter blockGetter, Entity entity, boolean bl, boolean bl2, float f) {
        if (entity != null) {
            Direction gravityDirection = GravityAPI.getGravityDirection(this.roundabout$povSwitch);
            RotationAnimation animation = GravityAPI.getRotationAnimation(this.roundabout$povSwitch);
            if (animation != null) {
                float partialTick = Minecraft.m_91087_().m_91296_();
                long timeMs = entity.m_9236_().m_46467_() * 50L + (long)(partialTick * 50.0f);
                animation.update(timeMs);
                if (gravityDirection != Direction.DOWN || animation.isInAnimation()) {
                    this.f_90549_ = true;
                    this.f_90550_ = blockGetter;
                    this.f_90551_ = entity;
                    this.f_90560_ = bl;
                    this.m_90572_(this.roundabout$getViewYRot(this.roundabout$povSwitch, f), this.roundabout$getViewXRot(this.roundabout$povSwitch, f));
                    Quaternionf gravityRotation = animation.getCurrentGravityRotation(gravityDirection, timeMs);
                    double entityX = Mth.m_14139_((double)f, (double)this.roundabout$povSwitch.f_19854_, (double)this.roundabout$povSwitch.m_20185_());
                    double entityY = Mth.m_14139_((double)f, (double)this.roundabout$povSwitch.f_19855_, (double)this.roundabout$povSwitch.m_20186_());
                    double entityZ = Mth.m_14139_((double)f, (double)this.roundabout$povSwitch.f_19856_, (double)this.roundabout$povSwitch.m_20189_());
                    double currentCameraY = Mth.m_14179_((float)f, (float)this.f_90563_, (float)this.f_90562_);
                    Vec3 eyeOffset = animation.getEyeOffset(gravityRotation, new Vec3(0.0, currentCameraY, 0.0), gravityDirection);
                    this.m_90584_(entityX + eyeOffset.m_7096_(), entityY + eyeOffset.m_7098_(), entityZ + eyeOffset.m_7094_());
                    if (bl) {
                        if (bl2) {
                            this.m_90572_(this.f_90558_ + 180.0f, -this.f_90557_);
                        }
                        this.m_90568_(-this.m_90566_(4.0), 0.0, 0.0);
                    } else if (this.roundabout$povSwitch instanceof LivingEntity && ((LivingEntity)this.roundabout$povSwitch).m_5803_()) {
                        Direction $$5 = ((LivingEntity)this.roundabout$povSwitch).m_21259_();
                        this.m_90572_($$5 != null ? $$5.m_122435_() - 180.0f : 0.0f, 0.0f);
                        this.m_90568_(0.0, 0.3, 0.0);
                    }
                    return;
                }
            }
        }
        this.f_90549_ = true;
        this.f_90550_ = blockGetter;
        this.f_90551_ = entity;
        this.f_90560_ = true;
        this.m_90572_(this.roundabout$getViewYRot(this.roundabout$povSwitch, f), this.roundabout$getViewXRot(this.roundabout$povSwitch, f));
        double xx = Mth.m_14139_((double)f, (double)this.roundabout$povSwitch.f_19854_, (double)this.roundabout$povSwitch.m_20185_());
        double yy = Mth.m_14139_((double)f, (double)this.roundabout$povSwitch.f_19855_, (double)this.roundabout$povSwitch.m_20186_()) + (double)Mth.m_14179_((float)f, (float)this.f_90563_, (float)this.f_90562_);
        double zz = Mth.m_14139_((double)f, (double)this.roundabout$povSwitch.f_19856_, (double)this.roundabout$povSwitch.m_20189_());
        this.m_90584_(xx, yy, zz);
        if (bl) {
            if (bl2) {
                this.m_90572_(this.f_90558_ + 180.0f, -this.f_90557_);
            }
            this.m_90568_(-this.m_90566_(4.0), 0.0, 0.0);
        } else if (this.roundabout$povSwitch instanceof LivingEntity && ((LivingEntity)this.roundabout$povSwitch).m_5803_()) {
            Direction direction = ((LivingEntity)this.roundabout$povSwitch).m_21259_();
            this.m_90572_(direction != null ? direction.m_122435_() - 180.0f : 0.0f, 0.0f);
            this.m_90568_(0.0, 0.3, 0.0);
        }
    }

    @Inject(method={"setup"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$setup(BlockGetter blockGetter, Entity entity, boolean bl, boolean bl2, float f, CallbackInfo ci) {
        if (!this.roundabout$cleared && entity != null && ((TimeStop)entity.m_9236_()).CanTimeStopEntity(entity) && !entity.m_20159_()) {
            f = ((IEntityAndData)entity).roundabout$getPreTSTick();
            this.roundabout$cleared = true;
            this.m_90575_(blockGetter, entity, bl, bl2, f);
            this.roundabout$cleared = false;
            ci.cancel();
            return;
        }
        if (this.roundabout$povSwitch != null && entity != null && !this.roundabout$povSwitch.m_7306_(entity)) {
            if (this.roundabout$povSwitch.m_6084_() && !this.roundabout$povSwitch.m_213877_()) {
                this.roundabout$setup(blockGetter, entity, bl, bl2, f);
                ci.cancel();
                return;
            }
            this.roundabout$povSwitch = null;
        } else {
            this.roundabout$povSwitch = null;
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    private void roundabout$tick(CallbackInfo ci) {
        if (!(this.roundabout$povSwitch == null || this.f_90551_ != null && this.roundabout$povSwitch.m_7306_(this.f_90551_))) {
            this.f_90563_ = this.f_90562_;
            this.f_90562_ += (this.roundabout$povSwitch.m_20192_() - this.f_90562_) * 0.5f;
            ci.cancel();
        }
    }

    @Shadow
    public void m_90575_(BlockGetter blockGetter, Entity entity, boolean bl, boolean bl2, float f) {
    }

    @Shadow
    protected abstract void m_90572_(float var1, float var2);

    @Shadow
    protected abstract void m_90581_(Vec3 var1);

    @Shadow
    protected abstract void m_90584_(double var1, double var3, double var5);

    @Shadow
    protected abstract void m_90568_(double var1, double var3, double var5);

    @Shadow
    protected abstract double m_90566_(double var1);
}

