/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Scanner;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IMob;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.KeyInputRegistry;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.client.gui.MemoryRecordScreen;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.AnubisSlipstreamEntity;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.index.AnubisMemory;
import net.hydra.jojomod.event.index.AnubisMoment;
import net.hydra.jojomod.event.index.FateTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.monster.piglin.Piglin;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import oshi.util.tuples.Pair;

public class PowersAnubis
extends NewDashPreset {
    public static final int MaxPossesionTime = 100;
    public static final int MaxPlayTime = 100;
    public static final int PogoDelay = 8;
    public static final byte SWING = 50;
    public List<AnubisMemory> memories = new ArrayList<AnubisMemory>();
    public final List<KeyMapping> playKeys = new ArrayList<KeyMapping>();
    public final List<Byte> playBytes = new ArrayList<Byte>();
    List<Integer> lasthits = new ArrayList<Integer>();
    float slipstreamTimer = 3.0f;
    int pogoTime = 0;
    int pogoCounter = 0;
    private final int quickdrawDelay = 6;
    public static final byte DOUBLE = 52;
    public static final byte UPPERCUT = 54;
    public static final byte SPIN = 55;
    List<Entity> targets = new ArrayList<Entity>();
    public static final byte ANIME = 1;
    public static final byte EVIL = 2;
    public static final byte AQUAMARINE = 3;
    public List<Pair<List<Byte>, Integer>> visualValues = new ArrayList<Pair<List<Byte>, Integer>>();
    AnubisMemory lastMemory = null;
    public byte playSlot = (byte)-1;
    public int playTime = -1;
    public int maxPlayTime = -1;

    public PowersAnubis(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersAnubis(entity);
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public boolean rendersPlayer() {
        return true;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.ANUBIS_ALLURING_LIGHT, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.ANUBIS_RAGING_LIGHT, (byte)4);
        }
        ResourceLocation icon2 = StandIcons.ANUBIS_REPLAY;
        if (this.playTime > 0) {
            icon2 = StandIcons.ANUBIS_CANCEL;
        } else {
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof MemoryRecordScreen) {
                MemoryRecordScreen MA = (MemoryRecordScreen)screen;
                if (MA.recording) {
                    icon2 = StandIcons.ANUBIS_DMOUSE;
                }
            }
        }
        this.setSkillIcon(context, x, y, 2, icon2, (byte)1);
        if (!this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.ANUBIS_BACKFLIP, (byte)6);
        }
        ResourceLocation icon4 = StandIcons.ANUBIS_RECORD;
        if (this.playTime > 0) {
            icon4 = this.getStandUserSelf().roundabout$getUniqueStandModeToggle() ? StandIcons.ANUBIS_CANCEL : StandIcons.ANUBIS_SAVE;
        }
        this.setSkillIcon(context, x, y, 4, icon4, (byte)3);
        super.renderIcons(context, x, y);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (((StandUser)this.getSelf()).roundabout$getActive() && this.getActivePower() != 3 && this.getActivePower() != 4) {
            basis *= this.getSelf().m_20142_() ? 1.6f : 1.0f;
        }
        if (this.getActivePower() == 4 && this.getAttackTimeDuring() > this.getBarrageMinimum()) {
            int v = this.getBarrageWindup() - this.getBarrageMinimum();
            float scale = Math.min((float)(this.getAttackTimeDuring() - v) / (float)v, 1.0f);
            basis *= 1.0f - 0.7f * scale;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public int getJumpHeightAddon() {
        if (this.getStandUserSelf().roundabout$getActive() && this.getActivePower() != 4) {
            return 1;
        }
        return super.getJumpHeightAddon();
    }

    @Override
    public boolean cancelSprintJump() {
        if (this.getActivePower() == 3) {
            return true;
        }
        return super.cancelSprintJump();
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_GUARD: {
                this.AlluringLightClient();
                break;
            }
            case SKILL_1_CROUCH: 
            case SKILL_1_CROUCH_GUARD: {
                this.RagingLightClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                if (this.playTime > 0) {
                    this.MemoryCancelClient();
                    break;
                }
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (screen instanceof MemoryRecordScreen) {
                    MemoryRecordScreen MA = (MemoryRecordScreen)screen;
                    if (MA.recording) {
                        this.MemoryChangeClient();
                        break;
                    }
                }
                this.MemoryPlayClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.dash();
                break;
            }
            case SKILL_3_CROUCH: {
                this.BackflipClient();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                if (this.playTime > 0) {
                    if (this.getStandUserSelf().roundabout$getUniqueStandModeToggle()) {
                        this.MemoryCancelClient();
                        break;
                    }
                    this.MemoryCancelSaveClient();
                    break;
                }
                this.MemoryRecordClient();
            }
        }
    }

    public void AlluringLightClient() {
        if (!this.onCooldown((byte)0)) {
            this.setCooldown((byte)0, 200);
            this.tryPowerPacket((byte)21);
        }
    }

    public void AlluringLightServer() {
        this.setCooldown((byte)0, 200);
        int radius = 8;
        AABB box = this.getSelf().m_20191_().m_82377_((double)radius, 2.0, (double)radius);
        for (Mob M : this.getSelf().m_9236_().m_45971_(Mob.class, TargetingConditions.f_26872_, this.getSelf(), box)) {
            ((IMob)M).roundabout$setHypnotizedBy(this.getSelf(), 200);
        }
        Vec3 pos = this.getSelf().m_20318_(1.0f);
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.ALLURING_LIGHT, pos.f_82479_, pos.f_82480_ + (double)this.getSelf().m_20192_(), pos.f_82481_, 30, 0.0, 0.0, 0.0, 0.4);
    }

    public void RagingLightClient() {
        if (!this.onCooldown((byte)4)) {
            this.setCooldown((byte)4, 200);
            this.tryPowerPacket((byte)22);
        }
    }

    public void RagingLightServer() {
        this.setCooldown((byte)4, 200);
        int radius = 13;
        AABB box = this.getSelf().m_20191_().m_82377_((double)radius, 2.0, (double)radius);
        List entities = this.getSelf().m_9236_().m_45971_(Mob.class, TargetingConditions.f_26872_, this.getSelf(), box);
        entities.removeIf(entity -> {
            TamableAnimal TA;
            return entity instanceof TamableAnimal && (TA = (TamableAnimal)entity).m_21824_();
        });
        entities.removeIf(entity -> entity instanceof Villager);
        entities.removeIf(entity -> entity instanceof NeutralMob && entity.m_5448_() == null);
        entities.removeIf(entity -> entity instanceof Piglin && entity.m_5448_() == null);
        for (Mob M : entities) {
            M.m_6710_(this.getSelf());
            M.m_6703_(this.getSelf());
        }
        Vec3 pos = this.getSelf().m_20318_(1.0f);
        ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ModParticles.RAGING_LIGHT, pos.f_82479_, pos.f_82480_ + (double)this.getSelf().m_20192_(), pos.f_82481_, 30, 0.0, 0.0, 0.0, 0.4);
    }

    public void BackflipClient() {
        if (!this.onCooldown((byte)6)) {
            this.tryPower(13, true);
            this.tryPowerPacket((byte)13);
        }
    }

    public void MemoryRecordClient() {
        if (!this.getStandUserSelf().roundabout$getUniqueStandModeToggle() && Minecraft.m_91087_().f_91067_.m_91600_()) {
            ClientUtil.openMemoryRecordScreen(true);
        }
    }

    public void MemoryPlayClient() {
        if (!this.getStandUserSelf().roundabout$getUniqueStandModeToggle() && Minecraft.m_91087_().f_91067_.m_91600_()) {
            ClientUtil.openMemoryRecordScreen(false);
        }
    }

    public void MemoryChangeClient() {
        MemoryRecordScreen MA;
        if (!this.isAttackIneptVisually((byte)1, 2) && (MA = (MemoryRecordScreen)Minecraft.m_91087_().f_91080_) != null) {
            byte type = this.memories.get((int)MA.currentlyHovered).memory_type;
            this.memories.get((int)MA.currentlyHovered).memory_type = (byte)((type + 1) % 3);
            this.SaveMemories();
        }
    }

    public void MemoryCancelSaveClient() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
        int time = 100 - this.playTime + 1;
        for (Byte playByte : this.playBytes) {
            if (!this.isPressed(playByte, time)) continue;
            AnubisMemory memory = this.getUsedMemory();
            List<AnubisMoment> moments = memory.moments;
            moments.add(new AnubisMoment(playByte, Math.min(100, time), false));
        }
        this.SaveMemories();
        this.setPlayTime(-1);
        this.playSlot = (byte)-1;
    }

    public void SaveMemories() {
        for (int i = 0; i < 8; ++i) {
            String cf = this.convertToConfig(i);
            if (cf == null) continue;
            ConfigManager.getClientConfig().anubisMemories.saveToMemory(i + 1, cf);
            ConfigManager.saveClientConfig();
        }
    }

    public void MemoryCancelClient() {
        if (!this.getStandUserSelf().roundabout$getUniqueStandModeToggle()) {
            this.memories.set(this.playSlot, this.lastMemory);
            this.lastMemory = null;
        }
        this.visualValues = new ArrayList<Pair<List<Byte>, Integer>>();
        this.setPlayTime(-1);
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        switch (activeP) {
            case 3: {
                if (Minecraft.m_91087_().f_91067_.m_91600_()) return false;
                return true;
            }
            case 1: {
                Screen screen = Minecraft.m_91087_().f_91080_;
                if (!(screen instanceof MemoryRecordScreen)) return false;
                MemoryRecordScreen MA = (MemoryRecordScreen)screen;
                if (MA.currentlyHovered == -1) return true;
                if (MA.currentlyHovered != 8) return false;
                return true;
            }
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        StandUser SU = (StandUser)this.getSelf();
        switch (move) {
            case 21: {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_ALLURING_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 22: {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_RAGING_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                break;
            }
            case 5: {
                this.setActivePower((byte)49);
                this.setPowerOther(49, this.getActivePower());
                break;
            }
            case 13: {
                this.enablePogo();
                this.setAttackTime(0);
                this.setActivePower((byte)13);
                this.setCooldown((byte)6, 260);
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_BACKFLIP_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                this.getStandUserSelf().roundabout$setStandAnimation((byte)13);
                LivingEntity livingEntity = this.getSelf();
                if (livingEntity instanceof Player) {
                    Player P = (Player)livingEntity;
                    P.m_150110_().f_35935_ = false;
                }
                if (this.isClient()) break;
                Vec3 look = this.getSelf().m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_();
                SU.roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
                SU.roundabout$setLeapIntentionally(true);
                float strength = 1.25f;
                if (Math.abs(look.f_82479_) + Math.abs(look.f_82481_) == 0.0) {
                    strength *= 0.7f;
                } else if (!this.getSelf().m_20096_()) {
                    strength *= 0.8f;
                }
                MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), strength, look.f_82479_ * 1.0, -1.0 * (this.getSelf().m_20096_() ? 1.0 : 0.8), look.f_82481_ * 1.0);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                this.AlluringLightServer();
                break;
            }
            case 22: {
                this.RagingLightServer();
                break;
            }
            case 1: 
            case 2: {
                this.tryBasicAttack((byte)move);
                break;
            }
            case 43: {
                this.tryPogoAttack();
                break;
            }
            case 41: {
                this.attackTimeDuring = 0;
                this.playBarrageChargeSound();
                this.setActivePower((byte)41);
                break;
            }
            case 49: {
                this.setActivePower((byte)49);
                this.setAttackTime(0);
                break;
            }
            case 42: {
                this.BarrageSlash();
            }
        }
        if (PowersAnubis.isVariant((byte)move)) {
            this.tryBasicAttack((byte)move);
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public void onActuallyHurt(DamageSource $$0, float $$1) {
        if (this.getActivePower() == 43 && this.getAttackTimeDuring() < 8) {
            this.setPowerNone();
        }
    }

    public boolean canPogo() {
        return this.pogoTime == 0;
    }

    public void enablePogo() {
        this.pogoTime = 0;
    }

    public void disablePogo() {
        this.pogoTime = -1;
    }

    public void setPogo(int i) {
        this.pogoTime = i;
    }

    @Override
    public void tickPower() {
        Player P;
        LivingEntity livingEntity;
        StandUser SU = this.getStandUserSelf();
        if (SU.roundabout$getStandSkin() == 0) {
            SU.roundabout$setStandSkin((byte)1);
        }
        if (this.pogoTime > 0) {
            --this.pogoTime;
        }
        if (this.getSelf().m_20096_()) {
            if ((this.getActivePower() != 43 || this.attackTime > 11) && this.pogoTime == -1) {
                if (this.pogoCounter == 0) {
                    this.setPogo(30);
                } else {
                    this.setPogo(0);
                }
            }
            if (this.isClient()) {
                LivingEntity livingEntity2 = this.getSelf();
                if (livingEntity2 instanceof Player) {
                    Player P5 = (Player)livingEntity2;
                    if (this.pogoCounter != 0 && ConfigManager.getClientConfig().anubisMemories.anubisPogoCounter.booleanValue()) {
                        P5.m_5661_((Component)Component.m_237113_((String)("" + this.pogoCounter)).m_130940_(ChatFormatting.RED), true);
                    }
                }
                this.pogoCounter = 0;
            }
        } else if (!this.canPogo() && (livingEntity = this.getSelf()) instanceof Player && (P = (Player)livingEntity).m_7500_()) {
            this.enablePogo();
        }
        SU.roundabout$setCombatMode(SU.roundabout$getActive());
        this.tickSlipStream();
        this.tickMemories();
        this.tickExtras();
        this.getSelf().m_20242_(this.getActivePower() == 43 && this.attackTimeDuring < 8);
        super.tickPower();
    }

    public void tickSlipStream() {
        StandUser SU = this.getStandUserSelf();
        if (!this.isClient()) {
            boolean noSlip;
            Level level = this.getSelf().m_9236_();
            boolean bl = noSlip = this.getActivePower() == 13 || this.getActivePower() == 43;
            if (this.getSelf().m_20142_() && SU.roundabout$getActive() && !noSlip) {
                float dif = this.getSelf().f_19787_ - this.getSelf().f_19867_;
                if (dif != 0.0f) {
                    this.slipstreamTimer -= dif;
                }
                if (this.slipstreamTimer <= 0.0f) {
                    this.slipstreamTimer = 3.0f;
                    AnubisSlipstreamEntity AS = new AnubisSlipstreamEntity(ModEntities.ANUBIS_SLIPSTREAM, level);
                    AS.m_146884_(this.getSelf().m_20318_(1.0f));
                    level.m_7967_((Entity)AS);
                }
            }
        }
    }

    public void tickMemories() {
        if (this.memories.size() != 8 && this.isClient()) {
            PowersAnubis.generateMemories(this);
        }
        if (this.playTime > 0 && this.isClient()) {
            if (!this.getStandUserSelf().roundabout$getUniqueStandModeToggle()) {
                ArrayList<Byte> value = new ArrayList<Byte>();
                for (int i = 0; i < this.playKeys.size(); ++i) {
                    KeyMapping key = this.playKeys.get(i);
                    if (key.m_90857_()) {
                        value.add(this.playBytes.get(i));
                    }
                    int time = 100 - this.playTime;
                    byte id = this.playBytes.get(i);
                    boolean vargs = key.m_90857_();
                    int lastMoment = this.getLastMoment(this.playSlot, id, time);
                    boolean bl = false;
                    if (lastMoment != -1) {
                        AnubisMoment m = this.getUsedMemory().moments.get(lastMoment);
                        if (m.vargs != vargs) {
                            bl = true;
                        }
                    }
                    boolean bl2 = true;
                    if ((id == 11 || id == 13) && this.getStandUserSelf().roundabout$getActive()) {
                        bl2 = false;
                    }
                    if (!bl2 || (lastMoment != -1 || !vargs) && !bl) continue;
                    this.getUsedMemory().moments.add(new AnubisMoment(id, time, vargs));
                }
                if (this.visualValues.isEmpty()) {
                    this.visualValues.add((Pair<List<Byte>, Integer>)new Pair(value, (Object)0));
                } else {
                    Pair<List<Byte>, Integer> last = this.visualValues.get(this.visualValues.size() - 1);
                    if (((List)last.getA()).equals(value)) {
                        this.visualValues.set(this.visualValues.size() - 1, (Pair<List<Byte>, Integer>)new Pair((Object)((List)last.getA()), (Object)((Integer)last.getB() + 1)));
                    } else {
                        this.visualValues.add((Pair<List<Byte>, Integer>)new Pair(value, (Object)0));
                    }
                }
            }
            --this.playTime;
            boolean bl = false;
            AnubisMemory memory = this.getUsedMemory();
            if (this.getStandUserSelf().roundabout$getUniqueStandModeToggle() && memory != null && !memory.moments.isEmpty() && 100 - this.playTime > memory.moments.get((int)(memory.moments.size() - 1)).time) {
                bl = true;
            }
            if (this.playTime <= 0 || bl) {
                this.MemoryCancelSaveClient();
            }
        }
    }

    public void tickExtras() {
        StandUser SU = this.getStandUserSelf();
        if (this.isGuarding()) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)3);
        } else if (this.getStandUserSelf().roundabout$getStandAnimation() == 3) {
            this.getStandUserSelf().roundabout$setStandAnimation((byte)0);
        }
        if (SU.roundabout$getStandAnimation() == 13 && this.attackTime > 16) {
            SU.roundabout$setStandAnimation((byte)0);
        }
        if (SU.roundabout$getStandAnimation() == 43 && (this.getActivePower() == 0 || this.getSelf().m_20096_())) {
            SU.roundabout$setStandAnimation((byte)0);
        }
        if (this.getActivePower() == 13) {
            if (this.getAttackTime() > 10 && this.getAttackTime() < 20) {
                if (this.getSelf().m_6047_()) {
                    this.addMomentum(0.0f, -0.075f, 0.0f);
                }
            } else if (this.getAttackTime() > 20) {
                this.setPowerNone();
            }
        }
    }

    @Override
    public boolean canAttack() {
        return super.canAttack() || this.getActivePower() == 13;
    }

    @Override
    public boolean interceptAttack() {
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (keyIsDown && this.canAttack()) {
            byte index = 1;
            if (this.isHoldingSneak()) {
                if (!this.getSelf().m_20096_() && this.canPogo()) {
                    this.disablePogo();
                    index = 43;
                } else {
                    index = 2;
                }
            }
            if (index != 43) {
                this.lasthits.add(index == 2 ? -1 : 1);
            }
            if (this.lasthits.size() == 3) {
                index = this.determineThird(this.lasthits);
            }
            if (index != 43 && index != 52 && index != 54) {
                this.getSelf().m_6674_(InteractionHand.MAIN_HAND);
            }
            this.tryPower(index);
            this.tryPowerPacket(index);
        }
    }

    @Override
    public boolean setPowerAttack() {
        return this.setPowerOther(1, this.getActivePower());
    }

    public void tryBasicAttack(byte move) {
        if (this.activePowerPhase >= 3) {
            this.activePowerPhase = 1;
        } else {
            this.activePowerPhase = (byte)(this.activePowerPhase + 1);
            this.attackTimeMax = this.activePowerPhase == 3 ? ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown.intValue() : ClientNetworking.getAppropriateConfig().generalStandSettings.standPunchCooldown.intValue();
        }
        this.attackTimeDuring = 0;
        this.setAttackTime(0);
        if (move == 54) {
            ((StandUser)this.getSelf()).roundabout$setMeleeImmunity(8);
        }
        this.setActivePower(move);
    }

    @Override
    public void updateAttack() {
        this.updateUniqueMoves();
    }

    @Override
    public void updateUniqueMoves() {
        switch (this.getActivePower()) {
            case 1: 
            case 2: {
                this.updateAttacks();
                break;
            }
            case 43: {
                this.updatePogoAttack();
                break;
            }
            case 49: {
                if (this.getAttackTime() < 6) {
                    this.scopeLevel = 1;
                    break;
                }
                if (this.getAttackTime() == 6) {
                    if (this.isClient()) break;
                    this.StartQuickdraw(8.0f);
                    break;
                }
                this.UpdateQuickdraw();
                this.scopeLevel = 0;
            }
        }
        if (PowersAnubis.isVariant(this.getActivePower())) {
            this.updateAttacks();
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 20 && chargeTime != 0) {
            this.pogoAttack(chargeTime);
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public void updateAttacks() {
        if (!this.isClient() && this.attackTimeDuring > -1) {
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else {
                switch (this.getActivePower()) {
                    case 54: {
                        if (this.getAttackTimeDuring() < 3) {
                            if (this.getTargetEntity(this.getSelf(), 2.0f) == null && this.getSelf().m_20096_()) {
                                Vec3 look = this.getSelf().m_20154_();
                                look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_().m_82548_();
                                MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), 1.0, look.f_82479_, look.f_82480_, look.f_82481_);
                                break;
                            }
                            this.Uppercut();
                            break;
                        }
                        this.Uppercut();
                        break;
                    }
                    case 52: {
                        if (this.attackTimeDuring % 4 != 1) break;
                        this.DoubleCut(this.attackTimeDuring < 5);
                        break;
                    }
                    case 55: {
                        if (this.getAttackTimeDuring() > 5) {
                            this.ThrustCut();
                            break;
                        }
                        if (this.getAttackTimeDuring() != 1) break;
                        Vec3 look = this.getSelf().m_20154_().m_82548_();
                        look = new Vec3(look.f_82479_, -0.2, look.f_82481_);
                        float strength = 1.0f;
                        MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), strength *= this.getSelf().m_20096_() ? 1.0f : 0.6f, look.f_82479_, look.f_82480_, look.f_82481_);
                    }
                }
                if (this.getActivePower() == 2 || this.getActivePower() == 1) {
                    if (this.getActivePower() == 2) {
                        this.SAttack();
                    } else {
                        this.NAttack();
                    }
                }
                if (this.getSelf() instanceof Player && this.isPacketPlayer()) {
                    this.setAttackTimeDuring(-10);
                }
            }
        }
    }

    public void NAttack() {
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f, 15.0f);
        this.punchImpact(targetEntity);
    }

    public void SAttack() {
        Entity targetEntity = this.getTargetEntity(this.self, -1.0f, 15.0f);
        this.punchImpact(targetEntity);
    }

    public void tryPogoAttack() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            P.m_150110_().f_35935_ = false;
        }
        this.attackTimeMax = ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown;
        this.attackTimeDuring = 0;
        this.setActivePower((byte)43);
        this.setAttackTime(0);
    }

    public void updatePogoAttack() {
        this.getSelf().m_20242_(this.attackTimeDuring < 8);
        if (this.attackTimeDuring > -1) {
            if (this.getSelf().m_20096_() && this.getAttackTime() < 8) {
                this.setPowerNone();
                this.attackTime += 5;
            }
            if (this.attackTimeDuring > this.attackTimeMax) {
                this.attackTime = -1;
                this.attackTimeMax = 0;
                ((StandUser)this.getSelf()).roundabout$tryPower(0, true);
            } else {
                int windup = 8;
                if (this.attackTimeDuring == 8) {
                    if (!this.isClient()) {
                        this.PogoLaunch();
                    }
                } else if (this.attackTimeDuring < 8) {
                    if (!this.isClient()) {
                        MainUtil.slowTarget((Entity)this.getSelf(), 0.8f);
                    }
                } else if (this.attackTimeDuring < 14) {
                    if (this.isClient() && this.isPacketPlayer()) {
                        this.pogoCheck();
                    }
                } else if (this.attackTimeDuring < 17 && !this.isClient()) {
                    MainUtil.slowTarget((Entity)this.getSelf(), 0.7f);
                    this.getSelf().m_183634_();
                }
                if (this.attackTimeDuring >= 17) {
                    this.setPowerNone();
                }
            }
        }
    }

    public void PogoLaunch() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        float power = 1.5f;
        Vec3 lookAngle = this.getSelf().m_20154_().m_82548_();
        this.getSelf().m_183634_();
        if (lookAngle.f_82480_ < -0.15) {
            power *= 0.5f;
        }
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_POGO_LAUNCH_EVENT, SoundSource.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.2));
        this.getStandUserSelf().roundabout$setMeleeImmunity((byte)6);
        MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), power, lookAngle.f_82479_, lookAngle.f_82480_, lookAngle.f_82481_);
    }

    public void pogoCheck() {
        Vec3 pos = this.getSelf().m_20299_(0.0f).m_82549_(this.getSelf().m_20154_().m_82490_(1.0));
        List<Entity> targets = MainUtil.genHitbox(this.getSelf().m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 1.4, 1.4, 1.4);
        targets.removeIf(entity -> entity.equals((Object)this.getSelf()));
        targets = this.doAttackChecks(targets);
        Entity target = null;
        if (!targets.isEmpty()) {
            target = targets.get(0);
        }
        if (target != null) {
            this.tryIntPowerPacket((byte)20, target.m_19879_());
        }
    }

    public void pogoAttack(int id) {
        LivingEntity LE;
        Entity target = this.getSelf().m_9236_().m_6815_(id);
        Roundabout.LOGGER.info(target.toString());
        this.setAttackTimeDuring(this.getAttackTimeDuring() + 15);
        double strength = this.getSelf().m_6047_() ? 0.5 : 0.7;
        MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), strength, 0.0, -1.0, 0.0);
        this.getStandUserSelf().roundabout$setLeapTicks(20);
        this.getStandUserSelf().roundabout$setLeapIntentionally(true);
        if (this.StandDamageEntityAttack(target, 4.0f, 1.0f, (Entity)this.getSelf()) && target instanceof LivingEntity && ((StandUser)(LE = (LivingEntity)target)).roundabout$getStandPowers().interceptGuard() && LE.m_21254_() && !((StandUser)LE).roundabout$isGuarding()) {
            this.knockShield2(target, 30);
        }
        this.setPowerNone();
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)43, this.attackTime + 5);
            if (target instanceof ArmorStand) {
                S2CPacketUtil.sendIntPowerDataPacket(P, (byte)15, 1);
            }
        }
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_POGO_HIT_EVENT, SoundSource.PLAYERS, 1.0f, 0.9f + (float)Math.random() * 0.2f);
        ((StandUser)this.getSelf()).roundabout$setMeleeImmunity((byte)(this.getSelf().m_6047_() ? 10 : 5));
    }

    @Override
    public void punchImpact(Entity entity) {
        this.setAttackTimeDuring(-10);
        float knockbackStrength = 0.2f;
        if (this.getActivePower() == 2) {
            knockbackStrength = 0.55f;
        }
        if (this.getSelf().m_20142_()) {
            knockbackStrength += 0.05f;
        }
        List<Entity> entities = this.getBasicSwordHitBox(this.getActivePower() == 2);
        for (Entity e : entities) {
            float pow;
            if (e == null || !this.StandDamageEntityAttack(e, pow = this.getPunchStrength(e) * (this.getActivePower() == 2 ? 1.2f : 1.0f), 0.0f, (Entity)this.self)) continue;
            if (e instanceof LivingEntity) {
                this.addEXP(1);
            }
            this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
            float pitch = 0.9f + (float)(Math.random() * (double)0.2f);
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, pitch += this.getActivePower() == 2 ? -0.3f : 0.0f);
        }
    }

    public static boolean isVariant(byte b) {
        return b >= 52 && b <= 55;
    }

    public byte determineThird(List<Integer> list) {
        String id;
        this.lasthits = new ArrayList<Integer>();
        return switch (id = String.valueOf(list.get(0)) + String.valueOf(list.get(1))) {
            case "11" -> 52;
            case "1-1", "-11" -> 54;
            case "-1-1" -> 55;
            default -> throw new IllegalStateException("How did you do this: " + id);
        };
    }

    public void DoubleCut(boolean first) {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        if (!this.canPogo()) {
            this.setAttackTime(0);
            this.setAttackTimeMax(this.getAttackTimeMax() + 10);
        }
        if (!first) {
            this.setAttackTimeDuring(-10);
        }
        if (this.getSelf().m_20096_() && this.getTargetEntity(this.getSelf(), 2.0f, this.getSelf().m_146909_()) == null) {
            Vec3 look = this.getSelf().m_20154_();
            look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_();
            MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), -0.5, look.f_82479_, look.f_82480_, look.f_82481_);
        }
        float knockbackStrength = 0.6f + (this.getSelf().m_20142_() ? 0.1f : 0.0f);
        if (first) {
            knockbackStrength = 0.2f;
        }
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 4.0, 35.0, 0.03);
        if (!(entities = this.doAttackChecks(entities)).isEmpty()) {
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 1.0f, 0.4f + (float)(Math.random() * 0.2) + (first ? 0.0f : 0.3f));
        }
        for (Entity e : entities) {
            LivingEntity LE;
            if (e == null) continue;
            if (e.m_20270_((Entity)this.getSelf()) < 1.5f) {
                knockbackStrength += 0.15f;
                this.setAttackTime(0);
                this.setAttackTimeMax(this.getAttackTimeMax() + 5);
            }
            float pow = this.getHeavyPunchStrength(e) * 0.6f;
            if (e instanceof LivingEntity && pow > (LE = (LivingEntity)e).m_21223_()) {
                pow = Math.max(LE.m_21223_() - 0.1f, 0.1f);
            }
            if (this.StandDamageEntityAttack(e, pow, 0.0f, (Entity)this.self)) {
                if (e instanceof LivingEntity) {
                    this.addEXP(2);
                }
                if (first) {
                    ((StandUser)e).roundabout$setDazed((byte)3);
                }
                this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
                continue;
            }
            if (first || !(e instanceof LivingEntity) || !(LE = (LivingEntity)e).m_21254_()) continue;
            MainUtil.knockShieldPlusStand(e, 40);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void ThrustCut() {
        this.setAttackTimeDuring(-10);
        boolean bl = false;
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 4.2, 20.0, 0.0);
        for (Entity entity : entities) {
            float dist = entity.m_20270_((Entity)this.getSelf());
            boolean range = (double)dist > 3.4;
            float pow = this.getHeavyPunchStrength(entity);
            if (range) {
                pow *= 1.4f;
                ((StandUser)this.getSelf()).roundabout$setMeleeImmunity(10);
            }
            if (range) {
                bl = true;
            }
            if (!this.StandDamageEntityAttack(entity, pow, 0.0f, (Entity)this.getSelf())) continue;
            int dur = 100;
            if (range) {
                MainUtil.takeUnresistableKnockbackWithY(entity, 0.45, 0.0, -1.0, 0.0);
                dur = 200;
            }
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity LE = (LivingEntity)entity;
            LE.m_7292_(new MobEffectInstance(ModEffects.BLEED, dur, 0));
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
            if (bl) {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_BARRAGE_1_EVENT, SoundSource.PLAYERS, 0.8f, 1.3f);
            } else {
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), SoundEvents.f_12317_, SoundSource.PLAYERS, 0.8f, 1.3f);
            }
        }
    }

    public void Uppercut() {
        this.getSelf().m_183634_();
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        this.setAttackTimeDuring(-10);
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 3.0, 55.0, 0.02);
        if (!entities.isEmpty()) {
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.4f + (float)(Math.random() * 0.2));
        }
        for (Entity e : entities) {
            LivingEntity LE;
            if (e == null) continue;
            float pow = this.getHeavyPunchStrength(e);
            if (this.StandDamageEntityAttack(e, pow, 0.0f, (Entity)this.self)) {
                if (e instanceof LivingEntity) {
                    this.addEXP(2);
                }
                Vec3 look = this.getSelf().m_20154_().m_82541_();
                look = new Vec3(look.f_82479_, 0.0, look.f_82481_).m_82541_().m_82548_().m_82490_(this.getSelf().m_20142_() ? 1.3 : 1.0);
                MainUtil.takeKnockbackWithY(e, 0.8f, look.f_82479_, -3.0, look.f_82481_);
                MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), 0.9f, 0.0, -4.0, 0.0);
                continue;
            }
            if (!(e instanceof LivingEntity) || !(LE = (LivingEntity)e).m_21254_()) continue;
            MainUtil.knockShieldPlusStand(e, 30);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public boolean setPowerBarrageCharge() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)4);
        this.playBarrageChargeSound();
        return true;
    }

    @Override
    public void setPowerBarrage() {
        this.attackTimeDuring = 0;
        this.setActivePower((byte)49);
        this.setAttackTimeMax(this.getBarrageRecoilTime());
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.playBarrageCrySound();
    }

    @Override
    public void updatePowerInt(byte activePower, int data) {
        switch (activePower) {
            case 50: {
                this.getSelf().m_6674_(InteractionHand.MAIN_HAND);
                break;
            }
            case 43: {
                this.attackTime = data;
                this.setPowerNone();
                ++this.pogoCounter;
                if (!ConfigManager.getClientConfig().anubisMemories.anubisPogoCounter.booleanValue()) break;
                ((Player)this.getSelf()).m_5661_((Component)Component.m_237113_((String)("" + this.pogoCounter)).m_130940_(ChatFormatting.WHITE), true);
                break;
            }
            case 15: {
                if (data == 1) {
                    this.enablePogo();
                    break;
                }
                this.disablePogo();
                break;
            }
            case 5: {
                if (data == 1) {
                    this.setPowerNone();
                    break;
                }
                this.setAttackTime(7);
                this.setAttackTimeDuring(0);
                this.setActivePowerPhase(this.getActivePowerPhaseMax());
                this.setAttackTimeMax(data);
            }
        }
        super.updatePowerInt(activePower, data);
    }

    @Override
    public boolean interceptGuard() {
        return true;
    }

    public boolean canGuard() {
        return !this.isBarraging() && !this.isClashing() && this.getActivePower() != 43 && this.getActivePower() != 49;
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        if (this.isBarrageCharging() || this.isBarrageAttacking()) {
            return false;
        }
        if (!this.isGuarding() && this.canGuard()) {
            this.tryPower(3, true);
            this.tryPowerPacket((byte)3);
            return true;
        }
        return false;
    }

    public boolean isRecording() {
        return this.playTime > 0 && !this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    @Override
    public void buttonInputBarrage(boolean keyIsDown, Options options) {
        if (keyIsDown) {
            if (this.isHoldingSneak() && (this.getAttackTime() >= this.getAttackTimeMax() || this.getActivePowerPhase() != this.getActivePowerPhaseMax())) {
                this.tryPower(41);
                this.tryPowerPacket((byte)41);
            } else if (this.getSelf().m_20202_() == null) {
                super.buttonInputBarrage(keyIsDown, options);
            }
        }
    }

    @Override
    public void updateBarrage() {
    }

    @Override
    public void updateBarrageCharge() {
    }

    @Override
    public boolean isBarrageAttacking() {
        return super.isBarrageAttacking() || this.getActivePower() == 42;
    }

    @Override
    public boolean isBarrageCharging() {
        return super.isBarrageCharging() || this.getActivePower() == 41;
    }

    public int getBarrageMinimum() {
        return this.getBarrageWindup();
    }

    @Override
    public int getBarrageWindup() {
        return super.getBarrageWindup() + 10;
    }

    @Override
    public boolean clickRelease() {
        return this.getActivePower() == 41;
    }

    @Override
    public boolean onClickRelease() {
        if (this.getActivePower() == 4 && this.getAttackTimeDuring() > this.getBarrageMinimum()) {
            this.tryPower(5);
            this.tryPowerPacket((byte)5);
            return true;
        }
        if (this.getActivePower() == 41 && this.getAttackTimeDuring() >= this.getKickBarrageWindup()) {
            this.tryPower(42);
            this.tryPowerPacket((byte)42);
        }
        return super.onClickRelease();
    }

    @Override
    public boolean canScope() {
        return this.getActivePower() == 49;
    }

    public void StartQuickdraw(float dist) {
        BlockHitResult bh;
        BlockPos bp;
        Level level = this.getSelf().m_9236_();
        if (level.m_8055_(bp = (bh = MainUtil.getAheadVec((Entity)this.getSelf(), dist)).m_82425_()).m_60795_()) {
            for (int i = 0; i < 5 && level.m_8055_(bp = bp.m_7495_()).m_60795_(); ++i) {
            }
        }
        if (!level.m_8055_(bp).m_60795_() && level.m_8055_(bp.m_7494_().m_7494_()).m_60795_()) {
            if ((double)bp.m_123342_() - this.getSelf().m_20186_() > 2.0) {
                return;
            }
            bp = bp.m_7494_();
            Vec3 pos = this.getSelf().m_20318_(1.0f);
            Vec3 npos = new Vec3((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_());
            Vec3 dpos = npos.m_82546_(pos);
            ArrayList<Entity> entities = new ArrayList<Entity>();
            int intervals = 5;
            for (int i = 0; i < intervals - 1; ++i) {
                float d = 1.0f / (float)intervals * (float)i;
                Vec3 spos = pos.m_82549_(dpos.m_82490_((double)d));
                List<Entity> targets = MainUtil.genHitbox(level, spos.f_82479_, spos.f_82480_, spos.f_82481_, 2.0, 1.5, 2.0);
                targets = this.doAttackChecks(targets);
                for (Entity entity : targets) {
                    if (entities.contains(entity)) continue;
                    entities.add(entity);
                }
            }
            this.targets = entities;
            this.setAttackTimeMax(70);
            this.getSelf().m_6021_((double)bp.m_123341_(), (double)bp.m_123342_(), (double)bp.m_123343_());
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_BARRAGE_END_EVENT, SoundSource.PLAYERS, 1.5f, 0.9f);
        } else {
            this.setAttackTimeMax(15);
        }
        this.setAttackTime(7);
        this.setAttackTimeDuring(0);
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)5, this.getAttackTimeMax());
        }
    }

    public void UpdateQuickdraw() {
        this.getStandUserSelf().roundabout$setMeleeImmunity(3);
        int duration = 15;
        if (!this.isClient()) {
            for (Entity entity : this.targets) {
                if (entity instanceof LivingEntity) {
                    ((StandUser)entity).roundabout$setDazed((byte)3);
                }
                if (this.getAttackTimeDuring() > duration) {
                    if (this.StandRushDamageEntityAttack(entity, 3.0f, 0.0f, (Entity)this.getSelf())) {
                        MainUtil.takeKnockbackWithY(entity, 0.9, 0.0, -1.0, 0.0);
                    }
                    this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_BARRAGE_1_EVENT, SoundSource.PLAYERS, 1.5f, 1.0f);
                    continue;
                }
                if (this.getSelf().f_19797_ % 2 != 1 || !this.StandRushDamageEntityAttack(entity, this.getBarrageHitStrength(entity), 0.0f, (Entity)this.getSelf())) continue;
                MainUtil.takeUnresistableKnockbackWithY(entity, 0.01, 0.0, -1.0, 0.0);
                this.hitParticles(entity);
                this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.ANUBIS_BARRAGE_1_HIT_EVENT, SoundSource.PLAYERS, 1.0f, 0.9f + (float)(Math.random() * 0.2));
            }
            if (this.getAttackTimeDuring() > duration) {
                this.targets = new ArrayList<Entity>();
                this.setPowerNone();
                LivingEntity livingEntity = this.getSelf();
                if (livingEntity instanceof Player) {
                    Player P = (Player)livingEntity;
                    S2CPacketUtil.sendActivePowerPacket(P, (byte)0);
                }
            }
        }
    }

    public void BarrageSlash() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            Player P = (Player)livingEntity;
            S2CPacketUtil.sendIntPowerDataPacket(P, (byte)50, 0);
        }
        this.setAttackTimeMax(ClientNetworking.getAppropriateConfig().generalStandSettings.finalStandPunchInStringCooldown);
        this.setAttackTime(0);
        this.setAttackTimeDuring(0);
        this.setActivePowerPhase(this.getActivePowerPhaseMax());
        this.setPowerNone();
        float knockbackStrength = 1.25f + (this.getSelf().m_20142_() ? 0.1f : 0.0f);
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 4.0, 45.0, 0.1);
        if (!entities.isEmpty()) {
            this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), SoundEvents.f_12314_, SoundSource.PLAYERS, 1.0f, 0.4f + (float)(Math.random() * 0.2));
        }
        for (Entity e : entities) {
            LivingEntity LE;
            float pow;
            if (e == null) continue;
            if (e.m_20270_((Entity)this.getSelf()) < 1.5f) {
                knockbackStrength += 0.15f;
                this.setAttackTime(0);
                this.setAttackTimeMax(this.getAttackTimeMax() + 5);
            }
            if (this.StandDamageEntityAttack(e, pow = this.getHeavyPunchStrength(e), 0.0f, (Entity)this.self)) {
                if (e instanceof LivingEntity) {
                    this.addEXP(2);
                }
                this.takeDeterminedKnockback(this.getSelf(), e, knockbackStrength);
                continue;
            }
            if (!(e instanceof LivingEntity) || !(LE = (LivingEntity)e).m_21254_()) continue;
            MainUtil.knockShieldPlusStand(e, 200);
        }
        if (!entities.isEmpty() && !this.isClient()) {
            Entity e = entities.get(0);
            Vec3 pos = e.m_20318_(0.0f).m_82520_(0.0, (double)(e.m_20192_() / 2.0f), 0.0);
            ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 0, 0.0, 0.0, 0.0, 0.0);
            LivingEntity livingEntity2 = this.getSelf();
            if (livingEntity2 instanceof Player) {
                Player P = (Player)livingEntity2;
                P.m_5704_(e);
            }
        }
    }

    @Override
    public boolean setPowerNone() {
        return super.setPowerNone();
    }

    @Override
    public Component getPosName(byte posID) {
        return switch (posID) {
            case 1 -> Component.m_237115_((String)"idle.roundabout.anubis_2");
            default -> Component.m_237115_((String)"idle.roundabout.anubis_1");
        };
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2, (byte)3);
    }

    @Override
    public Component getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> Component.m_237115_((String)"skins.roundabout.anubis.evil");
            case 3 -> Component.m_237115_((String)"skins.roundabout.anubis.aquamarine");
            default -> Component.m_237115_((String)"skins.roundabout.anubis.anime");
        };
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte worthinessType() {
        return 2;
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public Component ifWipListDevStatus() {
        return Component.m_237115_((String)"roundabout.dev_status.active").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component ifWipListDev() {
        return Component.m_237113_((String)"Prisma").m_130940_(ChatFormatting.YELLOW);
    }

    public List<Entity> getBasicSwordHitBox(boolean crouching) {
        List<Entity> entities = this.defaultSwordHitbox((Entity)this.getSelf(), 4.5, 45.0, 0.1);
        if (crouching) {
            entities = this.defaultSwordHitbox((Entity)this.getSelf(), 3.0, 60.0, 0.02);
        }
        return entities;
    }

    public List<Entity> defaultSwordHitbox(Entity e, double radius, double angle, double factor) {
        Vec3 Eyepos = new Vec3(e.m_20299_((float)0.0f).f_82479_, 0.0, e.m_146892_().f_82481_);
        Vec3 pos = e.m_146892_().m_82520_(0.0, e.m_20154_().f_82480_, 0.0);
        List<Entity> list = MainUtil.genHitbox(this.getSelf().m_9236_(), pos.f_82479_, pos.f_82480_, pos.f_82481_, 8.0, 1.5, 8.0);
        list = this.doAttackChecks(list);
        list.remove(e);
        list.removeIf(entity -> {
            double b;
            Vec3 Lookvec;
            double dungle;
            Vec3 ePos = entity.m_20318_(0.0f);
            ePos = new Vec3(ePos.f_82479_, 0.0, ePos.f_82481_);
            Vec3 vector = ePos.m_82546_(Eyepos);
            double dist = vector.m_82553_();
            if (dist > radius - (dungle = Math.abs(Math.toDegrees((vector = vector.m_82541_()).m_82526_(Lookvec = new Vec3(Math.cos(b = Math.toRadians(e.m_146908_())), 0.0, Math.sin(b)))))) * factor) {
                return true;
            }
            return dungle > angle;
        });
        return list;
    }

    public List<Entity> doAttackChecks(List<Entity> list) {
        list.remove(this.getSelf());
        list.removeIf(Entity2 -> !Entity2.m_6097_());
        list.removeIf(entity -> {
            TamableAnimal TA;
            return entity instanceof TamableAnimal && Objects.equals((TA = (TamableAnimal)entity).m_269323_(), this.getSelf());
        });
        return list;
    }

    public void addMomentum(float x, float y, float z) {
        this.addMomentum(new Vec3((double)x, (double)y, (double)z));
    }

    public void addMomentum(Vec3 v) {
        this.getSelf().f_19812_ = true;
        this.getSelf().f_19864_ = true;
        this.getSelf().m_20256_(this.getSelf().m_20184_().m_82549_(v));
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        if (soundChoice == 1) {
            return ModSounds.STAND_BARRAGE_WINDUP_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        StandUser standUser = (StandUser)playerEntity;
        boolean standOn = standUser.roundabout$getActive();
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        boolean renderingSomething = false;
        float attackTimeDuring = this.getAttackTimeDuring();
        if (standOn && this.isClashing()) {
            renderingSomething = true;
            ClashTime = 15 - Math.round(attackTimeDuring / 60.0f * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.isBarrageAttacking() && attackTimeDuring > -1.0f) {
            renderingSomething = true;
            ClashTime = 15 - Math.round(attackTimeDuring / (float)this.getBarrageLength() * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 30, ClashTime, 6);
        } else if (standOn && this.isBarrageCharging()) {
            renderingSomething = true;
            int windup = this.getActivePower() == 41 ? this.getKickBarrageWindup() : this.getBarrageWindup();
            int ClashTime = Math.round(Math.min(attackTimeDuring, (float)windup) / (float)windup * 15.0f);
            int height = 30;
            if (this.isBarrageCharging() && this.getAttackTimeDuring() > (this.getActivePower() == 4 ? this.getBarrageWindup() : this.getKickBarrageWindup())) {
                height -= 6;
            }
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, height, ClashTime, 6);
        } else {
            float attackTime;
            float finalATime;
            int barTexture = 0;
            List<Entity> TE = this.getBasicSwordHitBox(this.isHoldingSneak());
            float attackTimeMax = this.getAttackTimeMax();
            if (this.getAttackTime() > this.getAttackTimeMax()) {
                this.lasthits = new ArrayList<Integer>();
            }
            if (attackTimeMax > 0.0f && (finalATime = (attackTime = (float)this.getAttackTime()) / attackTimeMax) <= 1.0f) {
                barTexture = this.getActivePowerPhase() == standUser.roundabout$getActivePowerPhaseMax() ? 24 : (!TE.isEmpty() ? 12 : 18);
                renderingSomething = true;
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
                int finalATimeInt = Math.round(finalATime * 15.0f);
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            }
            if (standOn && !TE.isEmpty() && barTexture == 0) {
                renderingSomething = true;
                context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 0, 15, 6);
            }
        }
        if (this.getAttackTimeDuring() == -1 && renderingSomething && this.canPogo()) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 60, 15, 7);
        }
        if (!this.visualValues.isEmpty()) {
            for (int i = 0; i < this.visualValues.size(); ++i) {
                Pair<List<Byte>, Integer> pair = this.visualValues.get(i);
                this.renderMoment(context, ((List)pair.getA()).toArray(new Byte[0]), (this.visualValues.size() - i) * 8, (Integer)pair.getB());
            }
        }
    }

    public void renderMoment(GuiGraphics context, Byte[] moments, int offset, int time) {
        int Offset = offset + 4 + (this.getStandUserSelf().roundabout$getActive() || !FateTypes.isHuman(this.getSelf()) ? 24 : 0);
        int xoff = 1;
        for (Byte moment : moments) {
            int xIcon = 7 * (switch (moment) {
                case 1 -> 0;
                case 2 -> 1;
                case 3 -> 2;
                case 4 -> 3;
                case 5 -> 4;
                case 6 -> 5;
                case 7 -> 6;
                case 8 -> 7;
                case 9 -> 8;
                case 10 -> 9;
                case 11 -> 10;
                case 12 -> 11;
                case 13 -> 12;
                case 14 -> 13;
                case 15 -> 14;
                default -> 90;
            });
            if (moment > 20 && moment < 30) {
                xIcon = 1 + 7 * (14 + (moment - 20));
            }
            context.m_280218_(StandIcons.ANUBIS_MEMORY, xoff, Offset, xIcon, 79, 7, 8);
            xoff += 8;
        }
        if (moments.length == 0) {
            xoff += 8;
        }
        if (time != -1) {
            context.m_280488_(Minecraft.m_91087_().f_91062_, "" + time, xoff, Offset, 0xFFFFFF);
        }
    }

    public void setPlayTime(int time) {
        this.playTime = time;
        this.maxPlayTime = time;
    }

    public void recordMemory(byte slot) {
        if (this.memories.isEmpty()) {
            return;
        }
        if (slot == -1 || slot == 8) {
            return;
        }
        this.playSlot = slot;
        this.setPlayTime(100);
        this.visualValues = new ArrayList<Pair<List<Byte>, Integer>>();
        this.lastMemory = this.memories.get(slot);
        this.memories.get((int)slot).moments = new ArrayList<AnubisMoment>();
    }

    public void playbackMemory(byte slot) {
        if (this.memories.isEmpty()) {
            return;
        }
        if (slot == -1 || slot == 8) {
            return;
        }
        AnubisMemory memory = this.memories.get(slot);
        if (memory != null && !memory.moments.isEmpty()) {
            List<AnubisMoment> moments = this.memories.get((int)slot).moments;
            this.playSlot = slot;
            this.setPlayTime(100 - moments.get((int)0).time);
            this.getStandUserSelf().roundabout$setUniqueStandModeToggle(true);
        }
    }

    public String convertToConfig(int i) {
        Item item;
        AnubisMemory AM = this.memories.get(i);
        Object ret = "";
        if (AM != null && (item = AM.item) != null) {
            ret = (String)ret + Item.m_41393_((Item)item);
            ret = (String)ret + "/" + AM.memory_type;
            ret = (String)ret + "/{";
            List<AnubisMoment> moments = AM.moments;
            for (AnubisMoment am : moments) {
                ret = (String)ret + am.toConfig();
            }
            ret = ((String)ret).substring(0, ((String)ret).length() - 1) + "}";
        }
        return ret;
    }

    public static AnubisMemory convertToMemory(int slot) {
        String cf = ConfigManager.getClientConfig().anubisMemories.getFromMemory(slot);
        if (cf.equals("nothing yet :P")) {
            cf = "";
            ConfigManager.getClientConfig().anubisMemories.saveToMemory(slot, "");
        }
        Item item = null;
        byte Mode2 = 0;
        ArrayList<AnubisMoment> moments = new ArrayList<AnubisMoment>();
        if (!cf.isEmpty()) {
            Scanner s = new Scanner(cf);
            s.useDelimiter("/");
            if (s.hasNext()) {
                try {
                    int intItem = Integer.parseInt(s.next());
                    item = Item.m_41445_((int)intItem);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (s.hasNext()) {
                    try {
                        Mode2 = Byte.parseByte(s.next());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    if (s.hasNext() && cf.contains("{") && cf.contains("}")) {
                        String mems = cf.substring(cf.indexOf("{") + 1, cf.indexOf("}"));
                        Scanner memScanner = new Scanner(mems);
                        memScanner.useDelimiter("_");
                        ArrayList<Byte> memBytes = new ArrayList<Byte>();
                        while (memScanner.hasNext()) {
                            String o = memScanner.next();
                            try {
                                memBytes.add((byte)Integer.parseInt(o));
                            }
                            catch (NumberFormatException e) {
                                Roundabout.LOGGER.warn("Invalid Memory Token??  " + o);
                            }
                        }
                        if (memBytes.size() % 3 == 0) {
                            for (int i = 0; i < memBytes.size(); i += 3) {
                                moments.add(new AnubisMoment((Byte)memBytes.get(i), ((Byte)memBytes.get(i + 1)).byteValue(), (Byte)memBytes.get(i + 2) == 1));
                            }
                        } else {
                            Roundabout.LOGGER.warn("Invalid Memory Length");
                        }
                    }
                }
            }
        }
        if (!moments.isEmpty()) {
            AnubisMemory AM = new AnubisMemory(item, new ArrayList<AnubisMoment>());
            AM.memory_type = Mode2;
            AM.moments = moments;
            return AM;
        }
        return null;
    }

    public static void generateMemories(PowersAnubis PA) {
        for (int i = 0; i < 8; ++i) {
            ArrayList<AnubisMoment> moment = new ArrayList<AnubisMoment>();
            AnubisMemory AM = new AnubisMemory(ModItems.ANUBIS_ITEM, moment);
            AnubisMemory ret = PowersAnubis.convertToMemory(i + 1);
            if (ret != null) {
                AM = ret;
            }
            PA.memories.add(AM);
        }
        Options o = Minecraft.m_91087_().f_91066_;
        PA.playKeys.add(o.f_92085_);
        PA.playBytes.add((byte)1);
        PA.playKeys.add(o.f_92087_);
        PA.playBytes.add((byte)2);
        PA.playKeys.add(o.f_92086_);
        PA.playBytes.add((byte)3);
        PA.playKeys.add(o.f_92088_);
        PA.playBytes.add((byte)4);
        PA.playKeys.add(o.f_92089_);
        PA.playBytes.add((byte)5);
        PA.playKeys.add(o.f_92091_);
        PA.playBytes.add((byte)6);
        PA.playKeys.add(o.f_92090_);
        PA.playBytes.add((byte)7);
        PA.playKeys.add(KeyInputRegistry.switchRow);
        PA.playBytes.add((byte)8);
        PA.playKeys.add(KeyInputRegistry.abilityThreeKey);
        PA.playBytes.add((byte)12);
        PA.playKeys.add(KeyInputRegistry.summonKey);
        PA.playBytes.add((byte)9);
        PA.playKeys.add(KeyInputRegistry.abilityOneKey);
        PA.playBytes.add((byte)10);
        PA.playKeys.add(KeyInputRegistry.abilityTwoKey);
        PA.playBytes.add((byte)11);
        PA.playKeys.add(KeyInputRegistry.abilityFourKey);
        PA.playBytes.add((byte)13);
        PA.playKeys.add(o.f_92096_);
        PA.playBytes.add((byte)14);
        PA.playKeys.add(o.f_92095_);
        PA.playBytes.add((byte)15);
        for (int i = 0; i < AnubisMoment.HOTBAR.length; ++i) {
            PA.playKeys.add(o.f_92056_[i]);
            PA.playBytes.add(AnubisMoment.HOTBAR[i]);
        }
    }

    public AnubisMemory getUsedMemory() {
        if (this.playSlot != -1 && !this.memories.isEmpty()) {
            return this.memories.get(this.playSlot);
        }
        return null;
    }

    public int getLastMoment(int slot, byte type, int time) {
        AnubisMemory mem = this.memories.get(slot);
        List<AnubisMoment> moments = mem.moments;
        if (moments.isEmpty()) {
            return -1;
        }
        for (int i = moments.size() - 1; i >= 0; --i) {
            AnubisMoment moment = moments.get(i);
            if (moment.type != type || time < moment.time) continue;
            return i;
        }
        return -1;
    }

    public boolean isPressed(byte id, int time) {
        return this.isPressed(this.playSlot, id, time);
    }

    public boolean isPressed(byte slot, byte id, int time) {
        int a = this.getLastMoment(slot, id, time);
        if (a != -1) {
            AnubisMoment moment = this.memories.get((int)slot).moments.get(a);
            return moment.vargs;
        }
        return false;
    }

    public void convertToVisual(byte slot, List<AnubisMoment> moments) {
        this.visualValues = new ArrayList<Pair<List<Byte>, Integer>>();
        if (slot == -1) {
            return;
        }
        if (moments.isEmpty()) {
            return;
        }
        int maxTime = Math.min(100, moments.get((int)(moments.size() - 1)).time);
        for (int time = 0; time < maxTime; ++time) {
            ArrayList<Byte> value = new ArrayList<Byte>();
            for (Byte playByte : this.playBytes) {
                if (!this.isPressed(slot, playByte, time)) continue;
                value.add(playByte);
            }
            if (this.visualValues.isEmpty()) {
                this.visualValues.add((Pair<List<Byte>, Integer>)new Pair(value, (Object)0));
                continue;
            }
            Pair<List<Byte>, Integer> last = this.visualValues.get(this.visualValues.size() - 1);
            if (((List)last.getA()).equals(value)) {
                this.visualValues.set(this.visualValues.size() - 1, (Pair<List<Byte>, Integer>)new Pair((Object)((List)last.getA()), (Object)((Integer)last.getB() + 1)));
                continue;
            }
            this.visualValues.add((Pair<List<Byte>, Integer>)new Pair(value, (Object)0));
        }
    }
}

