/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.hydra.jojomod.access.IGravityEntity;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.client.hud.StandHudRender;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.C2SPacketUtil;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.hydra.jojomod.util.gravity.RotationUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class PowersWalkingHeart
extends NewDashPreset {
    public Direction heelDirection = Direction.DOWN;
    public int hitsSinceAttached = 0;
    public int cutCorners = 0;
    public int slowHeelTicks = 0;
    public int shootTicks = 0;
    public Direction cutDirection;
    public Vec3 lastGroundPosition = Vec3.f_82478_;
    public int lastTick = 0;
    public int heelExtension = 0;
    public boolean holdDownClick = false;
    public boolean consumeClickInput = false;
    public int pauseGrowthTicks = 0;
    public int justFlippedTicks = 0;
    public int mercyTicks = 0;
    public static final byte VISAGE_NOISE = 104;
    public static final byte IMPALE_NOISE = 105;
    public int currentKickTicks = 0;

    public PowersWalkingHeart(LivingEntity self) {
        super(self);
    }

    @Override
    public StandEntity getNewStandEntity() {
        return (StandEntity)ModEntities.WALKING_HEART.m_20615_(this.getSelf().m_9236_());
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersWalkingHeart(entity);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableWalkingHeart;
    }

    public boolean canWallWalkConfig() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableWallWalking;
    }

    public int walkingCDPerHit() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartCooldownPerHit;
    }

    public int walkingMaxHits() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartMaxHits;
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)0);
        $$1.add((byte)1);
        $$1.add((byte)2);
        $$1.add((byte)3);
        $$1.add((byte)4);
        return $$1;
    }

    @Override
    public byte getMaxLevel() {
        return 4;
    }

    @Override
    public boolean interceptSuccessfulDamageDealtEvent(DamageSource $$0, float $$1, LivingEntity target) {
        if (this.hasStandActive(this.getSelf()) && $$0.m_276093_(DamageTypes.f_268464_) && this.hasExtendedHeelsForWalking()) {
            this.addEXP(1);
        }
        return false;
    }

    @Override
    public int getExpForLevelUp(int currentLevel) {
        int amt = currentLevel == 1 ? 200 : (currentLevel == 2 ? 400 : 800);
        amt = (int)((float)amt * this.getLevelMultiplier());
        return amt;
    }

    @Override
    public void levelUp() {
        LivingEntity livingEntity;
        if (!this.getSelf().m_9236_().m_5776_() && (livingEntity = this.getSelf()) instanceof Player) {
            Player PE = (Player)livingEntity;
            IPlayerEntity ipe = (IPlayerEntity)PE;
            byte level = ipe.roundabout$getStandLevel();
            if (level == 4) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.max.skins").m_130940_(ChatFormatting.AQUA), true);
            } else if (level == 2 || level == 3) {
                ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"leveling.roundabout.levelup.skins").m_130940_(ChatFormatting.AQUA), true);
            }
        }
        super.levelUp();
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.spikeAttackModeToggleClient();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                this.extendHeels();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dashOrWallLatch();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.unlockSpiderClient();
            }
        }
    }

    public void unlockSpiderClient() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            ItemStack stack;
            boolean bypass;
            Player PE = (Player)livingEntity;
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (!((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !bypass && !(stack = this.self.m_21205_()).m_41619_() && stack.m_150930_(Items.f_41863_) && stack.m_41613_() >= 64) {
                this.tryPowerPacket((byte)36);
                return;
            }
            if (this.canWallWalkConfig() && this.canCornerCutConfig()) {
                this.tryPowerPacket((byte)37);
            }
        }
    }

    public void extendHeels() {
        if (!((this.onCooldown((byte)2) || this.onCooldown((byte)1)) && !this.hasExtendedHeelsForWalking() || this.inCombatMode() || this.self.m_6069_())) {
            if (this.forceBlock()) {
                return;
            }
            ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
            this.tryPowerPacket((byte)23);
        }
    }

    public boolean forceBlock() {
        return !MainUtil.isBlockWalkableSimplified(this.self.m_9236_().m_8055_(this.self.m_20097_()));
    }

    public void dashOrWallLatch() {
        if (this.inCombatMode()) {
            return;
        }
        if (this.canLatchOntoWall() && this.canWallWalkConfig()) {
            this.doWallLatchClient();
        } else if (!this.hasExtendedHeelsForWalking()) {
            this.dash();
        }
    }

    public void doWallLatchClient() {
        if (!this.onCooldown((byte)2) && !this.onCooldown((byte)1) && this.canLatchOntoWall() && this.canWallWalkConfig()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(25, true);
        }
    }

    public Direction getHeelDirection() {
        return this.heelDirection;
    }

    public void setHeelDirection(Direction dir) {
        this.heelDirection = dir;
    }

    public boolean hasExtendedHeelsForWalking() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    public boolean canLatchOntoWall() {
        if (this.onCooldown((byte)1) || this.self.m_6069_()) {
            return false;
        }
        if (MainUtil.isStandingInBlock(this.self)) {
            return false;
        }
        if (this.forceBlock()) {
            return false;
        }
        if (this.self.m_20096_() && !this.hasExtendedHeelsForWalking() || !this.self.m_20096_() && this.hasExtendedHeelsForWalking()) {
            return false;
        }
        Vec3 mpos = this.self.m_20318_(1.0f);
        Direction gravdir = ((IGravityEntity)this.self).roundabout$getGravityDirection();
        switch (gravdir) {
            case DOWN: {
                mpos = mpos.m_82520_(0.0, (double)0.1f, 0.0);
                break;
            }
            case UP: {
                mpos = mpos.m_82520_(0.0, (double)-0.1f, 0.0);
                break;
            }
            case NORTH: {
                mpos = mpos.m_82520_(0.0, 0.0, (double)0.1f);
                break;
            }
            case SOUTH: {
                mpos = mpos.m_82520_(0.0, 0.0, (double)-0.1f);
                break;
            }
            case WEST: {
                mpos = mpos.m_82520_((double)0.1f, 0.0, 0.0);
                break;
            }
            case EAST: {
                mpos = mpos.m_82520_((double)-0.1f, 0.0, 0.0);
            }
        }
        BlockPos pos1 = BlockPos.m_274446_((Position)mpos);
        Direction rd = RotationUtil.getRealFacingDirection2(this.self);
        if (rd == gravdir) {
            return false;
        }
        pos1 = pos1.m_121945_(RotationUtil.getRealFacingDirection2(this.self));
        BlockState bs = this.self.m_9236_().m_8055_(pos1);
        return MainUtil.isBlockWalkable(bs);
    }

    public void setHeelAttachCooldown() {
        int attachment = this.getHeelUnattachCooldown();
        if (attachment > 0) {
            this.setCooldown((byte)1, this.getHeelUnattachCooldown());
            S2CPacketUtil.sendCooldownSyncPacket((Player)((ServerPlayer)this.getSelf()), (byte)1, this.getHeelUnattachCooldown());
        }
    }

    public int getHeelUnattachCooldown() {
        return this.hitsSinceAttached * this.walkingCDPerHit();
    }

    public void hitHeelExtendedState() {
        int maxhits;
        if (this.hasExtendedHeelsForWalking() && (maxhits = this.walkingMaxHits()) >= 0) {
            ++this.hitsSinceAttached;
            if (this.hitsSinceAttached > maxhits) {
                this.toggleSpikes(false);
            }
        }
    }

    @Override
    public void onActuallyHurt(DamageSource $$0, float $$1) {
        if ($$0.m_7639_() != null && !$$0.m_276093_(DamageTypes.f_268440_)) {
            this.hitHeelExtendedState();
        }
    }

    public void regularExtendHeels() {
        if (this.self.m_6069_()) {
            return;
        }
        boolean isAnchored = this.hasExtendedHeelsForWalking();
        if (isAnchored) {
            if (!this.self.m_9236_().m_5776_()) {
                this.toggleSpikes(false);
            }
        } else if (!this.inCombatMode() && this.self.m_20096_()) {
            this.setCooldown((byte)2, 10);
            if (!this.self.m_9236_().m_5776_()) {
                this.setHeelDirection(((IGravityEntity)this.self).roundabout$getGravityDirection());
                this.toggleSpikes(true);
            }
        }
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_()) {
            if (effect.m_19557_() == 80) {
                MainUtil.makeBleed((Entity)this.self, 0, 900, (Entity)this.self);
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.SPIKE_HIT_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (MainUtil.getMobBleed((Entity)this.self)) {
                    MainUtil.makeMobBleed((Entity)this.self);
                }
            }
            if (effect.m_19557_() == 50) {
                MainUtil.makeBleed((Entity)this.self, 1, 900, (Entity)this.self);
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.SPIKE_HIT_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (MainUtil.getMobBleed((Entity)this.self)) {
                    MainUtil.makeMobBleed((Entity)this.self);
                }
            }
            if (effect.m_19557_() == 20) {
                MainUtil.makeBleed((Entity)this.self, 2, 900, (Entity)this.self);
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.SPIKE_HIT_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (MainUtil.getMobBleed((Entity)this.self)) {
                    MainUtil.makeMobBleed((Entity)this.self);
                }
            }
        }
    }

    public void spikeAttackModeToggleClient() {
        if (!this.hasExtendedHeelsForWalking() || ((IGravityEntity)this.self).roundabout$getGravityDirection() == Direction.DOWN) {
            if (!this.inCombatMode() && this.getShootTicks() > 0) {
                return;
            }
            this.tryPower(27, true);
            this.tryPowerPacket((byte)27);
            this.getStandUserSelf().roundabout$getStandPowers().tryPower(0, true);
            this.tryPowerPacket((byte)0);
            ClientUtil.stopDestroyingBlock();
        }
    }

    public void wallLatch() {
        this.setCooldown((byte)2, 10);
        this.toggleSpikes(true);
        Direction gd = RotationUtil.getRealFacingDirection2(this.self);
        this.setHeelDirection(gd);
        ((IGravityEntity)this.self).roundabout$setGravityDirection(gd);
        this.justFlippedTicks = 7;
        if (this.self.m_9236_().m_5776_()) {
            C2SPacketUtil.intToServerPacket((byte)16, MainUtil.getIntFromDirection(gd));
        }
    }

    public void grantFallImmunity() {
        if (ClientNetworking.getAppropriateConfig().walkingHeartSettings.fallProtectionOnRelease.booleanValue()) {
            ((StandUser)this.getSelf()).roundabout$setLeapTicks(((StandUser)this.getSelf()).roundabout$getMaxLeapTicks());
            ((StandUser)this.getSelf()).roundabout$setLeapIntentionally(true);
        }
    }

    public void toggleSpikes(boolean toggle) {
        boolean getTog;
        if (!this.self.m_9236_().m_5776_() && toggle != (getTog = this.getStandUserSelf().roundabout$getUniqueStandModeToggle())) {
            if (toggle) {
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.EXTEND_SPIKES_EVENT, SoundSource.PLAYERS, 1.0f, 1.0f);
            } else {
                this.setHeelAttachCooldown();
                this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.EXTEND_SPIKES_EVENT, SoundSource.PLAYERS, 1.0f, 1.5f);
            }
        }
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(toggle);
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.SPIKE_ATTACK_MODE, (byte)0);
        if (this.hasExtendedHeelsForWalking()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.GROUND_IMPLANT, (byte)1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.GROUND_IMPLANT_OUT, (byte)1);
        }
        if ((this.canLatchOntoWall() || this.hasExtendedHeelsForWalking()) && this.canWallWalkConfig()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.WALL_WALK, (byte)2);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        boolean isSpider = false;
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            ItemStack stack;
            boolean bypass;
            Player PE = (Player)livingEntity;
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (!((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !bypass && !(stack = this.self.m_21205_()).m_41619_() && stack.m_150930_(Items.f_41863_) && stack.m_41613_() >= 64) {
                this.setSkillIcon(context, x, y, 4, StandIcons.SPIDER_SKIN, (byte)0);
                isSpider = true;
            }
        }
        if (!isSpider && this.canWallWalkConfig() && this.canCornerCutConfig()) {
            if (this.canCutCorners()) {
                this.setSkillIcon(context, x, y, 4, StandIcons.WALL_CUT, (byte)0);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.WALL_PASS, (byte)0);
            }
        }
    }

    public boolean canCutCorners() {
        return this.cutCorners == 2;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (slot == 3 && this.hasExtendedHeelsForWalking() && !this.canLatchOntoWall()) {
            return true;
        }
        if (slot == 1 && this.hasExtendedHeelsForWalking() && ((IGravityEntity)this.self).roundabout$getGravityDirection() != Direction.DOWN) {
            return true;
        }
        if (slot == 1 && (this.isBlockedByStone() || this.getShootTicks() > 0 && !this.inCombatMode())) {
            return true;
        }
        if ((slot == 2 || slot == 3) && this.inCombatMode()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        byte bt = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (soundChoice == 18) {
            return ModSounds.SUMMON_WALKING_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.inCombatMode()) {
            return 0.0f;
        }
        if (this.hasExtendedHeelsForWalking() && (this.canCutCorners() || this.slowHeelTicks > 0)) {
            return basis * 0.8f;
        }
        return super.inputSpeedModifiers(basis);
    }

    public boolean inCombatMode() {
        return this.getStandUserSelf().roundabout$getCombatMode();
    }

    public boolean canCornerCutConfig() {
        return ClientNetworking.getAppropriateConfig().walkingHeartSettings.enableCornerCutting;
    }

    @Override
    public boolean cancelJump() {
        return this.inCombatMode() || this.hasExtendedHeelsForWalking() && this.canCutCorners();
    }

    @Override
    public boolean cancelSprint() {
        return this.inCombatMode();
    }

    public void switchModes() {
        if (this.getStandUserSelf().roundabout$getCombatMode()) {
            this.getStandUserSelf().roundabout$setCombatMode(false);
            if (!this.self.m_9236_().m_5776_()) {
                this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.HEEL_STOMP_EVENT, this.self.m_5720_(), 1.0f, 1.0f);
            }
        } else {
            if (this.hasExtendedHeelsForWalking() && ((IGravityEntity)this.self).roundabout$getGravityDirection() != Direction.DOWN || this.isBlockedByStone()) {
                return;
            }
            this.self.m_6858_(false);
            this.getStandUserSelf().roundabout$setCombatMode(true);
            if (!this.self.m_9236_().m_5776_()) {
                this.self.m_9236_().m_6263_(null, this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_(), ModSounds.HEEL_RAISE_EVENT, this.self.m_5720_(), 1.0f, 1.0f);
            }
        }
    }

    public int getMaxShootTicks() {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 > 3 || bypass) {
                return 10000;
            }
            if (Level2 > 2) {
                return 10000 - this.getUseTicks();
            }
            if (Level2 > 1) {
                return 10000 - this.getUseTicks() - this.getUseTicks();
            }
            return 10000 - this.getUseTicks() - this.getUseTicks() - this.getUseTicks() - this.getUseTicks();
        }
        return 10000;
    }

    public int getShootTicks() {
        return this.shootTicks;
    }

    public void setShootTicks(int shootTicks) {
        this.shootTicks = Mth.m_14045_((int)shootTicks, (int)0, (int)this.getMaxShootTicks());
        if (this.shootTicks >= this.getMaxShootTicks() && this.self.m_9236_().m_5776_()) {
            this.tryPowerPacket((byte)27);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        switch (move) {
            case 23: {
                this.regularExtendHeels();
                break;
            }
            case 25: {
                this.wallLatch();
                break;
            }
            case 27: {
                this.switchModes();
                break;
            }
            case 33: {
                this.useSpikeAttack();
                break;
            }
            case 52: {
                this.useSpikeAttack2();
                break;
            }
            case 34: {
                this.missSound();
                break;
            }
            case 22: {
                this.hitSound();
                break;
            }
            case 36: {
                this.spiderUnlock();
                break;
            }
            case 37: {
                this.serverSetCutCorners();
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public boolean interceptAttack() {
        return this.inCombatMode();
    }

    public void spiderUnlock() {
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            ItemStack stack;
            boolean bypass;
            Player PE = (Player)livingEntity;
            Level lv = this.getSelf().m_9236_();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            StandUser user = (StandUser)PE;
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (!(((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass || (stack = this.self.m_21205_()).m_41619_() || !stack.m_150930_(Items.f_41863_) || stack.m_41613_() < 64 || lv.m_5776_())) {
                IPlayerEntity ipe = (IPlayerEntity)PE;
                ipe.roundabout$setUnlockedBonusSkin(true);
                lv.m_6263_(null, PE.m_20185_(), PE.m_20186_(), PE.m_20189_(), ModSounds.UNLOCK_SKIN_EVENT, PE.m_5720_(), 2.0f, 1.0f);
                ((ServerLevel)lv).m_8767_((ParticleOptions)ParticleTypes.f_123810_, PE.m_20185_(), PE.m_20186_() + (double)PE.m_20192_(), PE.m_20189_(), 10, 0.5, 0.5, 0.5, 0.2);
                user.roundabout$setStandSkin((byte)8);
                ((ServerPlayer)ipe).m_5661_((Component)Component.m_237115_((String)"unlock_skin.roundabout.walking_heart.spider"), true);
                user.roundabout$summonStand(lv, true, false);
                stack.m_41774_(64);
            }
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        Entity ent;
        if (move == 44 && (ent = this.self.m_9236_().m_6815_(chargeTime)) != null) {
            this.HeelSpikeDamageEntityAttack(ent, this.getSpikeDamage(ent), 0.5f, (Entity)this.self, false);
            return true;
        }
        if (move == 45 && (ent = this.self.m_9236_().m_6815_(chargeTime)) != null) {
            this.HeelSpikeDamageEntityAttack(ent, this.getSpikeDamage(ent), 0.7f, (Entity)this.self, true);
            return true;
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public float getSpikeDamage(Entity entity) {
        if (this.getReducedDamage(entity)) {
            return this.levelupDamageMod((float)((double)1.8f * ((double)ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartAttackMultOnPlayers.intValue() * 0.01)));
        }
        return this.levelupDamageMod((float)(3.0 * ((double)ClientNetworking.getAppropriateConfig().walkingHeartSettings.walkingHeartAttackMultOnMobs.intValue() * 0.01)));
    }

    @Override
    public boolean interceptAllInteractions() {
        return this.inCombatMode();
    }

    public boolean HeelSpikeDamageEntityAttack(Entity target, float pow, float knockbackStrength, Entity attacker, boolean rightClick) {
        LivingEntity LE;
        if (target == null) {
            return false;
        }
        this.hitParticlesCenter(target);
        if (attacker instanceof TamableAnimal) {
            TamableAnimal TT;
            TamableAnimal TA = (TamableAnimal)attacker;
            if (target instanceof TamableAnimal && (TT = (TamableAnimal)target).m_269323_() != null && TA.m_269323_() != null && TT.m_269323_().m_7306_((Entity)TA.m_269323_())) {
                return false;
            }
        } else if (attacker instanceof AbstractVillager && target instanceof AbstractVillager) {
            return false;
        }
        if (DamageHandler.HeelSpikeStandDamageEntity(target, pow, attacker)) {
            if (attacker instanceof LivingEntity) {
                LE = (LivingEntity)attacker;
                LE.m_21335_(target);
            }
            if (target instanceof LivingEntity) {
                LE = (LivingEntity)target;
                this.addEXP(3, LE);
                float mod = -1.0f;
                if (rightClick) {
                    mod = 1.0f;
                }
                LE.f_19864_ = true;
                LE.m_147240_((double)(knockbackStrength * 0.5f), (double)(mod * Mth.m_14031_((float)(this.self.m_146908_() * ((float)Math.PI / 180)))), (double)(mod * -Mth.m_14089_((float)(this.self.m_146908_() * ((float)Math.PI / 180)))));
                MainUtil.makeBleed((Entity)LE, 0, 300, (Entity)this.self);
            }
            return true;
        }
        if (target instanceof LivingEntity) {
            LE = (LivingEntity)target;
            float mod = -1.0f;
            if (rightClick) {
                mod = 1.0f;
            }
            LE.f_19864_ = true;
            LE.m_147240_((double)(knockbackStrength * 0.5f), (double)(mod * Mth.m_14031_((float)(this.self.m_146908_() * ((float)Math.PI / 180)))), (double)(mod * -Mth.m_14089_((float)(this.self.m_146908_() * ((float)Math.PI / 180)))));
        }
        return false;
    }

    public final void sendHeelPacket(double range) {
        if (!this.self.m_9236_().f_46443_) {
            ServerLevel serverWorld = (ServerLevel)this.self.m_9236_();
            Vec3 userLocation = new Vec3(this.self.m_20185_(), this.self.m_20186_(), this.self.m_20189_());
            for (int j = 0; j < serverWorld.m_6907_().size(); ++j) {
                BlockPos blockPos;
                ServerPlayer serverPlayerEntity = (ServerPlayer)((ServerLevel)this.self.m_9236_()).m_6907_().get(j);
                if ((ServerLevel)serverPlayerEntity.m_9236_() != serverWorld || !(blockPos = serverPlayerEntity.m_20183_()).m_203195_((Position)userLocation, range)) continue;
                S2CPacketUtil.heelExtend((Player)serverPlayerEntity, this.self.m_19879_());
            }
        }
    }

    public void hitSound() {
        this.sendHeelPacket(120.0);
        this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.SPIKE_HIT_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
    }

    public void missSound() {
        this.sendHeelPacket(120.0);
        this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.SPIKE_MISS_EVENT, SoundSource.PLAYERS, 2.0f, (float)(0.98 + Math.random() * 0.04));
    }

    @Override
    public boolean replaceHudActively() {
        return this.inCombatMode() || this.getShootTicks() > 0;
    }

    @Override
    public void getReplacementHUD(GuiGraphics context, Player cameraPlayer, int screenWidth, int screenHeight, int x) {
        StandHudRender.renderWalkingHeartHud(context, cameraPlayer, screenWidth, screenHeight, x);
    }

    public void useSpikeAttackF(boolean rightClick) {
        this.setCooldown((byte)3, 3);
        this.setAttackTimeDuring(-10);
        this.setActivePower((byte)33);
        if (this.self.m_9236_().m_5776_()) {
            List<Entity> TE = ClientNetworking.getAppropriateConfig().miscellaneousSettings.wallPassingHitboxes == false ? this.getTargetEntityList(this.self, 7.0f, 10.0f) : this.getTargetEntityListThroughWalls(this.self, 7.0f, 10.0f);
            if (TE == null || TE.isEmpty()) {
                this.tryPowerPacket((byte)34);
            } else {
                this.tryPowerPacket((byte)22);
                for (Entity value : TE) {
                    if (rightClick) {
                        this.tryIntPowerPacket((byte)45, value.m_19879_());
                        continue;
                    }
                    this.tryIntPowerPacket((byte)44, value.m_19879_());
                }
            }
        }
    }

    public void useSpikeAttack2() {
        this.useSpikeAttackF(true);
    }

    public boolean isBlockedByStone() {
        byte curse = ((StandUser)this.self).roundabout$getLocacacaCurse();
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player) {
            Player PE = (Player)livingEntity;
            if (curse == 2 && PE.m_5737_() == HumanoidArm.RIGHT) {
                return true;
            }
            if (curse == 1 && PE.m_5737_() == HumanoidArm.LEFT) {
                return true;
            }
        }
        return false;
    }

    public void useSpikeAttack() {
        this.useSpikeAttackF(false);
    }

    public boolean tryCut(Vec3 cutPos) {
        BlockPos pos1 = BlockPos.m_274446_((Position)cutPos);
        BlockState bs = this.self.m_9236_().m_8055_(pos1);
        return MainUtil.isBlockWalkable(bs);
    }

    public boolean tryCutEast(Vec3 mpos) {
        return this.tryCut(mpos.m_82549_(new Vec3(0.1, 0.0, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3((double)(this.self.m_20205_() * 1.1f), 0.0, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3((double)(this.self.m_20205_() * 1.4f), 0.0, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3((double)(this.self.m_20205_() * 1.6f), 0.0, 0.0)));
    }

    public boolean tryCutWest(Vec3 mpos) {
        return this.tryCut(mpos.m_82549_(new Vec3(-0.1, 0.0, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3((double)(-this.self.m_20205_() * 1.1f), 0.0, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3((double)(-this.self.m_20205_() * 1.4f), 0.0, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3((double)(-this.self.m_20205_() * 1.6f), 0.0, 0.0)));
    }

    public boolean tryCutNorth(Vec3 mpos) {
        return this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, -0.1))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, (double)(-this.self.m_20205_() * 1.1f)))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, (double)(-this.self.m_20205_() * 1.4f)))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, (double)(-this.self.m_20205_() * 1.6f))));
    }

    public boolean tryCutSouth(Vec3 mpos) {
        return this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, 0.1))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, (double)(this.self.m_20205_() * 1.1f)))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, (double)(this.self.m_20205_() * 1.4f)))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.0, (double)(this.self.m_20205_() * 1.6f))));
    }

    public boolean tryCutUp(Vec3 mpos) {
        return this.tryCut(mpos.m_82549_(new Vec3(0.0, 0.1, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, (double)(this.self.m_20205_() * 1.1f), 0.0))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, (double)(this.self.m_20205_() * 1.4f), 0.0))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, (double)(this.self.m_20205_() * 1.6f), 0.0)));
    }

    public boolean tryCutDown(Vec3 mpos) {
        return this.tryCut(mpos.m_82549_(new Vec3(0.0, -0.1, 0.0))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, (double)(-this.self.m_20205_() * 1.1f), 0.0))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, (double)(-this.self.m_20205_() * 1.4f), 0.0))) || this.tryCut(mpos.m_82549_(new Vec3(0.0, (double)(-this.self.m_20205_() * 1.6f), 0.0)));
    }

    public boolean canCutX() {
        Vec3 mpos = this.self.m_20318_(1.0f);
        if (this.tryCutEast(mpos)) {
            if (this.tryCutWest(mpos)) {
                return false;
            }
            this.cutDirection = Direction.EAST;
        } else if (this.tryCutWest(mpos)) {
            this.cutDirection = Direction.WEST;
        } else if (this.tryCutSouth(mpos)) {
            if (this.tryCutNorth(mpos)) {
                return false;
            }
            this.cutDirection = Direction.SOUTH;
        } else if (this.tryCutNorth(mpos)) {
            this.cutDirection = Direction.NORTH;
        } else if (this.tryCutUp(mpos)) {
            if (this.tryCutDown(mpos)) {
                return false;
            }
            this.cutDirection = Direction.UP;
        } else if (this.tryCutDown(mpos)) {
            this.cutDirection = Direction.DOWN;
        } else {
            return false;
        }
        return true;
    }

    public boolean canCut() {
        Vec3 mpos = this.self.m_20318_(1.0f);
        float northTest = 1.0f * (float)(this.lastGroundPosition.f_82481_ - mpos.f_82481_);
        float southTest = -1.0f * (float)(this.lastGroundPosition.f_82481_ - mpos.f_82481_);
        float eastTest = -1.0f * (float)(this.lastGroundPosition.f_82479_ - mpos.f_82479_);
        float westTest = 1.0f * (float)(this.lastGroundPosition.f_82479_ - mpos.f_82479_);
        float upTest = -1.0f * (float)(this.lastGroundPosition.f_82480_ - mpos.f_82480_);
        float downTest = 1.0f * (float)(this.lastGroundPosition.f_82480_ - mpos.f_82480_);
        List<DirDist> tests = List.of(new DirDist(Direction.NORTH, northTest), new DirDist(Direction.SOUTH, southTest), new DirDist(Direction.EAST, eastTest), new DirDist(Direction.WEST, westTest), new DirDist(Direction.UP, upTest), new DirDist(Direction.DOWN, downTest));
        ArrayList<DirDist> ordered = new ArrayList<DirDist>(tests);
        ordered.sort(Comparator.comparing(d -> Float.valueOf(d.dist())));
        for (DirDist test : ordered) {
            boolean success;
            if (!(success = (switch (test.dir()) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.EAST -> this.tryCutEast(mpos);
                case Direction.WEST -> this.tryCutWest(mpos);
                case Direction.NORTH -> this.tryCutNorth(mpos);
                case Direction.SOUTH -> this.tryCutSouth(mpos);
                case Direction.UP -> this.tryCutUp(mpos);
                case Direction.DOWN -> this.tryCutDown(mpos);
            }))) continue;
            this.cutDirection = test.dir();
            if (this.cutDirection == Direction.EAST && this.tryCutWest(mpos)) {
                return false;
            }
            if (this.cutDirection == Direction.WEST && this.tryCutEast(mpos)) {
                return false;
            }
            if (this.cutDirection == Direction.NORTH && this.tryCutSouth(mpos)) {
                return false;
            }
            if (this.cutDirection == Direction.SOUTH && this.tryCutNorth(mpos)) {
                return false;
            }
            if (this.cutDirection == Direction.UP && this.tryCutDown(mpos)) {
                return false;
            }
            return this.cutDirection != Direction.DOWN || !this.tryCutUp(mpos);
        }
        return false;
    }

    @Override
    public void serverQueried() {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)livingEntity;
            S2CPacketUtil.sendGenericIntToClientPacket((Player)pl, (byte)10, this.cutCorners);
        }
    }

    @Override
    public void serverQueried2() {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)livingEntity;
            this.toggleSpikes(false);
        }
    }

    public void serverSetCutCorners() {
        if (this.canCutCorners()) {
            this.setCutCorners(1);
            ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"text.roundabout.walking.cut_ff").m_130940_(ChatFormatting.DARK_PURPLE), true);
        } else {
            this.setCutCorners(2);
            ((ServerPlayer)this.self).m_5661_((Component)Component.m_237115_((String)"text.roundabout.walking.cut_on").m_130940_(ChatFormatting.DARK_PURPLE), true);
        }
    }

    public void setCutCorners(int corners) {
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)livingEntity;
            this.cutCorners = corners;
            S2CPacketUtil.sendGenericIntToClientPacket((Player)pl, (byte)10, corners);
        }
    }

    @Override
    public void clientIntUpdated(int integer) {
        this.cutCorners = integer;
    }

    @Override
    public void tickPower() {
        Player PE;
        if (this.lastTick != this.self.f_19797_) {
            this.setHeelExtension(this.getHeelExtension() - 1);
            this.lastTick = this.self.f_19797_;
        }
        if (this.self.m_9236_().m_5776_()) {
            newVec = new Vec3(0.0, -0.2, 0.0);
            Vec3 newVec2 = new Vec3(0.0, -1.0, 0.0);
            Vec3 newVec4 = new Vec3(0.0, -0.5, 0.0);
            Vec3 newVec5 = new Vec3(0.0, -1.1, 0.0);
            newVec = RotationUtil.vecPlayerToWorld(newVec, ((IGravityEntity)this.self).roundabout$getGravityDirection());
            BlockPos pos = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec));
            newVec2 = RotationUtil.vecPlayerToWorld(newVec2, ((IGravityEntity)this.self).roundabout$getGravityDirection());
            BlockPos pos2 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec2));
            newVec4 = RotationUtil.vecPlayerToWorld(newVec4, ((IGravityEntity)this.self).roundabout$getGravityDirection());
            BlockPos pos4 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec4));
            newVec5 = RotationUtil.vecPlayerToWorld(newVec5, ((IGravityEntity)this.self).roundabout$getGravityDirection());
            BlockPos pos5 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec5));
            if (this.cutCorners == 0 && this.self instanceof Player) {
                this.cutCorners = 1;
                C2SPacketUtil.trySingleBytePacket((byte)33);
            } else if (this.canCutCorners()) {
                this.slowHeelTicks = 20;
            } else if (this.slowHeelTicks > 0) {
                --this.slowHeelTicks;
            }
            if (!this.inCombatMode()) {
                this.currentKickTicks = 0;
            } else if (this.currentKickTicks < PowersWalkingHeart.chargeKickTicks()) {
                ++this.currentKickTicks;
            }
            if (!(!this.hasExtendedHeelsForWalking() || this.getStandUserSelf().rdbt$getJumping() || this.self.m_20096_() || !(this.self.m_20184_().f_82480_ < 0.0) || this.canCutCorners() && this.justFlippedTicks > 0)) {
                this.self.m_20256_(this.self.m_20184_().m_82520_(0.0, -0.14, 0.0));
            }
            if (this.self.m_6069_()) {
                this.toggleSpikes(false);
                C2SPacketUtil.trySingleBytePacket((byte)34);
            }
            if (this.inCombatMode() && this.isBlockedByStone()) {
                this.switchModes();
            }
            if (this.hasExtendedHeelsForWalking()) {
                if (this.justFlippedTicks > 0) {
                    --this.justFlippedTicks;
                } else {
                    if (this.self.m_20096_() && MainUtil.isBlockWalkableSimplified(this.self.m_20075_())) {
                        this.mercyTicks = 5;
                        this.lastGroundPosition = this.self.m_20182_();
                    } else if (MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos)) || MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos2)) || MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos4)) || MainUtil.isBlockWalkable(this.self.m_9236_().m_8055_(pos5))) {
                        --this.mercyTicks;
                    } else if (this.canCutCorners()) {
                        if (this.mercyTicks > 4) {
                            this.mercyTicks = 4;
                        }
                        --this.mercyTicks;
                        if (this.canCut() && this.cutDirection != ((IGravityEntity)this.self).roundabout$getGravityDirection()) {
                            ((IGravityEntity)this.self).roundabout$setGravityDirection(this.cutDirection);
                            this.setHeelDirection(this.cutDirection);
                            this.justFlippedTicks = 5;
                            C2SPacketUtil.intToServerPacket((byte)15, MainUtil.getIntFromDirection(this.heelDirection));
                        }
                    } else {
                        this.mercyTicks = 0;
                    }
                    if (this.self.m_5803_() || !this.self.m_20096_() && this.mercyTicks <= 0 || this.self.m_20201_() != this.self) {
                        this.heelDirection = Direction.DOWN;
                        if (((IGravityEntity)this.self).roundabout$getGravityDirection() != this.heelDirection) {
                            this.grantFallImmunity();
                        }
                        this.toggleSpikes(false);
                        C2SPacketUtil.trySingleBytePacket((byte)34);
                        ((IGravityEntity)this.self).roundabout$setGravityDirection(this.heelDirection);
                        this.setHeelDirection(this.heelDirection);
                        this.justFlippedTicks = 5;
                        C2SPacketUtil.intToServerPacket((byte)15, MainUtil.getIntFromDirection(this.heelDirection));
                    }
                }
            } else {
                this.setHeelDirection(Direction.DOWN);
            }
        } else {
            boolean isOnValidBlock;
            if (!this.hasExtendedHeelsForWalking()) {
                this.hitsSinceAttached = 0;
                this.setHeelDirection(Direction.DOWN);
            }
            newVec = new Vec3(0.0, -0.2, 0.0);
            Vec3 newVec4 = new Vec3(0.0, -0.5, 0.0);
            newVec = RotationUtil.vecPlayerToWorld(newVec, ((IGravityEntity)this.self).roundabout$getGravityDirection());
            BlockPos pos = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec));
            newVec4 = RotationUtil.vecPlayerToWorld(newVec4, ((IGravityEntity)this.self).roundabout$getGravityDirection());
            BlockPos pos4 = BlockPos.m_274446_((Position)this.self.m_20318_(1.0f).m_82549_(newVec4));
            BlockState state1 = this.self.m_9236_().m_8055_(pos);
            BlockState state4 = this.self.m_9236_().m_8055_(pos4);
            boolean bl = isOnValidBlock = MainUtil.isBlockWalkableSimplified(state1) && MainUtil.isBlockWalkableSimplified(state4);
            if (!isOnValidBlock) {
                this.toggleSpikes(false);
            }
        }
        LivingEntity livingEntity = this.self;
        if (livingEntity instanceof Player && (PE = (Player)livingEntity).m_7500_()) {
            this.setShootTicks(0);
        } else if (this.inCombatMode()) {
            if (this.getShootTicks() < this.getMaxShootTicks()) {
                this.setShootTicks(this.getShootTicks() + this.getRaiseTicks());
            }
        } else if (this.getPauseGrowthTicks() > 0) {
            --this.pauseGrowthTicks;
        } else if (this.getShootTicks() > 0) {
            this.setShootTicks(this.getShootTicks() - this.getLowerTicks());
        }
        super.tickPower();
    }

    @Override
    public float getStepHeightAddon() {
        if (this.hasExtendedHeelsForWalking()) {
            if (this.canWallWalkConfig()) {
                return 0.4f;
            }
            return 2.0f;
        }
        if (!(this.self instanceof Player)) {
            return 3.0f;
        }
        return 0.0f;
    }

    public int getRaiseTicks() {
        return 40;
    }

    public int pauseTicks() {
        return 60;
    }

    public int getHeelExtension() {
        return this.heelExtension;
    }

    public void setHeelExtension(int extNum) {
        this.heelExtension = Mth.m_14045_((int)extNum, (int)0, (int)1000);
    }

    public int getLowerTicks() {
        return 60;
    }

    public boolean canShootSpikes(int useTicks) {
        return this.shootTicks + useTicks <= this.getMaxShootTicks();
    }

    public int getUseTicks() {
        return 1300;
    }

    @Override
    public boolean interceptGuard() {
        return this.inCombatMode();
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        this.buttonInputSpike(keyIsDown, options, true);
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        this.buttonInputSpike(keyIsDown, options, false);
    }

    public void buttonInputSpike(boolean keyIsDown, Options options, boolean rightClick) {
        if (this.currentKickTicks < PowersWalkingHeart.chargeKickTicks()) {
            return;
        }
        if (!this.consumeClickInput) {
            if (this.holdDownClick) {
                if (!keyIsDown) {
                    this.holdDownClick = false;
                }
            } else if (keyIsDown && this.inCombatMode() && !this.holdDownClick && !this.onCooldown((byte)3) && (this.getActivePower() == 0 || this.getActivePower() == 33) && this.confirmShot(this.getUseTicks())) {
                LivingEntity livingEntity = this.self;
                if (livingEntity instanceof Player) {
                    Player PE = (Player)livingEntity;
                    IPlayerEntity ipe = (IPlayerEntity)PE;
                    ipe.roundabout$getBubbleShotAim().m_216973_();
                    ipe.roundabout$setBubbleShotAimPoints(10);
                }
                if (rightClick) {
                    this.tryPower(52, true);
                } else {
                    this.tryPower(33, true);
                }
            }
        } else if (!keyIsDown) {
            this.consumeClickInput = false;
        }
    }

    public boolean confirmShot(int useTicks) {
        if (this.canShootSpikes(useTicks)) {
            this.pauseGrowthTicks = this.pauseTicks();
            this.setShootTicks(this.shootTicks + useTicks);
            return true;
        }
        return false;
    }

    public int getPauseGrowthTicks() {
        return this.pauseGrowthTicks;
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    public boolean deface() {
        StandEntity stand = this.getStandEntity(this.self);
        if (Objects.nonNull(stand)) {
            this.setAttackTimeDuring(0);
            this.setActivePower((byte)23);
            this.playStandUserOnlySoundsIfNearby((byte)105, 27.0, false, false);
            this.animateStand((byte)81);
            this.poseStand((byte)1);
            return true;
        }
        return false;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.spike_attack_mode", "instruction.roundabout.press_skill", StandIcons.SPIKE_ATTACK_MODE, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.heel_plant", "instruction.roundabout.press_skill", StandIcons.GROUND_IMPLANT, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        if (this.canWallWalkConfig()) {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.wall_walk_move", "instruction.roundabout.press_skill", StandIcons.WALL_WALK, 3, level, bypass));
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.firm_swing", "instruction.roundabout.passive", StandIcons.FIRM_SWING, 0, level, bypass));
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 0, "ability.roundabout.fall_disperse", "instruction.roundabout.passive", StandIcons.FALL_ABSORB, 0, level, bypass));
            if (this.canCornerCutConfig()) {
                $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 57, topPos + 80, 0, "ability.roundabout.corner_cut", "instruction.roundabout.press_skill", StandIcons.WALL_CUT, 4, level, bypass));
            }
        } else {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.firm_swing", "instruction.roundabout.passive", StandIcons.FIRM_SWING, 0, level, bypass));
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.fall_disperse", "instruction.roundabout.passive", StandIcons.FALL_ABSORB, 0, level, bypass));
        }
        return $$1;
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add((byte)1);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 > 1 || bypass) {
                $$1.add((byte)2);
                $$1.add((byte)3);
            }
            if (Level2 > 2 || bypass) {
                $$1.add((byte)9);
                $$1.add((byte)6);
                $$1.add((byte)4);
            }
            if (Level2 > 3 || bypass) {
                $$1.add((byte)5);
                $$1.add((byte)7);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                $$1.add((byte)8);
            }
        }
        return $$1;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return PowersWalkingHeart.getSkinNameT(skinId);
    }

    public static Component getSkinNameT(byte skinId) {
        if (skinId == 1) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.base");
        }
        if (skinId == 2) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.model");
        }
        if (skinId == 3) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.purple");
        }
        if (skinId == 4) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.verdant");
        }
        if (skinId == 5) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.pale");
        }
        if (skinId == 6) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.valentine");
        }
        if (skinId == 7) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.gothic");
        }
        if (skinId == 8) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.spider");
        }
        if (skinId == 9) {
            return Component.m_237115_((String)"skins.roundabout.walking_heart.scarecrow");
        }
        return Component.m_237115_((String)"skins.roundabout.walking_heart.base");
    }

    public static int chargeKickTicks() {
        return 9;
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.inCombatMode()) {
            Entity TE = this.getTargetEntityThroughWalls((LivingEntity)playerEntity, 7.0f, 10.0f);
            float finalATime = (float)this.currentKickTicks / (float)PowersWalkingHeart.chargeKickTicks();
            int barTexture = 0;
            if (TE != null) {
                barTexture = 18;
            }
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            int finalATimeInt = Math.round(finalATime * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, barTexture, finalATimeInt, 6);
            if (TE != null) {
                // empty if block
            }
        }
    }

    record DirDist(Direction dir, float dist) {
    }
}

