/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util.config;

import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.util.config.ConfigManager;
import net.hydra.jojomod.util.config.annotation.BooleanOption;
import net.hydra.jojomod.util.config.annotation.CommentedOption;
import net.hydra.jojomod.util.config.annotation.FloatOption;
import net.hydra.jojomod.util.config.annotation.Groups;
import net.hydra.jojomod.util.config.annotation.IntOption;
import net.hydra.jojomod.util.config.annotation.NestedOption;
import net.hydra.jojomod.util.config.annotation.StringOption;

@Groups(value={"toggles", "vanilla", "added_vanilla", "modded"})
public class ClientConfig
implements Cloneable {
    private static ClientConfig LOCAL_INSTANCE = new ClientConfig();
    private static ClientConfig DEFAULT_INSTANCE = new ClientConfig();
    @NestedOption(group="modded")
    public GeneralSettings generalSettings;
    @BooleanOption(group="inherit", value=true)
    public Boolean pressingAbilityKeysSummonsStands;
    @BooleanOption(group="inherit", value=false)
    public Boolean enablePickyIconRendering;
    @IntOption(group="inherit", value=50, min=0, max=72000)
    public Integer maxMirrorRendersAtOnceSetToZeroToDisable;
    @BooleanOption(group="inherit", value=false)
    public Boolean mirrorFlipsRendering;
    @BooleanOption(group="inherit", value=false)
    public Boolean renderGasSplatterOverlay;
    @BooleanOption(group="inherit", value=true)
    public Boolean vampireOSTChange;
    @BooleanOption(group="inherit", value=true)
    public Boolean showCreativeTextOnWorthinessArrow;
    @IntOption(group="inherit", value=190)
    public Integer justiceFogBrightness;
    @BooleanOption(group="inherit", value=true)
    public Boolean renderJusticeHandsWhilePiloting;
    @BooleanOption(group="inherit", value=true)
    public Boolean renderArmorOnPlayerCloneAbilities;
    @BooleanOption(group="inherit", value=true)
    public Boolean magiciansRedTexturesMakeItEmmissive;
    @BooleanOption(group="inherit", value=false)
    public Boolean magiciansRedLashesMakeItEmmissive;
    @BooleanOption(group="inherit", value=true)
    public Boolean magiciansRedRenderOnFireInFirstPerson;
    @BooleanOption(group="inherit", value=true)
    public Boolean mandomRewindShowsVisualEffectsToNonMandomUsers;
    @BooleanOption(group="inherit", value=true)
    public Boolean mandomRewindAttemptsToSkipInterpolation;
    @FloatOption(group="inherit", value=0.44f, min=0.0f, max=1.0f)
    public Float invisibleBlockDepthF;
    @IntOption(group="inherit", value=50, min=0, max=72000)
    public Integer invisibleBlocksDistanceAwaySeenI;
    @BooleanOption(group="inherit", value=true)
    public Boolean abilityIconHudIsAnimated;
    @IntOption(group="inherit", value=174, min=0, max=72000)
    public Integer abilityIconHudX;
    @IntOption(group="inherit", value=5, min=0, max=72000)
    public Integer abilityIconHudY;
    @BooleanOption(group="inherit", value=true)
    public Boolean enableBowlerHatRender;
    @BooleanOption(group="inherit", value=true)
    public Boolean enableFirearmRender;
    @BooleanOption(group="inherit", value=true)
    public Boolean enableRoadRollerRender;
    @NestedOption(group="modded")
    public ConfigSettings configSettings;
    @NestedOption(group="modded")
    public ParticleSettings particleSettings;
    @NestedOption(group="modded")
    public OpacitySettings opacitySettings;
    @NestedOption(group="modded")
    public DynamicSettings dynamicSettings;
    @NestedOption(group="modded")
    public VanillaMCTweaks vanillaMinecraftTweaks;
    @NestedOption(group="modded")
    public AnubisMemories anubisMemories;
    @NestedOption(group="modded")
    public TimeStopSettings timeStopSettings;

    public static ClientConfig getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public ClientConfig clone() {
        return (ClientConfig)ConfigManager.GSON.fromJson(ConfigManager.GSON.toJson((Object)this), ClientConfig.class);
    }

    public static ClientConfig getLocalInstance() {
        return LOCAL_INSTANCE;
    }

    static void updateLocal(ClientConfig config) {
        LOCAL_INSTANCE = config;
    }

    public static class AnubisMemories {
        @BooleanOption(group="inherit", value=false)
        public Boolean anubisPogoCounter;
        @StringOption(group="inherit", value="")
        public String mem1;
        @StringOption(group="inherit", value="")
        public String mem2;
        @StringOption(group="inherit", value="")
        public String mem3;
        @StringOption(group="inherit", value="")
        public String mem4;
        @StringOption(group="inherit", value="")
        public String mem5;
        @StringOption(group="inherit", value="")
        public String mem6;
        @StringOption(group="inherit", value="")
        public String mem7;
        @StringOption(group="inherit", value="")
        public String mem8;

        public void saveToMemory(int index, String id) {
            switch (index) {
                case 1: {
                    this.mem1 = id;
                    break;
                }
                case 2: {
                    this.mem2 = id;
                    break;
                }
                case 3: {
                    this.mem3 = id;
                    break;
                }
                case 4: {
                    this.mem4 = id;
                    break;
                }
                case 5: {
                    this.mem5 = id;
                    break;
                }
                case 6: {
                    this.mem6 = id;
                    break;
                }
                case 7: {
                    this.mem7 = id;
                    break;
                }
                case 8: {
                    this.mem8 = id;
                    break;
                }
                default: {
                    Roundabout.LOGGER.warn("Invalid Memory Save Id " + index);
                }
            }
        }

        public String getFromMemory(int index) {
            if (index > 0 && index < 9) {
                return switch (index) {
                    case 1 -> this.mem1;
                    case 2 -> this.mem2;
                    case 3 -> this.mem3;
                    case 4 -> this.mem4;
                    case 5 -> this.mem5;
                    case 6 -> this.mem6;
                    case 7 -> this.mem7;
                    case 8 -> this.mem8;
                    default -> this.mem1;
                };
            }
            Roundabout.LOGGER.warn("Invalid Memory Load Id " + index);
            return "";
        }
    }

    public static class TimeStopSettings {
        @BooleanOption(group="inherit", value=false)
        public Boolean timeStopFreezesScreen;
        @BooleanOption(group="inherit", value=true)
        public Boolean tsStandsSeeTSTeleportAndDontFreeze;
        @BooleanOption(group="inherit", value=true)
        public Boolean simpleTimeStopShader;
    }

    public static class VanillaMCTweaks {
        @BooleanOption(group="inherit", value=true)
        public Boolean namedSBRHorseSkins;
        @BooleanOption(group="inherit", value=false)
        public Boolean onlyStandUsersCanSeeVanillaGhostMobs;
        @BooleanOption(group="inherit", value=true)
        public Boolean disableObviousExperimentalWarning;
    }

    public static class DynamicSettings {
        @IntOption(group="inherit", value=1, min=1, max=8)
        public Integer SoftAndWetCurrentlySelectedBubble;
        @BooleanOption(group="inherit", value=false)
        public Boolean hideGUI;
        @BooleanOption(group="inherit", value=true)
        public Boolean vampireVisionMode;
    }

    public static class OpacitySettings {
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityOfStand;
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityWhileAttacking;
        @FloatOption(group="inherit", value=100.0f, min=0.0f, max=100.0f)
        public Float opacityOfOthers;
    }

    public static class ParticleSettings {
        @BooleanOption(group="inherit", value=true)
        public Boolean renderJusticeParticlesInFirstPerson;
        @BooleanOption(group="inherit", value=false)
        public Boolean renderJusticeParticlesWhilePilotingInFirstPerson;
        @IntOption(group="inherit", value=5, min=0, max=72000)
        public Integer justiceFogParticlesPerTick;
        @IntOption(group="inherit", value=3, min=0, max=72000)
        public Integer justiceSkinFlameParticlesPerTick;
        @IntOption(group="inherit", value=3, min=0, max=72000)
        public Integer cfhTicksPerFlameParticle;
        @IntOption(group="inherit", value=1, min=0, max=72000)
        public Integer bodyBagHoldingParticlesPerFiveTicks;
        @FloatOption(group="inherit", value=0.01f, min=0.0f, max=1.0f)
        public Float magiciansRedFirestormEmbersRate;
        @BooleanOption(group="inherit", value=true)
        public Boolean meteorsEmitParticles;
        @FloatOption(group="inherit", value=0.46f, min=0.0f, max=10.0f)
        public Float punchImpactSize;
        @FloatOption(group="inherit", value=0.82f, min=0.0f, max=1.0f)
        public Float punchImpactOpacity;
    }

    public static class ConfigSettings {
        @CommentedOption(comment="Offset of the Config Button (stand arrow button) in X coordinates")
        @IntOption(group="inherit", value=0, min=-1024, max=1024)
        public Integer configButtonOffsetX;
        @CommentedOption(comment="Offset of the Config Button (stand arrow button) in Y coordinates")
        @IntOption(group="inherit", value=0, min=-1024, max=1024)
        public Integer configButtonOffsetY;
        @CommentedOption(comment="Should Roundabout render the Config Button (stand arrow button) on the main menu?")
        @BooleanOption(group="inherit", value=true)
        public Boolean shouldShowConfigButton;
    }

    public static class GeneralSettings {
        @BooleanOption(group="inherit", value=true)
        public Boolean onlyStandUsersCanSeeStands;
    }
}

