/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.util.config;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.hydra.jojomod.util.config.annotation.BooleanOption;
import net.hydra.jojomod.util.config.annotation.CommentedOption;
import net.hydra.jojomod.util.config.annotation.FloatOption;
import net.hydra.jojomod.util.config.annotation.IntOption;
import net.hydra.jojomod.util.config.annotation.StringOption;

public class ConfigParser {
    public static <T> List<String> parse(T object) {
        return ConfigParser.parse(object, 0, new HashSet<Integer>());
    }

    private static <T> List<String> parse(T object, int tabLevel, Set<Integer> visited) {
        ArrayList<String> parsed = new ArrayList<String>();
        if (object == null) {
            parsed.add(ConfigParser.indent(tabLevel) + "null");
            return parsed;
        }
        int identity = System.identityHashCode(object);
        if (visited.contains(identity)) {
            parsed.add(ConfigParser.indent(tabLevel) + "\" -- circular reference -- \"");
            return parsed;
        }
        visited.add(identity);
        Class<?> clazz = object.getClass();
        parsed.add(ConfigParser.indent(tabLevel) + "{");
        Field[] fields = clazz.getFields();
        for (int fieldIndex = 0; fieldIndex < fields.length; ++fieldIndex) {
            Field field = fields[fieldIndex];
            field.setAccessible(true);
            String baseIndent = ConfigParser.indent(tabLevel + 1);
            String fieldName = field.getName();
            try {
                Object value = field.get(object);
                CommentedOption comment = field.getAnnotation(CommentedOption.class);
                if (comment != null) {
                    parsed.add(baseIndent + "/* " + comment.comment() + " */");
                }
                if (value == null) {
                    parsed.add(baseIndent + "\"" + fieldName + "\": null,");
                    continue;
                }
                Class<?> fieldType = field.getType();
                String closeNested = baseIndent + "}" + (fieldIndex == fields.length - 1 ? "" : ",");
                Object object2 = field.get(object);
                if (object2 instanceof HashSet) {
                    HashSet hashSet = (HashSet)object2;
                    parsed.add(baseIndent + "\"" + ConfigParser.toSnakeCase(fieldName) + "\": [");
                    Object[] elements = hashSet.toArray();
                    for (int objIndex = 0; objIndex < elements.length; ++objIndex) {
                        parsed.add(baseIndent + ConfigParser.indent(1) + "\"" + elements[objIndex].toString() + "\"" + (objIndex == elements.length - 1 ? "" : ","));
                    }
                    parsed.add(baseIndent + "]" + (fieldIndex == fields.length - 1 ? "" : ","));
                    continue;
                }
                if (ConfigParser.isPrimitiveLike(fieldType)) {
                    parsed.add(baseIndent + ConfigParser.getAnnotationTypeComment(field));
                    parsed.add(baseIndent + "\"" + ConfigParser.toSnakeCase(fieldName) + "\": " + ConfigParser.formatPrimitive(value) + (fieldIndex == fields.length - 1 ? "" : ","));
                    continue;
                }
                parsed.add(baseIndent + "\"" + ConfigParser.toSnakeCase(fieldName) + "\": {");
                List<String> nestedParsed = ConfigParser.parse(value, tabLevel + 1, visited);
                if (nestedParsed.size() >= 2) {
                    parsed.addAll(nestedParsed.subList(1, nestedParsed.size() - 1));
                    parsed.add(closeNested);
                    continue;
                }
                parsed.addAll(nestedParsed);
                continue;
            }
            catch (IllegalAccessException e) {
                parsed.add(baseIndent + "\"" + fieldName + "\": \" -- error accessing field -- \",");
            }
        }
        parsed.add(ConfigParser.indent(tabLevel) + "}");
        return parsed;
    }

    private static boolean isPrimitiveLike(Class<?> type) {
        return type.isPrimitive() || type == String.class || Number.class.isAssignableFrom(type) || type == Boolean.class || type == Character.class;
    }

    private static String formatPrimitive(Object value) {
        if (value instanceof String || value instanceof Character) {
            return "\"" + value.toString() + "\"";
        }
        return value.toString();
    }

    private static String indent(int level) {
        return "    ".repeat(level);
    }

    private static String getAnnotationTypeComment(Field field) {
        BooleanOption booleanOption = field.getAnnotation(BooleanOption.class);
        FloatOption floatOption = field.getAnnotation(FloatOption.class);
        IntOption intOption = field.getAnnotation(IntOption.class);
        StringOption stringOption = field.getAnnotation(StringOption.class);
        if (booleanOption == null && floatOption == null && intOption == null && stringOption == null) {
            return "/* -- error reading type info -- */";
        }
        if (stringOption != null) {
            return String.format("/* Default Value: %s */", stringOption.value());
        }
        if (booleanOption != null) {
            return String.format("/* Default Value: %s */", booleanOption.value());
        }
        if (floatOption != null) {
            return String.format("/* Minimum Value: %s | Maximum Value: %s | Default Value: %s */", Float.valueOf(floatOption.min()), Float.valueOf(floatOption.max()), Float.valueOf(floatOption.value()));
        }
        return String.format("/* Minimum Value: %s | Maximum Value: %s | Default Value: %s */", intOption.min(), intOption.max(), intOption.value());
    }

    public static String toSnakeCase(String input) {
        return input.replaceAll("([a-z])([A-Z]+)", "$1_$2").replaceAll("([A-Z])([A-Z][a-z])", "$1_$2").toLowerCase();
    }
}

