/*
 * Decompiled with CFR 0.152.
 */
package net.zetalasis.world;

import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.advancement.criteria.ModCriteria;
import net.hydra.jojomod.entity.stand.D4CEntity;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersD4C;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.dimension.LevelStem;
import net.zetalasis.networking.message.impl.IMessageEvent;
import net.zetalasis.world.DynamicWorldAccessor;
import org.jetbrains.annotations.Nullable;

public class DynamicWorld {
    private ServerLevel level;
    private final String name;
    public static HashMap<String, Level> levels = new HashMap();
    public ResourceKey<Level> LEVEL_KEY;

    public DynamicWorld(MinecraftServer server, String name, boolean broadcastPacket) {
        this.name = name;
        DynamicWorldAccessor accessor = DynamicWorldAccessor.getFrom(server);
        this.LEVEL_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)Roundabout.location(name));
        MappedRegistry<LevelStem> manager = DynamicWorld.getLevelStemRegistry(server);
        DynamicWorldAccessor managerAccessor = DynamicWorldAccessor.getFrom(manager);
        boolean isFrozen = managerAccessor.roundabout$isFrozen();
        managerAccessor.roundabout$setFrozen(false);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256862_, (ResourceLocation)this.LEVEL_KEY.m_135782_());
        if (!manager.m_142003_(key)) {
            manager.m_255290_(key, (Object)new LevelStem(server.m_129783_().m_6018_().m_204156_(), server.m_129783_().m_7726_().m_8481_()), Lifecycle.stable());
        }
        managerAccessor.roundabout$setFrozen(isFrozen);
        this.level = new ServerLevel(server, accessor.roundabout$getExecutor(), accessor.roundabout$getLevelStorageAccess(), accessor.roundabout$getLevelData(), this.LEVEL_KEY, accessor.roundabout$getLevelStem(), accessor.roundabout$getProgressListener(), false, accessor.roundabout$getObfuscatedSeed(), new ArrayList(), false, null);
        server.m_129783_().m_6857_().m_61929_((BorderChangeListener)new BorderChangeListener.DelegateBorderChangeListener(this.level.m_6857_()));
        accessor.roundabout$addWorld(this.LEVEL_KEY, this.level);
        this.level.m_8793_(() -> true);
        levels.put(name, (Level)this.level);
        if (broadcastPacket) {
            this.broadcastPacketsToPlayers(server);
        }
    }

    public void broadcastPacketsToPlayers(MinecraftServer server) {
        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
            S2CPacketUtil.sendNewDyanmicWorldPacket((Player)sp, this.name);
        }
    }

    public ServerLevel getLevel() {
        return this.level;
    }

    public String getName() {
        return this.name;
    }

    private static MappedRegistry<LevelStem> getLevelStemRegistry(MinecraftServer server) {
        RegistryAccess.Frozen registryManager = server.m_206579_();
        Registry temp = registryManager.m_175515_(Registries.f_256862_);
        return (MappedRegistry)temp;
    }

    public static void deregisterWorld(MinecraftServer server, String name) {
    }

    private static String generateRandomStringByWords(int numWords) {
        String[] words = new String[]{"boat", "ship", "airplane", "sword", "car", "train", "bike", "rocket", "submarine", "zeppelin", "spiral-staircase", "desolation-row", "fig-tart", "rhinoceros-beetle", "singularity-point", "giotto", "angel", "hydrangea", "secret-emperor"};
        Random random = new Random();
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < numWords; ++i) {
            if (i > 0) {
                result.append("-");
            }
            result.append(words[random.nextInt(words.length)]);
        }
        return result.toString();
    }

    public static DynamicWorld generateD4CWorld(MinecraftServer server) {
        return new DynamicWorld(server, "d4c-" + DynamicWorld.generateRandomStringByWords(7) + "-" + server.m_129783_().m_213780_().m_216332_(0, 999999), false);
    }

    public static void loadDynamicWorlds(MinecraftServer server) {
        for (ServerLevel level : server.m_129785_()) {
            if (!level.m_46472_().m_135782_().m_135827_().equals("roundabout")) continue;
            levels.put(level.m_46472_().m_135782_().m_135815_(), (Level)level);
        }
    }

    public static boolean isWorldDynamic(Level level) {
        return levels.containsValue(level);
    }

    public static class DynamicWorldNetMessages
    implements IMessageEvent {
        @Override
        public void INVOKE(String message, @Nullable ServerPlayer sender, Object ... vargs) {
            if (message.equals(MESSAGES.ADD_WORLD.value)) {
                if (sender == null) {
                    throw new RuntimeException("\"sender\" was null on a C2S packet!");
                }
                MinecraftServer server = sender.f_8924_;
                server.execute(() -> {
                    DynamicWorld world;
                    if (((StandUser)sender).roundabout$getStand() instanceof D4CEntity && (world = PowersD4C.queuedWorldTransports.remove(sender.m_19879_())) != null && world.getLevel() != null) {
                        sender.m_8999_(world.getLevel(), sender.m_20185_(), sender.m_20186_(), sender.m_20189_(), sender.m_146908_(), sender.m_146909_());
                        ((StandUser)sender).roundabout$summonStand((Level)world.getLevel(), true, false);
                        ModCriteria.DIMENSION_HOP_TRIGGER.trigger(sender);
                    }
                });
            }
        }

        public static enum MESSAGES {
            ADD_WORLD("thread_hop_add_world"),
            REMOVE_WORLD("thread_hop_remove_world");

            public final String value;

            private MESSAGES(String value) {
                this.value = value;
            }
        }
    }
}

