/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import net.hydra.jojomod.block.BubbleScaffoldBlockEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.projectile.SoftAndWetPlunderBubbleEntity;
import net.hydra.jojomod.event.powers.TimeStop;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BubbleScaffoldBlockEntityRenderer
implements BlockEntityRenderer<BubbleScaffoldBlockEntity> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("roundabout", "textures/stand/soft_and_wet/projectiles/bubble_plunder.png");
    private static final ResourceLocation HEART_ATTACK_MINI = new ResourceLocation("roundabout", "textures/particle/heart_attack_mini.png");
    private final float scale;
    public int bubbleCount = 7;

    public BubbleScaffoldBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.scale = 0.55f;
    }

    public void render(BubbleScaffoldBlockEntity bubbleScaffoldBlockEntity, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        if (bubbleScaffoldBlockEntity.bubbleList == null) {
            bubbleScaffoldBlockEntity.bubbleList = new ArrayList<Vec3>();
        }
        if (bubbleScaffoldBlockEntity.bubbleList.isEmpty()) {
            for (int i = 0; i < this.bubbleCount; ++i) {
                bubbleScaffoldBlockEntity.bubbleList.add(new Vec3(Math.random() * 0.8 + (double)0.1f, Math.random() * 0.6 + 0.5, Math.random() * 0.8 + (double)0.1f));
            }
        }
        if (ClientUtil.canSeeStands(ClientUtil.getPlayer())) {
            if (((TimeStop)bubbleScaffoldBlockEntity.m_58904_()).inTimeStopRange((Vec3i)bubbleScaffoldBlockEntity.m_58899_())) {
                partialTick = 0.0f;
            }
            for (Vec3 value : bubbleScaffoldBlockEntity.bubbleList) {
                ClientUtil.pushPoseAndCooperate(poseStack, 6);
                poseStack.m_85837_(value.f_82479_, value.f_82480_, value.f_82481_);
                poseStack.m_85841_(this.scale, this.scale, this.scale);
                poseStack.m_252781_(Minecraft.m_91087_().m_91290_().m_253208_());
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252880_(0.0f, SoftAndWetPlunderBubbleEntity.eHeight / 2.0f, 0.0f);
                VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getBubbleTextureLocation(bubbleScaffoldBlockEntity)));
                Matrix4f matrix = poseStack.m_85850_().m_252922_();
                Vector3f normal = Minecraft.m_91087_().f_91063_.m_109153_().m_253058_();
                normal.normalize();
                Vector3f coursecorrect = new Vector3f(0.577f, 0.577f, 0.577f);
                if (normal.y > 0.0f) {
                    coursecorrect = new Vector3f(0.01f, 1.0f, 0.01f);
                    if ((double)normal.y > 0.95) {
                        coursecorrect = new Vector3f(-0.577f, -0.577f, -0.577f);
                    }
                }
                float scaleIt = 0.23f;
                float size = (float)Math.min((double)scaleIt, (double)((float)bubbleScaffoldBlockEntity.getTickCount() + partialTick) * ((double)scaleIt * 0.1));
                vertexConsumer.m_252986_(matrix, -size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
                vertexConsumer.m_252986_(matrix, size, -size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
                vertexConsumer.m_252986_(matrix, size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
                vertexConsumer.m_252986_(matrix, -size, size, 0.0f).m_6122_(255, 255, 255, 255).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_5601_(coursecorrect.x, coursecorrect.y, coursecorrect.z).m_5752_();
                ClientUtil.popPoseAndCooperate(poseStack, 6);
            }
        }
    }

    public ResourceLocation getBubbleTextureLocation(BubbleScaffoldBlockEntity bubbleScaffoldBlockEntity) {
        BlockState bs = bubbleScaffoldBlockEntity.m_58900_();
        if (bs.m_61138_((Property)BlockStateProperties.f_61360_) && ((Boolean)bs.m_61143_((Property)BlockStateProperties.f_61360_)).booleanValue()) {
            return HEART_ATTACK_MINI;
        }
        return TEXTURE;
    }
}

