/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.block;

import net.hydra.jojomod.access.IPermaCasting;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.block.StandFireBlock;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.event.ModGamerules;
import net.hydra.jojomod.event.PermanentZoneCastInstance;
import net.hydra.jojomod.event.index.StandFireType;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.stand.powers.PowersMagiciansRed;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class StandFireBlockEntity
extends BlockEntity {
    int ticksStored = 0;
    int nextTarget = 0;
    int iterated = 0;
    int hardcap = 1200;
    public byte fireColorType;
    public int snapNumber;
    public int fireIDNumber;
    public LivingEntity standUser;

    public StandFireBlockEntity(BlockPos $$0, BlockState $$1) {
        super(ModBlocks.STAND_FIRE_BLOCK_ENTITY, $$0, $$1);
        this.fireColorType = StandFireType.ORANGE.id;
        this.snapNumber = 0;
        this.fireIDNumber = 0;
        this.standUser = null;
    }

    public StandFireBlockEntity(BlockEntityType<?> $$0, BlockPos $$1, BlockState $$2) {
        super($$0, $$1, $$2);
        this.fireColorType = StandFireType.ORANGE.id;
        this.snapNumber = 0;
        this.fireIDNumber = 0;
        this.standUser = null;
    }

    public static void tickFire(Level lvl, BlockPos bp, BlockState bs, StandFireBlockEntity sf) {
        sf.tick(bs, lvl, bp, sf, lvl.m_213780_());
    }

    public byte getFireColorType(BlockState $$0) {
        return ((Integer)$$0.m_61143_((Property)StandFireBlock.COLOR)).byteValue();
    }

    public void rollNextTarget(Level $$1, BlockPos $$2) {
        int mult = 20;
        int base = 20;
        if (((IPermaCasting)$$1).roundabout$inPermaCastRange((Vec3i)$$2, PermanentZoneCastInstance.FIRESTORM)) {
            mult = 10;
            base = 10;
        }
        this.nextTarget = (int)((long)base + Math.round(Math.random() * (double)mult));
    }

    public void tick(BlockState $$0, Level $$1, BlockPos $$2, StandFireBlockEntity sf, RandomSource $$3) {
        Block block;
        if (!$$1.m_5776_() && (block = $$0.m_60734_()) instanceof StandFireBlock) {
            StandFireBlock fb = (StandFireBlock)block;
            BlockState $$4 = $$1.m_8055_($$2.m_7495_());
            boolean $$5 = $$4.m_204336_($$1.m_6042_().f_63836_());
            if (!$$5 && $$1.m_46471_() && fb.isNearRain($$1, $$2)) {
                $$1.m_7471_($$2, false);
                return;
            }
            if (this.nextTarget == 0) {
                this.rollNextTarget($$1, $$2);
            }
            ++this.ticksStored;
            if (this.iterated >= this.hardcap) {
                $$1.m_7471_($$2, false);
                return;
            }
            if (this.standUser != null && this.standUser.m_6084_() && !this.standUser.m_213877_()) {
                StandPowers standPowers = ((StandUser)this.standUser).roundabout$getStandPowers();
                if (standPowers instanceof PowersMagiciansRed) {
                    PowersMagiciansRed PM = (PowersMagiciansRed)standPowers;
                    int maxFlames = ClientNetworking.getAppropriateConfig().magiciansRedSettings.maxMagiciansRedFlames;
                    int maxDist = ClientNetworking.getAppropriateConfig().magiciansRedSettings.maxMagiciansRedFlameDistance;
                    if (PM.snapNumber != this.snapNumber) {
                        $$1.m_7471_($$2, false);
                        return;
                    }
                    if (maxFlames >= 0 && PM.fireIDNumber - this.fireIDNumber > maxFlames) {
                        $$1.m_7471_($$2, false);
                        return;
                    }
                    if (maxFlames >= 0 && MainUtil.cheapDistanceTo2((double)$$2.m_123341_(), (double)$$2.m_123343_(), this.standUser.m_20185_(), this.standUser.m_20189_()) > (double)maxDist) {
                        $$1.m_7471_($$2, false);
                        return;
                    }
                } else {
                    this.standUser = null;
                }
            } else {
                $$1.m_7471_($$2, false);
                return;
            }
            BlockPos below = $$2.m_7495_();
            BlockState checkGas = $$1.m_8055_(below);
            if (checkGas.m_60713_(ModBlocks.GASOLINE_SPLATTER)) {
                $$1.m_7471_($$2, false);
                $$1.m_7471_(below, false);
                ((ServerLevel)$$1).m_8767_((ParticleOptions)ParticleTypes.f_123744_, (double)below.m_123341_(), (double)below.m_123342_(), (double)below.m_123343_(), 40, 0.0, 0.2, 0.0, 0.2);
                ((ServerLevel)$$1).m_8767_((ParticleOptions)ParticleTypes.f_123813_, (double)below.m_123341_(), (double)below.m_123342_(), (double)below.m_123343_(), 1, 0.5, 0.5, 0.5, 0.2);
                MainUtil.gasExplode(null, (ServerLevel)$$1, below, 0, 2, 4, MainUtil.gasDamageMultiplier() * 10.0f);
                return;
            }
            if (this.ticksStored >= this.nextTarget) {
                this.ticksStored = 0;
                this.rollNextTarget($$1, $$2);
                if ($$1.m_46469_().m_46207_(GameRules.f_46131_) && $$1.m_46469_().m_46207_(ModGamerules.ROUNDABOUT_STAND_GRIEFING) && (this.standUser instanceof Player || $$1.m_46469_().m_46207_(ModGamerules.ROUNDABOUT_MOB_STAND_FIRE_SPREADS) && this.standUser instanceof Monster) && (!(this.standUser instanceof Player) || ((ServerPlayer)this.standUser).f_8941_.m_9290_() != GameType.ADVENTURE)) {
                    if (!$$0.m_60710_((LevelReader)$$1, $$2)) {
                        $$1.m_7471_($$2, false);
                        return;
                    }
                    if ($$0.m_60713_(ModBlocks.STAND_FIRE)) {
                        int $$6 = (Integer)$$0.m_61143_((Property)StandFireBlock.AGE);
                        int color = (Integer)$$0.m_61143_((Property)StandFireBlock.COLOR);
                        if (!$$5 && $$1.m_46471_() && fb.isNearRain($$1, $$2) && $$3.m_188501_() < 0.2f + (float)$$6 * 0.03f) {
                            $$1.m_7471_($$2, false);
                        } else {
                            boolean $$9;
                            int $$7 = Math.min(15, $$6 + $$3.m_188503_(3) / 2);
                            if ($$6 != $$7) {
                                ++this.iterated;
                                if (this.standUser == null) {
                                    $$0 = (BlockState)((BlockState)$$0.m_61124_((Property)StandFireBlock.AGE, (Comparable)Integer.valueOf($$7))).m_61124_((Property)StandFireBlock.COLOR, (Comparable)Integer.valueOf(color));
                                    $$1.m_46597_($$2, $$0);
                                }
                            }
                            if (!$$5) {
                                if (!fb.isValidFireLocation((BlockGetter)$$1, $$2)) {
                                    BlockPos $$8 = $$2.m_7495_();
                                    if (!$$1.m_8055_($$8).m_60783_((BlockGetter)$$1, $$8, Direction.UP) || $$6 > 3) {
                                        $$1.m_7471_($$2, false);
                                    }
                                    return;
                                }
                                if ($$6 == 15 && $$3.m_188503_(4) == 0 && !fb.canBurn($$1.m_8055_($$2.m_7495_()))) {
                                    $$1.m_7471_($$2, false);
                                    return;
                                }
                            }
                            int $$10 = ($$9 = $$1.m_204166_($$2).m_203656_(BiomeTags.f_263839_)) ? -50 : 0;
                            fb.checkBurnOut($$1, $$2.m_122029_(), 300 + $$10, $$3, $$6, this);
                            fb.checkBurnOut($$1, $$2.m_122024_(), 300 + $$10, $$3, $$6, this);
                            fb.checkBurnOut($$1, $$2.m_7495_(), 250 + $$10, $$3, $$6, this);
                            fb.checkBurnOut($$1, $$2.m_7494_(), 250 + $$10, $$3, $$6, this);
                            fb.checkBurnOut($$1, $$2.m_122012_(), 300 + $$10, $$3, $$6, this);
                            fb.checkBurnOut($$1, $$2.m_122019_(), 300 + $$10, $$3, $$6, this);
                            BlockPos.MutableBlockPos $$11 = new BlockPos.MutableBlockPos();
                            for (int $$12 = -1; $$12 <= 1; ++$$12) {
                                for (int $$13 = -1; $$13 <= 1; ++$$13) {
                                    for (int $$14 = -1; $$14 <= 4; ++$$14) {
                                        BlockEntity be;
                                        StandPowers standPowers;
                                        if ($$12 == 0 && $$14 == 0 && $$13 == 0) continue;
                                        int $$15 = 100;
                                        if ($$14 > 1) {
                                            $$15 += ($$14 - 1) * 100;
                                        }
                                        $$11.m_122154_((Vec3i)$$2, $$12, $$14, $$13);
                                        int $$16 = fb.getIgniteOdds((LevelReader)$$1, (BlockPos)$$11);
                                        if ($$16 <= 0) continue;
                                        int $$17 = ($$16 + 40 + $$1.m_46791_().m_19028_() * 7) / ($$6 + 30);
                                        if ($$9) {
                                            $$17 /= 2;
                                        }
                                        if (this.standUser == null || !((standPowers = ((StandUser)this.standUser).roundabout$getStandPowers()) instanceof PowersMagiciansRed)) continue;
                                        PowersMagiciansRed PM = (PowersMagiciansRed)standPowers;
                                        if ($$17 <= 0 || $$3.m_188503_($$15) > $$17 || $$1.m_46471_() && fb.isNearRain($$1, (BlockPos)$$11)) continue;
                                        int $$18 = Math.min(15, $$6 + $$3.m_188503_(5) / 4);
                                        BlockState bs = fb.getStateWithAge((LevelAccessor)$$1, (BlockPos)$$11, $$18);
                                        if (bs.m_60713_(ModBlocks.STAND_FIRE)) {
                                            $$1.m_46597_((BlockPos)$$11, (BlockState)bs.m_61124_((Property)StandFireBlock.COLOR, (Comparable)Integer.valueOf(color)));
                                        }
                                        if (!((be = this.f_58857_.m_7702_((BlockPos)$$11)) instanceof StandFireBlockEntity)) continue;
                                        StandFireBlockEntity sfbe = (StandFireBlockEntity)be;
                                        sfbe.snapNumber = this.snapNumber;
                                        sfbe.standUser = this.standUser;
                                        sfbe.fireColorType = this.fireColorType;
                                        sfbe.fireIDNumber = PM.getNewFireId();
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
    }
}

