/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.layers;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientPlatform;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.models.visages.PlayerLikeModel;
import net.hydra.jojomod.entity.visages.JojoNPC;
import net.hydra.jojomod.event.index.ShapeShifts;
import net.hydra.jojomod.event.powers.StandUserClient;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.item.MaskItem;
import net.hydra.jojomod.networking.ModPacketHandler;
import net.hydra.jojomod.util.config.ConfigManager;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Unique;

public class HumanoidLikeArmorLayer<T extends JojoNPC, M extends PlayerLikeModel<T>, A extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final A innerModel;
    private final A outerModel;
    private final TextureAtlas armorTrimAtlas;
    @Unique
    public int roundabout$ArmorPhase;
    @Unique
    public boolean roundabout$ModifyEntity;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderChest;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderLegs;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderBoots;
    @Unique
    @Nullable
    public ItemStack roundabout$RenderHead;

    public HumanoidLikeArmorLayer(RenderLayerParent<T, M> $$0, A $$1, A $$2, ModelManager $$3) {
        super($$0);
        this.innerModel = $$1;
        this.outerModel = $$2;
        this.armorTrimAtlas = $$3.m_119428_(Sheets.f_265912_);
    }

    public void render(PoseStack $$0, MultiBufferSource $$1, int $$2, T $$3, float $$4, float $$5, float $$6, float $$7, float $$8, float $$9) {
        this.roundabout$ArmorPhase = 0;
        if (((JojoNPC)((Object)$$3)).host != null) {
            Item item;
            IPlayerEntity ipe = (IPlayerEntity)((JojoNPC)((Object)$$3)).host;
            if (ShapeShifts.getShiftFromByte(ipe.roundabout$getShapeShift()) == ShapeShifts.EERIE) {
                return;
            }
            StandUserClient userclient = (StandUserClient)$$3;
            boolean bl = this.roundabout$ModifyEntity = ((TimeStop)$$3.m_9236_()).CanTimeStopEntity((Entity)$$3) || ClientUtil.getScreenFreeze();
            if (this.roundabout$ModifyEntity) {
                if (userclient.roundabout$getRoundaboutRenderChest() == null) {
                    userclient.roundabout$setRoundaboutRenderChest($$3.m_6844_(EquipmentSlot.CHEST).m_41777_());
                }
                if (userclient.roundabout$getRoundaboutRenderLegs() == null) {
                    userclient.roundabout$setRoundaboutRenderLegs($$3.m_6844_(EquipmentSlot.LEGS).m_41777_());
                }
                if (userclient.roundabout$getRoundaboutRenderBoots() == null) {
                    userclient.roundabout$setRoundaboutRenderBoots($$3.m_6844_(EquipmentSlot.FEET).m_41777_());
                }
                if (userclient.roundabout$getRoundaboutRenderHead() == null) {
                    userclient.roundabout$setRoundaboutRenderHead($$3.m_6844_(EquipmentSlot.HEAD).m_41777_());
                }
                this.roundabout$RenderChest = userclient.roundabout$getRoundaboutRenderChest();
                this.roundabout$RenderLegs = userclient.roundabout$getRoundaboutRenderLegs();
                this.roundabout$RenderBoots = userclient.roundabout$getRoundaboutRenderBoots();
                this.roundabout$RenderHead = userclient.roundabout$getRoundaboutRenderHead();
            } else {
                if (userclient.roundabout$getRoundaboutRenderChest() != null) {
                    userclient.roundabout$setRoundaboutRenderChest(null);
                }
                if (userclient.roundabout$getRoundaboutRenderLegs() != null) {
                    userclient.roundabout$setRoundaboutRenderLegs(null);
                }
                if (userclient.roundabout$getRoundaboutRenderBoots() != null) {
                    userclient.roundabout$setRoundaboutRenderBoots(null);
                }
                if (userclient.roundabout$getRoundaboutRenderHead() != null) {
                    userclient.roundabout$setRoundaboutRenderHead(null);
                }
            }
            if (!((IPlayerEntity)((JojoNPC)((Object)$$3)).host).roundabout$getMaskSlot().m_41619_() && (item = ((IPlayerEntity)((JojoNPC)((Object)$$3)).host).roundabout$getMaskSlot().m_41720_()) instanceof MaskItem) {
                MaskItem ME = (MaskItem)item;
                if (!ME.visageData.rendersArmor()) {
                    return;
                }
            }
        } else {
            this.roundabout$ModifyEntity = false;
        }
        if (ConfigManager.getClientConfig().renderArmorOnPlayerCloneAbilities.booleanValue()) {
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.CHEST, $$2, this.getArmorModel(EquipmentSlot.CHEST));
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.LEGS, $$2, this.getArmorModel(EquipmentSlot.LEGS));
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.FEET, $$2, this.getArmorModel(EquipmentSlot.FEET));
            this.renderArmorPiece($$0, $$1, $$3, EquipmentSlot.HEAD, $$2, this.getArmorModel(EquipmentSlot.HEAD));
        }
    }

    private void renderArmorPiece(PoseStack $$0, MultiBufferSource $$1, T entity, EquipmentSlot slot, int $$4, A model) {
        ArmorItem armorItem;
        ItemStack itemStack = this.store(entity.m_6844_(slot));
        Item item = itemStack.m_41720_();
        if (item instanceof ArmorItem && (armorItem = (ArmorItem)item).m_40402_() == slot) {
            ((PlayerLikeModel)this.m_117386_()).copyPropertiesTo2(model);
            this.setPartVisibility(model, slot);
            Model model2 = ClientPlatform.PLATFORM_ACCESS_CLIENT.getArmorModelHook(entity, itemStack, slot, model);
            Object usethis = model;
            if (model2 != null) {
                usethis = model2;
            }
            boolean flag = this.usesInnerModel(slot);
            if (Objects.equals(ModPacketHandler.PLATFORM_ACCESS.getPlatformName(), "Forge") && armorItem instanceof DyeableLeatherItem) {
                int i = ((DyeableLeatherItem)armorItem).m_41121_(itemStack);
                float f = (float)(i >> 16 & 0xFF) / 255.0f;
                float f1 = (float)(i >> 8 & 0xFF) / 255.0f;
                float f2 = (float)(i & 0xFF) / 255.0f;
                this.renderModel($$0, $$1, $$4, armorItem, (Model)usethis, flag, f, f1, f2, null, (Entity)entity, itemStack, slot);
            } else if (armorItem instanceof DyeableArmorItem) {
                DyeableArmorItem $$10 = (DyeableArmorItem)armorItem;
                int $$11 = $$10.m_41121_(itemStack);
                float $$12 = (float)($$11 >> 16 & 0xFF) / 255.0f;
                float $$13 = (float)($$11 >> 8 & 0xFF) / 255.0f;
                float $$14 = (float)($$11 & 0xFF) / 255.0f;
                this.renderModel($$0, $$1, $$4, armorItem, (Model)usethis, flag, $$12, $$13, $$14, null, (Entity)entity, itemStack, slot);
                this.renderModel($$0, $$1, $$4, armorItem, (Model)usethis, flag, 1.0f, 1.0f, 1.0f, "overlay", (Entity)entity, itemStack, slot);
            } else {
                this.renderModel($$0, $$1, $$4, armorItem, (Model)usethis, flag, 1.0f, 1.0f, 1.0f, null, (Entity)entity, itemStack, slot);
            }
            ArmorTrim.m_266285_((RegistryAccess)entity.m_9236_().m_9598_(), (ItemStack)itemStack).ifPresent($$6x -> this.renderTrim(armorItem.m_40401_(), $$0, $$1, $$4, (ArmorTrim)$$6x, model, flag));
            if (itemStack.m_41790_()) {
                this.renderGlint($$0, $$1, $$4, model);
            }
        }
    }

    public ItemStack store(ItemStack stack) {
        if (this.roundabout$ModifyEntity) {
            ++this.roundabout$ArmorPhase;
            if (this.roundabout$ArmorPhase == 1) {
                if (this.roundabout$RenderChest != null) {
                    return this.roundabout$RenderChest;
                }
            } else if (this.roundabout$ArmorPhase == 2) {
                if (this.roundabout$RenderLegs != null) {
                    return this.roundabout$RenderLegs;
                }
            } else if (this.roundabout$ArmorPhase == 3) {
                if (this.roundabout$RenderBoots != null) {
                    return this.roundabout$RenderBoots;
                }
            } else if (this.roundabout$RenderHead != null) {
                return this.roundabout$RenderHead;
            }
            return stack;
        }
        return stack;
    }

    protected void setPartVisibility(A $$0, EquipmentSlot $$1) {
        $$0.m_8009_(false);
        switch ($$1) {
            case HEAD: {
                ((HumanoidModel)$$0).f_102808_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                ((HumanoidModel)$$0).f_102810_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102811_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                ((HumanoidModel)$$0).f_102810_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102813_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                ((HumanoidModel)$$0).f_102813_.f_104207_ = true;
                ((HumanoidModel)$$0).f_102814_.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack $$0, MultiBufferSource $$1, int $$2, ArmorItem $$3, Model $$4, boolean $$5, float $$6, float $$7, float $$8, @javax.annotation.Nullable String $$9, Entity ent, ItemStack stack, EquipmentSlot slot) {
        if (Objects.equals(ModPacketHandler.PLATFORM_ACCESS.getPlatformName(), "Forge")) {
            ResourceLocation rl = this.getArmorResource(ent, stack, slot, $$9);
            if (rl != null) {
                this.renderModel($$0, $$1, $$2, $$3, $$4, $$5, $$6, $$7, $$8, rl);
            } else {
                VertexConsumer $$10 = $$1.m_6299_(RenderType.m_110431_((ResourceLocation)this.getArmorLocation($$3, $$5, $$9)));
                $$4.m_7695_($$0, $$10, $$2, OverlayTexture.f_118083_, $$6, $$7, $$8, 1.0f);
            }
        } else {
            VertexConsumer $$10 = $$1.m_6299_(RenderType.m_110431_((ResourceLocation)this.getArmorLocation($$3, $$5, $$9)));
            $$4.m_7695_($$0, $$10, $$2, OverlayTexture.f_118083_, $$6, $$7, $$8, 1.0f);
        }
    }

    private void renderModel(PoseStack p_289664_, MultiBufferSource p_289689_, int p_289681_, ArmorItem p_289650_, Model p_289658_, boolean p_289668_, float p_289678_, float p_289674_, float p_289693_, ResourceLocation armorResource) {
        VertexConsumer vertexconsumer = p_289689_.m_6299_(RenderType.m_110431_((ResourceLocation)armorResource));
        p_289658_.m_7695_(p_289664_, vertexconsumer, p_289681_, OverlayTexture.f_118083_, p_289678_, p_289674_, p_289693_, 1.0f);
    }

    private void renderTrim(ArmorMaterial $$0, PoseStack $$1, MultiBufferSource $$2, int $$3, ArmorTrim $$4, A $$5, boolean $$6) {
        TextureAtlasSprite $$7 = this.armorTrimAtlas.m_118316_($$6 ? $$4.m_267774_($$0) : $$4.m_267606_($$0));
        VertexConsumer $$8 = $$7.m_118381_($$2.m_6299_(Sheets.m_266442_()));
        $$5.m_7695_($$1, $$8, $$3, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderGlint(PoseStack $$0, MultiBufferSource $$1, int $$2, A $$3) {
        $$3.m_7695_($$0, $$1.m_6299_(RenderType.m_110484_()), $$2, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private A getArmorModel(EquipmentSlot $$0) {
        return this.usesInnerModel($$0) ? this.innerModel : this.outerModel;
    }

    private boolean usesInnerModel(EquipmentSlot $$0) {
        return $$0 == EquipmentSlot.LEGS;
    }

    private ResourceLocation getArmorLocation(ArmorItem $$0, boolean $$1, @javax.annotation.Nullable String $$2) {
        String $$3 = "textures/models/armor/" + $$0.m_40401_().m_6082_() + "_layer_" + ($$1 ? 2 : 1) + (String)($$2 == null ? "" : "_" + $$2) + ".png";
        return ARMOR_LOCATION_CACHE.computeIfAbsent($$3, ResourceLocation::new);
    }

    public ResourceLocation getArmorResource(Entity entity, ItemStack stack, EquipmentSlot slot, @javax.annotation.Nullable String type) {
        ArmorItem item = (ArmorItem)stack.m_41720_();
        String texture = item.m_40401_().m_6082_();
        String domain = "minecraft";
        int idx = texture.indexOf(58);
        if (idx != -1) {
            domain = texture.substring(0, idx);
            texture = texture.substring(idx + 1);
        }
        String s1 = String.format(Locale.ROOT, "%s:textures/models/armor/%s_layer_%d%s.png", domain, texture, this.usesInnerModel(slot) ? 2 : 1, type == null ? "" : String.format(Locale.ROOT, "_%s", type));
        ResourceLocation resourcelocation = ARMOR_LOCATION_CACHE.get(s1 = ClientPlatform.PLATFORM_ACCESS_CLIENT.getArmorTexture(entity, stack, s1, slot, type));
        if (resourcelocation == null && s1 != null) {
            resourcelocation = new ResourceLocation(s1);
            ARMOR_LOCATION_CACHE.put(s1, resourcelocation);
        }
        return resourcelocation;
    }
}

