/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.paintings;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.hydra.jojomod.entity.paintings.RoundaboutPainting;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockAndTintGetter;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class CustomPaintingRenderer
extends EntityRenderer<RoundaboutPainting> {
    private static final ResourceLocation PAINTING_BACK = new ResourceLocation("minecraft", "textures/entity/painting/back.png");

    public CustomPaintingRenderer(EntityRendererProvider.Context $$0) {
        super($$0);
    }

    public void render(RoundaboutPainting painting, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource source, int light) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yaw));
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        this.renderPainting(poseStack, this.getTexture(), this.getTextureBack(), painting, this.getWidth(), this.getHeight(), source);
        poseStack.m_85849_();
        super.m_7392_((Entity)painting, yaw, partialTicks, poseStack, source, light);
    }

    public int getWidth() {
        return 16;
    }

    public int getHeight() {
        return 32;
    }

    public ResourceLocation getTexture() {
        return new ResourceLocation("roundabout", "textures/entity/painting/van_gogh.png");
    }

    public ResourceLocation getTextureBack() {
        return new ResourceLocation("roundabout", "textures/entity/painting/back.png");
    }

    public ResourceLocation getTextureLocation(RoundaboutPainting $$0) {
        return this.getTextureBack();
    }

    private void renderPainting(PoseStack stack, ResourceLocation frontBuffer, ResourceLocation backBuffer, RoundaboutPainting painting, int width, int height, MultiBufferSource source) {
        PoseStack.Pose last = stack.m_85850_();
        Matrix4f pose = last.m_252922_();
        Matrix3f normal = last.m_252943_();
        float x0 = (float)(-width) / 2.0f;
        float y0 = (float)(-height) / 2.0f;
        int tilesX = width / 16;
        int tilesY = height / 16;
        double uStep = 1.0 / (double)tilesX;
        double vStep = 1.0 / (double)tilesY;
        for (int tx = 0; tx < tilesX; ++tx) {
            for (int ty = 0; ty < tilesY; ++ty) {
                float x1 = x0 + (float)((tx + 1) * 16);
                float x2 = x0 + (float)(tx * 16);
                float y1 = y0 + (float)((ty + 1) * 16);
                float y2 = y0 + (float)(ty * 16);
                int blockX = painting.m_146903_();
                int blockY = Mth.m_14107_((double)(painting.m_20186_() + (double)((y1 + y2) / 2.0f / 16.0f)));
                int blockZ = painting.m_146907_();
                Direction dir = painting.m_6350_();
                if (dir == Direction.NORTH) {
                    blockX = Mth.m_14107_((double)(painting.m_20185_() + (double)((x1 + x2) / 2.0f / 16.0f)));
                }
                if (dir == Direction.WEST) {
                    blockZ = Mth.m_14107_((double)(painting.m_20189_() - (double)((x1 + x2) / 2.0f / 16.0f)));
                }
                if (dir == Direction.SOUTH) {
                    blockX = Mth.m_14107_((double)(painting.m_20185_() - (double)((x1 + x2) / 2.0f / 16.0f)));
                }
                if (dir == Direction.EAST) {
                    blockZ = Mth.m_14107_((double)(painting.m_20189_() + (double)((x1 + x2) / 2.0f / 16.0f)));
                }
                int light = LevelRenderer.m_109541_((BlockAndTintGetter)painting.m_9236_(), (BlockPos)new BlockPos(blockX, blockY, blockZ));
                VertexConsumer frontBuffer2 = source.m_6299_(RenderType.m_110446_((ResourceLocation)frontBuffer));
                float u0 = (float)(uStep * (double)(tilesX - tx));
                float u1 = (float)(uStep * (double)(tilesX - (tx + 1)));
                float v0 = (float)(vStep * (double)(tilesY - ty));
                float v1 = (float)(vStep * (double)(tilesY - (ty + 1)));
                this.vertex(pose, normal, frontBuffer2, x1, y2, u1, v0, -0.5f, 0, 0, -1, light);
                this.vertex(pose, normal, frontBuffer2, x2, y2, u0, v0, -0.5f, 0, 0, -1, light);
                this.vertex(pose, normal, frontBuffer2, x2, y1, u0, v1, -0.5f, 0, 0, -1, light);
                this.vertex(pose, normal, frontBuffer2, x1, y1, u1, v1, -0.5f, 0, 0, -1, light);
                VertexConsumer backBuffer2 = source.m_6299_(RenderType.m_110446_((ResourceLocation)backBuffer));
                u0 = 0.0f;
                u1 = 1.0f;
                v0 = 0.0f;
                v1 = 1.0f;
                this.vertex(pose, normal, backBuffer2, x1, y1, u1, v0, 0.5f, 0, 0, 1, light);
                this.vertex(pose, normal, backBuffer2, x2, y1, u0, v0, 0.5f, 0, 0, 1, light);
                this.vertex(pose, normal, backBuffer2, x2, y2, u0, v1, 0.5f, 0, 0, 1, light);
                this.vertex(pose, normal, backBuffer2, x1, y2, u1, v1, 0.5f, 0, 0, 1, light);
                VertexConsumer edgeBuffer = source.m_6299_(RenderType.m_110446_((ResourceLocation)backBuffer));
                float topY = y1;
                float zFront = -0.5f;
                float zBack = 0.5f;
                this.vertex(pose, normal, edgeBuffer, x1, topY, 1.0f, 0.0f, zFront, 0, 1, 0, light);
                this.vertex(pose, normal, edgeBuffer, x2, topY, 0.0f, 0.0f, zFront, 0, 1, 0, light);
                this.vertex(pose, normal, edgeBuffer, x2, topY, 0.0f, 0.0625f, zBack, 0, 1, 0, light);
                this.vertex(pose, normal, edgeBuffer, x1, topY, 1.0f, 0.0625f, zBack, 0, 1, 0, light);
                float bottomY = y2;
                this.vertex(pose, normal, edgeBuffer, x1, bottomY, 1.0f, 0.9375f, zBack, 0, -1, 0, light);
                this.vertex(pose, normal, edgeBuffer, x2, bottomY, 0.0f, 0.9375f, zBack, 0, -1, 0, light);
                this.vertex(pose, normal, edgeBuffer, x2, bottomY, 0.0f, 1.0f, zFront, 0, -1, 0, light);
                this.vertex(pose, normal, edgeBuffer, x1, bottomY, 1.0f, 1.0f, zFront, 0, -1, 0, light);
                float leftX = x2;
                this.vertex(pose, normal, edgeBuffer, leftX, y1, 0.9375f, 0.0f, zFront, -1, 0, 0, light);
                this.vertex(pose, normal, edgeBuffer, leftX, y2, 0.9375f, 1.0f, zFront, -1, 0, 0, light);
                this.vertex(pose, normal, edgeBuffer, leftX, y2, 1.0f, 1.0f, zBack, -1, 0, 0, light);
                this.vertex(pose, normal, edgeBuffer, leftX, y1, 1.0f, 0.0f, zBack, -1, 0, 0, light);
                float rightX = x1;
                this.vertex(pose, normal, edgeBuffer, rightX, y1, 0.0f, 0.0f, zBack, 1, 0, 0, light);
                this.vertex(pose, normal, edgeBuffer, rightX, y2, 0.0f, 1.0f, zBack, 1, 0, 0, light);
                this.vertex(pose, normal, edgeBuffer, rightX, y2, 0.0625f, 1.0f, zFront, 1, 0, 0, light);
                this.vertex(pose, normal, edgeBuffer, rightX, y1, 0.0625f, 0.0f, zFront, 1, 0, 0, light);
            }
        }
    }

    private void vertex(Matrix4f pose, Matrix3f normal, VertexConsumer consumer, float x, float y, float u, float v, float zOffset, int nx, int ny, int nz, int light) {
        consumer.m_252986_(pose, x, y, zOffset).m_6122_(255, 255, 255, 255).m_7421_(u, v).m_86008_(OverlayTexture.f_118083_).m_85969_(light).m_252939_(normal, (float)nx, (float)ny, (float)nz).m_5752_();
    }
}

