/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.hydra.jojomod.access.IEntityAndData;
import net.hydra.jojomod.block.InvisiBlockEntity;
import net.hydra.jojomod.block.ModBlocks;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.client.hud.StandHudRender;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.CooldownInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class PowersAchtungBaby
extends NewDashPreset {
    public int grabInventorySlot = 1;
    public int burstTicks = -1;
    int timebetweenbursts = 10;
    public static final byte BURST = 61;

    public PowersAchtungBaby(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersAchtungBaby(entity);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().achtungSettings.enableAchtungBaby;
    }

    public boolean invisibleVisionOn() {
        return !this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        if (this.invisibleVisionOn()) {
            this.setSkillIcon(context, x, y, 1, StandIcons.BABY_VISION_ON, (byte)0);
        } else {
            this.setSkillIcon(context, x, y, 1, StandIcons.BABY_VISION_OFF, (byte)0);
        }
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.SELF_INVIS, (byte)1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.BURST_INVIS, (byte)1);
        }
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.SELF_INVIS, (byte)1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.BURST_INVIS, (byte)1);
        }
        if (this.isHoldingSneak() && ClientNetworking.getAppropriateConfig().achtungSettings.hidesPlacedBlocks.booleanValue()) {
            this.setSkillIcon(context, x, y, 3, StandIcons.INVIS_BLOCK, (byte)2);
        } else {
            this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        }
        super.renderIcons(context, x, y);
    }

    @Override
    public boolean rendersPlayer() {
        return true;
    }

    @Override
    public Component getPosName(byte posID) {
        return Component.m_237119_();
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.switchModeClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.invisiburstClient();
                break;
            }
            case SKILL_2_CROUCH: {
                this.invisiburstSimpleClient();
                break;
            }
            case SKILL_3_NORMAL: {
                this.dash();
                break;
            }
            case SKILL_3_CROUCH: {
                this.placeOrDashClient();
            }
        }
    }

    public void placeOrDashClient() {
        if (ClientNetworking.getAppropriateConfig().achtungSettings.hidesPlacedBlocks.booleanValue()) {
            this.placeClient();
        } else {
            this.dash();
        }
    }

    public void placeClient() {
        ItemStack stack = this.getSelf().m_21205_();
        if (!this.onCooldown((byte)2)) {
            this.setCooldown((byte)2, 2);
            if (!stack.m_41619_() && ((IEntityAndData)this.self).roundabout$getTrueInvisibility() > -1) {
                ((StandUser)this.getSelf()).roundabout$tryIntPower(25, true, ((Player)this.getSelf()).m_150109_().f_35977_);
                this.tryIntPowerPacket((byte)25, ((Player)this.getSelf()).m_150109_().f_35977_);
            }
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        if (move == 25) {
            this.grabInventorySlot = chargeTime;
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public boolean inBurstState() {
        return this.burstTicks > 1;
    }

    public void invisiburstClient() {
        if (!this.onCooldown((byte)1)) {
            ((StandUser)this.getSelf()).roundabout$tryPower(23, true);
            this.tryPowerPacket((byte)23);
        }
    }

    public void invisiburstSimpleClient() {
        if (!this.onCooldown((byte)1)) {
            ((StandUser)this.getSelf()).roundabout$tryPower(24, true);
            this.tryPowerPacket((byte)24);
        }
    }

    public void switchModeClient() {
        ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
        this.tryPowerPacket((byte)21);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                return this.invisibleVisionSwitch();
            }
            case 23: {
                return this.invisibleBurst();
            }
            case 24: {
                return this.invisibleBurstSimple();
            }
            case 25: {
                return this.inventoryGrab();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    public boolean inventoryGrab() {
        BlockItem BE;
        Item item;
        ItemStack stack;
        if (!this.getSelf().m_9236_().m_5776_() && this.getSelf() instanceof Player && ((IEntityAndData)this.self).roundabout$getTrueInvisibility() > -1 && !(stack = ((Player)this.getSelf()).m_150109_().m_8020_(this.grabInventorySlot)).m_41619_() && (item = stack.m_41720_()) instanceof BlockItem && !((BE = (BlockItem)item).m_40614_() instanceof ShulkerBoxBlock)) {
            ItemStack stack2 = stack.m_41777_();
            if (this.placeBlock(stack2)) {
                stack.m_41774_(1);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlock(ItemStack stack) {
        if (!this.getSelf().m_9236_().m_5776_()) {
            Vec3 vec3d = this.getSelf().m_20299_(0.0f);
            Vec3 vec3d2 = this.getSelf().m_20252_(0.0f);
            Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 5.0, vec3d2.f_82480_ * 5.0, vec3d2.f_82481_ * 5.0);
            BlockHitResult $$0 = this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
            BlockPos pos = null;
            if (this.getSelf().m_9236_().m_8055_($$0.m_82425_()).m_280296_() || this.getSelf().m_9236_().m_8055_($$0.m_82425_()).m_60713_(ModBlocks.INVISIBLOCK)) {
                pos = $$0.m_82425_().m_121945_($$0.m_82434_());
            }
            if (pos != null) {
                BlockState state = this.getSelf().m_9236_().m_8055_(pos);
                Item item = stack.m_41720_();
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    if (MainUtil.getIsGamemodeApproriateForGrief((Entity)this.self)) {
                        Player plr;
                        if (!blockItem.m_40614_().m_180643_(blockItem.m_40614_().m_49966_(), (BlockGetter)this.self.m_9236_(), pos)) {
                            return false;
                        }
                        LivingEntity livingEntity = this.getSelf();
                        if (livingEntity instanceof Player && !MainUtil.canPlaceOnClaim(plr = (Player)livingEntity, $$0)) {
                            return false;
                        }
                        if (this.tryHitBlockAndConvert($$0, pos, state, stack)) {
                            this.setCooldown((byte)2, 3);
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected boolean canPlace(BlockPlaceContext $$0, BlockState $$1, BlockItem stack) {
        Player $$2 = $$0.m_43723_();
        CollisionContext $$3 = $$2 == null ? CollisionContext.m_82749_() : CollisionContext.m_82750_((Entity)$$2);
        return $$1.m_60710_((LevelReader)$$0.m_43725_(), $$0.m_8083_()) && $$0.m_43725_().m_45752_($$1, $$0.m_8083_(), $$3);
    }

    @Nullable
    protected BlockState getPlacementState(BlockPlaceContext $$0, BlockItem stack) {
        BlockState $$1 = stack.m_40614_().m_5573_($$0);
        return $$1 != null && this.canPlace($$0, $$1, stack) ? $$1 : null;
    }

    public boolean tryHitBlockAndConvert(BlockHitResult $$0, BlockPos pos, BlockState state, ItemStack stack) {
        Item item;
        if ((state.m_60795_() || state.m_247087_()) && (!(this.getSelf() instanceof Player) || !((Player)this.getSelf()).m_36187_(this.getSelf().m_9236_(), pos, ((ServerPlayer)this.getSelf()).f_8941_.m_9290_())) && this.getSelf().m_9236_().m_7966_((Player)this.getSelf(), pos) && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockState $$2;
            DirectionalPlaceContext dpc;
            BlockItem BI = (BlockItem)item;
            Direction direction = $$0.m_82434_();
            if (direction.m_122434_() == Direction.Axis.X) {
                direction = direction.m_122424_();
            }
            if (BI.m_40614_() instanceof RotatedPillarBlock) {
                direction = $$0.m_82434_();
            }
            if ((dpc = new DirectionalPlaceContext(this.getSelf().m_9236_(), pos, direction, stack, direction)).m_7059_() && ($$2 = this.getPlacementState((BlockPlaceContext)dpc, BI)) != null) {
                BlockEntity BE;
                BlockPlaceContext $$1 = this.updatePlacementContext((BlockPlaceContext)dpc);
                if (this.self.m_9236_().m_7731_($$1.m_8083_(), ModBlocks.INVISIBLOCK.m_49966_(), 11) && (BE = this.self.m_9236_().m_7702_($$1.m_8083_())) instanceof InvisiBlockEntity) {
                    InvisiBlockEntity IBE = (InvisiBlockEntity)BE;
                    BlockPos $$3 = $$1.m_8083_();
                    Level $$4 = $$1.m_43725_();
                    Player $$5 = $$1.m_43723_();
                    BlockState $$7 = $$4.m_8055_($$3);
                    SoundType $$8 = $$7.m_60827_();
                    $$4.m_5594_($$5, $$3, this.getPlaceSound(BI.m_40614_().m_49966_()), SoundSource.BLOCKS, ($$8.m_56773_() + 1.0f) / 2.0f, $$8.m_56774_() * 0.8f);
                    $$4.m_220407_(GameEvent.f_157797_, $$3, GameEvent.Context.m_223719_((Entity)$$5, (BlockState)$$7));
                    IBE.setOriginal2(BI.m_40614_().m_5573_($$1));
                    IBE.ticksUntilRestore = ((IEntityAndData)this.self).roundabout$getTrueInvisibility();
                    PowersAchtungBaby.spawnExplosionParticles(this.self.m_9236_(), pos.m_252807_(), 10, 0.2);
                    return true;
                }
            }
        }
        return false;
    }

    @Nullable
    public BlockPlaceContext updatePlacementContext(BlockPlaceContext $$0) {
        return $$0;
    }

    protected SoundEvent getPlaceSound(BlockState $$0) {
        return $$0.m_60827_().m_56777_();
    }

    @Override
    public boolean isServerControlledCooldown(CooldownInstance ci, byte num) {
        if (num == 1 && ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstCooldownUsesServerLatency.booleanValue()) {
            return true;
        }
        return super.isServerControlledCooldown(ci, num);
    }

    public boolean isPlacable(ItemStack stack) {
        Item item;
        if (stack != null && !stack.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockItem BE = (BlockItem)item;
            return true;
        }
        return false;
    }

    public void burstBlocks(ServerLevel sl) {
        int radius = ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstBlockRange;
        BlockPos baseCenter = this.self.m_20097_();
        if (radius > 0 && MainUtil.getIsGamemodeApproriateForGrief((Entity)this.self)) {
            for (int x = -radius; x <= radius; ++x) {
                for (int y = 0; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        if (x * x + y * y + z * z > radius * radius) continue;
                        BlockPos targetPos = baseCenter.m_7918_(x, y, z);
                        BlockState oldState = this.self.m_9236_().m_8055_(targetPos);
                        if (oldState.m_60795_() || oldState.m_60713_(Blocks.f_50080_) || !oldState.m_60734_().m_180643_(oldState, (BlockGetter)this.self.m_9236_(), targetPos) || this.self.m_9236_().m_7702_(targetPos) != null || MainUtil.confirmIsOre(oldState)) continue;
                        BlockState replaced = sl.m_8055_(targetPos);
                        BlockEntity replacedEntity = sl.m_7702_(targetPos);
                        CompoundTag replacedTag = replacedEntity != null ? replacedEntity.m_187480_() : null;
                        sl.m_7731_(targetPos, ModBlocks.INVISIBLOCK.m_49966_(), 3);
                        BlockEntity maybeEntity = sl.m_7702_(targetPos);
                        if (maybeEntity instanceof InvisiBlockEntity) {
                            InvisiBlockEntity entity = (InvisiBlockEntity)maybeEntity;
                            entity.setOriginal(replaced, replacedTag, this.self.m_9236_());
                            entity.ticksUntilRestore = ((IEntityAndData)this.self).roundabout$getTrueInvisibility();
                        }
                        this.self.m_9236_().m_7731_(targetPos, ModBlocks.INVISIBLOCK.m_49966_(), 3);
                    }
                }
            }
        }
    }

    public boolean invisibleBurst() {
        if (this.isClient() || !this.onCooldown((byte)1) || !ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstCooldownUsesServerLatency.booleanValue()) {
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstCooldown);
            Level level = this.self.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.burstTicks = 22;
                this.burstParticles(sl);
                float range = ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstRange.floatValue();
                this.burstEntities(range);
                this.burstBlocks(sl);
            }
        }
        return true;
    }

    public void burstRejection() {
        Level level = this.self.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            this.burstTicks = 22;
            this.burstParticlesRejection(sl);
            this.self.m_9236_().m_5594_(null, this.self.m_20183_(), ModSounds.ACHTUNG_BURST_EVENT, SoundSource.PLAYERS, 0.95f, 1.0f);
            float range = ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstRange.floatValue();
            this.burstEntities(range);
            this.burstBlocks(sl);
        }
    }

    public void burstParticlesRejection(ServerLevel sl) {
        Vec3 pos = new Vec3(this.self.m_20185_(), this.self.m_20186_() + (double)this.self.m_20206_() * 0.5, this.self.m_20189_());
        sl.m_8767_((ParticleOptions)ModParticles.BABY_CRACKLE, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
        PowersAchtungBaby.spawnExplosionParticles(this.self.m_9236_(), pos, 100, 0.5);
    }

    public void burstParticles(ServerLevel sl) {
        Vec3 pos = new Vec3(this.self.m_20185_(), this.self.m_20186_() + (double)this.self.m_20206_() * 0.5, this.self.m_20189_());
        sl.m_8767_((ParticleOptions)ModParticles.BABY_CRACKLE, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 0, 0.0, 0.0, 0.0, 0.0);
        this.playStandUserOnlySoundsIfNearby((byte)61, 27.0, false, false);
        PowersAchtungBaby.spawnExplosionParticles(this.self.m_9236_(), pos, 100, 0.5);
    }

    public void burstEntities(float range) {
        this.burstEntitiesAggro();
        List<Entity> mobsInRange = MainUtil.getEntitiesInRange(this.self.m_9236_(), this.getSelf().m_20183_(), range + 1.0f);
        if (!mobsInRange.isEmpty()) {
            for (Entity ent : mobsInRange) {
                if (!(ent.m_20270_((Entity)this.self) <= range)) continue;
                IEntityAndData entityAndData = (IEntityAndData)ent;
                entityAndData.roundabout$setTrueInvisibility(ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstDuration);
            }
        }
    }

    public void burstEntitiesAggro() {
        List<Entity> mobsInRange;
        float range = 100.0f;
        float range2 = 13.0f;
        if (range2 > -1.0f && !(mobsInRange = MainUtil.getEntitiesInRange(this.self.m_9236_(), this.getSelf().m_20183_(), range + 1.0f)).isEmpty()) {
            for (Entity ent : mobsInRange) {
                Mob mb;
                if (!(ent instanceof Mob) || (mb = (Mob)ent).m_5448_() == null || !mb.m_5448_().m_7306_((Entity)this.self) || !(mb.m_20270_((Entity)this.self) >= range2)) continue;
                ((StandUser)mb).roundabout$aggressivelyEnforceAggro(null);
            }
        }
    }

    public boolean invisibleBurstSimple() {
        if (this.isClient() || !this.onCooldown((byte)1) || !ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstCooldownUsesServerLatency.booleanValue()) {
            this.setCooldown((byte)1, ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstCooldown);
            Level level = this.self.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel sl = (ServerLevel)level;
                this.burstTicks = 22;
                this.burstParticles(sl);
                float range = ClientNetworking.getAppropriateConfig().achtungSettings.invisiBurstCrouchRange.floatValue();
                this.burstEntities(range);
            }
        }
        return true;
    }

    @Override
    public boolean canUseStillStandingRecharge(byte bt) {
        if (bt == 1) {
            return false;
        }
        return super.canUseStillStandingRecharge(bt);
    }

    public static void spawnExplosionParticles(Level level, Vec3 center, int particleCount, double speed) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double x = random.m_188501_() - 0.5f;
            double y = random.m_188501_() - 0.5f;
            double z = random.m_188501_() - 0.5f;
            serverLevel.m_8767_((ParticleOptions)ModParticles.MAGIC_DUST, center.f_82479_, center.f_82480_, center.f_82481_, 0, x, y, z, speed);
        }
    }

    @Override
    public boolean highlightsEntity(Entity ent, Player player) {
        return false;
    }

    @Override
    public int highlightsEntityColor(Entity ent, Player player) {
        return 14806268;
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.getSelf().m_9236_().m_5776_()) {
            --this.timebetweenbursts;
            if (this.timebetweenbursts <= -1) {
                this.burstRejection();
                this.timebetweenbursts = 30;
            }
        }
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        Level level = this.self.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            if (attackTarget != null && !this.onCooldown((byte)1)) {
                this.invisibleBurst();
            }
        }
    }

    @Override
    public void tickPower() {
        if (!this.self.m_9236_().m_5776_() && this.burstTicks > -1) {
            --this.burstTicks;
        }
        super.tickPower();
    }

    @Override
    public void updateIntMove(int in) {
        super.updateIntMove(in);
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public Component getSkinName(byte skinId) {
        return Component.m_237115_((String)"skins.roundabout.achtung_baby.base");
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        switch (soundChoice) {
            case 18: {
                return ModSounds.SUMMON_ACHTUNG_EVENT;
            }
            case 61: {
                return ModSounds.ACHTUNG_BURST_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (ClientNetworking.getAppropriateConfig().achtungSettings.hidesPlacedBlocks.booleanValue() && slot == 3 && this.isHoldingSneak() && ((IEntityAndData)this.self).roundabout$getTrueInvisibility() <= -1) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.invisivision", "instruction.roundabout.press_skill", StandIcons.BABY_VISION_ON, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.invisiburst", "instruction.roundabout.press_skill", StandIcons.BURST_INVIS, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.controlled_burst", "instruction.roundabout.press_skill_crouch", StandIcons.SELF_INVIS, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        if (ClientNetworking.getAppropriateConfig().achtungSettings.hidesPlacedBlocks.booleanValue()) {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.place_invis", "instruction.roundabout.press_skill_crouch", StandIcons.INVIS_BLOCK, 3, level, bypass));
        }
        return $$1;
    }

    @Override
    public boolean replaceHudActively() {
        return this.invisibleVisionOn() && ((IEntityAndData)this.self).roundabout$getTrueInvisibility() > -1;
    }

    @Override
    public void getReplacementHUD(GuiGraphics context, Player cameraPlayer, int screenWidth, int screenHeight, int x) {
        StandHudRender.renderInvisibilityHUD(context, cameraPlayer, screenWidth, screenHeight, x);
    }

    public boolean invisibleVisionSwitch() {
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            LivingEntity livingEntity;
            this.getStandUserSelf().roundabout$setUniqueStandModeToggle(this.invisibleVisionOn());
            if (!this.isClient() && (livingEntity = this.self) instanceof ServerPlayer) {
                ServerPlayer PE = (ServerPlayer)livingEntity;
                if (this.invisibleVisionOn()) {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.achtung.vision_on").m_130940_(ChatFormatting.AQUA), true);
                } else {
                    PE.m_5661_((Component)Component.m_237115_((String)"text.roundabout.achtung.vision_off").m_130940_(ChatFormatting.AQUA), true);
                }
            }
        }
        return true;
    }
}

