/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.hydra.jojomod.Roundabout;
import net.hydra.jojomod.access.IPlayerEntity;
import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.RattDartEntity;
import net.hydra.jojomod.entity.stand.RattEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.ModEffects;
import net.hydra.jojomod.event.ModParticles;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.item.MaxStandDiscItem;
import net.hydra.jojomod.item.ModItems;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.hydra.jojomod.util.S2CPacketUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;

public class PowersRatt
extends NewDashPreset {
    public static final int MinThreshold = 30;
    public static final int MaxThreshold = 90;
    public static final int BaseShootCooldown = 10;
    public static final int PlaceDelay = 10;
    public static final int PlaceShootCooldown = 30;
    public static final int MaxShootCooldown = 20;
    public static final int[] ShotThresholds = new int[]{30, 50, 90};
    public static final float[] ShotPowerFloats = new float[]{3.55f, 3.5f, 4.0f};
    public static final int[] ShotSuperthrowTicks = new int[]{4, 10, 15};
    public static final float DespawnRange = 35.0f;
    public static final byte UPDATE_POSITION = 52;
    public static final byte AUTO = 54;
    public static final byte FIRE_DART = 57;
    public static final byte TOGGLE_BURSTING = 58;
    public static final byte START_PLAYER_BURST = 59;
    public static final byte PLAYER_BURST = 60;
    public static final byte START_PLACE_BURST = 61;
    public static final byte NET_PLACE = 63;
    public static final byte NET_RECALL = 64;
    public static final byte NET_SCOPE = 65;
    public static final byte UPDATE_CHARGE = 66;
    public static final byte START_CHARGE = 67;
    public static final byte CHECK_AUTO = 68;
    public static final byte PLACE_BURST = 69;
    public static final byte CHANGE_MODE = 7;
    public static final byte SETPLACE = 8;
    public static final byte SCOPE = 9;
    public static final byte RATT_LEAP = 5;
    int shotcooldown = 0;
    int maxshotcooldown = 0;
    public boolean active = false;
    public boolean immuneWhileReturning = false;
    int chargeTime = 0;
    Vec3 Placement = null;

    public PowersRatt(LivingEntity self) {
        super(self);
    }

    @Override
    public StandPowers generateStandPowers(LivingEntity entity) {
        return new PowersRatt(entity);
    }

    @Override
    public StandEntity getNewStandEntity() {
        byte skin = ((StandUser)this.getSelf()).roundabout$getStandSkin();
        if (skin == 10) {
            return (StandEntity)ModEntities.REDD.m_20615_(this.getSelf().m_9236_());
        }
        if (skin >= 11) {
            return (StandEntity)ModEntities.CHAIR_RATT.m_20615_(this.getSelf().m_9236_());
        }
        return (StandEntity)ModEntities.RATT.m_20615_(this.getSelf().m_9236_());
    }

    public void setShotCooldown(int i) {
        this.shotcooldown = i;
        this.maxshotcooldown = i;
    }

    public LivingEntity getShootTarget() {
        StandEntity standEntity = this.getStandEntity(this.getSelf());
        if (standEntity instanceof RattEntity) {
            RattEntity RE = (RattEntity)standEntity;
            return RE.m_5448_();
        }
        return null;
    }

    public void setShootTarget(LivingEntity l) {
        StandEntity standEntity = this.getStandEntity(this.getSelf());
        if (standEntity instanceof RattEntity) {
            RattEntity RE = (RattEntity)standEntity;
            RE.m_6710_(l);
        }
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    public int getChargeTime() {
        return this.chargeTime;
    }

    public void updateChargeTime(int i) {
        this.tryIntPower(66, true, i);
        this.tryIntPowerPacket((byte)66, i);
    }

    public boolean isPlaced() {
        return this.getStandEntity(this.getSelf()) != null;
    }

    public boolean isAuto() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    public BlockHitResult getTargetPos() {
        Vec3 vec3d = this.getSelf().m_20299_(0.0f);
        Vec3 vec3d2 = this.getSelf().m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 60.0, vec3d2.f_82480_ * 60.0, vec3d2.f_82481_ * 60.0);
        return this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
    }

    public Entity CoolerrayCastEntity(Level world, LivingEntity ratt, double maxDistance) {
        Vec3 vars = this.getRotations((Entity)this.getShootTarget());
        Vec3 eyePos = ratt.m_20299_(1.0f);
        Vec3 lookVec = new Vec3(Math.cos(vars.f_82480_ + 1.5707963267948966), Math.sin(vars.f_82479_), Math.sin(vars.f_82480_ + 1.5707963267948966));
        Vec3 reachVec = eyePos.m_82549_(lookVec.m_82490_(maxDistance));
        ClipContext blockContext = new ClipContext(eyePos, reachVec, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)ratt);
        BlockHitResult blockHit = world.m_45547_(blockContext);
        double blockHitDistance = blockHit.m_82450_().m_82554_(eyePos);
        AABB box = ratt.m_20191_().m_82369_(lookVec.m_82490_(maxDistance)).m_82400_(1.0);
        List candidates = world.m_6249_((Entity)ratt, box, e -> e instanceof Entity && e.m_6087_() && e.m_6084_());
        Entity closest = null;
        double closestDistance = blockHitDistance;
        for (Entity entity : candidates) {
            double hitDistance;
            AABB aabb = entity.m_20191_().m_82400_(0.3);
            Optional hitOptional = aabb.m_82371_(eyePos, reachVec);
            if (!hitOptional.isPresent() || !((hitDistance = eyePos.m_82554_((Vec3)hitOptional.get())) < closestDistance) || entity.m_5833_() || !MainUtil.isStandPickable(entity) || entity.m_20147_() || entity.m_20363_((Entity)ratt)) continue;
            closestDistance = hitDistance;
            closest = entity;
        }
        return closest;
    }

    private Vec3 getValidPlacement() {
        Vec3 vec3d = this.getSelf().m_20299_(0.0f);
        Vec3 vec3d2 = this.getSelf().m_20252_(0.0f);
        Vec3 vec3d3 = vec3d.m_82520_(vec3d2.f_82479_ * 8.0, vec3d2.f_82480_ * 8.0, vec3d2.f_82481_ * 8.0);
        BlockHitResult blockHit = this.getSelf().m_9236_().m_45547_(new ClipContext(vec3d, vec3d3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this.getSelf()));
        Vec3 location = blockHit.m_82450_();
        if (blockHit.m_82425_() instanceof BlockPos.MutableBlockPos) {
            if (blockHit.m_82434_() == Direction.UP) {
                return blockHit.m_82450_();
            }
            if (blockHit.m_82434_() == Direction.DOWN) {
                if (this.getSelf().m_9236_().m_8055_(blockHit.m_82425_().m_6630_(1)).m_60795_()) {
                    return new Vec3(location.m_7096_(), (double)((int)location.m_7098_() + 1), location.m_7094_());
                }
            } else {
                for (int oy = 0; oy < 3; ++oy) {
                    if (!this.getSelf().m_9236_().m_8055_(blockHit.m_82425_().m_6630_(oy)).m_60795_()) continue;
                    return new Vec3(location.m_7096_(), (double)((int)location.m_7098_() + oy), location.m_7094_());
                }
            }
        }
        return null;
    }

    @Override
    public void renderIcons(GuiGraphics context, int x, int y) {
        ClientUtil.fx.roundabout$onGUI(context);
        if (this.isPlaced()) {
            if (!this.isHoldingSneak()) {
                this.setSkillIcon(context, x, y, 1, this.LockedOrNot(StandIcons.RATT_BURST, 0), (byte)69);
            } else if (this.isAuto()) {
                this.setSkillIcon(context, x, y, 1, this.LockedOrNot(StandIcons.RATT_AUTO, 3), (byte)7);
            } else {
                this.setSkillIcon(context, x, y, 1, this.LockedOrNot(StandIcons.RATT_UNAUTO, 3), (byte)7);
            }
            if (this.scopeLevel == 0) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_RECALL, (byte)8);
            }
        } else {
            ResourceLocation ScopeIcon = StandIcons.RATT_SCOPE_IN;
            if (this.scopeLevel == 1) {
                ScopeIcon = StandIcons.RATT_SCOPE_OUT;
            }
            this.setSkillIcon(context, x, y, 1, this.LockedOrNot(ScopeIcon, 2), (byte)9);
            if (this.scopeLevel == 0) {
                this.setSkillIcon(context, x, y, 2, StandIcons.RATT_PLACE, (byte)8);
            } else if (this.isAuto()) {
                this.setSkillIcon(context, x, y, 2, this.LockedOrNot(StandIcons.RATT_BURST, 3), (byte)7);
            } else {
                this.setSkillIcon(context, x, y, 2, this.LockedOrNot(StandIcons.RATT_SINGLE, 3), (byte)7);
            }
        }
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        this.setSkillIcon(context, x, y, 4, this.LockedOrNot(StandIcons.RATT_LEAP, 4), (byte)5);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, Vec3 pos) {
        StandEntity SE = this.getStandEntity(this.getSelf());
        switch (move) {
            case 52: {
                if (SE == null) break;
                SE.m_146884_(pos);
                break;
            }
            case 63: {
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                this.active = true;
                this.immuneWhileReturning = false;
                this.Placement = pos;
                this.setCooldown((byte)8, 80);
            }
        }
        return true;
    }

    public void placeRatt(Vec3 pos) {
        int cooldown = 60;
        this.setCooldown((byte)8, cooldown);
        if (!this.isClient()) {
            this.blipStand(pos);
        }
    }

    public void blipStand(Vec3 pos) {
        StandEntity stand = this.getNewStandEntity();
        if (stand instanceof RattEntity) {
            RattEntity RE = (RattEntity)stand;
            StandUser user = this.getStandUserSelf();
            RE.setMaster(this.self);
            RE.m_20248_(pos.m_7096_(), pos.m_7098_(), pos.m_7094_());
            RE.setSavedSkin(((StandUser)this.getSelf()).roundabout$getStandSkin());
            this.getStandUserSelf().roundabout$standMount(RE);
            this.self.m_9236_().m_7967_((Entity)RE);
        }
    }

    public Vec3 getRotations(Entity target) {
        RattEntity RE = (RattEntity)this.getStandEntity(this.getSelf());
        if (RE != null) {
            Vec3 targetPos = this.getTargetPos().m_82450_();
            if (target != null) {
                targetPos = target.m_20299_(1.0f);
                if (this.isAuto()) {
                    double dist = targetPos.m_82554_(RE.m_20318_(1.0f));
                    double time = dist / (double)ShotPowerFloats[1];
                    time *= 1.4;
                    Vec3 vec = target.m_20184_();
                    if (target instanceof Player) {
                        Roundabout.LOGGER.info(vec.toString());
                        if (Math.abs(vec.f_82480_) < 3.0) {
                            vec = new Vec3(vec.f_82479_, 0.0, vec.f_82481_);
                        }
                    }
                    targetPos = targetPos.m_82549_(vec.m_82542_(time, time, time));
                }
            }
            double x = targetPos.m_7096_() - RE.m_20318_(0.0f).m_7096_();
            double z = targetPos.m_7094_() - RE.m_20318_(0.0f).m_7094_();
            float rot = (float)(Math.atan2(z, x) - 1.5707963267948966);
            double hy = targetPos.m_7098_() - RE.getEyeP(0.0f).m_7098_();
            double hd = Math.sqrt(Math.pow(x, 2.0) + Math.pow(z, 2.0));
            double bonus = 1.5707963267948966;
            float hrot = (float)(Math.atan2(hd, hy) + 1.5707963267948966);
            double percent = (double)RE.getFadeOut() / (double)RE.getMaxFade();
            if (percent != 1.0 && RE.getSavedSkin() < 11) {
                hrot = (float)Mth.m_14139_((double)percent, (double)0.0, (double)hrot);
            }
            return new Vec3((double)hrot, (double)rot, 0.0);
        }
        return new Vec3(0.0, 0.0, 0.0);
    }

    @Override
    public void tickPower() {
        super.tickPower();
        if (this.isPlaced()) {
            DimensionType T;
            DimensionType t = this.getStandEntity(this.getSelf()).m_9236_().m_6042_();
            if (t != (T = this.getSelf().m_9236_().m_6042_())) {
                this.RecallClient(true);
            }
            if (this.getSelf().m_20270_((Entity)this.getStandEntity(this.getSelf())) > 35.0f) {
                this.RecallClient(true);
            }
        }
        if (this.getActivePower() == 67) {
            this.updateChargeTime(Mth.m_14045_((int)(this.getChargeTime() + 4), (int)0, (int)100));
            if (this.getChargeTime() == 100 || this.scopeLevel == 0) {
                this.setPowerNone();
            }
        }
        if (this.getStandEntity(this.getSelf()) != null && this.getStandEntity((LivingEntity)this.getSelf()).forceDespawnSet) {
            this.setPowerNone();
        }
        if (this.shotcooldown != 0) {
            --this.shotcooldown;
        }
        if (this.shotcooldown == 0) {
            this.maxshotcooldown = 0;
        }
        StandEntity SE = this.getStandEntity(this.getSelf());
        if (this.isPlaced() && !(this.getSelf() instanceof Mob)) {
            if (!this.isClient()) {
                if (!SE.m_20096_()) {
                    ((ServerLevel)this.getSelf().m_9236_()).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.86f, 0.28f, 0.48f), 1.0f), SE.m_20185_(), ((RattEntity)SE).getEyeP(0.0f).m_7098_(), SE.m_20189_(), 0, 0.0, 0.0, 0.0, 0.0);
                }
                this.immuneWhileReturning = SE.m_20096_();
                Entity e = MainUtil.getTargetEntity(this.getSelf(), 40.0f);
                if (e instanceof LivingEntity) {
                    LivingEntity L = (LivingEntity)e;
                    if (!(this.isAuto() || L.equals((Object)this.getSelf()) || L.equals((Object)SE) || MainUtil.getEntityIsTrulyInvisible(e) || L.m_21124_(MobEffects.f_19609_) != null || L instanceof StandEntity)) {
                        this.setShootTarget(L);
                    }
                    if (e.m_20270_((Entity)this.getStandEntity(this.getSelf())) >= 40.0f) {
                        this.setShootTarget(null);
                    }
                    if (this.getShootTarget() != null && (MainUtil.getEntityIsTrulyInvisible((Entity)this.getShootTarget()) || this.getShootTarget().m_21124_(MobEffects.f_19609_) != null)) {
                        this.setShootTarget(null);
                    }
                } else if (e == null && !this.isAuto()) {
                    this.setShootTarget(null);
                }
            }
            if (this.isAuto()) {
                if (this.isClient()) {
                    this.BurstFire();
                }
                if (this.getShootTarget() != null) {
                    if (this.getShootTarget().m_21223_() == 0.0f) {
                        this.setShootTarget(null);
                    }
                } else if (this.isAuto()) {
                    this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                }
            }
        } else if (this.active && this.getStandUserSelf().roundabout$getActive() && !this.isClient() && this.Placement != null) {
            this.placeRatt(this.Placement);
        }
    }

    @Override
    public void updateUniqueMoves() {
        if (this.getActivePower() == 60) {
            if (this.isClient()) {
                if (this.attackTimeDuring % 2 == 1) {
                    this.tryPower(60, true);
                    this.tryPowerPacket((byte)60);
                }
                if (this.getChargeTime() < 30) {
                    this.updateChargeTime(0);
                    this.setShotCooldown(20);
                    this.tryPowerPacket((byte)0);
                    this.setPowerNone();
                }
            }
        } else if (this.getActivePower() == 69) {
            this.setShotCooldown(30);
            if (this.getAttackTimeDuring() == 10) {
                this.setAttackTimeDuring(15);
                this.setPowerNone();
                if (!this.isClient()) {
                    this.placeBurst();
                }
            }
        }
        super.updateUniqueMoves();
    }

    public void placeBurst() {
        this.chargeTime += 30;
        this.animateStand((byte)81);
        this.setPowerNone();
        this.getSelf().m_9236_().m_5594_(null, this.getSelf().m_20183_(), ModSounds.RATT_FIRING_EVENT, SoundSource.PLAYERS, 1.7f, 0.9f + (float)Math.random() * 0.2f);
        for (int i = 0; i < 3; ++i) {
            StandEntity standEntity = this.getStandEntity(this.getSelf());
            if (!(standEntity instanceof RattEntity)) continue;
            RattEntity RE = (RattEntity)standEntity;
            RattDartEntity e = new RattDartEntity(RE.m_9236_(), this.getSelf(), 1, 0.1f);
            Vec3 v = this.getRotations((Entity)this.getShootTarget());
            e.m_37251_((Entity)RE, (float)v.f_82479_ * 180.0f / (float)Math.PI + 180.0f, (float)v.f_82480_ * 180.0f / (float)Math.PI, -0.5f, ShotPowerFloats[1], 0.84f);
            e.EnableSuperThrow();
            e.setParticleTrails(true);
            RE.m_9236_().m_7967_((Entity)e);
        }
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: {
                if (!this.isPlaced()) {
                    if (!this.canExecuteMoveWithLevel(2)) break;
                    this.RattScope();
                    break;
                }
                this.BurstFire();
                break;
            }
            case SKILL_1_CROUCH: {
                if (this.isPlaced()) {
                    if (this.isAttackIneptVisually((byte)54, 1) || !this.canExecuteMoveWithLevel(3)) break;
                    this.ToggleAuto();
                    break;
                }
                if (!this.canExecuteMoveWithLevel(2)) break;
                this.RattScope();
                break;
            }
            case SKILL_2_NORMAL: 
            case SKILL_2_CROUCH: {
                if (this.scopeLevel != 0) {
                    if (!this.canExecuteMoveWithLevel(3)) break;
                    this.ToggleBursting();
                    break;
                }
                if (!this.isPlaced()) {
                    if (this.getValidPlacement() == null) break;
                    this.DeployClient();
                    break;
                }
                this.RecallClient(false);
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.RattLeap();
            }
        }
    }

    public void RattLeap() {
        if (!this.onCooldown((byte)5)) {
            this.tryPower(5);
            this.tryPowerPacket((byte)5);
        }
    }

    public void RattScope() {
        if (!this.onCooldown((byte)9)) {
            int nl = this.scopeLevel + 1;
            this.tryIntPower(65, true, nl == 2 ? 0 : nl);
            this.tryIntPowerPacket((byte)65, nl == 2 ? 0 : nl);
            this.getSelf().m_5496_(nl != 2 ? ModSounds.RATT_SCOPE_EVENT : ModSounds.RATT_DESCOPE_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
        }
    }

    @Override
    public boolean tryIntPower(int move, boolean forced, int chargeTime) {
        switch (move) {
            case 65: {
                this.setCooldown((byte)9, 5);
                this.setAttackTime(-1);
                this.setScopeLevel(chargeTime);
                this.getStandUserSelf().roundabout$setCombatMode(this.scopeLevel != 0);
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(true);
                break;
            }
            case 66: {
                this.chargeTime = chargeTime;
                break;
            }
            case 57: {
                this.setShotCooldown(chargeTime >= 90 ? 20 : 10);
                this.setCooldown((byte)8, 30);
                if (!this.isClient()) {
                    this.FireDart(chargeTime, 0.2f);
                    break;
                }
                this.updateChargeTime(0);
            }
        }
        return super.tryIntPower(move, forced, chargeTime);
    }

    public void ToggleBursting() {
        this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.isAuto());
        this.tryPower(58, true);
        this.tryPowerPacket((byte)58);
    }

    public void PlayerFire() {
        int i = this.getChargeTime();
        this.tryIntPower(57, true, i);
        this.tryIntPowerPacket((byte)57, i);
    }

    public void BurstFire() {
        if (!this.isAttackIneptVisually((byte)69, 2)) {
            this.tryPower(61, true);
            this.tryPowerPacket((byte)61);
        }
    }

    public void FireDart(int i, float acuracy) {
        float power = 0.0f;
        for (int b = ShotThresholds.length - 1; b >= 0; --b) {
            if ((i == -1 ? 51 : i) < ShotThresholds[b]) continue;
            power = ShotPowerFloats[b];
            break;
        }
        RattDartEntity e = new RattDartEntity(this.getSelf().m_9236_(), this.getSelf(), i);
        e.m_37251_((Entity)this.getSelf(), this.getSelf().m_146909_(), this.getSelf().m_146908_(), -0.5f, power, acuracy);
        e.EnableSuperThrow();
        e.setParticleTrails(true);
        this.getSelf().m_9236_().m_7967_((Entity)e);
    }

    public void ToggleAuto() {
        this.tryPower(58, true);
        this.tryPowerPacket((byte)58);
    }

    public void DeployClient() {
        if (!this.onCooldown((byte)8)) {
            this.getSelf().m_5496_(ModSounds.RATT_PLACE_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
            Vec3 blockHitResult = this.getValidPlacement();
            if (blockHitResult != null) {
                this.tryPosPower(63, true, blockHitResult);
                this.tryPosPowerPacket((byte)63, blockHitResult);
            }
        }
    }

    public void RecallClient(boolean forced) {
        if (!this.onCooldown((byte)8) || forced) {
            this.tryPower(64, true);
            this.tryPowerPacket((byte)64);
        }
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        switch (move) {
            case 68: {
                this.setShootTarget(null);
                break;
            }
            case 64: {
                this.active = false;
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(false);
                if (this.getStandEntity(this.getSelf()) != null) {
                    this.getStandEntity((LivingEntity)this.getSelf()).forceDespawnSet = true;
                }
                this.setCooldown((byte)8, 40);
                break;
            }
            case 57: {
                this.setCooldown((byte)7, 15);
                break;
            }
            case 59: {
                this.setAttackTimeDuring(0);
                this.setActivePower((byte)60);
                break;
            }
            case 60: {
                this.setCooldown((byte)8, 10);
                this.setActivePower((byte)60);
                this.chargeTime -= 30;
                if (this.isClient()) break;
                this.FireDart(61, 0.4f);
                break;
            }
            case 58: {
                this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.isAuto());
                this.setCooldown((byte)7, 10);
                break;
            }
            case 61: {
                this.setShotCooldown(30);
                this.setAttackTimeDuring(0);
                this.setAttackTime(-1);
                if (this.getActivePower() != 69) {
                    this.getSelf().m_9236_().m_247517_(null, this.getSelf().m_20183_(), ModSounds.RATT_LOADING_EVENT, SoundSource.PLAYERS);
                }
                this.setActivePower((byte)69);
                if (this.getSelf() instanceof Player) {
                    S2CPacketUtil.sendActivePowerPacket((Player)this.getSelf(), this.getActivePower());
                }
                if (this.isClient()) break;
                this.animateStand((byte)82);
                break;
            }
            case 5: {
                this.setCooldown((byte)5, 120);
                Vec3 dir = this.getSelf().m_20252_(1.0f);
                if (this.getStandEntity(this.getSelf()) == null) break;
                dir = dir.m_82490_(1.1);
                Vec3 vec3 = new Vec3(dir.f_82479_, dir.f_82480_ + (double)0.1f, dir.f_82481_);
                this.getStandEntity(this.getSelf()).m_20256_(vec3);
            }
        }
        return super.tryPower(move, forced);
    }

    @Override
    public float inputSpeedModifiers(float basis) {
        if (this.scopeLevel != 0) {
            basis *= 0.7f;
        }
        return super.inputSpeedModifiers(basis);
    }

    @Override
    public boolean isAttackInept(byte activeP) {
        if (this.getSelf().m_6117_()) {
            return false;
        }
        return super.isAttackInept(activeP);
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        switch (activeP) {
            case 54: {
                return this.getShootTarget() == null && this.isHoldingSneak() && !this.isAuto() && this.isPlaced();
            }
            case 8: {
                if (this.isPlaced()) {
                    return false;
                }
                if (this.scopeLevel != 0) break;
                return this.getValidPlacement() == null && !this.isPlaced();
            }
            case 69: {
                return this.shotcooldown != 0;
            }
            case 7: {
                if (!this.canExecuteMoveWithLevel(3)) {
                    return false;
                }
                if (this.scopeLevel != 0) {
                    return this.getChargeTime() <= 30 || this.shotcooldown != 0;
                }
                if (!this.isPlaced()) break;
                return !this.isAuto() && this.getShootTarget() == null;
            }
            case 5: {
                return !this.isPlaced() || !this.getStandEntity(this.getSelf()).m_20096_();
            }
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public boolean interceptAttack() {
        return this.scopeLevel != 0;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, Options options) {
        if (keyIsDown && this.scopeLevel != 0 && this.chargeTime >= 30 && this.getActivePower() == 0 && !this.isAttackIneptVisually((byte)7, 2)) {
            this.getSelf().m_5496_(ModSounds.RATT_FIRING_EVENT, 1.0f, (float)((double)0.98f + Math.random() * (double)0.04f));
            if (this.isAuto()) {
                this.tryPower(59, true);
                this.tryPowerPacket((byte)59);
            } else {
                this.PlayerFire();
            }
        }
    }

    @Override
    public boolean interceptGuard() {
        return this.scopeLevel != 0;
    }

    @Override
    public boolean buttonInputGuard(boolean keyIsDown, Options options) {
        if (this.getActivePower() == 0 && this.getChargeTime() != 100 && this.shotcooldown == 0) {
            this.tryPower(3, true);
            this.tryPowerPacket((byte)3);
        }
        return true;
    }

    @Override
    public boolean clickRelease() {
        if (this.scopeLevel != 0 && this.getActivePower() == 67) {
            this.setPowerNone();
        }
        return false;
    }

    @Override
    public boolean setPowerGuard() {
        this.setActivePower((byte)67);
        return true;
    }

    @Override
    public void tickStandRejection(MobEffectInstance effect) {
        if (!this.isClient() && effect.m_19557_() % 15 == 0) {
            MobEffectInstance effec = this.getSelf().m_21124_(ModEffects.MELTING);
            int stack = effec != null ? effec.m_19564_() : 0;
            this.getSelf().m_7292_(new MobEffectInstance(ModEffects.MELTING, 600, stack + 2));
            float degrees = (float)Math.random() * 360.0f;
            MainUtil.takeUnresistableKnockbackWithY((Entity)this.getSelf(), 0.27f, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.34906584f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
        }
    }

    @Override
    public boolean shouldReset(byte activeP) {
        return super.shouldReset(activeP);
    }

    @Override
    public void tickMobAI(LivingEntity attackTarget) {
        if (attackTarget != null) {
            this.setShootTarget(attackTarget);
            if (this.isPlaced()) {
                if (this.shotcooldown == 0) {
                    this.shotcooldown = 30;
                    ((StandUser)this.getSelf()).roundabout$tryPower(61, true);
                }
            } else if (!this.onCooldown((byte)8)) {
                Vec3 vec3 = this.getSelf().m_20318_(0.0f);
                this.blipStand(new Vec3(vec3.f_82479_, Math.floor(vec3.f_82480_), vec3.f_82481_));
            }
        }
    }

    @Override
    public void renderAttackHud(GuiGraphics context, Player playerEntity, int scaledWidth, int scaledHeight, int ticks, int vehicleHeartCount, float flashAlpha, float otherFlashAlpha) {
        int j = scaledHeight / 2 - 7 - 4;
        int k = scaledWidth / 2 - 8;
        if (this.getValidPlacement() != null && !this.isPlaced()) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
        }
        if (this.shotcooldown != 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            float ratio = (float)this.shotcooldown / (float)this.maxshotcooldown;
            int fifteen = 15 - Math.round(ratio * 15.0f);
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 12, fifteen, 6);
        } else if (this.getChargeTime() >= 10 || this.scopeLevel != 0) {
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, 6, 15, 6);
            float amount = (float)this.getChargeTime() / 100.0f;
            int finalAmount = Math.round(amount * 15.0f);
            int bartexture = 30;
            if (this.getChargeTime() >= 90) {
                bartexture -= 6;
            }
            context.m_280218_(StandIcons.JOJO_ICONS, k, j, 193, bartexture, finalAmount, 6);
        }
        super.renderAttackHud(context, playerEntity, scaledWidth, scaledHeight, ticks, vehicleHeartCount, flashAlpha, otherFlashAlpha);
    }

    @Override
    public boolean canScope() {
        return this.getStandUserSelf().roundabout$getActive() && !this.isPlaced();
    }

    @Override
    public boolean rendersPlayer() {
        return !this.isPlaced();
    }

    @Override
    public List<Byte> getSkinList() {
        ArrayList list = Lists.newArrayList();
        list.add((byte)1);
        list.add((byte)2);
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player) {
            boolean bypass;
            Player PE = (Player)livingEntity;
            byte Level2 = ((IPlayerEntity)PE).roundabout$getStandLevel();
            ItemStack goldDisc = ((StandUser)PE).roundabout$getStandDisc();
            boolean bl = bypass = PE.m_7500_() || !goldDisc.m_41619_() && goldDisc.m_41720_() instanceof MaxStandDiscItem;
            if (Level2 >= 2 || bypass) {
                list.add((byte)3);
                list.add((byte)5);
                list.add((byte)8);
                list.add((byte)9);
            }
            if (Level2 >= 3 || bypass) {
                list.add((byte)6);
                list.add((byte)10);
                list.add((byte)4);
                list.add((byte)7);
            }
            if (((IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() || bypass) {
                list.add((byte)11);
                list.add((byte)12);
                list.add((byte)13);
            }
        }
        return list;
    }

    @Override
    public Component getSkinName(byte skinId) {
        return PowersRatt.getSkinNameT(skinId);
    }

    public static Component getSkinNameT(byte skinId) {
        switch (skinId) {
            case 2: {
                return Component.m_237115_((String)"skins.roundabout.ratt.manga");
            }
            case 3: {
                return Component.m_237115_((String)"skins.roundabout.ratt.melon");
            }
            case 4: {
                return Component.m_237115_((String)"skins.roundabout.ratt.sand");
            }
            case 5: {
                return Component.m_237115_((String)"skins.roundabout.ratt.aztec");
            }
            case 6: {
                return Component.m_237115_((String)"skins.roundabout.ratt.tower");
            }
            case 10: {
                return Component.m_237115_((String)"skins.roundabout.ratt.redd");
            }
            case 7: {
                return Component.m_237115_((String)"skins.roundabout.ratt.snowy");
            }
            case 8: {
                return Component.m_237115_((String)"skins.roundabout.ratt.guardian");
            }
            case 9: {
                return Component.m_237115_((String)"skins.roundabout.ratt.elder_guardian");
            }
            case 11: {
                return Component.m_237115_((String)"skins.roundabout.ratt.chair_rat");
            }
            case 12: {
                return Component.m_237115_((String)"skins.roundabout.ratt.king_rat");
            }
            case 13: {
                return Component.m_237115_((String)"skins.roundabout.ratt.mech_rat");
            }
        }
        return Component.m_237115_((String)"skins.roundabout.ratt.anime");
    }

    public void unlockSkin() {
        IPlayerEntity ipe;
        Player PE;
        StandUser user;
        ItemStack stack;
        Level lv = this.getSelf().m_9236_();
        LivingEntity livingEntity = this.getSelf();
        if (livingEntity instanceof Player && !(stack = (user = (StandUser)(PE = (Player)livingEntity)).roundabout$getStandDisc()).m_41619_() && stack.m_150930_(ModItems.STAND_DISC_RATT) && !(ipe = (IPlayerEntity)PE).roundabout$getUnlockedBonusSkin() && !lv.m_5776_()) {
            ipe.roundabout$setUnlockedBonusSkin(true);
            lv.m_6263_(null, PE.m_20185_(), PE.m_20186_(), PE.m_20189_(), ModSounds.UNLOCK_SKIN_EVENT, PE.m_5720_(), 2.0f, 1.0f);
            ((ServerLevel)lv).m_8767_((ParticleOptions)ModParticles.HEART_ATTACK_MINI, PE.m_20185_(), PE.m_20186_() + (double)PE.m_20192_(), PE.m_20189_(), 10, 0.5, 0.5, 0.5, 0.2);
            user.roundabout$setStandSkin((byte)11);
            user.roundabout$summonStand(this.getSelf().m_9236_(), true, false);
            ((ServerPlayer)ipe).m_5661_((Component)Component.m_237115_((String)"unlock_skin.roundabout.ratt.rat"), true);
        }
    }

    @Override
    public Component getPosName(byte posID) {
        if (posID == 1) {
            return Component.m_237115_((String)"idle.roundabout.ratt_1");
        }
        return Component.m_237115_((String)"idle.roundabout.ratt_2");
    }

    @Override
    public SoundEvent getSoundFromByte(byte soundChoice) {
        if (soundChoice == 18) {
            return ModSounds.RATT_SUMMON_EVENT;
        }
        return super.getSoundFromByte(soundChoice);
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public byte getMaxLevel() {
        return 4;
    }

    public ResourceLocation LockedOrNot(ResourceLocation img, int level) {
        return this.canExecuteMoveWithLevel(level) ? img : StandIcons.LOCKED;
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(GuiGraphics context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypas) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 2, "ability.roundabout.ratt_scope", "instruction.roundabout.press_skill", StandIcons.RATT_SCOPE_IN, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 2, "ability.roundabout.ratt_single", "instruction.roundabout.hold_block", StandIcons.RATT_SINGLE, 0, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 3, "ability.roundabout.ratt_burst", "instruction.roundabout.press_skill", StandIcons.RATT_BURST, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.ratt_place", "instruction.roundabout.press_skill", StandIcons.RATT_PLACE, 2, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.ratt_place_burst", "instruction.roundabout.press_skill", StandIcons.RATT_BURST, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 118, 3, "ability.roundabout.ratt_auto", "instruction.roundabout.press_skill_crouch", StandIcons.RATT_AUTO, 1, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 80, 4, "ability.roundabout.ratt_leap", "instruction.roundabout.press_skill", StandIcons.RATT_LEAP, 4, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 99, 0, "ability.roundabout.ratt_flesh", "instruction.roundabout.passive", StandIcons.RATT_BLOB, 3, level, bypas));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 58, topPos + 118, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypas));
        return $$1;
    }

    @Override
    public boolean isWip() {
        return true;
    }

    @Override
    public Component ifWipListDevStatus() {
        return Component.m_237115_((String)"roundabout.dev_status.active").m_130940_(ChatFormatting.AQUA);
    }

    @Override
    public Component ifWipListDev() {
        return Component.m_237113_((String)"Prisma").m_130940_(ChatFormatting.YELLOW);
    }
}

