/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.client.models.projectile.renderers;

import net.hydra.jojomod.client.ClientUtil;
import net.hydra.jojomod.entity.projectile.SoftAndWetBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetExplosiveBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetItemLaunchingBubbleEntity;
import net.hydra.jojomod.entity.projectile.SoftAndWetPlunderBubbleEntity;
import net.hydra.jojomod.event.index.PlunderTypes;
import net.hydra.jojomod.event.powers.TimeStop;
import net.minecraft.class_1297;
import net.minecraft.class_1747;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_897;
import net.minecraft.class_918;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SoftAndWetBubbleRenderer
extends class_897<SoftAndWetBubbleEntity> {
    private static final class_2960 TEXTURE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/bubble_plunder.png");
    private static final class_2960 SHOOTING_1 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_1.png");
    private static final class_2960 SHOOTING_2 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_2.png");
    private static final class_2960 SHOOTING_3 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_3.png");
    private static final class_2960 SHOOTING_4 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/shooting_bubble_4.png");
    private static final class_2960 ITEM_1 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_1.png");
    private static final class_2960 ITEM_2 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_2.png");
    private static final class_2960 ITEM_3 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_3.png");
    private static final class_2960 ITEM_4 = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/explosive_item_bubble_4.png");
    private static final class_2960 MOB = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/bubble_plunder_mob.png");
    private static final class_2960 BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/bubble.png");
    private static final class_2960 GAS_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/gasoline_bubble.png");
    private static final class_2960 WATER_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/water_bubble.png");
    private static final class_2960 LAVA_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/lava_bubble.png");
    private static final class_2960 FIRE_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/fire_bubble.png");
    private static final class_2960 BLOOD_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/blood_bubble.png");
    private static final class_2960 BLUE_BLOOD_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/hemolymph_bubble.png");
    private static final class_2960 ENDER_BLOOD_BUBBLE = new class_2960("roundabout", "textures/stand/soft_and_wet/projectiles/ender_blood_bubble.png");
    private final float scale;
    private final class_918 itemRenderer;

    public SoftAndWetBubbleRenderer(class_5617.class_5618 context, float scale) {
        super(context);
        this.itemRenderer = context.method_32168();
        this.scale = scale;
    }

    public SoftAndWetBubbleRenderer(class_5617.class_5618 context) {
        super(context);
        this.itemRenderer = context.method_32168();
        this.scale = 1.0f;
    }

    public void render(SoftAndWetBubbleEntity entity, float entityYaw, float partialTicks, class_4587 poseStack, class_4597 buffer, int packedLight) {
        block19: {
            SoftAndWetItemLaunchingBubbleEntity launch;
            SoftAndWetPlunderBubbleEntity plunder;
            float size;
            Vector3f coursecorrect;
            Matrix4f matrix;
            class_4588 vertexConsumer;
            block22: {
                float scaleIt;
                block21: {
                    block20: {
                        SoftAndWetPlunderBubbleEntity sp;
                        if (!ClientUtil.canSeeStands(ClientUtil.getPlayer())) break block19;
                        if (((TimeStop)entity.method_37908()).inTimeStopRange((class_1297)entity)) {
                            partialTicks = 0.0f;
                        }
                        if (entity instanceof SoftAndWetPlunderBubbleEntity && (sp = (SoftAndWetPlunderBubbleEntity)entity).isPopPlunderBubbble()) break block19;
                        poseStack.method_22903();
                        poseStack.method_22905(this.scale, this.scale, this.scale);
                        poseStack.method_22907(this.field_4676.method_24197());
                        poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
                        poseStack.method_46416(0.0f, entity.method_17682() / 2.0f, 0.0f);
                        vertexConsumer = buffer.getBuffer(class_1921.method_23580((class_2960)this.getTextureLocation(entity)));
                        matrix = poseStack.method_23760().method_23761();
                        Vector3f normal = class_310.method_1551().field_1773.method_19418().method_19335();
                        normal.normalize();
                        coursecorrect = new Vector3f(0.577f, 0.577f, 0.577f);
                        if (normal.y > 0.0f) {
                            coursecorrect = new Vector3f(0.01f, 1.0f, 0.01f);
                            if ((double)normal.y > 0.95) {
                                coursecorrect = new Vector3f(-0.577f, -0.577f, -0.577f);
                            }
                        }
                        scaleIt = 0.23f;
                        if (entity instanceof SoftAndWetPlunderBubbleEntity) {
                            SoftAndWetPlunderBubbleEntity sp2 = (SoftAndWetPlunderBubbleEntity)entity;
                            int ls = sp2.getLiquidStolen();
                            if (ls == 3) {
                                packedLight = 0xF000F0;
                            } else if (sp2.getActivated() && sp2.getPlunderType() == PlunderTypes.OXYGEN.id) {
                                packedLight = 0xF000F0;
                            }
                            if (!sp2.getHeldItem().method_7960()) {
                                scaleIt = 0.33f;
                            }
                            if (sp2.getEntityStolen() > 0 && sp2.getPlunderType() == PlunderTypes.MOBS.id) {
                                scaleIt = 1.0f;
                            }
                        } else if (entity instanceof SoftAndWetItemLaunchingBubbleEntity) {
                            SoftAndWetItemLaunchingBubbleEntity itemn = (SoftAndWetItemLaunchingBubbleEntity)entity;
                            scaleIt = 0.33f;
                        }
                        size = (float)Math.min((double)scaleIt, (double)((float)entity.field_6012 + partialTicks) * ((double)scaleIt * 0.1));
                        if (!(entity instanceof SoftAndWetExplosiveBubbleEntity)) break block20;
                        SoftAndWetExplosiveBubbleEntity seb = (SoftAndWetExplosiveBubbleEntity)entity;
                        break block21;
                    }
                    if (!(entity instanceof SoftAndWetItemLaunchingBubbleEntity)) break block22;
                    SoftAndWetItemLaunchingBubbleEntity softAndWetItemLaunchingBubbleEntity = (SoftAndWetItemLaunchingBubbleEntity)entity;
                }
                size = scaleIt;
            }
            vertexConsumer.method_22918(matrix, -size, -size, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(coursecorrect.x, coursecorrect.y, coursecorrect.z).method_1344();
            vertexConsumer.method_22918(matrix, size, -size, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(coursecorrect.x, coursecorrect.y, coursecorrect.z).method_1344();
            vertexConsumer.method_22918(matrix, size, size, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(coursecorrect.x, coursecorrect.y, coursecorrect.z).method_1344();
            vertexConsumer.method_22918(matrix, -size, size, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_22916(packedLight).method_22914(coursecorrect.x, coursecorrect.y, coursecorrect.z).method_1344();
            if (entity instanceof SoftAndWetPlunderBubbleEntity && !(plunder = (SoftAndWetPlunderBubbleEntity)entity).getHeldItem().method_7960()) {
                poseStack.method_22904(0.0, -0.12, 0.0);
                this.itemRenderer.method_23178(plunder.getHeldItem(), class_811.field_4318, packedLight, class_4608.field_21444, poseStack, buffer, entity.method_37908(), entity.method_5628());
            }
            if (entity instanceof SoftAndWetItemLaunchingBubbleEntity && !(launch = (SoftAndWetItemLaunchingBubbleEntity)entity).getHeldItem().method_7960()) {
                if (launch.getHeldItem().method_7909() instanceof class_1747) {
                    poseStack.method_22904(0.0, -0.19, 0.0);
                } else {
                    poseStack.method_22904(0.0, -0.12, 0.0);
                }
                this.itemRenderer.method_23178(launch.getHeldItem(), class_811.field_4318, packedLight, class_4608.field_21444, poseStack, buffer, entity.method_37908(), entity.method_5628());
            }
            poseStack.method_22909();
            super.method_3936((class_1297)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }

    public class_2960 getTextureLocation(SoftAndWetBubbleEntity entity) {
        if (entity instanceof SoftAndWetPlunderBubbleEntity) {
            SoftAndWetPlunderBubbleEntity sp = (SoftAndWetPlunderBubbleEntity)entity;
            int ls = sp.getLiquidStolen();
            if (ls == 1) {
                return GAS_BUBBLE;
            }
            if (ls == 2) {
                return WATER_BUBBLE;
            }
            if (ls == 3) {
                return LAVA_BUBBLE;
            }
            if (ls == 4) {
                return BLOOD_BUBBLE;
            }
            if (ls == 5) {
                return BLUE_BLOOD_BUBBLE;
            }
            if (ls == 6) {
                return ENDER_BLOOD_BUBBLE;
            }
            if (sp.getActivated() && sp.getPlunderType() == PlunderTypes.OXYGEN.id) {
                return FIRE_BUBBLE;
            }
            if (sp.getActivated() && sp.getPlunderType() == PlunderTypes.MOBS.id) {
                return MOB;
            }
            return TEXTURE;
        }
        if (entity instanceof SoftAndWetItemLaunchingBubbleEntity) {
            SoftAndWetItemLaunchingBubbleEntity seb = (SoftAndWetItemLaunchingBubbleEntity)entity;
            int div = seb.field_6012 % 4;
            return switch (div) {
                case 1 -> ITEM_1;
                case 2 -> ITEM_2;
                case 3 -> ITEM_3;
                default -> ITEM_4;
            };
        }
        if (entity instanceof SoftAndWetExplosiveBubbleEntity) {
            SoftAndWetExplosiveBubbleEntity seb = (SoftAndWetExplosiveBubbleEntity)entity;
            int div = seb.field_6012 % 4;
            return switch (div) {
                case 1 -> SHOOTING_2;
                case 2 -> SHOOTING_3;
                case 3 -> SHOOTING_4;
                default -> SHOOTING_1;
            };
        }
        return BUBBLE;
    }
}

