/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.stand.powers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.hydra.jojomod.client.ClientNetworking;
import net.hydra.jojomod.client.StandIcons;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.projectile.ThrownWaterBottleEntity;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.entity.stand.SurvivorEntity;
import net.hydra.jojomod.event.AbilityIconInstance;
import net.hydra.jojomod.event.powers.CooldownInstance;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.stand.powers.elements.PowerContext;
import net.hydra.jojomod.stand.powers.presets.NewDashPreset;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1812;
import net.minecraft.class_1828;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_315;
import net.minecraft.class_3222;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class PowersSurvivor
extends NewDashPreset {
    public List<SurvivorEntity> survivorsSpawned = new ArrayList<SurvivorEntity>();
    public StandEntity displayStand = null;
    public SurvivorEntity SurvivorTarget = null;
    public class_1297 EntityTargetOne = null;
    public class_1297 EntityTargetTwo = null;
    public int lastPlacementTime = -1;
    boolean thisistheend = false;
    SurvivorEntity tempstand = null;
    public int meltDodgeTicks = -1;
    public static final byte BASE = 1;
    public static final byte GREEN = 2;
    public static final byte RED = 3;
    public static final byte PURPLE = 4;
    public static final byte BLUE = 5;
    public static final byte SILVER = 6;
    public static final byte GHAST = 7;
    public static final byte ENDER = 8;
    public static final byte CONDUIT = 9;
    public static final byte CAKE = 10;
    public static final byte PLACE = 61;
    public static final byte RETRACT = 62;
    public static final byte SHOCK = 63;
    boolean holdAttack = false;

    public PowersSurvivor(class_1309 self) {
        super(self);
    }

    @Override
    public boolean isStandEnabled() {
        return ClientNetworking.getAppropriateConfig().survivorSettings.enableSurvivor;
    }

    @Override
    public StandPowers generateStandPowers(class_1309 entity) {
        return new PowersSurvivor(entity);
    }

    @Override
    public boolean interceptAttack() {
        return this.angerSelectionMode();
    }

    public boolean angerSelectionMode() {
        return this.getStandUserSelf().roundabout$getUniqueStandModeToggle();
    }

    @Override
    public boolean canSummonStandAsEntity() {
        return false;
    }

    @Override
    public void renderIcons(class_332 context, int x, int y) {
        this.setSkillIcon(context, x, y, 1, StandIcons.BOTTLE, (byte)0);
        if (this.isHoldingSneak()) {
            this.setSkillIcon(context, x, y, 2, StandIcons.DESPAWN, (byte)-1);
        } else {
            this.setSkillIcon(context, x, y, 2, StandIcons.SPAWN, (byte)1);
        }
        this.setSkillIcon(context, x, y, 3, StandIcons.DODGE, (byte)6);
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            if (this.angerSelectionMode()) {
                this.setSkillIcon(context, x, y, 4, StandIcons.CUPID_ON, (byte)3);
            } else {
                this.setSkillIcon(context, x, y, 4, StandIcons.RAGE_SELECTION, (byte)3);
            }
        }
        super.renderIcons(context, x, y);
    }

    public void listInit() {
        if (this.survivorsSpawned == null) {
            this.survivorsSpawned = new ArrayList<SurvivorEntity>();
        }
    }

    @Override
    public class_2561 getPosName(byte posID) {
        return class_2561.method_43473();
    }

    @Override
    public List<Byte> getPosList() {
        ArrayList $$1 = Lists.newArrayList();
        return $$1;
    }

    @Override
    public void tickPowerEnd() {
        if (this.survivorsSpawned != null && !this.survivorsSpawned.isEmpty()) {
            this.offloadSurvivors();
        }
    }

    public void addSurvivorToList(SurvivorEntity che) {
        this.listInit();
        this.survivorsSpawned.add(che);
        ArrayList<SurvivorEntity> survivorsList2 = new ArrayList<SurvivorEntity>(this.survivorsSpawned){};
        int scount = ClientNetworking.getAppropriateConfig().survivorSettings.maxSurvivorsCount;
        if (!survivorsList2.isEmpty() && survivorsList2.size() > scount) {
            ((SurvivorEntity)survivorsList2.get(0)).forceDespawn(true);
            this.survivorsSpawned.remove(0);
        }
    }

    public void offloadSurvivors() {
        this.listInit();
        ArrayList<SurvivorEntity> survivorsList2 = new ArrayList<SurvivorEntity>(this.survivorsSpawned){};
        if (!survivorsList2.isEmpty()) {
            for (SurvivorEntity value : survivorsList2) {
                if (!value.method_31481() && value.method_5805() && (!this.self.method_37908().method_8608() || this.self.method_37908().method_8469(value.method_5628()) != null)) continue;
                this.survivorsSpawned.remove(value);
            }
        }
    }

    public boolean removeAllSurvivors() {
        this.listInit();
        boolean success = false;
        ArrayList<SurvivorEntity> survivorsList2 = new ArrayList<SurvivorEntity>(this.survivorsSpawned){};
        if (!survivorsList2.isEmpty()) {
            for (SurvivorEntity value : survivorsList2) {
                value.forceDespawn(true);
                success = true;
                this.survivorsSpawned.remove(value);
            }
        }
        if (success) {
            this.playStandUserOnlySoundsIfNearby((byte)62, 100.0, false, false);
        }
        return true;
    }

    @Override
    public void powerActivate(PowerContext context) {
        switch (context) {
            case SKILL_1_NORMAL: 
            case SKILL_1_CROUCH: {
                this.throwBottleClient();
                break;
            }
            case SKILL_2_NORMAL: {
                this.summonSurvivorClient();
                break;
            }
            case SKILL_2_CROUCH: {
                this.despawnSurvivorClient();
                break;
            }
            case SKILL_3_NORMAL: 
            case SKILL_3_CROUCH: {
                this.dash();
                break;
            }
            case SKILL_4_NORMAL: 
            case SKILL_4_CROUCH: {
                this.switchModeClient();
            }
        }
    }

    public void switchModeClient() {
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            this.SurvivorTarget = null;
            this.EntityTargetOne = null;
            ((StandUser)this.getSelf()).roundabout$tryPower(27, true);
            this.tryPowerPacket((byte)27);
        }
    }

    public void throwBottleClient() {
        if (!this.onCooldown((byte)0) && this.canUseWaterBottleThrow()) {
            ((StandUser)this.getSelf()).roundabout$tryPower(21, true);
            this.tryPowerPacket((byte)21);
        }
    }

    public void throwBottleActually(class_1799 stack) {
        this.self.method_37908().method_43128(null, this.self.method_23317(), this.self.method_23318(), this.self.method_23321(), class_3417.field_14910, class_3419.field_15248, 0.5f, 0.4f / (this.self.method_6051().method_43057() * 0.4f + 0.8f));
        ThrownWaterBottleEntity $$4 = new ThrownWaterBottleEntity(this.self.method_37908(), this.self);
        $$4.method_16940(stack);
        $$4.method_24919((class_1297)this.self, this.self.method_36455(), this.self.method_36454(), -0.1f, 1.5f, 0.2f);
        this.self.method_37908().method_8649((class_1297)$$4);
    }

    public boolean throwWaterBottle() {
        class_1309 class_13092;
        int cooldown = 5;
        this.setCooldown((byte)0, cooldown);
        if (!this.self.method_37908().method_8608() && (class_13092 = this.self) instanceof class_1657) {
            class_1792 class_17922;
            class_1799 stack2;
            class_1792 class_17923;
            class_1657 PL = (class_1657)class_13092;
            class_1799 stack = this.getSelf().method_6047();
            if (!stack.method_7960() && (class_17923 = stack.method_7909()) instanceof class_1812) {
                class_1812 PI = (class_1812)class_17923;
                if (class_1844.method_8063((class_1799)stack) == class_1847.field_8991 && !(stack.method_7909() instanceof class_1828)) {
                    this.throwBottleActually(stack.method_7972());
                    if (!PL.method_31549().field_7477) {
                        stack.method_7934(1);
                    }
                    return true;
                }
            }
            if (!(stack2 = this.getSelf().method_6079()).method_7960() && (class_17922 = stack2.method_7909()) instanceof class_1812) {
                class_1812 PI = (class_1812)class_17922;
                if (class_1844.method_8063((class_1799)stack2) == class_1847.field_8991 && !(stack2.method_7909() instanceof class_1828)) {
                    this.throwBottleActually(stack2.method_7972());
                    if (!PL.method_31549().field_7477) {
                        stack2.method_7934(1);
                    }
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public boolean tryTripleIntPower(int move, boolean forced, int chargeTime, int move2, int move3) {
        switch (move) {
            case 37: {
                this.initializeTargets(chargeTime, move2, move3);
            }
        }
        return this.tryPower(move, forced);
    }

    public void initializeTargets(int x, int y, int z) {
        class_1297 targ = this.self.method_37908().method_8469(x);
        if (targ instanceof SurvivorEntity) {
            SurvivorEntity SE;
            this.SurvivorTarget = SE = (SurvivorEntity)targ;
        }
        this.EntityTargetOne = this.self.method_37908().method_8469(y);
        this.EntityTargetTwo = this.self.method_37908().method_8469(z);
    }

    @Override
    public boolean setPowerOther(int move, int lastMove) {
        switch (move) {
            case 21: {
                return this.throwWaterBottle();
            }
            case 24: {
                return this.removeAllSurvivors();
            }
            case 27: {
                return this.switchAngerSelectionMode();
            }
            case 37: {
                return this.selectTarget();
            }
        }
        return super.setPowerOther(move, lastMove);
    }

    @Override
    public boolean highlightsEntity(class_1297 ent, class_1657 player) {
        if (ent != null && this.angerSelectionMode()) {
            if (this.SurvivorTarget != null && ent.method_5779((class_1297)this.SurvivorTarget) || this.EntityTargetOne != null && ent.method_5779(this.EntityTargetOne)) {
                return true;
            }
            class_1297 highlights = this.getHighlighter();
            if (highlights != null && highlights.method_5779(ent)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int highlightsEntityColor(class_1297 ent, class_1657 player) {
        if (this.SurvivorTarget != null && ent != null && ent.method_5779((class_1297)this.SurvivorTarget) || this.EntityTargetOne != null && ent != null && ent.method_5779(this.EntityTargetOne)) {
            return 4971295;
        }
        return 11283968;
    }

    @Override
    public boolean returnFakeStandForHud() {
        return true;
    }

    public boolean selectTarget() {
        class_1297 class_12972;
        this.setRageCupidCooldown();
        this.unloadTargets();
        SurvivorEntity surv = this.SurvivorTarget;
        if (surv != null && (class_12972 = this.EntityTargetOne) instanceof class_1309) {
            class_1309 LE = (class_1309)class_12972;
            class_12972 = this.EntityTargetTwo;
            if (class_12972 instanceof class_1309) {
                class_1309 LE2 = (class_1309)class_12972;
                surv.matchEntities(LE, LE2);
            }
        }
        return true;
    }

    public void selectTargetClient() {
        class_1297 TE = MainUtil.getTargetEntity(this.self, this.getCupidHighlightRange(), 15);
        if (this.SurvivorTarget == null) {
            SurvivorEntity SE;
            if (TE instanceof SurvivorEntity && ((SE = (SurvivorEntity)TE).getActivated() || this.getCreative())) {
                this.SurvivorTarget = SE;
                this.self.method_5783(ModSounds.SURVIVOR_PLACE_EVENT, 1.0f, 1.5f);
            }
        } else if (this.EntityTargetOne == null) {
            if (SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && TE.method_5739((class_1297)this.SurvivorTarget) <= (float)this.getCupidRange()) {
                this.EntityTargetOne = TE;
                this.self.method_5783(ModSounds.SURVIVOR_PLACE_EVENT, 1.0f, 1.5f);
            }
        } else if (SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && TE.method_5739((class_1297)this.SurvivorTarget) <= (float)this.getCupidRange() && !this.EntityTargetOne.method_5779(TE) && !this.onCooldown((byte)3)) {
            this.setRageCupidCooldown();
            this.tryTripleIntPacket((byte)37, this.SurvivorTarget.method_5628(), this.EntityTargetOne.method_5628(), TE.method_5628());
            this.SurvivorTarget = null;
            this.EntityTargetOne = null;
        }
    }

    @Override
    public boolean canUseStillStandingRecharge(byte bt) {
        if (bt == 1) {
            return false;
        }
        return super.canUseStillStandingRecharge(bt);
    }

    public void summonSurvivorClient() {
        class_243 pos;
        if (!this.onCooldown((byte)1) && (pos = MainUtil.getRaytracePointOnMobOrBlockIfNotUp((class_1297)this.self, 30.0f, 0.3f)) != null) {
            this.tryPosPower(23, true, pos);
            this.tryPosPowerPacket((byte)23, pos);
        }
    }

    @Override
    public void tickMobAI(class_1309 attackTarget) {
        --this.lastPlacementTime;
        if (this.lastPlacementTime <= -1) {
            this.lastPlacementTime = 600;
            this.createSurvivor(this.self.method_30950(1.0f), true);
        }
    }

    public void despawnSurvivorClient() {
        this.tryPowerPacket((byte)24);
    }

    @Override
    public boolean tryPosPower(int move, boolean forced, class_243 pos) {
        if (move == 23) {
            this.createSurvivor(pos, false);
            return true;
        }
        return this.tryPower(move, forced);
    }

    @Override
    public void tickStandRejection(class_1293 effect) {
        if (!this.getSelf().method_37908().method_8608() && effect.method_5584() == 50) {
            this.createSurvivor(this.self.method_30950(1.0f), true);
            if (this.tempstand != null) {
                List<class_1297> mobsInRange = MainUtil.getEntitiesInRange(this.self.method_37908(), this.self.method_24515(), ClientNetworking.getAppropriateConfig().survivorSettings.survivorRange.intValue(), (class_1297)this.self);
                Object firstTarget = null;
                if (!mobsInRange.isEmpty()) {
                    for (class_1297 ent : mobsInRange) {
                        if (!SurvivorEntity.canZapEntity(ent) || !this.canUseZap(ent) || !(ent instanceof class_1309)) continue;
                        class_1309 LE = (class_1309)ent;
                        this.tempstand.matchEntities(this.self, LE);
                    }
                }
            }
        }
    }

    public boolean canUseZap(class_1297 ent) {
        class_1309 LE;
        return !(ent instanceof class_1309) || !MainUtil.isBossMob(LE = (class_1309)ent) || ClientNetworking.getAppropriateConfig().survivorSettings.canUseSurvivorOnBossesInSurvival != false || this.getCreative();
    }

    public void createSurvivor(class_243 pos, boolean activated) {
        if (this.isClient() || !this.onCooldown((byte)1) || !ClientNetworking.getAppropriateConfig().survivorSettings.SummonSurvivorCooldownCooldownUsesServerLatency.booleanValue()) {
            int cooldown = ClientNetworking.getAppropriateConfig().survivorSettings.SummonSurvivorCooldownV2;
            this.setCooldown((byte)1, cooldown);
            if (!this.isClient()) {
                this.blipStand(pos, activated);
            }
        }
    }

    public void setRageCupidCooldown() {
        int cooldown = ClientNetworking.getAppropriateConfig().survivorSettings.rageCupidCooldown;
        this.setCooldown((byte)3, cooldown);
    }

    public class_1297 getHighlighter() {
        class_1297 TE = MainUtil.getTargetEntity(this.self, this.getCupidHighlightRange(), 15);
        if (this.SurvivorTarget == null) {
            SurvivorEntity SE;
            if (TE instanceof SurvivorEntity && ((SE = (SurvivorEntity)TE).getActivated() || this.getCreative())) {
                return SE;
            }
        } else if (this.EntityTargetOne == null ? SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && !TE.method_5767() && TE.method_5739((class_1297)this.SurvivorTarget) <= (float)this.getCupidRange() : SurvivorEntity.canZapEntity(TE) && this.canUseZap(TE) && !TE.method_5767() && TE.method_5739((class_1297)this.SurvivorTarget) <= (float)this.getCupidRange() && !this.EntityTargetOne.method_5779(TE)) {
            return TE;
        }
        return null;
    }

    public void blipStand(class_243 pos, boolean activated) {
        StandEntity stand = (StandEntity)ModEntities.SURVIVOR.method_5883(this.getSelf().method_37908());
        if (stand instanceof SurvivorEntity) {
            SurvivorEntity SE = (SurvivorEntity)stand;
            StandUser user = this.getStandUserSelf();
            stand.method_30634(pos.method_10216(), pos.method_10214(), pos.method_10215());
            stand.setSkin(user.roundabout$getStandSkin());
            stand.setIdleAnimation(user.roundabout$getIdlePos());
            stand.setMaster(this.self);
            this.addSurvivorToList(SE);
            SE.setRandomSize((float)(Math.random() * (double)0.4f));
            SE.method_36456(this.self.method_5791() % 360.0f);
            if (activated) {
                SE.setActivated(true);
            }
            this.tempstand = SE;
            this.self.method_37908().method_8649((class_1297)stand);
            this.playStandUserOnlySoundsIfNearby((byte)61, 100.0, false, false);
        }
    }

    @Override
    public boolean isServerControlledCooldown(CooldownInstance ci, byte num) {
        if (num == 1 && ClientNetworking.getAppropriateConfig().survivorSettings.SummonSurvivorCooldownCooldownUsesServerLatency.booleanValue()) {
            return true;
        }
        if (num == 3 && ClientNetworking.getAppropriateConfig().survivorSettings.rageCupidCooldownCooldownUsesServerLatency.booleanValue()) {
            return true;
        }
        return super.isServerControlledCooldown(ci, num);
    }

    @Override
    public boolean tryPower(int move, boolean forced) {
        return super.tryPower(move, forced);
    }

    public int getCupidRange() {
        if (this.getCreative()) {
            return ClientNetworking.getAppropriateConfig().survivorSettings.survivorCupidCreativeRange;
        }
        return ClientNetworking.getAppropriateConfig().survivorSettings.survivorCupidRange;
    }

    public int getCupidHighlightRange() {
        return 100;
    }

    public void unloadTargets() {
        if (this.SurvivorTarget != null && (!this.SurvivorTarget.getActivated() && !this.getCreative() || this.SurvivorTarget.method_31481() || !this.SurvivorTarget.method_5805())) {
            this.SurvivorTarget = null;
        }
        if (this.EntityTargetOne != null && (this.SurvivorTarget == null || this.EntityTargetOne.method_31481() || !this.EntityTargetOne.method_5805() || this.EntityTargetOne.method_5739((class_1297)this.SurvivorTarget) > (float)this.getCupidRange())) {
            this.SurvivorTarget = null;
        }
        if (this.EntityTargetTwo != null && (this.SurvivorTarget == null || this.EntityTargetOne == null || this.EntityTargetTwo.method_31481() || !this.EntityTargetTwo.method_5805() || this.EntityTargetTwo.method_5739((class_1297)this.SurvivorTarget) > (float)this.getCupidRange() || this.EntityTargetOne != null && this.EntityTargetOne.method_5779(this.EntityTargetTwo))) {
            this.EntityTargetTwo = null;
        }
    }

    @Override
    public void tickPower() {
        if (this.self.method_37908().method_8608()) {
            this.unloadTargets();
        }
        super.tickPower();
    }

    @Override
    public void updateIntMove(int in) {
        super.updateIntMove(in);
    }

    @Override
    public void updateUniqueMoves() {
        super.updateUniqueMoves();
    }

    @Override
    public List<Byte> getSkinList() {
        return Arrays.asList((byte)1, (byte)2, (byte)3, (byte)4, (byte)5, (byte)6, (byte)7, (byte)8, (byte)9, (byte)10);
    }

    @Override
    public int getDisplayPowerInventoryScale() {
        return 60;
    }

    @Override
    public int getDisplayPowerInventoryYOffset() {
        return 7;
    }

    @Override
    public class_2561 getSkinName(byte skinId) {
        return switch (skinId) {
            case 2 -> class_2561.method_43471((String)"skins.roundabout.survivor.green");
            case 3 -> class_2561.method_43471((String)"skins.roundabout.survivor.red");
            case 4 -> class_2561.method_43471((String)"skins.roundabout.survivor.purple");
            case 5 -> class_2561.method_43471((String)"skins.roundabout.survivor.blue");
            case 6 -> class_2561.method_43471((String)"skins.roundabout.survivor.silver");
            case 7 -> class_2561.method_43471((String)"skins.roundabout.survivor.ghast");
            case 8 -> class_2561.method_43471((String)"skins.roundabout.survivor.ender");
            case 9 -> class_2561.method_43471((String)"skins.roundabout.survivor.conduit");
            case 10 -> class_2561.method_43471((String)"skins.roundabout.survivor.cake");
            default -> class_2561.method_43471((String)"skins.roundabout.survivor.base");
        };
    }

    @Override
    public boolean isSecondaryStand() {
        return true;
    }

    @Override
    protected Byte getSummonSound() {
        return (byte)18;
    }

    @Override
    public class_3414 getSoundFromByte(byte soundChoice) {
        switch (soundChoice) {
            case 18: {
                return ModSounds.SURVIVOR_SUMMON_EVENT;
            }
            case 61: {
                return ModSounds.SURVIVOR_PLACE_EVENT;
            }
            case 62: {
                return ModSounds.SURVIVOR_REMOVE_EVENT;
            }
            case 63: {
                return ModSounds.SURVIVOR_SHOCK_EVENT;
            }
        }
        return super.getSoundFromByte(soundChoice);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canUseWaterBottleThrow() {
        class_1792 class_17922;
        class_1799 stack = this.getSelf().method_6047();
        class_1799 stack2 = this.getSelf().method_6079();
        if (!stack.method_7960() && (class_17922 = stack.method_7909()) instanceof class_1812) {
            class_1812 PI = (class_1812)class_17922;
            if (class_1844.method_8063((class_1799)stack) == class_1847.field_8991) {
                if (!(PI instanceof class_1828)) return true;
            }
        }
        if (stack2.method_7960()) return false;
        class_17922 = stack2.method_7909();
        if (!(class_17922 instanceof class_1812)) return false;
        class_1812 PI2 = (class_1812)class_17922;
        if (class_1844.method_8063((class_1799)stack2) != class_1847.field_8991) return false;
        if (PI2 instanceof class_1828) return false;
        return true;
    }

    @Override
    public boolean isAttackIneptVisually(byte activeP, int slot) {
        if (slot == 1 && !this.canUseWaterBottleThrow()) {
            return true;
        }
        return super.isAttackIneptVisually(activeP, slot);
    }

    @Override
    public List<AbilityIconInstance> drawGUIIcons(class_332 context, float delta, int mouseX, int mouseY, int leftPos, int topPos, byte level, boolean bypass) {
        ArrayList $$1 = Lists.newArrayList();
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 80, 0, "ability.roundabout.throw_bottle", "instruction.roundabout.press_skill", StandIcons.BOTTLE, 1, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 99, 0, "ability.roundabout.summon_survivor", "instruction.roundabout.press_skill", StandIcons.SPAWN, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 20, topPos + 118, 0, "ability.roundabout.desummon_survivor", "instruction.roundabout.press_skill_crouch", StandIcons.DESPAWN, 2, level, bypass));
        $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 80, 0, "ability.roundabout.dodge", "instruction.roundabout.press_skill", StandIcons.DODGE, 3, level, bypass));
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            $$1.add(this.drawSingleGUIIcon(context, 18, leftPos + 39, topPos + 99, 0, "ability.roundabout.target_zap", "instruction.roundabout.press_skill", StandIcons.RAGE_SELECTION, 4, level, bypass));
        }
        return $$1;
    }

    public boolean switchAngerSelectionMode() {
        if (this.getCreative() || !ClientNetworking.getAppropriateConfig().survivorSettings.canonSurvivorHasNoRageCupid.booleanValue()) {
            class_1309 class_13092;
            this.getStandUserSelf().roundabout$setUniqueStandModeToggle(!this.angerSelectionMode());
            if (!this.isClient() && (class_13092 = this.self) instanceof class_3222) {
                class_3222 PE = (class_3222)class_13092;
                if (this.angerSelectionMode()) {
                    PE.method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.survivor.anger_selection").method_27692(class_124.field_1061), true);
                } else {
                    PE.method_7353((class_2561)class_2561.method_43471((String)"text.roundabout.survivor.anger_selection_off").method_27692(class_124.field_1061), true);
                }
            }
        }
        return true;
    }

    @Override
    public void buttonInputAttack(boolean keyIsDown, class_315 options) {
        if (keyIsDown) {
            if (!this.holdAttack) {
                this.holdAttack = true;
                if (this.angerSelectionMode()) {
                    this.selectTargetClient();
                }
            }
        } else if (this.holdAttack) {
            this.holdAttack = false;
        }
    }
}

