/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.projectile;

import java.util.List;
import java.util.UUID;
import net.hydra.jojomod.entity.ModEntities;
import net.hydra.jojomod.entity.UnburnableProjectile;
import net.hydra.jojomod.entity.stand.MagiciansRedEntity;
import net.hydra.jojomod.event.powers.DamageHandler;
import net.hydra.jojomod.event.powers.ModDamageTypes;
import net.hydra.jojomod.event.powers.StandPowers;
import net.hydra.jojomod.event.powers.StandUser;
import net.hydra.jojomod.event.powers.stand.PowersMagiciansRed;
import net.hydra.jojomod.sound.ModSounds;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class StandFireballEntity
extends AbstractHurtingProjectile
implements UnburnableProjectile {
    private static final EntityDataAccessor<Integer> USER_ID = SynchedEntityData.m_135353_(StandFireballEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity standUser;
    public UUID standUserUUID;
    public double renderRotation = 0.0;
    public double lastRenderRotation = 0.0;
    public Vec3 storeVec;
    public boolean initialized = false;
    public boolean isBundle = false;
    public int saneAgeTicking;
    public int inWaterTicks = 0;

    public StandFireballEntity(EntityType<? extends StandFireballEntity> $$0, Level $$1) {
        super($$0, $$1);
    }

    protected StandFireballEntity(EntityType<? extends StandFireballEntity> $$0, double $$1, double $$2, double $$3, Level $$4) {
        this($$0, $$4);
        this.m_6034_($$1, $$2, $$3);
    }

    public int getUserID() {
        return (Integer)this.m_20088_().m_135370_(USER_ID);
    }

    public void setUserID(int idd) {
        this.m_20088_().m_135381_(USER_ID, (Object)idd);
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE;
            this.standUser = LE = (LivingEntity)entity;
            if (!this.m_9236_().m_5776_()) {
                this.standUserUUID = LE.m_20148_();
            }
        }
    }

    public boolean m_20069_() {
        return false;
    }

    public boolean isEffectivelyInWater() {
        return this.f_19798_;
    }

    protected float m_6884_() {
        return 1.0f;
    }

    public boolean m_6109_() {
        return super.m_6109_();
    }

    public boolean m_6087_() {
        return false;
    }

    public void setOldPosAndRot2() {
        if (this.storeVec != null) {
            double $$0 = this.storeVec.m_7096_();
            double $$1 = this.storeVec.m_7098_();
            double $$2 = this.storeVec.m_7094_();
            this.f_19854_ = $$0;
            this.f_19855_ = $$1;
            this.f_19856_ = $$2;
            this.f_19790_ = $$0;
            this.f_19791_ = $$1;
            this.f_19792_ = $$2;
            this.f_19859_ = this.m_146908_();
            this.f_19860_ = this.m_146909_();
        }
    }

    public void setRenderRotation(double rotation) {
        this.lastRenderRotation = this.renderRotation;
        this.renderRotation = rotation;
    }

    public void setUser(LivingEntity User) {
        this.standUser = User;
        this.m_20088_().m_135381_(USER_ID, (Object)User.m_19879_());
        if (!this.m_9236_().m_5776_()) {
            this.standUserUUID = User.m_20148_();
        }
    }

    protected StandFireballEntity(EntityType<StandFireballEntity> $$0, LivingEntity $$1, Level $$2) {
        this($$0, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public StandFireballEntity(LivingEntity $$1, Level $$2) {
        this(ModEntities.STAND_FIREBALL, $$1.m_20185_(), $$1.m_20188_() - (double)0.1f, $$1.m_20189_(), $$2);
        this.m_5602_((Entity)$$1);
    }

    public void tickWater() {
        ++this.inWaterTicks;
        if (this.inWaterTicks > 40) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        boolean client = this.m_9236_().m_5776_();
        if (!client) {
            if (this.isEffectivelyInWater()) {
                this.tickWater();
            }
            if (this.getStandUser() != null) {
                if (MainUtil.cheapDistanceTo2(this.m_20185_(), this.m_20189_(), this.standUser.m_20185_(), this.standUser.m_20189_()) > 80.0 || !this.getStandUser().m_6084_() || this.getStandUser().m_213877_()) {
                    this.m_146870_();
                }
            } else {
                this.m_146870_();
            }
        }
        super.m_8119_();
        if (!client && this.isEffectivelyInWater()) {
            this.tickWater();
        }
    }

    public double getRandomY(double $$0) {
        return this.m_20227_((2.0 * this.f_19796_.m_188500_() - 1.0) * $$0);
    }

    protected void m_8060_(BlockHitResult $$0) {
        StandPowers standPowers;
        LivingEntity user;
        this.radialExplosion(null);
        if (!this.m_9236_().m_5776_() && (user = this.getStandUser()) != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            BlockPos pos = $$0.m_82425_().m_121945_($$0.m_82434_());
            PMR.createStandFire2(pos);
        }
        this.m_146870_();
    }

    public LivingEntity getUser() {
        Entity entity = this.m_9236_().m_6815_(this.getUserID());
        if (entity instanceof LivingEntity) {
            LivingEntity LE = (LivingEntity)entity;
            return LE;
        }
        return null;
    }

    public void shootFromRotationDeltaAgnostic(Entity $$0, float $$1, float $$2, float $$3, float $$4, float $$5) {
        float $$6 = -Mth.m_14031_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        float $$7 = -Mth.m_14031_((float)(($$1 + $$3) * ((float)Math.PI / 180)));
        float $$8 = Mth.m_14089_((float)($$2 * ((float)Math.PI / 180))) * Mth.m_14089_((float)($$1 * ((float)Math.PI / 180)));
        this.m_6686_($$6, $$7, $$8, $$4, $$5);
        Vec3 $$9 = $$0.m_20184_();
    }

    protected void m_5790_(EntityHitResult $$0) {
        Entity $$1 = $$0.m_82443_();
        if (this.getUserID() != $$1.m_19879_() && !($$1 instanceof MagiciansRedEntity)) {
            this.radialExplosion($$1);
            this.m_146870_();
        }
    }

    public void radialExplosion(Entity mainTarget) {
        StandPowers standPowers;
        LivingEntity user;
        if (!this.m_9236_().m_5776_() && (user = this.getStandUser()) != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            List<Entity> entityList;
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            this.m_9236_().m_5594_(null, this.m_20183_(), ModSounds.FIREBALL_HIT_EVENT, SoundSource.PLAYERS, 2.5f, (float)((double)0.99f + Math.random() * 0.02));
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)PMR.getFlameParticle(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, 0.005, 0.01, 0.005, 0.02);
            if (mainTarget != null) {
                this.getEntity(mainTarget, PMR, user);
            }
            if (!(entityList = DamageHandler.genHitbox(user, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0, 2.0, 2.0)).isEmpty()) {
                for (Entity value : entityList) {
                    if (mainTarget != null && value.m_7306_(mainTarget) || !value.m_6087_()) continue;
                    this.getEntity(value, PMR, user);
                }
            }
        }
    }

    public void getEntity(Entity gotten, PowersMagiciansRed PMR, LivingEntity user) {
        if (gotten != null && gotten.m_19879_() != this.getUserID()) {
            Mob mb;
            float dmg = PMR.getFireballDamage(gotten);
            float strength = 0.85f;
            if (!(user instanceof Player || user instanceof Monster || gotten instanceof Monster || user instanceof Mob && (mb = (Mob)user).m_5448_() != null && mb.m_5448_().m_7306_(gotten))) {
                return;
            }
            if (gotten.m_6469_(ModDamageTypes.of(this.m_9236_(), ModDamageTypes.CROSSFIRE, (Entity)this.standUser), dmg)) {
                float degrees = MainUtil.getLookAtEntityYaw((Entity)this, gotten);
                MainUtil.takeUnresistableKnockbackWithY(gotten, strength, Mth.m_14031_((float)(degrees * ((float)Math.PI / 180))), Mth.m_14031_((float)-0.29670596f), -Mth.m_14089_((float)(degrees * ((float)Math.PI / 180))));
                if (gotten instanceof LivingEntity) {
                    LivingEntity LE = (LivingEntity)gotten;
                    PMR.addEXP(3, LE);
                    StandUser userLE = (StandUser)LE;
                    int ticks = 20;
                    ticks = userLE.roundabout$getRemainingFireTicks() > -1 ? (ticks += userLE.roundabout$getRemainingFireTicks()) : (ticks += 80);
                    userLE.roundabout$setOnStandFire(PMR.getFireColor(), this.standUser);
                    userLE.roundabout$setRemainingStandFireTicks(ticks);
                }
            }
        }
    }

    public boolean m_5825_() {
        return true;
    }

    protected ParticleOptions m_5967_() {
        StandPowers standPowers;
        LivingEntity user = this.getStandUser();
        if (user != null && (standPowers = ((StandUser)user).roundabout$getStandPowers()) instanceof PowersMagiciansRed) {
            PowersMagiciansRed PMR = (PowersMagiciansRed)standPowers;
            return PMR.getFlameParticle();
        }
        return new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50016_.m_49966_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(USER_ID, (Object)-1);
    }

    public void m_7380_(CompoundTag $$0) {
        super.m_7380_($$0);
        if (this.standUser != null) {
            $$0.m_128362_("standUser", this.standUser.m_20148_());
        }
    }

    public void m_7378_(CompoundTag $$0) {
        super.m_7378_($$0);
        if ($$0.m_128403_("standUser")) {
            Entity ett;
            this.standUserUUID = $$0.m_128342_("standUser");
            if (!this.m_9236_().m_5776_() && (ett = ((ServerLevel)this.m_9236_()).m_8791_(this.standUserUUID)) instanceof LivingEntity) {
                LivingEntity lett;
                this.standUser = lett = (LivingEntity)ett;
                this.setUserID(lett.m_19879_());
            }
        }
    }

    public LivingEntity getStandUser() {
        if (this.standUser != null) {
            return this.standUser;
        }
        if (this.standUserUUID != null && !this.m_9236_().m_5776_()) {
            Entity ett = ((ServerLevel)this.m_9236_()).m_8791_(this.standUserUUID);
            if (ett instanceof LivingEntity) {
                LivingEntity lett;
                this.standUser = lett = (LivingEntity)ett;
                this.setUserID(lett.m_19879_());
            }
        } else {
            Entity entity = this.m_9236_().m_6815_(this.getUserID());
            if (entity instanceof LivingEntity) {
                LivingEntity LE;
                this.standUser = LE = (LivingEntity)entity;
            }
        }
        return this.standUser;
    }

    protected boolean m_5931_() {
        return false;
    }
}

