/*
 * Decompiled with CFR 0.152.
 */
package net.hydra.jojomod.entity.stand;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.hydra.jojomod.entity.stand.StandAnimations;
import net.hydra.jojomod.entity.stand.StandEntity;
import net.hydra.jojomod.event.index.OffsetIndex;
import net.hydra.jojomod.event.powers.TimeStop;
import net.hydra.jojomod.util.MainUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;

public class StandModel<T extends StandEntity>
extends HierarchicalModel<T> {
    private float alpha;
    ModelPart stand;
    ModelPart head;
    ModelPart body;
    public ModelPart leftHand;
    public ModelPart rightHand;
    private final float maxRotX = 0.25f;
    private final float minRotX = 0.04f;
    private float swimRotCorrect = 0.0f;

    public void setHeadRotations(float pitch, float yaw) {
        this.head.f_104203_ = pitch;
        this.head.f_104204_ = yaw;
    }

    public void setBodyRotations(float pitch, float yaw) {
        this.body.f_104203_ = pitch;
        this.body.f_104204_ = yaw;
    }

    public void setStandRotations(float pitch, float yaw, float z) {
        this.stand.f_104203_ = pitch;
        this.stand.f_104204_ = yaw;
        this.stand.f_104205_ = z;
    }

    protected ModelPart getArm(HumanoidArm p_102852_) {
        return p_102852_ == HumanoidArm.LEFT ? this.rightHand : this.leftHand;
    }

    public void translateToHand(HumanoidArm p_103778_, PoseStack p_103779_, float zshift, float yshift, float xshift) {
        float f = p_103778_ == HumanoidArm.RIGHT ? xshift : -xshift;
        ModelPart modelpart = this.getArm(p_103778_);
        modelpart.f_104200_ += f;
        modelpart.f_104201_ -= yshift;
        modelpart.f_104202_ += zshift;
        modelpart.m_104299_(p_103779_);
        modelpart.f_104200_ -= f;
        modelpart.f_104201_ += yshift;
        modelpart.f_104202_ -= zshift;
    }

    public ModelPart m_142109_() {
        return this.stand;
    }

    public void defaultAnimations(T entity, float animationProgress, float windupLength) {
        this.m_233385_(((StandEntity)((Object)entity)).idleAnimationState, StandAnimations.STAND_IDLE_FLOAT, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).idleAnimationState2, StandAnimations.IDLE_2, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).idleAnimationState3, StandAnimations.FLOATY_IDLE, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).idleAnimationState4, StandAnimations.STAR_PLATINUM_IDLE, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).punchState1, StandAnimations.COMBO1, animationProgress, 1.4f);
        this.m_233385_(((StandEntity)((Object)entity)).punchState2, StandAnimations.COMBO2, animationProgress, 1.16666f);
        this.m_233385_(((StandEntity)((Object)entity)).punchState3, StandAnimations.COMBO3, animationProgress, 1.16666f);
        this.m_233385_(((StandEntity)((Object)entity)).blockAnimationState, StandAnimations.BLOCK, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).barrageChargeAnimationState, StandAnimations.BARRAGECHARGE, animationProgress, windupLength);
        this.m_233385_(((StandEntity)((Object)entity)).barrageAnimationState, StandAnimations.BARRAGE, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).miningBarrageAnimationState, StandAnimations.MINING_BARRAGE, animationProgress, 1.65f);
        this.m_233385_(((StandEntity)((Object)entity)).barrageEndAnimationState, StandAnimations.COMBO3, animationProgress, 2.2f);
        this.m_233385_(((StandEntity)((Object)entity)).barrageHurtAnimationState, StandAnimations.BARRAGEDAMAGE, animationProgress, 2.5f);
        this.m_233385_(((StandEntity)((Object)entity)).brokenBlockAnimationState, StandAnimations.BLOCKBREAK, animationProgress, 1.8f);
        this.m_233385_(((StandEntity)((Object)entity)).standLeapAnimationState, StandAnimations.STAND_LEAP, animationProgress, 1.0f);
        this.m_233385_(((StandEntity)((Object)entity)).standLeapEndAnimationState, StandAnimations.STAND_LEAP_END, animationProgress, 3.0f);
    }

    public void defaultModifiers(T entity) {
        Minecraft mc = Minecraft.m_91087_();
        if (((StandEntity)((Object)entity)).getUser() != null) {
            LivingEntity User = ((StandEntity)((Object)entity)).getUser();
            if (!mc.m_91104_() && !((TimeStop)entity.m_9236_()).CanTimeStopEntity((Entity)User)) {
                float tickDelta = mc.m_91297_();
                this.rotateStand(entity, this.m_142109_(), tickDelta);
                if (this.m_142109_().m_233562_("stand2")) {
                    if (this.m_142109_().m_171324_("stand2").m_233562_("head")) {
                        if (User != null && User.m_6162_()) {
                            ModelPart mp = this.m_142109_().m_171324_("stand2").m_171324_("head");
                            mp.f_233553_ *= 1.5f;
                            mp.f_233554_ *= 1.5f;
                            mp.f_233555_ *= 1.5f;
                        }
                        this.rotateHead(entity, this.m_142109_().m_171324_("stand2").m_171324_("head"), tickDelta);
                    }
                    if (this.m_142109_().m_171324_("stand2").m_233562_("body")) {
                        this.rotateBody(entity, this.m_142109_().m_171324_("stand2").m_171324_("body"), tickDelta);
                    }
                }
            } else {
                float rotX = ((StandEntity)((Object)entity)).getStandRotationX();
                float rotY = ((StandEntity)((Object)entity)).getStandRotationY();
                float rotZ = ((StandEntity)((Object)entity)).getStandRotationZ();
                this.setStandRotations(rotX, rotY, rotZ);
                if (this.m_142109_().m_233562_("stand2")) {
                    if (this.m_142109_().m_171324_("stand2").m_233562_("head")) {
                        rotX = ((StandEntity)((Object)entity)).getHeadRotationX();
                        rotY = ((StandEntity)((Object)entity)).getHeadRotationY();
                        this.setHeadRotations(rotX, rotY);
                    }
                    if (this.m_142109_().m_171324_("stand2").m_233562_("body")) {
                        rotX = ((StandEntity)((Object)entity)).getBodyRotationX();
                        rotY = ((StandEntity)((Object)entity)).getBodyRotationY();
                        this.setBodyRotations(rotX, rotY);
                    }
                }
            }
        }
    }

    public void setupAnim(T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
    }

    public void m_7695_(PoseStack matrices, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.stand.m_104306_(matrices, vertexConsumer, light, overlay, red, green, blue, this.alpha);
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void rotateHead(T mobEntity, ModelPart head, float tickDelta) {
        if (((StandEntity)((Object)mobEntity)).getDisplay()) {
            this.setHeadRotations(0.0f, 0.0f);
            return;
        }
        byte animationNumber = ((StandEntity)((Object)mobEntity)).getOffsetType();
        byte animationStyle = OffsetIndex.OffsetStyle(animationNumber);
        float rotX = ((StandEntity)((Object)mobEntity)).getHeadRotationX();
        float rotY = ((StandEntity)((Object)mobEntity)).getHeadRotationY();
        if (animationStyle == 0) {
            if ((((StandEntity)((Object)mobEntity)).m_6069_() || ((StandEntity)((Object)mobEntity)).m_20143_() || ((StandEntity)((Object)mobEntity)).m_21255_()) && animationNumber != 7) {
                if (this.swimRotCorrect > -45.0f) {
                    this.swimRotCorrect -= 2.0f;
                    this.swimRotCorrect = Math.min(this.swimRotCorrect, -45.0f);
                }
            } else if (this.swimRotCorrect < 0.0f) {
                this.swimRotCorrect += 2.0f;
                this.swimRotCorrect = Math.max(this.swimRotCorrect, 0.0f);
            }
            float tickDelta2 = Math.min(tickDelta, 2.0f);
            rotX = (((StandEntity)((Object)mobEntity)).getUser().m_5686_(tickDelta2) % 360.0f - this.swimRotCorrect) * ((float)Math.PI / 180);
            rotY = 0.0f;
        } else if (animationStyle == 1) {
            rotX = 0.0f;
            rotY = 0.0f;
        } else if (animationStyle == 2) {
            rotX = 0.0f;
            rotY = 0.0f;
        }
        ((StandEntity)((Object)mobEntity)).setHeadRotationX(rotX);
        ((StandEntity)((Object)mobEntity)).setHeadRotationY(rotY);
        this.setHeadRotations(rotX, rotY);
    }

    public void rotateStand(T mobEntity, ModelPart stand, float tickDelta) {
        if (((StandEntity)((Object)mobEntity)).getDisplay()) {
            this.setStandRotations(0.0f, 0.0f, 0.0f);
            return;
        }
        byte animationNumber = ((StandEntity)((Object)mobEntity)).getOffsetType();
        byte animationStyle = OffsetIndex.OffsetStyle(animationNumber);
        float rotX = ((StandEntity)((Object)mobEntity)).getStandRotationX();
        float rotY = ((StandEntity)((Object)mobEntity)).getStandRotationY();
        float rotZ = ((StandEntity)((Object)mobEntity)).getStandRotationZ();
        float cRX = 0.0f;
        float cRY = 0.0f;
        float cRZ = 0.0f;
        if (animationNumber == 0) {
            cRY = ((StandEntity)((Object)mobEntity)).getIdleRotation() * ((float)Math.PI / 180);
        }
        if (animationStyle == 1) {
            cRX = ((StandEntity)((Object)mobEntity)).getUser().m_5686_(tickDelta) % 360.0f * ((float)Math.PI / 180);
            if (animationNumber == 6) {
                cRX = 1.5707964f;
                cRZ = (float)Math.PI;
            }
        } else if (animationStyle == 2 || animationNumber == 8) {
            cRX = mobEntity.m_5686_(tickDelta) % 360.0f * ((float)Math.PI / 180);
        }
        rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, cRX, 0.8f);
        rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, cRY, 0.8f);
        rotZ = MainUtil.controlledLerpRadianDegrees(tickDelta, rotZ, cRZ, 0.8f);
        ((StandEntity)((Object)mobEntity)).setStandRotationX(rotX);
        ((StandEntity)((Object)mobEntity)).setStandRotationY(rotY);
        ((StandEntity)((Object)mobEntity)).setStandRotationZ(rotZ);
        this.setStandRotations(rotX, rotY, rotZ);
    }

    public void rotateBody(T mobEntity, ModelPart body, float tickDelta) {
        if (((StandEntity)((Object)mobEntity)).getDisplay()) {
            this.setBodyRotations(0.0f, 0.0f);
            return;
        }
        byte animationNumber = ((StandEntity)((Object)mobEntity)).getOffsetType();
        byte animationStyle = OffsetIndex.OffsetStyle(animationNumber);
        float rotX = ((StandEntity)((Object)mobEntity)).getBodyRotationX();
        float rotY = ((StandEntity)((Object)mobEntity)).getBodyRotationY();
        if (animationStyle == 0) {
            float cRot = 0.25f;
            if ((((StandEntity)((Object)mobEntity)).m_6069_() || ((StandEntity)((Object)mobEntity)).m_21255_()) && animationNumber != 7) {
                cRot = (((StandEntity)((Object)mobEntity)).getUser().m_5686_(tickDelta) % 360.0f + 90.0f) * ((float)Math.PI / 180);
            } else if (((StandEntity)((Object)mobEntity)).m_20143_() && animationNumber != 7) {
                cRot = 1.5707964f;
            } else {
                byte moveForward = ((StandEntity)((Object)mobEntity)).getMoveForward();
                if (animationNumber == 7) {
                    moveForward = 0;
                }
                cRot = moveForward < 0 ? (cRot *= (float)(-moveForward)) : (moveForward > 0 ? (cRot *= (float)(-moveForward)) : 0.0f);
                cRot *= -0.6f;
            }
            rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, cRot, 0.15f);
            rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, 0.0f, 0.8f);
        } else if (animationStyle == 1) {
            float xRot = 0.0f;
            float yRot = 0.0f;
            rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, xRot, 0.8f);
            rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, yRot, 0.8f);
        } else if (animationStyle == 2) {
            rotX = MainUtil.controlledLerpRadianDegrees(tickDelta, rotX, 0.0f, 0.8f);
            rotY = MainUtil.controlledLerpRadianDegrees(tickDelta, rotY, 0.0f, 0.8f);
        }
        ((StandEntity)((Object)mobEntity)).setBodyRotationX(rotX);
        ((StandEntity)((Object)mobEntity)).setBodyRotationY(rotY);
        this.setBodyRotations(rotX, rotY);
    }
}

